/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftRecordFactory;
import com.kingdee.eas.tm.td.basedata.DraftItemStatus;
import com.kingdee.eas.tm.td.basedata.IRptBillRange;
import com.kingdee.eas.tm.td.basedata.RptBillRangeCollection;
import com.kingdee.eas.tm.td.basedata.RptBillRangeEntryCollection;
import com.kingdee.eas.tm.td.basedata.RptBillRangeEntryInfo;
import com.kingdee.eas.tm.td.basedata.RptBillRangeFactory;
import com.kingdee.eas.tm.td.basedata.RptBillRangeInfo;
import com.kingdee.eas.tm.td.basedata.app.AbstractRptBillRangeControllerBean;
import com.kingdee.eas.tm.td.cloud.TDCloudException;
import com.kingdee.eas.tm.td.utils.LogUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class RptBillRangeControllerBean
extends AbstractRptBillRangeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.basedata.app.RptBillRangeControllerBean");
    private static final int DESCRIPTION_MAX_LENGTH = 255;

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RptBillRangeInfo info = (RptBillRangeInfo)model;
        this.setNewNumber(ctx, info);
        RptBillRangeEntryCollection entrys = info.getEntrys();
        RptBillRangeEntryInfo entry = null;
        String desc = "";
        for (int i = 0; i < entrys.size(); ++i) {
            entry = entrys.get(i);
            desc = TDUtils.cutStr(entry.getDescription(), 255);
            entry.setDescription(desc);
        }
        return super._save(ctx, model);
    }

    public void setNewNumber(Context ctx, RptBillRangeInfo info) throws EASBizException, BOSException {
        if (info.getNumber() != null) {
            this.checkNumberDup(ctx, null, info);
            return;
        }
        if (StringUtils.isEmpty((String)info.getNumber())) {
            String number = this.getNumber(ctx, info);
            info.setNumber(number);
        }
    }

    private String getNumber(Context ctx, RptBillRangeInfo caller) throws BOSException, EASBizException {
        IRptBillRange iBillBase = RptBillRangeFactory.getLocalInstance(ctx);
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String number = (String)caller.get("number");
        String cuID = caller.getCU() == null ? ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString() : caller.getCU().getId().toString();
        int maxCycleNum = 100;
        String filterString = "where number = '" + number + "' and CU.id = '" + cuID + "' " + (caller.get("id") != null ? "and id !='" + caller.get("id") + "'" : "");
        while (number == null || number.equals("") || iBillBase.exists(filterString)) {
            if (--maxCycleNum == 0) {
                throw new CodingRuleException(CodingRuleException.ERROR_REFERENCE_INVALID);
            }
            CodingRuleInfo ruleInfo = iCodingRuleManager.getCodingRule((IObjectValue)caller, cuID);
            number = iCodingRuleManager.getNumber((IObjectValue)caller, ruleInfo);
            filterString = "where number = '" + number + "' and CU.id = '" + cuID + "' " + (caller.get("id") != null ? "and id !='" + caller.get("id") + "'" : "");
        }
        return number;
    }

    protected boolean _checkNumberDup(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CoreBillBaseInfo coreBillBaseInfo = (CoreBillBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)coreBillBaseInfo.getString("number"), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (coreBillBaseInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)coreBillBaseInfo.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            String str = ResourceBase.getString((String)"com.kingdee.eas.tm.td.TDCommonResource", (String)"EXIST_SAME_NUMBER", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{coreBillBaseInfo.getString("number")});
            throw new TDException(TDException.ERROR_MSG, new Object[]{str});
        }
        return true;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        RptBillRangeInfo info = RptBillRangeFactory.getLocalInstance(ctx).getRptBillRangeInfo(pk);
        this.checkBeforeDelete(ctx, info);
        IObjectPK logPk = LogUtils.beginLog(ctx, "delete", BOSObjectType.create((String)"5A9517F2"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "billRange_delete", info.getCU().getId().toString());
        super._delete(ctx, pk);
        LogUtils.afterLog(ctx, logPk);
    }

    private void checkBeforeDelete(Context ctx, RptBillRangeInfo info) throws BOSException, EASBizException {
        if (DraftItemStatus.AWAKEN.equals((Object)info.getStatus())) {
            throw new TDCloudException(TDCloudException.DELETE_STATUS_ERROR1);
        }
        if (info.isIsPreseted()) {
            throw new TDCloudException(TDCloudException.DELETE_STATUS_ERROR2);
        }
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("billRange", (Object)info.getId().toString(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (TaxDraftRecordFactory.getLocalInstance(ctx).exists(filter)) {
            throw new TDCloudException(TDCloudException.DELETE_USED_ERROR);
        }
    }

    @Override
    protected ArrayList _batchDelete(Context ctx, Set ids) throws BOSException, EASBizException {
        ArrayList<String> errors = new ArrayList<String>();
        Iterator idIter = ids.iterator();
        while (idIter.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)idIter.next().toString()));
            RptBillRangeInfo info = this.getRptBillRangeInfo(ctx, (IObjectPK)pk);
            if (DraftItemStatus.AWAKEN.equals((Object)info.getStatus())) {
                errors.add(info.getNumber() + "\uff1a" + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "Active_NotDelete", ctx.getLocale()));
                continue;
            }
            if (info.isIsPreseted()) {
                errors.add(info.getNumber() + "\uff1a" + TDUtils.getString("com.kingdee.eas.tm.td.basedata.RptBillRangeResource", "ISPRESETED_CANNOT_REMOVE", TDUtils.getLocale()));
                continue;
            }
            FilterInfo filter = new FilterInfo();
            FilterItemInfo filterItem = new FilterItemInfo("billRange", (Object)info.getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            if (TaxDraftRecordFactory.getLocalInstance(ctx).exists(filter)) {
                errors.add(info.getNumber() + "\uff1a" + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "Used_NotDelete", ctx.getLocale()));
                continue;
            }
            super.delete(ctx, (IObjectPK)pk);
        }
        return errors;
    }

    @Override
    protected ArrayList _cancel(Context ctx, Set ids) throws BOSException, EASBizException {
        String idStr = "";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        RptBillRangeCollection coll = RptBillRangeFactory.getLocalInstance(ctx).getRptBillRangeCollection(view);
        RptBillRangeInfo info = null;
        ArrayList<String> errors = new ArrayList<String>();
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (!DraftItemStatus.AWAKEN.equals((Object)info.getStatus())) {
                errors.add(info.getNumber() + " : " + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "CANNOT_INACTIVE", ctx.getLocale()));
                continue;
            }
            idStr = idStr + "'" + info.getId().toString() + "',";
        }
        if (!StringUtils.isEmpty((String)idStr)) {
            StringBuffer sb = new StringBuffer();
            idStr = idStr.substring(0, idStr.length() - 1);
            sb.append("update T_TM_RptBillRange set FStatus = 2 where FID in (").append(idStr).append(")");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        return errors;
    }

    @Override
    protected ArrayList _cancelCancel(Context ctx, Set ids) throws BOSException, EASBizException {
        String idStr = "";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        RptBillRangeCollection coll = RptBillRangeFactory.getLocalInstance(ctx).getRptBillRangeCollection(view);
        RptBillRangeInfo info = null;
        ArrayList<String> errors = new ArrayList<String>();
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (DraftItemStatus.AWAKEN.equals((Object)info.getStatus())) {
                errors.add(info.getNumber() + " : " + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "CANNOT_AWAKEN", ctx.getLocale()));
                continue;
            }
            idStr = idStr + "'" + info.getId().toString() + "',";
        }
        if (!StringUtils.isEmpty((String)idStr)) {
            StringBuffer sb = new StringBuffer();
            idStr = idStr.substring(0, idStr.length() - 1);
            sb.append("update T_TM_RptBillRange set FStatus = 1 where FID in (").append(idStr).append(")");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        return errors;
    }
}

