/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.TaxPayerType;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.PeriodTypeEnum;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.CompanyStatus;
import com.kingdee.eas.tm.td.basedata.ITaxBase;
import com.kingdee.eas.tm.td.basedata.ITaxItemType;
import com.kingdee.eas.tm.td.basedata.LegalQualificationType;
import com.kingdee.eas.tm.td.basedata.TaxBaseCollection;
import com.kingdee.eas.tm.td.basedata.TaxBaseEntryCollection;
import com.kingdee.eas.tm.td.basedata.TaxBaseEntryInfo;
import com.kingdee.eas.tm.td.basedata.TaxBaseFactory;
import com.kingdee.eas.tm.td.basedata.TaxBaseInfo;
import com.kingdee.eas.tm.td.basedata.TaxInfoState;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeCollection;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeFactory;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.StringEnum;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class TaxBaseDataImport
extends AbstractDataTransmission {
    private static final int RAET_PRECISION = 6;
    private static final int INCOMERATIO_PRECISION = 2;
    private static final int MAINRATE_PRECISION = 6;
    private static final BigDecimal ONE_HUNDRED = new BigDecimal(100);
    private TaxBaseInfo taxBaseInfo = new TaxBaseInfo();
    private static final String[] ATTR_NAME_F7 = new String[]{"taxOfficer", "financer", "legalRepresentor", "mainGovName", "mainCompany", "registCountry", "operateCountry", "registProvince", "operateProvince", "registCity", "operateCity", "taxCurrency", "costCenter", "creator", "lastUpdateUser"};
    private static final String[] CELL_NAME_F7 = new String[]{"FTaxOfficer_number", "FFinancer_number", "FLegalRepresentor_number", "FMainGovName_number", "FMainCompany_number", "FRegistCountry_number", "FOperateCountry_number", "FRegistProvince_number", "FOperateProvince_number", "FRegistCity_number", "FOperateCity_number", "FTaxCurrency_number", "FCostCenter_number", "FCreator_number", "FLastUpdateUser_number"};
    private static final String[] PERSON_ATTR_NAME = new String[]{"taxOfficer", "financer", "legalRepresentor"};
    private static final String[] USER_ATTR_NAME = new String[]{"creator", "lastUpdateUser"};
    private static final String[] COMPANY_ATTR_NAME = new String[]{"mainGovName", "mainCompany"};
    private static final String[] COUNTRY_ATTR_NAME = new String[]{"registCountry", "operateCountry"};
    private static final String[] PROVINCE_ATTR_NAME = new String[]{"registProvince", "operateProvince"};
    private static final String[] CITY_ATTR_NAME = new String[]{"registCity", "operateCity"};
    private static final String[] CURRENCY_ATTR_NAME = new String[]{"taxCurrency"};
    private static final String[] COSTCENTER_ATTR_NAME = new String[]{"costCenter"};
    private static final String[] TAXITEMTYPE_ATTR_NAME = new String[]{"taxItemTypeID"};
    private static final String[] ATTR_NAME_TEXT = new String[]{"taxOfficerTel", "taxpayerName", "taxpayerIdetifyNO", "registerType", "registAddress", "operateAddress", "countryNameAndCode", "industryName", "industryCode", "operateScole", "mainGovAgency", "nationTaxContact", "nationTaxTel"};
    private static final String[] CELL_NAME_TEXT = new String[]{"FTaxOfficerTel", "FTaxpayerName_l2", "FTaxpayerIdetifyNO", "FRegisterType", "FRegistAddress_l2", "FOperateAddress", "FCountryNameAndCode", "FIndustryName", "FIndustryCode", "FOperateScole", "FMainGovAgency", "FNationTaxContact", "FNationTaxTel"};
    private static final String[] ATTR_NAME_NUM = new String[]{"mainRate", "registCapital", "totalInvest"};
    private static final String[] CELL_NAME_NUM = new String[]{"FMainRate", "FRegistCapital", "FTotalInvest"};
    private static final String[] ATTR_NAME_DATE = new String[]{"enterRegistDate", "createTime", "lastUpdateTime"};
    private static final String[] CELL_NAME_DATE = new String[]{"FEnterRegistDate", "FCreateTime", "FLastUpdateTime"};
    private static final String[] ATTR_NAME_ENUM = new String[]{"taxpayerType", "comStatus", "legalQualification", "state"};
    private static final String[] CELL_NAME_ENUM = new String[]{"FTaxpayerType", "FComStatus", "FLegalQualification", "FState"};
    private static final String[] ATTR_NAME_RADIO = new String[]{"isMinitype", "isSumRatepayCom", "isThousandEnterprise", "isKeyTaxEnterprise"};
    private static final String[] CELL_NAME_RADIO = new String[]{"FIsMinitype", "FIsSumRatepayCom", "FIsThousandEnterprise", "FIsKeyTaxEnterprise"};
    private static final String[] ATTR_NAME_NUM_ENTRY = new String[]{"taxRate", "incomeRatioOne", "incomeRatioTwo"};
    private static final String[] CELL_NAME_NUM_ENTRY = new String[]{"FTaxBaseEntry_taxRate", "FTaxBaseEntry_incomeRatioOne", "FTaxBaseEntry_incomeRatioTwo"};
    private static final ArrayList<String> VARCHAR_TEXT = new ArrayList<String>(Arrays.asList("FTaxOfficerTel", "FTaxpayerIdetifyNO", "FRegisterType", "FOperateScole", "FNationTaxTel"));
    private static final int[] VARCHAR_TEXT_MAX_LENGTH = new int[]{44, 80, 44, 255, 40};
    private static final ArrayList<String> NVARCHAR_TEXT = new ArrayList<String>(Arrays.asList("FTaxpayerName_l2", "FRegistAddress_l2", "FOperateAddress", "FCountryNameAndCode", "FIndustryName", "FIndustryCode", "FMainGovAgency", "FNationTaxContact"));
    private static final int[] NVARCHAR_TEXT_MAX_LENGTH = new int[]{120, 120, 120, 44, 120, 80, 100, 40};
    private static final String[] CELL_NAME_ENTRY = new String[]{"FTaxBaseEntry_seq", "FTaxBaseEntry$taxItemTypeID_name_l2", "FTaxBaseEntry_taxTypeCheckDate", "FTaxBaseEntry_taxPeriod", "FTaxBaseEntry_taxRate", "FTaxBaseEntry_incomeRatioOne", "FTaxBaseEntry_incomeRatioTwo"};
    private Hashtable firstData = null;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return TaxBaseFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException(bex.getMessage(), (Throwable)bex);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        this.taxBaseInfo = null;
        int k = 0;
        HashMap<String, TaxBaseEntryInfo> taxBaseEntryInfoMap = null;
        for (int i = 0; i < hsData.size(); ++i) {
            Hashtable lineData = (Hashtable)hsData.get(new Integer(i));
            if (k == 0) {
                this.taxBaseInfo = this.transmitHead(lineData, ctx);
                if (this.taxBaseInfo == null) {
                    return null;
                }
                if (this.isSltImportUpdate()) {
                    taxBaseEntryInfoMap = new HashMap<String, TaxBaseEntryInfo>();
                    TaxBaseEntryCollection entries = this.taxBaseInfo.getTaxBaseEntry();
                    if (entries != null && entries.size() > 0) {
                        for (int j = 0; j < entries.size(); ++j) {
                            taxBaseEntryInfoMap.put(entries.get(i).getTaxItemTypeID() == null ? null : entries.get(i).getTaxItemTypeID().getNumber(), entries.get(j));
                        }
                    }
                }
            }
            TaxBaseEntryInfo entryInfo = null;
            entryInfo = this.transmitEntry(lineData, ctx, i, (Map<String, TaxBaseEntryInfo>)taxBaseEntryInfoMap);
            this.afterBuildEntry(entryInfo);
            ++k;
        }
        if (taxBaseEntryInfoMap != null && taxBaseEntryInfoMap.size() > 0) {
            for (Map.Entry entry : taxBaseEntryInfoMap.entrySet()) {
                this.taxBaseInfo.getTaxBaseEntry().remove((TaxBaseEntryInfo)entry.getValue());
            }
        }
        return this.taxBaseInfo;
    }

    private void afterBuildEntry(TaxBaseEntryInfo entryInfo) {
        entryInfo.setParent(this.taxBaseInfo);
        this.taxBaseInfo.getTaxBaseEntry().add(entryInfo);
    }

    private TaxBaseEntryInfo transmitEntry(Hashtable hsData, Context ctx, int index, Map<String, TaxBaseEntryInfo> taxBaseEntryInfoMap) throws TaskExternalException {
        TaxBaseEntryInfo entry = new TaxBaseEntryInfo();
        TaxBaseEntryCollection entries = this.taxBaseInfo.getTaxBaseEntry();
        this.checkEntryInput(ctx, hsData);
        String FEntryTaxTypeNumber = this.getCellStr(hsData, "FTaxBaseEntry$taxItemTypeID_number");
        String colName = this.colName(hsData, "FTaxBaseEntry$taxItemTypeID_number");
        BOSUuid entryId = null;
        if (FEntryTaxTypeNumber != null && !"".equals(FEntryTaxTypeNumber)) {
            try {
                if (this.isSltImportUpdate()) {
                    for (int i = 0; i < entries.size(); ++i) {
                        if (!FEntryTaxTypeNumber.equals(entries.get(i).getTaxItemTypeID() == null ? null : entries.get(i).getTaxItemTypeID().getNumber())) continue;
                        entryId = entries.get(i).getId();
                        entries.remove(entries.get(i));
                        taxBaseEntryInfoMap.remove(FEntryTaxTypeNumber);
                        entry.setSeq(i + 1);
                    }
                }
            }
            catch (Exception e) {
                throw new TaskExternalException(colName + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "Data_Error", ctx.getLocale()));
            }
        }
        if (entryId != null) {
            entry.put("id", entryId);
        }
        this.doF7(hsData, ctx, (CoreBaseInfo)entry, "taxItemTypeID", "FTaxBaseEntry$taxItemTypeID_number");
        this.doDate(hsData, ctx, (CoreBaseInfo)entry, "taxTypeCheckDate", "FTaxBaseEntry_taxTypeCheckDate");
        String taxPeriodValue = this.getCellStr(hsData, "FTaxBaseEntry_taxPeriod");
        if (entry.getTaxItemTypeID() != null && TDUtils.isEmpty(taxPeriodValue)) {
            throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "TaxPeriod_notNull", ctx.getLocale()));
        }
        if (entry.getTaxItemTypeID() != null && !TDUtils.isEmpty(taxPeriodValue)) {
            this.doEnum(hsData, ctx, (CoreBaseInfo)entry, "taxPeriod", "FTaxBaseEntry_taxPeriod");
        }
        for (int i = 0; i < ATTR_NAME_NUM_ENTRY.length; ++i) {
            this.doNum(hsData, ctx, (CoreBaseInfo)entry, ATTR_NAME_NUM_ENTRY[i], CELL_NAME_NUM_ENTRY[i]);
        }
        return entry;
    }

    public void checkEntryInput(Context ctx, Hashtable hsData) throws TaskExternalException {
        String FEntryTaxTypeNumber = this.getCellStr(hsData, "FTaxBaseEntry$taxItemTypeID_number");
        String FEntryTaxTypeColName = this.colName(hsData, "FTaxBaseEntry$taxItemTypeID_number");
        if (!TDUtils.isEmpty(FEntryTaxTypeNumber)) {
            return;
        }
        String cellString = "";
        boolean isOtherFieldHasValue = false;
        int j = CELL_NAME_ENTRY.length;
        for (int i = 0; i < j; ++i) {
            cellString = this.getCellStr(hsData, CELL_NAME_ENTRY[i]);
            if (TDUtils.isEmpty(cellString)) continue;
            isOtherFieldHasValue = true;
        }
        if (isOtherFieldHasValue) {
            throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "TaxItemType_notNull", ctx.getLocale()));
        }
    }

    public TaxBaseInfo transmitHead(Hashtable hsData, Context ctx) throws TaskExternalException {
        int i;
        TaxBaseInfo taxBaseInfo = new TaxBaseInfo();
        this.doCompany(hsData, ctx, taxBaseInfo);
        taxBaseInfo = this.doNumber(hsData, ctx, taxBaseInfo);
        this.doName(hsData, ctx, taxBaseInfo);
        for (i = 0; i < ATTR_NAME_F7.length; ++i) {
            this.doF7(hsData, ctx, (CoreBaseInfo)taxBaseInfo, ATTR_NAME_F7[i], CELL_NAME_F7[i]);
        }
        for (i = 0; i < ATTR_NAME_TEXT.length; ++i) {
            this.doText(hsData, ctx, taxBaseInfo, ATTR_NAME_TEXT[i], CELL_NAME_TEXT[i]);
        }
        for (i = 0; i < ATTR_NAME_NUM.length; ++i) {
            this.doNum(hsData, ctx, (CoreBaseInfo)taxBaseInfo, ATTR_NAME_NUM[i], CELL_NAME_NUM[i]);
        }
        for (i = 0; i < ATTR_NAME_DATE.length; ++i) {
            this.doDate(hsData, ctx, (CoreBaseInfo)taxBaseInfo, ATTR_NAME_DATE[i], CELL_NAME_DATE[i]);
        }
        for (i = 0; i < ATTR_NAME_ENUM.length; ++i) {
            this.doEnum(hsData, ctx, (CoreBaseInfo)taxBaseInfo, ATTR_NAME_ENUM[i], CELL_NAME_ENUM[i]);
        }
        for (i = 0; i < ATTR_NAME_RADIO.length; ++i) {
            this.doRadio(hsData, ctx, taxBaseInfo, ATTR_NAME_RADIO[i], CELL_NAME_RADIO[i]);
        }
        return taxBaseInfo;
    }

    private void doEnum(Hashtable hsData, Context ctx, CoreBaseInfo coreBaseInfo, String attrName, String cellName) throws TaskExternalException {
        String colName = this.colName(hsData, cellName);
        String value = this.getCellStr(hsData, cellName).trim();
        if (value != null || !"".equals(value)) {
            Object enumTemp = null;
            if (attrName.equals("taxpayerType")) {
                enumTemp = TaxPayerType.getEnum((String)value);
                if (enumTemp == null) {
                    List enumList = TaxPayerType.getEnumList();
                    for (StringEnum _enum : enumList) {
                        if (!_enum.getAlias().trim().equals(value)) continue;
                        enumTemp = _enum;
                        break;
                    }
                }
            } else if (attrName.equals("comStatus")) {
                enumTemp = CompanyStatus.getEnum(value);
                if (enumTemp == null) {
                    List enumList = CompanyStatus.getEnumList();
                    for (StringEnum _enum : enumList) {
                        if (!_enum.getAlias().trim().equals(value)) continue;
                        enumTemp = _enum;
                        break;
                    }
                }
            } else if (attrName.equals("legalQualification")) {
                enumTemp = LegalQualificationType.getEnum(value);
                if (enumTemp == null) {
                    List enumList = LegalQualificationType.getEnumList();
                    for (StringEnum _enum : enumList) {
                        if (!_enum.getAlias().trim().equals(value)) continue;
                        enumTemp = _enum;
                        break;
                    }
                }
            } else if (attrName.equals("state")) {
                enumTemp = TaxInfoState.getEnum(value);
                if (enumTemp == null) {
                    List enumList = TaxInfoState.getEnumList();
                    for (StringEnum _enum : enumList) {
                        if (!_enum.getAlias().trim().equals(value)) continue;
                        enumTemp = _enum;
                        break;
                    }
                }
            } else if (attrName.equals("taxPeriod") && (enumTemp = PeriodTypeEnum.getEnum(value)) == null) {
                List enumList = PeriodTypeEnum.getEnumList();
                for (StringEnum _enum : enumList) {
                    if (!_enum.getAlias().trim().equals(value)) continue;
                    enumTemp = _enum;
                    break;
                }
            }
            if (enumTemp == null) {
                throw new TaskExternalException(colName + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "Data_Error", ctx.getLocale()));
            }
            coreBaseInfo.put(attrName, (Object)enumTemp.getValue());
        } else if (attrName.equals("state")) {
            coreBaseInfo.put(attrName, (Object)TaxInfoState.ABLE.getValue());
        }
    }

    private void doRadio(Hashtable hsData, Context ctx, CoreBillBaseInfo coreBillBaseInfo, String attrName, String cellName) throws TaskExternalException {
        String colName = this.colName(hsData, cellName);
        String value = this.getCellStr(hsData, cellName).trim();
        if (!StringUtils.isEmpty((String)value)) {
            if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("\u662f")) {
                coreBillBaseInfo.put(attrName, (Object)true);
            } else if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("\u5426")) {
                coreBillBaseInfo.put(attrName, (Object)false);
            } else {
                throw new TaskExternalException(colName + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "Data_Error", ctx.getLocale()));
            }
        }
    }

    private void doDate(Hashtable hsData, Context ctx, CoreBaseInfo coreBaseInfo, String attrName, String cellName) throws TaskExternalException {
        String colName = this.colName(hsData, cellName);
        Date date = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Object o = ((DataToken)hsData.get((Object)cellName)).data;
        if (o != null && o.toString().length() > 0) {
            try {
                o = df.parse(o.toString());
            }
            catch (ParseException pex) {
                throw new TaskExternalException(colName + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "DATE_ERROR", ctx.getLocale()));
            }
        }
        if (o != null && o instanceof Date) {
            date = (Date)o;
        }
        coreBaseInfo.put(attrName, date);
    }

    private void doNum(Hashtable hsData, Context ctx, CoreBaseInfo coreBaseInfo, String attrName, String cellName) throws TaskExternalException {
        String num = this.getCellStr(hsData, cellName);
        String colName = this.colName(hsData, cellName);
        BigDecimal bdNum = null;
        if (num != null && !"".equals(num)) {
            String valStr = num.trim();
            DecimalFormat format = new DecimalFormat();
            try {
                Number val = format.parse(valStr);
                bdNum = new BigDecimal(val.toString());
            }
            catch (ParseException e) {
                throw new TaskExternalException(colName + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "Data_Error", ctx.getLocale()));
            }
            if (attrName.equals("mainRate")) {
                this.doMainRate(ctx, bdNum, colName);
                bdNum = bdNum.divide(ONE_HUNDRED).setScale(8, 4);
            }
            if (attrName.equals("incomeRatioOne") || attrName.equals("incomeRatioTwo")) {
                bdNum = bdNum.divide(ONE_HUNDRED).setScale(4, 4);
            }
            if (attrName.equals("taxRate")) {
                bdNum = bdNum.divide(ONE_HUNDRED).setScale(8, 4);
            }
            coreBaseInfo.put(attrName, (Object)bdNum);
        }
    }

    private void doMainRate(Context ctx, BigDecimal bdNum, String colName) throws TaskExternalException {
        bdNum.setScale(6, 4);
        if (bdNum.compareTo(new BigDecimal("100")) > 0) {
            throw new TaskExternalException(colName + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "Rate_tooLarger", ctx.getLocale()));
        }
        if (bdNum.compareTo(new BigDecimal("0")) < 0) {
            throw new TaskExternalException(colName + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "Rate_tooSmall", ctx.getLocale()));
        }
    }

    private void doText(Hashtable hsData, Context ctx, CoreBillBaseInfo coreBillBaseInfo, String attrName, String cellName) throws TaskExternalException {
        String str = this.getCellStr(hsData, cellName);
        if (VARCHAR_TEXT.contains(cellName)) {
            try {
                int bytesLength = str.getBytes("utf-8").length;
                int varcharMaxLength = VARCHAR_TEXT_MAX_LENGTH[VARCHAR_TEXT.indexOf(cellName)];
                if (bytesLength > varcharMaxLength) {
                    String errorMsg = TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "Varchar_TooLong", ctx.getLocale(), new Object[]{((DataToken)hsData.get((Object)cellName)).desc, varcharMaxLength});
                    throw new TaskExternalException(errorMsg);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new TaskExternalException(e.getMessage());
            }
        }
        if (NVARCHAR_TEXT.contains(cellName)) {
            int nvarcharMaxLength = NVARCHAR_TEXT_MAX_LENGTH[NVARCHAR_TEXT.indexOf(cellName)];
            if (str.length() > nvarcharMaxLength) {
                String errorMsg = TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "Nvarchar_TooLong", ctx.getLocale(), new Object[]{((DataToken)hsData.get((Object)cellName)).desc, nvarcharMaxLength});
                throw new TaskExternalException(errorMsg);
            }
        }
        coreBillBaseInfo.put(attrName, (Object)str, null);
    }

    private void doF7(Hashtable hsData, Context ctx, CoreBaseInfo coreBaseInfo, String attrName, String cellName) throws TaskExternalException {
        String number = this.getCellStr(hsData, cellName);
        String colName = this.colName(hsData, cellName);
        if (number == null || "".equals(number)) {
            return;
        }
        CoreBaseInfo info = new CoreBaseInfo(){};
        try {
            if (this.isInclude(PERSON_ATTR_NAME, attrName)) {
                info = DataImportUtils.getPersonInfoFromNumber((Context)ctx, (String)number);
            } else if (this.isInclude(USER_ATTR_NAME, attrName)) {
                info = DataImportUtils.getUserInfoFromNumber((Context)ctx, (String)number);
            } else if (this.isInclude(COMPANY_ATTR_NAME, attrName)) {
                info = DataImportUtils.getCompanyOrgUnitInfoFromNumber((Context)ctx, (String)number);
            } else if (this.isInclude(COUNTRY_ATTR_NAME, attrName)) {
                info = DataImportUtils.getCountryInfoFromNumber((Context)ctx, (String)number);
            } else if (this.isInclude(PROVINCE_ATTR_NAME, attrName)) {
                info = DataImportUtils.getProvinceInfoFromNumber((Context)ctx, (String)number);
            } else if (this.isInclude(CITY_ATTR_NAME, attrName)) {
                info = DataImportUtils.getCityInfoFromNumber((Context)ctx, (String)number);
            } else if (this.isInclude(CURRENCY_ATTR_NAME, attrName)) {
                info = DataImportUtils.getCurrencyInfoFromNumber((Context)ctx, (String)number);
            } else if (this.isInclude(COSTCENTER_ATTR_NAME, attrName)) {
                info = this.getCostCenterInfoFromNumber(ctx, number);
            } else if (this.isInclude(TAXITEMTYPE_ATTR_NAME, attrName)) {
                info = this.getTaxItemTypeInfoFromNumber(ctx, number);
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        if (info == null) {
            String errorMsg = colName + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "Data_Error", ctx.getLocale());
            throw new TaskExternalException(errorMsg);
        }
        coreBaseInfo.put(attrName, (Object)info);
    }

    private CoreBaseInfo getCostCenterInfoFromNumber(Context ctx, String number) throws BOSException {
        CostCenterOrgUnitInfo info = null;
        if (number != null && number.trim().length() > 0) {
            EntityViewInfo viewInfo = DataImportUtils.getViewInfo((String)number);
            ICostCenterOrgUnit iCostCenterOrgUnit = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
            CostCenterOrgUnitCollection collection = iCostCenterOrgUnit.getCostCenterOrgUnitCollection(viewInfo);
            if (collection != null && collection.size() > 0) {
                info = collection.get(0);
            }
        }
        return info;
    }

    private CoreBaseInfo getTaxItemTypeInfoFromNumber(Context ctx, String number) throws BOSException {
        TaxItemTypeInfo info = null;
        if (number != null && number.trim().length() > 0) {
            EntityViewInfo viewInfo = DataImportUtils.getViewInfo((String)number);
            ITaxItemType iTaxItemType = TaxItemTypeFactory.getLocalInstance(ctx);
            TaxItemTypeCollection collection = iTaxItemType.getTaxItemTypeCollection(viewInfo);
            if (collection != null && collection.size() > 0) {
                info = collection.get(0);
            }
        }
        return info;
    }

    public boolean isInclude(String[] array, String str) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != str) continue;
            return true;
        }
        return false;
    }

    private void doCompany(Hashtable hsData, Context ctx, TaxBaseInfo taxBaseInfo) throws TaskExternalException {
        String colNameCompanyName = this.colName(hsData, "FCompany_name_l2");
        String colNameCompanyNumber = this.colName(hsData, "FCompany_number");
        CompanyOrgUnitCollection coll = new CompanyOrgUnitCollection();
        EntityViewInfo view = new EntityViewInfo();
        String errorStr = "";
        boolean isShowError = true;
        String companyName = this.getCellStr(hsData, "FCompany_name_l2");
        String companyNumber = this.getCellStr(hsData, "FCompany_number");
        if ("".equals(companyNumber) && "".equals(companyName)) {
            errorStr = errorStr + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "CompanyNumberOrName_NotNULL", ctx.getLocale(), new Object[]{colNameCompanyNumber, colNameCompanyName});
        } else if (!"".equals(companyNumber)) {
            try {
                CompanyOrgUnitInfo companyInfo = DataImportUtils.getCompanyOrgUnitInfoFromNumber((Context)ctx, (String)companyNumber);
                if (companyInfo == null) {
                    errorStr = errorStr + colNameCompanyNumber + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "Data_Error", ctx.getLocale());
                }
                taxBaseInfo.setCompany(companyInfo);
                isShowError = false;
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        } else if (!"".equals(companyName)) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)companyName, CompareType.EQUALS));
            view.setFilter(filter);
            try {
                coll = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
                if (coll.size() == 0) {
                    errorStr = errorStr + colNameCompanyName + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "Data_Error", ctx.getLocale());
                } else {
                    taxBaseInfo.setCompany(coll.get(0));
                    isShowError = false;
                }
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
        if (isShowError) {
            throw new TaskExternalException(errorStr);
        }
    }

    private boolean checkSameCompany(Context ctx, CompanyOrgUnitInfo companyInfo) throws TaskExternalException {
        EntityViewInfo view = new EntityViewInfo();
        ITaxBase iTaxBase = (ITaxBase)this.getController(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"1", CompareType.EQUALS));
        view.setFilter(filter);
        try {
            TaxBaseCollection coll = iTaxBase.getTaxBaseCollection(view);
            return coll.size() > 0;
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    private void checkPermission(Context ctx, String companyId) throws TaskExternalException {
        String permItem = "taxbase_new";
        if (this.isSltImportUpdate()) {
            permItem = "taxbase_update";
        }
        try {
            TDUtils.checkPermission(ctx, String.valueOf(ContextUtil.getCurrentUserInfo((Context)ctx).getId()), companyId, permItem);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage());
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    private TaxBaseInfo doNumber(Hashtable hsData, Context ctx, TaxBaseInfo taxBaseInfo) throws TaskExternalException {
        Object number = ((DataToken)hsData.get((Object)"FNumber")).data;
        String importCompanyId = String.valueOf(taxBaseInfo.getCompany().getId());
        if (number != null && number.toString().trim().length() > 0) {
            taxBaseInfo.setNumber(number.toString().trim());
            TaxBaseCollection taxBaseCollection = this.getTaxBaseCollection(ctx, number.toString().trim());
            if (!this.isSltImportUpdate()) {
                if (taxBaseCollection.size() > 0) {
                    String str = TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "EXIST_SAME_NUMBER", ctx.getLocale());
                    throw new TaskExternalException(number.toString().trim() + "  " + str);
                }
                this.doEnum(hsData, ctx, (CoreBaseInfo)taxBaseInfo, "state", "FState");
                this.checkPermission(ctx, importCompanyId);
                boolean hasActiveTaxBase = this.checkSameCompany(ctx, taxBaseInfo.getCompany());
                if (hasActiveTaxBase && "1".equals(taxBaseInfo.getState().getValue())) {
                    throw new TaskExternalException(taxBaseInfo.getCompany().getName() + ":" + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "Bill_HasExist", ctx.getLocale()));
                }
            } else {
                String status;
                if (taxBaseCollection.size() == 0) {
                    throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "BILL_NOT_EXEIST", ctx.getLocale()));
                }
                this.checkPermission(ctx, String.valueOf(taxBaseCollection.get(0).getCompany().getId()));
                if (!importCompanyId.equals(String.valueOf(taxBaseCollection.get(0).getCompany().getId()))) {
                    String str = TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "UPDATE_COMPANY_ERROR", ctx.getLocale());
                    throw new TaskExternalException(number.toString().trim() + "  " + str);
                }
                String string = status = taxBaseCollection.get(0).getState() == null ? "" : taxBaseCollection.get(0).getState().getValue();
                if (!"0".equals(status)) {
                    String str = TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "BILLSTATUS_ERROR1", ctx.getLocale());
                    throw new TaskExternalException(number.toString().trim() + "  " + str);
                }
                taxBaseInfo = taxBaseCollection.get(0);
            }
        } else {
            String str = TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "NUMBER_IS_ISNULL", ctx.getLocale());
            throw new TaskExternalException(str);
        }
        return taxBaseInfo;
    }

    private TaxBaseCollection getTaxBaseCollection(Context ctx, String number) throws TaskExternalException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("taxBaseEntry.*"));
        sic.add(new SelectorItemInfo("taxBaseEntry.taxItemTypeID.id"));
        sic.add(new SelectorItemInfo("taxBaseEntry.taxItemTypeID.number"));
        sic.add(new SelectorItemInfo("taxBaseEntry.taxItemTypeID.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        view.setSelector(sic);
        try {
            TaxBaseCollection coll = TaxBaseFactory.getLocalInstance(ctx).getTaxBaseCollection(view);
            return coll;
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    private void doName(Hashtable hsData, Context ctx, TaxBaseInfo taxBaseInfo) throws TaskExternalException {
        String name = this.getCellStr(hsData, "FName_l2");
        String colNameName = this.colName(hsData, "FName_l2");
        if (name == null || "".equals(name)) {
            String str = colNameName + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "Data_NotNull", ctx.getLocale());
            throw new TaskExternalException(str);
        }
        taxBaseInfo.setName(name);
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        TaxBaseInfo taxBaseInfo = (TaxBaseInfo)coreBaseInfo;
        TaxBaseEntryCollection entries = taxBaseInfo.getTaxBaseEntry();
        entries.sort("seq");
        ITaxBase iTaxBase = (ITaxBase)this.getController(ctx);
        try {
            iTaxBase.save((CoreBaseInfo)taxBaseInfo);
            iTaxBase.submit((CoreBaseInfo)taxBaseInfo);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private String colName(Hashtable hsData, String cellName) {
        String retval = ((DataToken)hsData.get((Object)cellName)).desc;
        return retval;
    }

    private String getCellStr(Hashtable hsData, String cellName) {
        String retval = "";
        Object o = ((DataToken)hsData.get((Object)cellName)).data;
        if (o != null && !"".equals(o.toString())) {
            retval = o.toString();
        }
        return retval;
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        String yes = TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "YES", ctx.getLocale());
        String no = TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "NO", ctx.getLocale());
        try {
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FName_l2", rs.getString("name"));
            this.putTable(result, "FCompany_name_l2", rs.getString("company.name"));
            this.putTable(result, "FCompany_number", rs.getString("company.number"));
            this.putTable(result, "FFinancer_name_l2", rs.getString("financer.name"));
            this.putTable(result, "FFinancer_number", rs.getString("financer.number"));
            this.putTable(result, "FTaxOfficer_name_l2", rs.getString("taxOfficer.name"));
            this.putTable(result, "FTaxOfficer_number", rs.getString("taxOfficer.number"));
            this.putTable(result, "FTaxOfficerTel", rs.getString("taxOfficerTel"));
            this.putTable(result, "FTaxpayerName_l2", rs.getString("taxpayerName"));
            this.putTable(result, "FTaxpayerIdetifyNO", rs.getString("taxpayerIdetifyNO"));
            this.putTable(result, "FTaxpayerType", TaxPayerType.getEnum((String)rs.getString("taxpayerType")));
            this.putTable(result, "FRegisterType", rs.getString("registerType"));
            this.putTable(result, "FEnterRegistDate", rs.getString("enterRegistDate"));
            this.putTable(result, "FComStatus", (Object)CompanyStatus.getEnum(rs.getString("comStatus")));
            this.putTable(result, "FRegistCountry_name_l2", rs.getString("registCountry.name"));
            this.putTable(result, "FRegistCountry_number", rs.getString("registCountry.number"));
            this.putTable(result, "FRegistProvince_name_l2", rs.getString("registProvince.name"));
            this.putTable(result, "FRegistProvince_number", rs.getString("registProvince.number"));
            this.putTable(result, "FRegistCity_name_l2", rs.getString("registCity.name"));
            this.putTable(result, "FRegistCity_number", rs.getString("registCity.number"));
            this.putTable(result, "FRegistAddress_l2", rs.getString("registAddress"));
            this.putTable(result, "FOperateCountry_name_l2", rs.getString("operateCountry.name"));
            this.putTable(result, "FOperateCountry_number", rs.getString("operateCountry.number"));
            this.putTable(result, "FOperateProvince_name_l2", rs.getString("operateProvince.name"));
            this.putTable(result, "FOperateProvince_number", rs.getString("operateProvince.number"));
            this.putTable(result, "FOperateCity_name_l2", rs.getString("operateCity.name"));
            this.putTable(result, "FOperateCity_number", rs.getString("operateCity.number"));
            this.putTable(result, "FOperateAddress", rs.getString("operateAddress"));
            this.putTable(result, "FCountryNameAndCode", rs.getString("countryNameAndCode"));
            this.putTable(result, "FIndustryName", rs.getString("industryName"));
            this.putTable(result, "FIndustryCode", rs.getString("industryCode"));
            this.putTable(result, "FIsSumRatepayCom", Boolean.parseBoolean(rs.getString("isSumRatepayCom")) ? yes : no);
            this.putTable(result, "FIsMinitype", Boolean.parseBoolean(rs.getString("isMinitype")) ? yes : no);
            this.putTable(result, "FOperateScole", rs.getString("operateScole"));
            this.putTable(result, "FLegalQualification", (Object)LegalQualificationType.getEnum(rs.getString("legalQualification")));
            this.putTable(result, "FMainGovName_name_l2", rs.getString("mainGovName.name"));
            this.putTable(result, "FMainGovName_number", rs.getString("mainGovName.number"));
            this.putTable(result, "FMainCompany_name_l2", rs.getString("mainCompany.name"));
            this.putTable(result, "FMainCompany_number", rs.getString("mainCompany.number"));
            this.putTable(result, "FMainRate", rs.getBigDecimal("mainRate") == null ? null : rs.getBigDecimal("mainRate").multiply(ONE_HUNDRED).setScale(6));
            this.putTable(result, "FMainGovAgency", rs.getString("mainGovAgency"));
            this.putTable(result, "FNationTaxContact", rs.getString("nationTaxContact"));
            this.putTable(result, "FNationTaxTel", rs.getString("nationTaxTel"));
            this.putTable(result, "FTaxCurrency_name_l2", rs.getString("taxCurrency.name"));
            this.putTable(result, "FTaxCurrency_number", rs.getString("taxCurrency.number"));
            this.putTable(result, "FRegistCapital", rs.getString("registCapital"));
            this.putTable(result, "FTotalInvest", rs.getString("totalInvest"));
            this.putTable(result, "FLegalRepresentor_name_l2", rs.getString("legalRepresentor.name"));
            this.putTable(result, "FLegalRepresentor_number", rs.getString("legalRepresentor.number"));
            this.putTable(result, "FIsThousandEnterprise", Boolean.parseBoolean(rs.getString("isThousandEnterprise")) ? yes : no);
            this.putTable(result, "FIsKeyTaxEnterprise", Boolean.parseBoolean(rs.getString("isKeyTaxEnterprise")) ? yes : no);
            this.putTable(result, "FState", (Object)TaxInfoState.getEnum(rs.getString("state")));
            this.putTable(result, "FCostCenter_name_l2", rs.getString("costCenter.name"));
            this.putTable(result, "FCostCenter_number", rs.getString("costCenter.number"));
            this.putTable(result, "FTaxBaseEntry_seq", rs.getString("taxBaseEntry.seq"));
            this.putTable(result, "FTaxBaseEntry$taxItemTypeID_name_l2", rs.getString("taxItemTypeID.name"));
            this.putTable(result, "FTaxBaseEntry$taxItemTypeID_number", rs.getString("taxItemTypeID.number"));
            this.putTable(result, "FTaxBaseEntry_taxTypeCheckDate", rs.getString("taxBaseEntry.taxTypeCheckDate"));
            this.putTable(result, "FTaxBaseEntry_taxPeriod", (Object)PeriodTypeEnum.getEnum(rs.getString("taxBaseEntry.taxPeriod")));
            this.putTable(result, "FTaxBaseEntry_taxRate", rs.getBigDecimal("taxBaseEntry.taxRate") == null ? null : rs.getBigDecimal("taxBaseEntry.taxRate").multiply(ONE_HUNDRED).setScale(6));
            this.putTable(result, "FTaxBaseEntry_incomeRatioOne", rs.getBigDecimal("taxBaseEntry.incomeRatioOne") == null ? null : rs.getBigDecimal("taxBaseEntry.incomeRatioOne").multiply(ONE_HUNDRED).setScale(6));
            this.putTable(result, "FTaxBaseEntry_incomeRatioTwo", rs.getBigDecimal("taxBaseEntry.incomeRatioTwo") == null ? null : rs.getBigDecimal("taxBaseEntry.incomeRatioTwo").multiply(ONE_HUNDRED).setScale(6));
            this.putTable(result, "FCreator_number", rs.getString("creator.number"));
            this.putTable(result, "FCreator_name_l2", rs.getString("creator.name"));
            this.putTable(result, "FCreateTime", rs.getString("createTime"));
            this.putTable(result, "FLastUpdateUser_number", rs.getString("lastUpdateUser.number"));
            this.putTable(result, "FLastUpdateUser_name_l2", rs.getString("lastUpdateUser.name"));
            this.putTable(result, "FLastUpdateTime", rs.getString("lastUpdateTime"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        if (this.getContextMap().get("filter") != null) {
            String filterStr = this.getContextMap().get("filter").toString();
            filterStr = filterStr.replace("$", "'");
            try {
                filter = new FilterInfo(filterStr);
            }
            catch (ParserException e) {
                Logger.error((Throwable)e);
            }
        }
        if (this.getContextMap().get("bizCommonQueryFilter") != null) {
            String filterItems = this.getContextMap().get("bizCommonQueryFilter").toString();
            filterItems = filterItems.replace("$", "'");
            try {
                filter = new FilterInfo(filterItems);
            }
            catch (ParserException e) {
                Logger.error((Throwable)e);
            }
        }
        return filter;
    }

    public int getSubmitType() {
        return 1;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        if (firstData == null || currentData == null) {
            return false;
        }
        DataToken firstNumber = (DataToken)firstData.get(this.getMainField());
        if (this.firstData != null) {
            firstNumber = (DataToken)this.firstData.get(this.getMainField());
        }
        DataToken currentNumber = (DataToken)currentData.get(this.getMainField());
        this.firstData = currentData;
        return firstNumber != null && currentNumber != null && firstNumber.data != null && !"".equals(firstNumber.data) && currentNumber.data != null && !"".equals(currentNumber.data) && firstNumber.equals((Object)currentNumber);
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.tm.td.basedata.app.TaxBaseQuery";
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }
}

