/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.basedata.TaxReliefRulesFactory;
import com.kingdee.eas.tm.td.basedata.TaxReliefRulesInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;

public class TaxReliefRulesDataImport
extends AbstractDataTransmission {
    private TaxReliefRulesInfo taxReliefRulesInfo = null;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return TaxReliefRulesFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            Logger.error((Throwable)bex);
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase iTaxReliefRules = this.getController(ctx);
        TaxReliefRulesInfo taxReliefRules = (TaxReliefRulesInfo)coreBaseInfo;
        if (coreBaseInfo == null) {
            return;
        }
        try {
            if (coreBaseInfo.getId() == null || !iTaxReliefRules.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                iTaxReliefRules.addnew(coreBaseInfo);
            } else {
                iTaxReliefRules.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        this.taxReliefRulesInfo = null;
        Boolean isUpdate = this.isSltImportUpdate();
        try {
            this.taxReliefRulesInfo = this.transmitData(hsData, isUpdate, ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        if (this.taxReliefRulesInfo == null) {
            return null;
        }
        return this.taxReliefRulesInfo;
    }

    private TaxReliefRulesInfo transmitData(Hashtable hsData, boolean isUpdate, Context ctx) throws TaskExternalException, BOSException, EASBizException {
        String derateItemCode;
        Date expireDate;
        Date validDate;
        String relatedPolicyTerms;
        String taxReliefMajorCatergory;
        this.taxReliefRulesInfo = new TaxReliefRulesInfo();
        this.doUnique(hsData, isUpdate, ctx);
        TaxItemTypeInfo taxItemTypeInfo = this.getTaxItemType(hsData, ctx);
        if (taxItemTypeInfo != null) {
            this.taxReliefRulesInfo.setTaxItemType(taxItemTypeInfo);
        }
        if (StringUtils.isEmpty((String)(taxReliefMajorCatergory = this.getString(hsData, "FTaxReliefMajorCatergory")))) {
            throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxReliefRulesResource", "TaxReliefMajorCatergoryNotNull", ctx.getLocale()));
        }
        this.taxReliefRulesInfo.setTaxReliefMajorCatergory(taxReliefMajorCatergory);
        String taxReliefSubCatergory = this.getString(hsData, "FTaxReliefSubCatergory");
        if (StringUtils.isEmpty((String)taxReliefSubCatergory)) {
            throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxReliefRulesResource", "TaxReliefSubCatergoryNotNull", ctx.getLocale()));
        }
        this.taxReliefRulesInfo.setTaxReliefSubCatergory(taxReliefSubCatergory);
        String preferentialTerms = this.getString(hsData, "FPreferentialTerms");
        if (!StringUtils.isEmpty((String)preferentialTerms)) {
            this.taxReliefRulesInfo.setPreferentialTerms(preferentialTerms);
        }
        if (!StringUtils.isEmpty((String)(relatedPolicyTerms = this.getString(hsData, "FRelatedPolicyTerms")))) {
            this.taxReliefRulesInfo.setRelatedPolicyTerms(relatedPolicyTerms);
        }
        if ((validDate = this.getDate(hsData, "FValidDate", ctx)) != null) {
            this.taxReliefRulesInfo.setValidDate(validDate);
        }
        if ((expireDate = this.getDate(hsData, "FExpireDate", ctx)) != null) {
            this.taxReliefRulesInfo.setExpireDate(expireDate);
        }
        if (!StringUtils.isEmpty((String)(derateItemCode = this.getString(hsData, "FDerateItemCode")))) {
            this.taxReliefRulesInfo.setDerateItemCode(derateItemCode);
        }
        this.taxReliefRulesInfo.setCU(CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4")));
        return this.taxReliefRulesInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doUnique(Hashtable hsData, boolean isUpdate, Context ctx) throws TaskExternalException, BOSException {
        String number = this.getString(hsData, "FNumber");
        if (null == number || number.length() == 0) {
            throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxReliefRulesResource", "DedutionExmpCodeNotNull", ctx.getLocale()));
        }
        this.taxReliefRulesInfo.setNumber(number);
        String taxReliefName = this.getString(hsData, "FTaxReliefName");
        if (StringUtils.isEmpty((String)taxReliefName)) {
            throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxReliefRulesResource", "TaxReliefNameNotNull", ctx.getLocale()));
        }
        this.taxReliefRulesInfo.setTaxReliefName(taxReliefName);
        String dedutionExmpName = this.getString(hsData, "FName_l2");
        if (StringUtils.isEmpty((String)dedutionExmpName)) {
            throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxReliefRulesResource", "DedutionExmpNameNotNull", ctx.getLocale()));
        }
        this.taxReliefRulesInfo.setName(dedutionExmpName);
        String id = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FID from T_TD_TaxReliefRules where FNumber='").append(number).append("' and FTaxReliefName = '").append(taxReliefName).append("' and FName_l2 = '").append(dedutionExmpName).append("' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                id = rs.getString("FID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (isUpdate) {
            try {
                if (StringUtils.isEmpty((String)id)) return;
                this.taxReliefRulesInfo.setId(BOSUuid.read((String)id));
                return;
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage());
            }
        } else {
            if (StringUtils.isEmpty((String)id)) return;
            throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxReliefRulesResource", "EXIST_SAME_DATA", ctx.getLocale(), new Object[]{this.taxReliefRulesInfo.getNumber(), this.taxReliefRulesInfo.getTaxReliefName(), this.taxReliefRulesInfo.getName()}));
        }
    }

    private TaxItemTypeInfo getTaxItemType(Hashtable hsData, Context ctx) throws TaskExternalException {
        TaxItemTypeInfo taxItemTypeInfo = null;
        String taxItemTypeName = this.getString(hsData, "FTaxItemType_name_l2");
        if (taxItemTypeName != null && taxItemTypeName.length() > 0) {
            String sql = "select top 1 Fid,FNumber  from T_TM_TaxItemType  where FName_l2 = ?";
            if (taxItemTypeName != null && taxItemTypeName.length() > 0) {
                try {
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{taxItemTypeName});
                    if (rs == null || !rs.next()) {
                        throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxReliefRulesResource", "TaxItemTypeNameNotExists", ctx.getLocale()));
                    }
                    taxItemTypeInfo = new TaxItemTypeInfo();
                    taxItemTypeInfo.setId(BOSUuid.read((String)rs.getString("Fid")));
                    taxItemTypeInfo.setNumber(rs.getString("FNumber"));
                    taxItemTypeInfo.setName(taxItemTypeName);
                }
                catch (BOSException e) {
                    Logger.error((Throwable)e);
                }
                catch (UuidException e) {
                    Logger.error((Throwable)e);
                }
                catch (SQLException e) {
                    Logger.error((Throwable)e);
                }
            }
        } else {
            throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxReliefRulesResource", "TaxItemTypeNameNotNull", ctx.getLocale()));
        }
        return taxItemTypeInfo;
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            DataImportTools.putToHashtable(result, (Object)"FTaxItemType_name_l2", (Object)rs.getString("taxItemType.name"));
            DataImportTools.putToHashtable(result, (Object)"FTaxReliefMajorCatergory", (Object)rs.getString("taxReliefMajorCatergory"));
            DataImportTools.putToHashtable(result, (Object)"FTaxReliefSubCatergory", (Object)rs.getString("taxReliefSubCatergory"));
            DataImportTools.putToHashtable(result, (Object)"FNumber", (Object)rs.getString("number"));
            DataImportTools.putToHashtable(result, (Object)"FTaxReliefName", (Object)rs.getString("taxReliefName"));
            DataImportTools.putToHashtable(result, (Object)"FPreferentialTerms", (Object)rs.getString("preferentialTerms"));
            DataImportTools.putToHashtable(result, (Object)"FDerateItemCode", (Object)rs.getString("derateItemCode"));
            DataImportTools.putToHashtable(result, (Object)"FName_l2", (Object)rs.getString("name"));
            DataImportTools.putToHashtable(result, (Object)"FRelatedPolicyTerms", (Object)rs.getString("relatedPolicyTerms"));
            DataImportTools.putToHashtable(result, (Object)"FValidDate", (Object)rs.getString("validDate"));
            DataImportTools.putToHashtable(result, (Object)"FExpireDate", (Object)rs.getString("expireDate"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        return result;
    }

    protected String getString(Hashtable hsData, String key) {
        Object o = ((DataToken)hsData.get((Object)key)).data;
        return o == null ? null : o.toString();
    }

    protected Date getDate(Hashtable hsData, String key, Context ctx) throws TaskExternalException {
        Object o = ((DataToken)hsData.get((Object)key)).data;
        Date value = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        if (o != null && o.toString().length() > 0) {
            try {
                o = df.parse(o.toString());
            }
            catch (ParseException pex) {
                Logger.error((Throwable)pex);
                throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxReliefRulesResource", "DateFormatError", ctx.getLocale()));
            }
        }
        if (o != null && o instanceof Date) {
            value = (Date)o;
        }
        return value;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        String filterStr;
        FilterInfo filter = new FilterInfo();
        if (this.getContextMap().get("bizCommonQueryFilter") != null) {
            filterStr = this.getContextMap().get("bizCommonQueryFilter").toString();
            filterStr = filterStr.replace("$", "'");
            try {
                filter = new FilterInfo(filterStr);
            }
            catch (ParserException e) {
                Logger.error((Throwable)e);
            }
        }
        if (this.getContextMap().get("filter") != null) {
            filterStr = this.getContextMap().get("filter").toString();
            filterStr = filterStr.replace("$", "'");
            try {
                filter = new FilterInfo(filterStr);
            }
            catch (ParserException e) {
                Logger.error((Throwable)e);
            }
        }
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.tm.td.basedata.app.TaxReliefRulesQuery";
    }
}

