/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.basedata.TaxReportTypeCollection;
import com.kingdee.eas.tm.td.basedata.TaxReportTypeFactory;
import com.kingdee.eas.tm.td.basedata.TaxReportTypeInfo;
import com.kingdee.eas.tm.td.basedata.app.AbstractTaxReportTypeControllerBean;
import com.kingdee.eas.tm.td.cloud.EnableStateEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class TaxReportTypeControllerBean
extends AbstractTaxReportTypeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.basedata.app.TaxReportTypeControllerBean");
    private static final String RES = "com.kingdee.eas.tm.td.basedata.TaxBaseResource";

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TaxReportTypeInfo info = (TaxReportTypeInfo)model;
        this.checkBeforeSave(ctx, info);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (TaxReportTypeFactory.getLocalInstance(ctx).exists(filter)) {
            throw new TDException(TDException.NUMBER_EXIST);
        }
        return super._save(ctx, model);
    }

    private void checkBeforeSave(Context ctx, TaxReportTypeInfo info) throws TDException {
        String number = info.getNumber();
        if (number != null && "".equals(number.trim())) {
            String error = EASResource.getString((String)RES, (String)"Number_NULL");
            throw new TDException(TDException.ERROR_MSG, new Object[]{error});
        }
        info.setNumber(number == null ? "" : number.trim());
        String name = info.getName();
        if (name != null && "".equals(name.trim())) {
            String error = EASResource.getString((String)RES, (String)"Name_NULL");
            throw new TDException(TDException.ERROR_MSG, new Object[]{error});
        }
        info.setName(name == null ? "" : name.trim());
    }

    @Override
    protected ArrayList _cancel(Context ctx, Set ids) throws BOSException, EASBizException {
        String idStr = "";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        TaxReportTypeCollection coll = TaxReportTypeFactory.getLocalInstance(ctx).getTaxReportTypeCollection(view);
        TaxReportTypeInfo info = null;
        ArrayList<String> error = new ArrayList<String>();
        ResourceBase.getString((String)RES, (String)"", (Locale)ctx.getLocale(), (Object[])new Object[0]);
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (EnableStateEnum.DISABLE.equals((Object)info.getStatus())) {
                error.add(ResourceBase.getString((String)RES, (String)"Already_Disenable", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getName()}));
                continue;
            }
            idStr = idStr + "'" + info.getId().toString() + "',";
        }
        if (!StringUtils.isEmpty((String)idStr)) {
            StringBuffer sb = new StringBuffer();
            idStr = idStr.substring(0, idStr.length() - 1);
            sb.append("update T_TM_TaxReportType set FStatus = 1 where FID in (").append(idStr).append(")");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        return error;
    }

    @Override
    protected ArrayList _cancelCancel(Context ctx, Set ids) throws BOSException, EASBizException {
        String idStr = "";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        TaxReportTypeCollection coll = TaxReportTypeFactory.getLocalInstance(ctx).getTaxReportTypeCollection(view);
        ArrayList<String> error = new ArrayList<String>();
        for (int i = 0; i < coll.size(); ++i) {
            TaxReportTypeInfo info = coll.get(i);
            if (EnableStateEnum.ENABLE.equals((Object)info.getStatus())) {
                error.add(ResourceBase.getString((String)RES, (String)"Already_Enable", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getName()}));
                continue;
            }
            idStr = "'" + info.getId() + "',";
            if (StringUtils.isEmpty((String)idStr)) continue;
            StringBuffer sb = new StringBuffer();
            idStr = idStr.substring(0, idStr.length() - 1);
            sb.append("update T_TM_TaxReportType set FStatus = 0 where FID in (").append(idStr).append(")");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        return error;
    }

    @Override
    protected ArrayList _batchDelete(Context ctx, Set ids) throws BOSException, EASBizException {
        String idStr = "";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        TaxReportTypeCollection coll = TaxReportTypeFactory.getLocalInstance(ctx).getTaxReportTypeCollection(view);
        ArrayList<String> error = new ArrayList<String>();
        for (int i = 0; i < coll.size(); ++i) {
            TaxReportTypeInfo info = coll.get(i);
            if (EnableStateEnum.ENABLE.equals((Object)info.getStatus())) {
                error.add(ResourceBase.getString((String)RES, (String)"AlreadyEnable_CantDelete", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getName()}));
                continue;
            }
            idStr = "'" + info.getId() + "',";
            if (StringUtils.isEmpty((String)idStr)) continue;
            StringBuffer sb = new StringBuffer();
            idStr = idStr.substring(0, idStr.length() - 1);
            sb.append("delete FROM T_TM_TaxReportType where FID in (").append(idStr).append(")");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        return error;
    }
}

