/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.basedata.AccountConfigEntryInfo;
import com.kingdee.eas.tm.td.basedata.DataSourceEntryCollection;
import com.kingdee.eas.tm.td.basedata.DataSourceEntryInfo;
import com.kingdee.eas.tm.td.basedata.DataSourceInfo;
import com.kingdee.eas.tm.td.basedata.util.PropertyMeta;
import com.kingdee.eas.tm.td.basedata.util.PropertyMetaUtil;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchEntryInfo;
import java.util.List;
import javax.swing.tree.MutableTreeNode;

public class DraftItemDataSourceTreeUtil {
    public static DefaultKingdeeTreeNode getDataQueryRoot(DataSourceInfo dataQuery) throws Exception {
        if (dataQuery == null || dataQuery.getMainTable() == null) {
            return null;
        }
        DefaultKingdeeTreeNode root = DraftItemDataSourceTreeUtil.createRoot(dataQuery);
        DataSourceEntryCollection coll = dataQuery.getEntry();
        coll.sort("seq");
        for (int i = 0; i < coll.size(); ++i) {
            DraftItemDataSourceTreeUtil.addTableNode(root, coll.get(i), null, "", null, null, null);
        }
        return root;
    }

    public static DefaultKingdeeTreeNode getDataQueryRoot(DataSourceInfo dataQuery, CompanyOrgUnitInfo fieldModel, String property, AccountConfigEntryInfo configEntry, DataFetchEntryInfo entry, FullOrgUnitInfo fullOrgUnitInfo) throws Exception {
        if (dataQuery == null) {
            return null;
        }
        DefaultKingdeeTreeNode root = DraftItemDataSourceTreeUtil.createRoot(dataQuery);
        DataSourceEntryCollection coll = dataQuery.getEntry();
        coll.sort("seq");
        for (int i = 0; i < coll.size(); ++i) {
            DraftItemDataSourceTreeUtil.addTableNode(root, coll.get(i), fieldModel, property, configEntry, entry, fullOrgUnitInfo);
        }
        return root;
    }

    private static DefaultKingdeeTreeNode createRoot(DataSourceInfo dataQuery) {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        root.setText(dataQuery.getName());
        return root;
    }

    protected static void fillChildrenNode(DataSourceInfo dataQuery, DefaultKingdeeTreeNode root, DataSourceEntryInfo table, CompanyOrgUnitInfo fieldModel, String propertyName, AccountConfigEntryInfo configEntry, DataFetchEntryInfo entry) throws EASBizException, BOSException {
        if (table == null) {
            return;
        }
        DataSourceEntryCollection coll = table.getChildren(dataQuery.getEntry());
        for (int i = 0; i < coll.size(); ++i) {
            DefaultKingdeeTreeNode node = DraftItemDataSourceTreeUtil.addTableNode(root, coll.get(i), fieldModel, propertyName, configEntry, entry, null);
            DraftItemDataSourceTreeUtil.fillChildrenNode(dataQuery, node, coll.get(i), fieldModel, propertyName, configEntry, entry);
        }
    }

    private static DefaultKingdeeTreeNode addTableNode(DefaultKingdeeTreeNode parent, DataSourceEntryInfo table, CompanyOrgUnitInfo fieldModel, String propertyName, AccountConfigEntryInfo configEntry, DataFetchEntryInfo entry, FullOrgUnitInfo fullOrgUnitInfo) {
        if (table == null) {
            return null;
        }
        DefaultKingdeeTreeNode treeNode = null;
        treeNode = new DefaultKingdeeTreeNode((Object)table);
        treeNode.setText(table.getName());
        if (parent != null) {
            parent.add((MutableTreeNode)treeNode);
        }
        DraftItemDataSourceTreeUtil.addTableFieldNode(treeNode, table, fieldModel, propertyName, configEntry, entry, fullOrgUnitInfo);
        return treeNode;
    }

    private static void addTableFieldNode(DefaultKingdeeTreeNode parent, DataSourceEntryInfo table, CompanyOrgUnitInfo fieldModel, String propertyName, AccountConfigEntryInfo configEntry, DataFetchEntryInfo entry, FullOrgUnitInfo fullOrgUnitInfo) {
        if (table == null) {
            return;
        }
        try {
            PropertyMeta property = null;
            List<PropertyMeta> fieldList = PropertyMetaUtil.getEntityProperty(table);
            for (int i = 0; i < fieldList.size(); ++i) {
                property = fieldList.get(i);
                if (!DraftItemDataSourceTreeUtil.isSameDataType(fieldModel, propertyName, property, configEntry, entry, fullOrgUnitInfo)) continue;
                DraftItemDataSourceTreeUtil.addOneFieldNode(parent, property);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addOneFieldNode(DefaultKingdeeTreeNode parent, PropertyMeta property) {
        DefaultKingdeeTreeNode treeNode = new DefaultKingdeeTreeNode((Object)property);
        treeNode.setText(property.getAlias());
        parent.add((MutableTreeNode)treeNode);
    }

    private static boolean isSameDataType(CompanyOrgUnitInfo fieldModel, String propertyName, PropertyMeta property, AccountConfigEntryInfo configEntry, DataFetchEntryInfo entry, FullOrgUnitInfo fullOrgUnitInfo) {
        if (fieldModel != null) {
            if (propertyName == null) {
                return true;
            }
            String propertyDataType = property.getDataType();
            String fieldDataType = propertyName;
            if ("Date".equals(fieldDataType) && ("Date".equals(propertyDataType) || "TimeStamp".equals(propertyDataType) || "Time".equals(propertyDataType))) {
                return true;
            }
            if ("Integer".equals(fieldDataType) && ("Integer".equals(propertyDataType) || "Short".equals(propertyDataType) || "Long".equals(propertyDataType))) {
                return true;
            }
            if (propertyDataType.equalsIgnoreCase(fieldDataType)) {
                if (fieldDataType.equals("Enum") && fieldModel.getBOSType() != null) {
                    return property.getEnumClassName().equals(fieldModel.getBOSType());
                }
                return true;
            }
            if ((fieldDataType.equals("Amount") || fieldDataType.equals("Qty") || fieldDataType.equals("Price")) && propertyDataType.equals("BigDecimal")) {
                return true;
            }
            if ("F7".equals(propertyDataType) && fieldDataType.equals("BOSUuid")) {
                if (fieldModel.getBOSType() != null && property.getRelationBosType().equals(fieldModel.getBOSType())) {
                    return true;
                }
                if (fieldModel.getBOSType() == null) {
                    return true;
                }
            }
        } else if (configEntry != null) {
            String fieldDataType;
            String propertyDataType = property.getDataType();
            if (propertyDataType.equalsIgnoreCase(fieldDataType = configEntry.getDataType().getName())) {
                if (fieldDataType.equals("Enum") && configEntry.getBaseDataBOSType() != null) {
                    return property.getEnumClassName().equals(configEntry.getBaseDataBOSType());
                }
                return true;
            }
            if ((fieldDataType.equals("Amount") || fieldDataType.equals("Qty") || fieldDataType.equals("Price")) && propertyDataType.equals("BigDecimal")) {
                return true;
            }
            if ("F7".equals(propertyDataType) && fieldDataType.equals("BOSUuid")) {
                if (configEntry.getBaseDataBOSType() != null && property.getRelationBosType().equals(configEntry.getBaseDataBOSType())) {
                    return true;
                }
                if (configEntry.getBaseDataBOSType() == null) {
                    return true;
                }
            }
        } else if (entry != null) {
            String fieldDataType;
            String propertyDataType = property.getDataType();
            if (propertyDataType.equalsIgnoreCase(fieldDataType = entry.getDataType().getName())) {
                if (fieldDataType.equals("Enum") && entry.getBaseDataBOSType() != null) {
                    return property.getEnumClassName().equals(entry.getBaseDataBOSType());
                }
                return true;
            }
            if ((fieldDataType.equals("Amount") || fieldDataType.equals("Qty") || fieldDataType.equals("Price")) && propertyDataType.equals("BigDecimal")) {
                return true;
            }
            if ("F7".equals(propertyDataType) && fieldDataType.equals("BOSUuid")) {
                if (entry.getBaseDataBOSType() != null && property.getRelationBosType().equals(entry.getBaseDataBOSType())) {
                    return true;
                }
                if (entry.getBaseDataBOSType() == null) {
                    return true;
                }
            }
        } else {
            if (propertyName == null) {
                return true;
            }
            String propertyDataType = property.getDataType();
            String fieldDataType = propertyName;
            if ("Date".equals(fieldDataType) && ("Date".equals(propertyDataType) || "TimeStamp".equals(propertyDataType))) {
                return true;
            }
            if ("Integer".equals(fieldDataType) && ("Integer".equals(propertyDataType) || "Short".equals(propertyDataType) || "Long".equals(propertyDataType))) {
                return true;
            }
            if (propertyDataType.equalsIgnoreCase(fieldDataType)) {
                if (fieldDataType.equals("Enum") && fullOrgUnitInfo.getBOSType() != null) {
                    return property.getEnumClassName().equals(fullOrgUnitInfo.getBOSType());
                }
                return true;
            }
            if ((fieldDataType.equals("Amount") || fieldDataType.equals("Qty") || fieldDataType.equals("Price")) && propertyDataType.equals("BigDecimal")) {
                return true;
            }
            if ("F7".equals(propertyDataType) && fieldDataType.equals("BOSUuid")) {
                if (fullOrgUnitInfo.getBOSType() != null && property.getRelationBosType().equals(fullOrgUnitInfo.getBOSType())) {
                    return true;
                }
                if (fullOrgUnitInfo.getBOSType() == null) {
                    return true;
                }
            }
        }
        return false;
    }
}

