/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.tm.td.utils.CollectionUtil;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public final class EntityDataUtil {
    public static final Logger logger = Logger.getLogger(EntityDataUtil.class);
    public static Map<String, EntityObjectInfo> entiytyMap = new HashMap<String, EntityObjectInfo>();
    public static Map<String, String> billEntryNameMap = new HashMap<String, String>();

    public static EntityObjectInfo getEntityObjectInfo(String bosTypeID) {
        return EntityDataUtil.getEntityObjectInfo(null, bosTypeID);
    }

    public static EntityObjectInfo getEntityObjectInfo(Context ctx, String bosTypeID) {
        if (StringUtils.isEmpty((String)bosTypeID)) {
            return null;
        }
        if (entiytyMap.containsKey(bosTypeID)) {
            return entiytyMap.get(bosTypeID);
        }
        BOSObjectType bosType = BOSObjectType.create((String)bosTypeID);
        IMetaDataLoader iMeta = null;
        iMeta = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = iMeta.getEntity(bosType);
        if (entity != null) {
            entiytyMap.put(bosTypeID, entity);
        }
        return entity;
    }

    public static EntityObjectInfo getEntryEntityObject(EntityObjectInfo parentObject) {
        if (parentObject == null) {
            return null;
        }
        EntityObjectInfo entryEntity = null;
        PropertyCollection col = parentObject.getEntityProperties();
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            return null;
        }
        PropertyInfo property = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            property = col.get(i);
            if (!EntityDataUtil.isEntryProperty(parentObject, property)) continue;
            RelationshipInfo relation = ((LinkPropertyInfo)property).getRelationship();
            return relation.getSupplierObject();
        }
        return entryEntity;
    }

    public static String getParentRelFileds(EntityObjectInfo entityObject) {
        if (entityObject == null) {
            return null;
        }
        String parentFiledsName = null;
        PropertyCollection col = entityObject.getEntityProperties();
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            return null;
        }
        PropertyInfo property = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            property = col.get(i);
            if (!EntityDataUtil.isParentProperty(entityObject, property)) continue;
            return property.getMappingField().getName();
        }
        return parentFiledsName;
    }

    public static String getBillEntryPropertyName(EntityObjectInfo billEntity) {
        if (billEntity == null) {
            return null;
        }
        String entryPropertyName = null;
        PropertyCollection col = billEntity.getEntityProperties();
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            return null;
        }
        PropertyInfo property = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            property = col.get(i);
            if (!EntityDataUtil.isEntryProperty(billEntity, property)) continue;
            return property.getName();
        }
        return entryPropertyName;
    }

    public static String getBillEntryPropertyName(String bosTypeID) {
        if (billEntryNameMap.containsKey(bosTypeID)) {
            return billEntryNameMap.get(bosTypeID);
        }
        EntityObjectInfo billEntity = null;
        billEntity = EntityDataUtil.getEntityObjectInfo(bosTypeID);
        if (billEntity == null) {
            return null;
        }
        String entryPropertyName = null;
        PropertyCollection col = billEntity.getEntityProperties();
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            return null;
        }
        PropertyInfo property = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            property = col.get(i);
            if (!EntityDataUtil.isEntryProperty(billEntity, property)) continue;
            billEntryNameMap.put(bosTypeID, property.getName());
            return property.getName();
        }
        return entryPropertyName;
    }

    public static LinkPropertyInfo getBillEntryProperty(Context ctx, String bosTypeID) {
        EntityObjectInfo billEntity = null;
        billEntity = EntityDataUtil.getEntityObjectInfo(ctx, bosTypeID);
        if (billEntity == null) {
            return null;
        }
        PropertyCollection col = billEntity.getEntityProperties();
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            return null;
        }
        PropertyInfo property = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            property = col.get(i);
            if (!EntityDataUtil.isEntryProperty(billEntity, property)) continue;
            return (LinkPropertyInfo)property;
        }
        return null;
    }

    public static boolean isEntryProperty(EntityObjectInfo parent, PropertyInfo property) {
        RelationshipInfo relation;
        return !(parent == null || property == null || !(property instanceof LinkPropertyInfo) || (relation = ((LinkPropertyInfo)property).getRelationship()).getType() != RelationshipType.COMPOSITION && !Boolean.TRUE.toString().equalsIgnoreCase(property.getExtendedProperty("isEntries")) || !relation.getClientObject().getFullName().equals(parent.getFullName()) || relation.getSupplierCardinality() != CardinalityType.ONE_TO_UNBOUNDED && relation.getSupplierCardinality() != CardinalityType.ZERO_TO_UNBOUNDED);
    }

    public static boolean isParentProperty(EntityObjectInfo entry, PropertyInfo property) {
        RelationshipInfo relation;
        return !(entry == null || property == null || !(property instanceof LinkPropertyInfo) || (relation = ((LinkPropertyInfo)property).getRelationship()).getType() != RelationshipType.COMPOSITION && !Boolean.TRUE.toString().equalsIgnoreCase(property.getExtendedProperty("isEntries")) || !relation.getSupplierObject().getFullName().equals(entry.getFullName()) || relation.getSupplierCardinality() != CardinalityType.ONE_TO_UNBOUNDED && relation.getSupplierCardinality() != CardinalityType.ZERO_TO_UNBOUNDED);
    }
}

