/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.cloud.BackupDataTypeCollection;
import com.kingdee.eas.tm.td.cloud.BackupDataTypeFactory;
import com.kingdee.eas.tm.td.cloud.BackupDataTypeInfo;
import com.kingdee.eas.tm.td.cloud.EnableStateEnum;
import com.kingdee.eas.tm.td.cloud.TDCloudException;
import com.kingdee.eas.tm.td.cloud.app.AbstractBackupDataTypeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class BackupDataTypeControllerBean
extends AbstractBackupDataTypeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.cloud.app.BackupDataTypeControllerBean");

    @Override
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkNumberDup(ctx, pk, (IObjectValue)((DataBaseInfo)model));
        super._addnew(ctx, pk, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkNumberDup(ctx, pk, (IObjectValue)((DataBaseInfo)model));
        super._update(ctx, pk, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BackupDataTypeInfo info = BackupDataTypeFactory.getLocalInstance(ctx).getBackupDataTypeInfo(pk);
        this.checkBeforeDelete(ctx, info);
        super._delete(ctx, pk);
    }

    private void checkBeforeDelete(Context ctx, BackupDataTypeInfo info) throws BOSException, EASBizException {
        if (EnableStateEnum.ENABLE.equals((Object)info.getState())) {
            throw new TDCloudException(TDCloudException.DELETE_STATUS_ERROR1);
        }
        if (info.isIsPreinstall()) {
            throw new TDCloudException(TDCloudException.DELETE_STATUS_ERROR2);
        }
    }

    protected boolean checkNumberDup(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        DataBaseInfo coreBillBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)coreBillBaseInfo.getString("number"), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (coreBillBaseInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)coreBillBaseInfo.getId().toString(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1");
        }
        if (super._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{coreBillBaseInfo.getString("number"), ""});
        }
        return true;
    }

    @Override
    protected ArrayList _batchDelete(Context ctx, Set ids) throws BOSException, EASBizException {
        ArrayList<String> errors = new ArrayList<String>();
        Iterator idIter = ids.iterator();
        while (idIter.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)idIter.next().toString()));
            BackupDataTypeInfo info = this.getBackupDataTypeInfo(ctx, (IObjectPK)pk);
            if (EnableStateEnum.ENABLE.equals((Object)info.getState())) {
                errors.add(info.getNumber() + "\uff1a" + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "Active_NotDelete", ctx.getLocale()));
                continue;
            }
            if (info.isIsPreinstall()) {
                errors.add(info.getNumber() + "\uff1a" + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "Preinstall_Not_Remove", ctx.getLocale()));
                continue;
            }
            super.delete(ctx, (IObjectPK)pk);
        }
        return errors;
    }

    @Override
    protected ArrayList _cancel(Context ctx, Set ids) throws BOSException, EASBizException {
        super._cancel(ctx, ids);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        BackupDataTypeCollection coll = BackupDataTypeFactory.getLocalInstance(ctx).getBackupDataTypeCollection(view);
        BackupDataTypeInfo info = null;
        ArrayList<String> errors = new ArrayList<String>();
        String idStr = "";
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (!EnableStateEnum.ENABLE.equals((Object)info.getState())) {
                errors.add(info.getNumber() + " : " + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "CANNOT_INACTIVE", ctx.getLocale()));
                continue;
            }
            idStr = idStr + "'" + info.getId().toString() + "',";
        }
        if (!StringUtils.isEmpty((String)idStr)) {
            StringBuffer sb = new StringBuffer();
            idStr = idStr.substring(0, idStr.length() - 1);
            sb.append("update T_TD_BackupDataType set FState = 1 where FID in (").append(idStr).append(")");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        return errors;
    }

    @Override
    protected ArrayList _cancelCancel(Context ctx, Set ids) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        BackupDataTypeCollection coll = BackupDataTypeFactory.getLocalInstance(ctx).getBackupDataTypeCollection(view);
        BackupDataTypeInfo info = null;
        ArrayList<String> errors = new ArrayList<String>();
        String idStr = "";
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (!EnableStateEnum.DISABLE.equals((Object)info.getState())) {
                errors.add(info.getNumber() + " : " + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "CANNOT_INACTIVE", ctx.getLocale()));
                continue;
            }
            idStr = idStr + "'" + info.getId().toString() + "',";
        }
        if (!StringUtils.isEmpty((String)idStr)) {
            StringBuffer sb = new StringBuffer();
            idStr = idStr.substring(0, idStr.length() - 1);
            sb.append("update T_TD_BackupDataType set FState = 0 where FID in (").append(idStr).append(")");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        return errors;
    }
}

