/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.cloud.GroupCollection;
import com.kingdee.eas.tm.td.cloud.GroupFactory;
import com.kingdee.eas.tm.td.cloud.GroupInfo;
import com.kingdee.eas.tm.td.cloud.OrgGroupFactory;
import com.kingdee.eas.tm.td.cloud.OrgGroupInfo;
import com.kingdee.eas.tm.td.cloud.app.AbstractGroupControllerBean;
import com.kingdee.eas.tm.td.utils.CollectionUtil;
import com.kingdee.eas.tm.td.utils.LogUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class GroupControllerBean
extends AbstractGroupControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.cloud.app.GroupControllerBean");

    @Override
    protected String _deleteGroup(Context ctx, String groupId) throws BOSException, EASBizException {
        IObjectPK logPk = null;
        String result = null;
        String qsql = "select FNUMBER,FIsPreinstall from t_td_group where fid = '" + groupId + "'";
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)qsql);
        try {
            if (row.next()) {
                String groupNumber = row.getString("FNUMBER");
                logPk = LogUtils.beginLog(ctx, "delete", BOSObjectType.create((String)"EC39E92F"), (IObjectPK)new ObjectUuidPK(groupId), groupNumber, "td_orgGroup_deleteOrg", "");
                if (row.getInt("FIsPreinstall") == 1) {
                    result = "\u8be5\u5206\u7ec4\u4e3a\u9884\u8bbe\u6570\u636e\u4e0d\u53ef\u5220\u9664\uff01";
                    return result;
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        String sql = "select count(s.fid) num from t_td_group s,t_td_group p where p.fid = s.fparentid and p.fid = '" + groupId + "'";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.next()) {
                if (rowSet.getInt("num") > 0) {
                    result = "\u8be5\u5206\u7ec4\u5b58\u5728\u5b50\u5206\u7ec4\uff0c\u4e0d\u5141\u8bb8\u5220\u9664!";
                } else {
                    boolean isExistsOrgs = OrgGroupFactory.getLocalInstance(ctx).exists("where group.id = '" + groupId + "'");
                    if (isExistsOrgs) {
                        result = "\u8be5\u5206\u7ec4\u5b58\u5728\u7ec4\u7ec7\uff0c\u4e0d\u5141\u8bb8\u5220\u9664!";
                    } else {
                        sql = "delete from t_td_orggroup where fgroupid = '" + groupId + "';delete from t_td_group where fid = '" + groupId + "';";
                        DbUtil.execute((Context)ctx, (String)sql);
                        result = "\u5220\u9664\u6210\u529f";
                    }
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (logPk != null) {
            LogUtils.afterLog(ctx, logPk);
        }
        return result;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        GroupInfo info = (GroupInfo)model;
        this.checkNameDup(ctx, (DataBaseInfo)info);
        this.checkNumberDup(ctx, (DataBaseInfo)info);
        super._update(ctx, pk, model);
    }

    @Override
    protected Map _assignOrgGroup(Context ctx, String groupId, String[] orgIds) throws BOSException, EASBizException {
        return this.groupOrgs(ctx, groupId, orgIds);
    }

    private Map<String, IObjectPK[]> groupOrgs(Context ctx, String groupId, String[] orgIds) throws BOSException, EASBizException {
        if (groupId == null || orgIds == null) {
            return null;
        }
        HashMap<String, IObjectPK[]> retMap = new HashMap<String, IObjectPK[]>();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" select orggroup.fcompanyid as fcompanyid ,tdgroup.fnumber as groupNumber ");
            sql.append(" from t_td_orggroup orggroup ");
            sql.append(" left join T_TD_Group tdgroup on orggroup.fgroupid = tdgroup.fid ");
            sql.append(" where orggroup.fgroupid = '").append(groupId).append("'");
            HashSet<String> containList = new HashSet<String>();
            String groupNumber = null;
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowset.next()) {
                containList.add(rowset.getString("fcompanyid"));
                groupNumber = rowset.getString("groupNumber");
            }
            sql.setLength(0);
            HashMap<String, String> unitNumberMap = new HashMap<String, String>();
            sql.append(" select fid,fnumber from T_ORG_BaseUnit ");
            sql.append(" where fid in  " + TDUtils.getInStringFromArray(orgIds));
            rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowset.next()) {
                unitNumberMap.put(rowset.getString("fid"), rowset.getString("fnumber"));
            }
            CoreBaseCollection orgGroupCollection = new CoreBaseCollection();
            OrgGroupInfo orgGroupInfo = null;
            GroupInfo groupInfo = null;
            CompanyOrgUnitInfo orgInfo = null;
            ArrayList addedGids = new ArrayList();
            ArrayList<IObjectPK> logPks = new ArrayList<IObjectPK>();
            IObjectPK logPk = null;
            for (String oid : orgIds) {
                if (containList.contains(oid)) continue;
                orgInfo = new CompanyOrgUnitInfo();
                orgInfo.setId(BOSUuid.read((String)oid));
                groupInfo = new GroupInfo();
                groupInfo.setId(BOSUuid.read((String)groupId));
                orgGroupInfo = new OrgGroupInfo();
                orgGroupInfo.setGroup(groupInfo);
                orgGroupInfo.setCompany(orgInfo);
                orgGroupCollection.add((CoreBaseInfo)orgGroupInfo);
                logPk = LogUtils.beginLog(ctx, "edit", BOSObjectType.create((String)"EC39E92F"), (IObjectPK)new ObjectUuidPK(groupId), groupNumber + "_" + (String)unitNumberMap.get(oid), "td_orgGroup_importOrg", oid);
                logPks.add(logPk);
            }
            if (!orgGroupCollection.isEmpty()) {
                IObjectPK[] ugpks = OrgGroupFactory.getLocalInstance(ctx).addnewBatchData(orgGroupCollection);
                retMap.put("orgGroup", ugpks);
            }
            int size = logPks.size();
            for (int i = 0; i < size; ++i) {
                logPk = (IObjectPK)logPks.get(i);
                LogUtils.afterLog(ctx, logPk);
            }
        }
        catch (UuidException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return retMap;
    }

    @Override
    protected Map _relieveOrgGrouop(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.size() == 0) {
            return null;
        }
        String idInCondition = CollectionUtil.convertList2String(idList);
        StringBuffer sql = new StringBuffer();
        sql.append(" select orggroup.fcompanyid as companyid,orggroup.fid as orggroupid,unit.fnumber as unitNumber,tdgroup.fnumber as groupNumber ");
        sql.append(" from t_td_orggroup orggroup ");
        sql.append(" left join T_ORG_BaseUnit unit on orggroup.fcompanyid = unit.fid ");
        sql.append(" left join T_TD_Group tdgroup on orggroup.fgroupid = tdgroup.fid ");
        sql.append(" where orggroup.fid in  (").append(idInCondition).append(")");
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<IObjectPK> logPks = new ArrayList<IObjectPK>();
        IObjectPK logPk = null;
        String companyid = null;
        String orggroupid = null;
        String unitNumber = null;
        String groupNumber = null;
        try {
            while (rowset.next()) {
                companyid = rowset.getString("companyid");
                orggroupid = rowset.getString("orggroupid");
                unitNumber = rowset.getString("unitNumber");
                groupNumber = rowset.getString("groupNumber");
                logPk = LogUtils.beginLog(ctx, "delete", BOSObjectType.create((String)"EC39E92F"), (IObjectPK)new ObjectUuidPK(orggroupid), groupNumber + unitNumber, "td_orgGroup_deleteOrg", companyid);
                logPks.add(logPk);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        sql.setLength(0);
        sql.append(" delete from t_td_orggroup");
        sql.append(" where fid in (").append(idInCondition).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        int size = logPks.size();
        for (int i = 0; i < size; ++i) {
            LogUtils.afterLog(ctx, (IObjectPK)logPks.get(i));
        }
        return new HashMap();
    }

    protected IObjectCollection _getOrgsInGroup(Context ctx, String id, String longNumber, String language) throws BOSException {
        CompanyOrgUnitCollection orgCollection = new CompanyOrgUnitCollection();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" select distinct c.fid,c.fname_").append(language).append(",c.fnumber,c.code,u.fdescription_").append(language);
            sql.append(" c.fsimplename");
            sql.append(" from t_org_company c ");
            sql.append(" left join t_td_orggroup og on c.fid = og.fcompanyid");
            sql.append(" left join t_td_group g on g.fid = og.fgroupid");
            if (longNumber != null) {
                sql.append(" and (g.flongnumber like '" + longNumber + "!%' or g.fid = '" + id + "')");
            } else {
                sql.append(" and g.fid = '" + id + "'");
            }
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            CompanyOrgUnitInfo companyOrgUnitInfo = null;
            while (rowset.next()) {
                companyOrgUnitInfo = new CompanyOrgUnitInfo();
                companyOrgUnitInfo.setId(BOSUuid.read((String)rowset.getString("fid")));
                companyOrgUnitInfo.setName(rowset.getString("fname_" + language));
                companyOrgUnitInfo.setNumber(rowset.getString("fnumber"));
                companyOrgUnitInfo.setCode(rowset.getString("fcode"));
                companyOrgUnitInfo.setDescription(rowset.getString("fdescription_" + language));
                companyOrgUnitInfo.setSimpleName(rowset.getString("fsimplename"));
                orgCollection.add(companyOrgUnitInfo);
            }
        }
        catch (UuidException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return orgCollection;
    }

    protected boolean _relieveOrgGroupRelation(Context ctx, String groupId, String[] orgIds) throws BOSException {
        StringBuffer ugsql = new StringBuffer("");
        String orgCondition = CollectionUtil.convertList2String(Arrays.asList((Object[])orgIds), ",");
        ugsql.append("delete from t_td_orggroup where fgroupid = '").append(groupId).append("' ").append("and fcompanyid in ").append(orgCondition);
        DbUtil.execute((Context)ctx, (String)ugsql.toString());
        return true;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean checkNumber = this._checkNumber(ctx, model);
        if (!checkNumber) {
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{model.get("number")});
        }
        return super._submit(ctx, model);
    }

    protected Map _saveGroup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        HashMap<String, EASBizException> resultMap = new HashMap<String, EASBizException>();
        if (model != null && model.get("name") != null && model.get("number") != null) {
            String oldNumber = null;
            if (model.get("id") != null) {
                String gid = model.get("id").toString();
                Boolean isExists = GroupFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(gid));
                if (isExists.booleanValue()) {
                    GroupInfo group = GroupFactory.getLocalInstance(ctx).getGroupInfo((IObjectPK)new ObjectUuidPK(gid));
                    oldNumber = group.getNumber();
                }
            }
            String number = model.get("number").toString();
            String shareCenterId = ShareCenterUtils.getShareCenterIdByCtx((Context)ctx);
            boolean isExists = GroupFactory.getLocalInstance(ctx).exists("where number = '" + number + "' and shareCenterId = '" + shareCenterId + "'");
            if (isExists && (oldNumber == null || !number.equals(oldNumber))) {
                NumericExceptionSubItem item = new NumericExceptionSubItem("bs.ssc.group.groupNumberIsExists", "\u7f16\u7801\u5df2\u5b58\u5728!");
                EASBizException exception = new EASBizException(item);
                resultMap.put("error", exception);
            } else {
                IObjectPK objectPK = GroupFactory.getLocalInstance(ctx).submit((CoreBaseInfo)model);
                resultMap.put("success", (EASBizException)objectPK);
            }
        } else {
            NumericExceptionSubItem item = new NumericExceptionSubItem("bs.ssc.group.nameOrNumberIsNull", "\u540d\u79f0\u548c\u7f16\u7801\u5fc5\u987b\u586b\u5199!");
            EASBizException exception = new EASBizException(item);
            resultMap.put("error", exception);
        }
        return resultMap;
    }

    @Override
    protected boolean _checkNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean checkNumber = true;
        GroupInfo info = (GroupInfo)model;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
        view.setFilter(filter);
        GroupCollection coll = GroupFactory.getLocalInstance(ctx).getGroupCollection(view);
        if (coll != null && coll.size() > 0) {
            checkNumber = false;
        }
        return checkNumber;
    }
}

