/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.common.olap.EASEjbFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.tm.td.cloud.app.AbstractTaxPreviewReportFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class TaxPreviewReportFacadeControllerBean
extends AbstractTaxPreviewReportFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.cloud.app.TaxPreviewReportFacadeControllerBean");

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        ctx = EASEjbFactory.getCtx((String)this.getClass().getName(), (Context)ctx);
        this.dropTempTable(params.getString("tempTable"), ctx);
        String orgTempTableName = this.createTempTable(ctx, this.getCreateOrgTable());
        this.insertOrgData(ctx, orgTempTableName, params);
        String tempTable = null;
        tempTable = this.createTempTable(ctx, this.getCreateTempTable());
        params.setString("tempTable", tempTable);
        this.insertData(ctx, tempTable, orgTempTableName, params);
        this.updateData(ctx, tempTable, params);
        return params;
    }

    private void insertData(Context ctx, String tempTableName, String orgTempTableName, RptParams params) throws BOSException {
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("insert into ").append(tempTableName).append(" ").append(" (FID,FCompanyID,FTaxNotesID,FProvinceID,FYear,FMonth) ");
        String selectSQL = this.getSelectSQL(orgTempTableName, params);
        String sql = insertSQL + selectSQL;
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void updateData(Context ctx, String tempTableName, RptParams params) throws BOSException {
        DbUtil.execute((Context)ctx, (String)this.getUpdateRptSQL(tempTableName));
    }

    private String getUpdateRptSQL(String tempTableName) {
        StringBuffer updateSQL = new StringBuffer();
        updateSQL.append(" update ").append(tempTableName).append(" as a ");
        updateSQL.append(" set (FRptID) =");
        updateSQL.append(" ( select record.fid from ").append(tempTableName).append(" b ");
        updateSQL.append(" inner join T_TD_TaxNotes taxnotes on taxnotes.FID = b.FTaxNotesID");
        updateSQL.append(" inner join T_TD_TaxDraftRecord record on record.fcompanyOrgUnitID = b.fcompanyID");
        updateSQL.append(" and record.FRecordType=taxnotes.FRecordType and record.fyear = b.fyear and record.fperiod = b.fmonth");
        updateSQL.append(" where taxnotes.FState=1 and record.fdraftstatus = 3  ");
        updateSQL.append(" and a.fid =b.fid)");
        return updateSQL.toString();
    }

    private String getSelectSQL(String orgTempTableName, RptParams params) {
        StringBuffer selectSQL = new StringBuffer();
        selectSQL.append(" select newbosid('88888888') as FID,orgTemp.FCompanyID,taxtime.FTaxNotesID,taxtime.FProvinceID, ");
        selectSQL.append(" taxtime.FYear,taxtime.FMonth");
        selectSQL.append(" FROM ").append(orgTempTableName).append(" orgTemp ");
        selectSQL.append(" inner join t_tm_taxbase taxbase on orgTemp.FCompanyID = taxbase.FCOMPANYID");
        selectSQL.append(" inner join T_TD_TaxTimeTable taxtime on taxtime.FPROVINCEID = taxbase.FREGISTPROVINCE");
        selectSQL.append(" inner join T_TD_TaxNotes taxnotes on taxtime.FTaxNotesID = taxnotes.fid");
        selectSQL.append(" where taxnotes.FState=1 and taxtime.FState=1 and taxbase.FSTATE=1");
        String dateFrom = params.getString("dateFrom");
        String[] dateArr = dateFrom.split("-");
        int year = Integer.parseInt(dateArr[0].toString());
        int month = Integer.parseInt(dateArr[1].toString());
        selectSQL.append(" and  taxtime.FYear*100+taxtime.FMonth").append(">=").append(year * 100 + month);
        String dateTo = params.getString("dateTo");
        dateArr = dateTo.split("-");
        year = Integer.parseInt(dateArr[0].toString());
        month = Integer.parseInt(dateArr[1].toString());
        selectSQL.append(" and  taxtime.FYear*100+taxtime.FMonth").append("<=").append(year * 100 + month);
        return selectSQL.toString();
    }

    private void insertOrgData(Context ctx, String orgTempTableName, RptParams params) throws BOSException {
        Set companyIds = (Set)params.getObject("companyIds");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        Iterator idIter = companyIds.iterator();
        Object[] values = null;
        while (idIter.hasNext()) {
            values = new Object[]{idIter.next()};
            paramsList.add(values);
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(orgTempTableName).append(" ").append(" (FCompanyID) values ( ? )");
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramsList);
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        ctx = EASEjbFactory.getCtx((String)this.getClass().getName(), (Context)ctx);
        RptRowSet rs = null;
        String tempTable = params.getString("tempTable");
        rs = this.executeQuery(this.getQuerySelectSQL(ctx, tempTable, params), null, from, len, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        RptRowSet countRs = null;
        int totalCount = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select count(*) as totalCount from ").append(tempTable);
        countRs = this.executeQuery(sql.toString(), null, ctx);
        if (countRs.next()) {
            totalCount = countRs.getInt("totalCount");
        }
        pp.setInt("totalCount", totalCount);
        return pp;
    }

    private String getQuerySelectSQL(Context ctx, String tempTableName, RptParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT a.FID as FID,a.FCompanyID as FCompanyID,FTaxNotesID,");
        sql.append(" company.fname_").append(ctx.getLocale().toString()).append(" as FCompanyName,");
        sql.append(" notes.FName_").append(ctx.getLocale().toString()).append(" as FTaxNotesName,FProvinceID, ");
        sql.append(" province.FName_").append(ctx.getLocale().toString()).append(" as FProvinceName,");
        sql.append(" a.FYear as FYear,a.FMonth as FMonth,isnull(record.FIsDeclare,0) as FIsDeclare,isnull(record.FIsScottare,0) as FIsScottare,0 as FScottareAmt");
        sql.append(" from ").append(tempTableName).append(" a ");
        sql.append(" inner join t_org_company company on company.fid = a.fcompanyid");
        sql.append(" inner join T_TD_TaxNotes notes on notes.fid = a.FTaxNotesID");
        sql.append(" inner join T_BD_Province province on province.fid = a.FProvinceID");
        sql.append(" left join T_TD_TaxDraftRecord record on record.fid = a.FRptID");
        sql.append(" where 1=1 ");
        String dateFrom = params.getString("dateFrom");
        String[] dateArr = dateFrom.split("-");
        int year = Integer.parseInt(dateArr[0].toString());
        int month = Integer.parseInt(dateArr[1].toString());
        sql.append(" and  a.FYear*100+a.FMonth").append(">=").append(year * 100 + month);
        String dateTo = params.getString("dateTo");
        dateArr = dateTo.split("-");
        year = Integer.parseInt(dateArr[0].toString());
        month = Integer.parseInt(dateArr[1].toString());
        sql.append(" and  a.FYear*100+a.FMonth").append("<=").append(year * 100 + month);
        sql.append(" order by a.fyear desc, a.fmonth asc, a.FCompanyID asc;");
        return sql.toString();
    }

    private String getCreateOrgTable() {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table TempOrgTable(");
        sql.append("FCompanyID varchar(44)");
        sql.append(");");
        return sql.toString();
    }

    private String getCreateTempTable() {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table TempReportTable(");
        sql.append("FID varchar(44),");
        sql.append("FCompanyID varchar(44),");
        sql.append("FTaxNotesID varchar(44),");
        sql.append("FProvinceID varchar(44),");
        sql.append("FYear int,");
        sql.append("FMonth int,");
        sql.append("FRptID varchar(44),");
        sql.append("FIsDeclare int,");
        sql.append("FIsScottare int,");
        sql.append("FScottareAmt Decimal(28, 10) not null default 0");
        sql.append(");");
        return sql.toString();
    }
}

