/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.cloud.EnableStateEnum;
import com.kingdee.eas.tm.td.cloud.TDCloudException;
import com.kingdee.eas.tm.td.cloud.datamodel.ArchiveUrlCollection;
import com.kingdee.eas.tm.td.cloud.datamodel.ArchiveUrlFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.ArchiveUrlInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.app.AbstractArchiveUrlControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class ArchiveUrlControllerBean
extends AbstractArchiveUrlControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.cloud.datamodel.app.ArchiveUrlControllerBean");

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ArchiveUrlInfo info = ArchiveUrlFactory.getLocalInstance(ctx).getArchiveUrlInfo(pk);
        this.checkBeforeDelete(ctx, info);
        super._delete(ctx, pk);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ArchiveUrlInfo info = ArchiveUrlFactory.getLocalInstance(ctx).getArchiveUrlInfo(pk);
        this.checkBeforeCancel(ctx, info);
        info.setState(EnableStateEnum.DISABLE);
        super._update(ctx, pk, (IObjectValue)info);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ArchiveUrlInfo info = ArchiveUrlFactory.getLocalInstance(ctx).getArchiveUrlInfo(pk);
        this.checkBeforeCancelCancel(ctx, info);
        info.setState(EnableStateEnum.ENABLE);
        super._update(ctx, pk, (IObjectValue)info);
    }

    private void checkBeforeDelete(Context ctx, ArchiveUrlInfo info) throws BOSException, EASBizException {
        if (EnableStateEnum.ENABLE.equals((Object)info.getState())) {
            throw new TDCloudException(TDCloudException.DELETE_STATUS_ERROR1);
        }
    }

    private void checkBeforeCancel(Context ctx, ArchiveUrlInfo info) throws BOSException, EASBizException {
        if (!EnableStateEnum.ENABLE.equals((Object)info.getState())) {
            throw new TDCloudException(TDCloudException.CANCEL_STATUS_ERROR);
        }
    }

    private void checkBeforeCancelCancel(Context ctx, ArchiveUrlInfo info) throws BOSException, EASBizException {
        if (EnableStateEnum.ENABLE.equals((Object)info.getState())) {
            throw new TDCloudException(TDCloudException.CANCELCANCEL_STATUS_ERROR);
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNumberDup(ctx, (DataBaseInfo)model);
        return super._submit(ctx, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        DataBaseInfo coreBillBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)coreBillBaseInfo.getString("number"), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (coreBillBaseInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)coreBillBaseInfo.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{coreBillBaseInfo.getString("number"), ""});
        }
    }

    @Override
    protected ArrayList _batchDelete(Context ctx, Set ids) throws BOSException, EASBizException {
        ArrayList<String> errors = new ArrayList<String>();
        Iterator idIter = ids.iterator();
        while (idIter.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)idIter.next().toString()));
            ArchiveUrlInfo info = this.getArchiveUrlInfo(ctx, (IObjectPK)pk);
            if (EnableStateEnum.ENABLE.equals((Object)info.getState())) {
                errors.add(info.getNumber() + "\uff1a" + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "Active_NotDelete", ctx.getLocale()));
                continue;
            }
            super.delete(ctx, (IObjectPK)pk);
        }
        return errors;
    }

    @Override
    protected ArrayList _cancel(Context ctx, Set ids) throws BOSException, EASBizException {
        String idStr = "";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        ArchiveUrlCollection coll = ArchiveUrlFactory.getLocalInstance(ctx).getArchiveUrlCollection(view);
        ArchiveUrlInfo info = null;
        ArrayList<String> errors = new ArrayList<String>();
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (!EnableStateEnum.ENABLE.equals((Object)info.getState())) {
                errors.add(info.getNumber() + " : " + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "CANNOT_INACTIVE", ctx.getLocale()));
                continue;
            }
            idStr = idStr + "'" + info.getId().toString() + "',";
        }
        if (!StringUtils.isEmpty((String)idStr)) {
            StringBuffer sb = new StringBuffer();
            idStr = idStr.substring(0, idStr.length() - 1);
            sb.append("update T_TD_ArchiveUrl set FState = 1 where FID in (").append(idStr).append(")");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        return errors;
    }

    @Override
    protected ArrayList _cancelCancel(Context ctx, Set ids) throws BOSException, EASBizException {
        String idStr = "";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        ArchiveUrlCollection coll = ArchiveUrlFactory.getLocalInstance(ctx).getArchiveUrlCollection(view);
        ArchiveUrlInfo info = null;
        ArrayList<String> errors = new ArrayList<String>();
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (!EnableStateEnum.DISABLE.equals((Object)info.getState())) {
                errors.add(info.getNumber() + " : " + TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "CANNOT_ACTIVE", ctx.getLocale()));
                continue;
            }
            idStr = idStr + "'" + info.getId().toString() + "',";
        }
        if (!StringUtils.isEmpty((String)idStr)) {
            StringBuffer sb = new StringBuffer();
            idStr = idStr.substring(0, idStr.length() - 1);
            sb.append("update T_TD_ArchiveUrl set FState = 0 where FID in (").append(idStr).append(")");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        return errors;
    }
}

