/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.app.AbstractCheckViewControllerBean;
import com.kingdee.eas.tm.td.utils.CollectionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class CheckViewControllerBean
extends AbstractCheckViewControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.cloud.datamodel.app.CheckViewControllerBean");

    @Override
    protected List _getCheckIDList(Context ctx, Set companyIds, CheckTypeEnum checkType) throws BOSException, EASBizException {
        List checkIDList = new ArrayList();
        checkIDList = companyIds.size() > 1000 ? this.getBatchAssignCheckIDList(ctx, companyIds, checkType) : this.getAssignCheckIDList(ctx, companyIds, checkType);
        return checkIDList;
    }

    private List getAssignCheckIDList(Context ctx, Set companyIdList, CheckTypeEnum checkType) throws BOSException {
        ArrayList<String> checkIdList = new ArrayList<String>();
        String fieldName = CheckTypeEnum.TAXDECLARE.equals((Object)checkType) ? "FItemID" : "FIndexID";
        StringBuffer exeSql = new StringBuffer();
        exeSql.append(" select ").append(fieldName).append(" from T_TD_CheckView");
        exeSql.append(" where  fcompanyid in ( ").append(CollectionUtil.convertSet2String(companyIdList, ",", true)).append(") ");
        exeSql.append(" and fchecktype = '").append(checkType.getValue()).append("'");
        exeSql.append(" group by ").append(fieldName).append(" having count(").append(fieldName).append(")=").append(companyIdList.size());
        exeSql.append(" order by ").append(fieldName);
        try {
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)exeSql.toString());
            while (row.next()) {
                checkIdList.add(row.getString(1));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return checkIdList;
    }

    private List getBatchAssignCheckIDList(Context ctx, Set companyIdList, CheckTypeEnum checkType) throws BOSException {
        ArrayList<String> checkIdList = new ArrayList<String>();
        ITableManagerFacade instance = null;
        Connection cn = null;
        PreparedStatement stmt = null;
        String tbl = null;
        try {
            instance = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
            tbl = instance.getTableName("CHECKVIEW");
            StringBuffer createSql = new StringBuffer();
            createSql.append("create table ");
            createSql.append(tbl);
            createSql.append(" (fid varchar(44)");
            createSql.append(")");
            TableManagerFacadeFactory.getLocalInstance((Context)ctx).createTempTable(createSql.toString());
            cn = EJBFactory.getConnection((Context)ctx);
            stmt = cn.prepareStatement("insert into " + tbl + " values(?)");
            for (Object companyId : companyIdList) {
                stmt.setString(1, companyId.toString());
                stmt.addBatch();
            }
            stmt.executeBatch();
            String fieldName = CheckTypeEnum.TAXDECLARE.equals((Object)checkType) ? "FItemID" : "FIndexID";
            StringBuffer exeSql = new StringBuffer();
            exeSql.append(" select ").append(fieldName).append(" from T_TD_CheckView");
            exeSql.append(" where  fcompanyid in (select fid from ").append(tbl).append(") ");
            exeSql.append(" and fcheckType = '").append(checkType.getValue()).append("'");
            exeSql.append(" group by ").append(fieldName).append(" having count(").append(fieldName).append(")=").append(companyIdList.size());
            exeSql.append(" order by ").append(fieldName);
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)exeSql.toString());
            while (row.next()) {
                checkIdList.add(row.getString(1));
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                instance.releaseTableName(tbl);
                SQLUtils.cleanup(stmt, cn);
                throw throwable;
            }
        }
        instance.releaseTableName(tbl);
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        return checkIdList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _assignCheck(Context ctx, IObjectCollection couCols, IObjectCollection checkCols, CheckTypeEnum checkType, boolean isAssign) throws BOSException, EASBizException {
        ArrayList errorList;
        block15: {
            int i;
            IObjectValue check;
            IObjectValue cou;
            block16: {
                errorList = new ArrayList();
                cou = null;
                check = null;
                if (!isAssign) break block16;
                Connection conn = null;
                PreparedStatement pstmt = null;
                try {
                    conn = EJBFactory.getConnection((Context)ctx);
                    pstmt = conn.prepareStatement("INSERT INTO T_TD_CheckView(FID,FCompanyID,FCheckType,FItemID,FIndexID) values(?,?,?,?,?)");
                    int size = couCols.size();
                    for (int i2 = 0; i2 < size; ++i2) {
                        cou = couCols.getObject(i2);
                        int checkSize = checkCols.size();
                        for (int j = 0; j < checkSize; ++j) {
                            check = checkCols.getObject(j);
                            String fieldName = CheckTypeEnum.TAXDECLARE.equals((Object)checkType) ? "FItemID" : "FIndexID";
                            String sql = "Select 1 from T_TD_CheckView where FCompanyID='" + cou.get("id").toString() + "' and " + fieldName + "='" + check.get("id").toString() + "'";
                            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                            if (rs.next()) continue;
                            pstmt.setString(1, BOSUuid.create((String)"9EC8B5EA").toString());
                            pstmt.setString(2, cou.get("id").toString());
                            pstmt.setString(3, checkType.getValue());
                            pstmt.setString(4, CheckTypeEnum.TAXDECLARE.equals((Object)checkType) ? check.get("id").toString() : null);
                            pstmt.setString(5, CheckTypeEnum.TAXDECLARE.equals((Object)checkType) ? null : check.get("id").toString());
                            pstmt.addBatch();
                        }
                    }
                    pstmt.executeBatch();
                }
                catch (SQLException e) {
                    try {
                        throw new BOSException(e.getMessage());
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(pstmt, (Connection)conn);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
                break block15;
            }
            ArrayList<String> couIdList = new ArrayList<String>();
            ArrayList<String> checkIdList = new ArrayList<String>();
            int size = couCols.size();
            for (i = 0; i < size; ++i) {
                cou = couCols.getObject(i);
                couIdList.add(cou.get("id").toString());
            }
            size = checkCols.size();
            for (i = 0; i < size; ++i) {
                check = checkCols.getObject(i);
                checkIdList.add(check.get("id").toString());
            }
            String couTbl = null;
            String checkTbl = null;
            String companyIDStr = null;
            String checkIDStr = null;
            if (couIdList.size() > 1000) {
                couTbl = this.getIdTempTable(ctx, "CHECKCOU", couIdList);
                companyIDStr = "select fid from " + couTbl;
            } else {
                companyIDStr = CollectionUtil.convertList2String(couIdList);
            }
            if (checkIdList.size() > 1000) {
                checkTbl = this.getIdTempTable(ctx, "CHECKITEM", checkIdList);
                checkIDStr = "select fid from " + checkTbl;
            } else {
                checkIDStr = CollectionUtil.convertList2String(checkIdList);
            }
            try {
                StringBuffer deleteSQL = new StringBuffer();
                deleteSQL.append(" delete from T_TD_CheckView ");
                deleteSQL.append(" where FCompanyID  in (").append(companyIDStr).append(")");
                deleteSQL.append(" and ").append(CheckTypeEnum.TAXDECLARE.equals((Object)checkType) ? "FItemID" : "FIndexID").append(" in (").append(checkIDStr).append(")");
                DbUtil.execute((Context)ctx, (String)deleteSQL.toString());
            }
            finally {
                this.releaseTempTable(ctx, couTbl);
                this.releaseTempTable(ctx, checkTbl);
            }
        }
        return errorList;
    }

    private String getIdTempTable(Context ctx, String tableName, List idList) throws BOSException {
        Connection cn = null;
        PreparedStatement stmt = null;
        String tbl = null;
        try {
            tbl = TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName(tableName);
            StringBuffer createSql = new StringBuffer();
            createSql.append(" create table ");
            createSql.append(tbl);
            createSql.append(" (fid varchar(44)");
            createSql.append(")");
            TableManagerFacadeFactory.getLocalInstance((Context)ctx).createTempTable(createSql.toString());
            cn = EJBFactory.getConnection((Context)ctx);
            stmt = cn.prepareStatement("insert into " + tbl + " values(?)");
            for (Object id : idList) {
                stmt.setString(1, id.toString());
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        return tbl;
    }

    private void releaseTempTable(Context ctx, String tableName) throws BOSException {
        if (tableName != null) {
            TableManagerFacadeFactory.getLocalInstance((Context)ctx).releaseTableName(tableName);
        }
    }
}

