/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.cloud.datamodel.IndexTypeCollection;
import com.kingdee.eas.tm.td.cloud.datamodel.IndexTypeFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.IndexTypeInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.IndexTypeStateEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.app.AbstractIndexTypeControllerBean;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class IndexTypeControllerBean
extends AbstractIndexTypeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.cloud.datamodel.app.IndexTypeControllerBean");

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IndexTypeInfo info = this.getIndexTypeInfo(ctx, pk);
        if (info.getState().equals((Object)IndexTypeStateEnum.ENABLE)) {
            throw new TDException(TDException.ERROR_MSG, new Object[]{EASResource.getString((String)"com.kingdee.eas.tm.td.TDResource", (String)"EnableNotAllowRemove")});
        }
        super._delete(ctx, pk);
    }

    @Override
    protected boolean _checkNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean checkNumber = true;
        IndexTypeInfo info = (IndexTypeInfo)model;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
        view.setFilter(filter);
        IndexTypeCollection coll = IndexTypeFactory.getLocalInstance(ctx).getIndexTypeCollection(view);
        if (coll != null && coll.size() > 0) {
            checkNumber = false;
        }
        return checkNumber;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkBeforeSubmit(ctx, model);
        return super._submit(ctx, model);
    }

    private void checkBeforeSubmit(Context ctx, IObjectValue model) throws TDException {
        StringBuffer sb = new StringBuffer();
        IndexTypeInfo info = (IndexTypeInfo)model;
        if (StringUtils.isEmpty((String)info.getName())) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.tm.td.TDCommonResource", (String)"Name")).append(",");
        }
        if (StringUtils.isEmpty((String)info.getNumber())) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.tm.td.TDCommonResource", (String)"Number")).append(",");
        }
        if (sb.length() > 0) {
            String msg = sb.substring(0, sb.length() - 1);
            throw new TDException(TDException.ERROR_MSG, new Object[]{msg + EASResource.getString((String)"com.kingdee.eas.tm.td.TDResource", (String)"NOTNULL")});
        }
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        IndexTypeInfo info = (IndexTypeInfo)model;
        if (IndexTypeStateEnum.DISABLE.equals((Object)info.getState())) {
            throw new TDException(TDException.DISABLEAREADY);
        }
        info.setState(IndexTypeStateEnum.DISABLE);
        super._cancel(ctx, pk, model);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        IndexTypeInfo info = (IndexTypeInfo)model;
        if (IndexTypeStateEnum.ENABLE.equals((Object)info.getState())) {
            throw new TDException(TDException.ENABLEALREADY);
        }
        info.setState(IndexTypeStateEnum.ENABLE);
        super._cancelCancel(ctx, pk, model);
    }
}

