/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.common.olap.EASEjbFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.AccountConfigInfo;
import com.kingdee.eas.tm.td.basedata.TaxBaseCollection;
import com.kingdee.eas.tm.td.basedata.TaxBaseFactory;
import com.kingdee.eas.tm.td.cloud.GroupCollection;
import com.kingdee.eas.tm.td.cloud.GroupFactory;
import com.kingdee.eas.tm.td.cloud.GroupInfo;
import com.kingdee.eas.tm.td.cloud.OrgGroupCollection;
import com.kingdee.eas.tm.td.cloud.OrgGroupFactory;
import com.kingdee.eas.tm.td.cloud.OrgGroupInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemDimensionEntryInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemDimensionInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemMappingCollection;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemMappingInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.app.AbstractItemAnalysisFacadeControllerBean;
import com.kingdee.eas.tm.td.cloud.datamodel.check.info.StatPeriodVo;
import com.kingdee.eas.tm.td.cloud.datamodel.check.info.YearMonthVo;
import com.kingdee.eas.tm.td.cloud.utils.TDCloudUtil;
import com.kingdee.eas.tm.td.est.RealEstateGroupInfo;
import com.kingdee.eas.tm.td.structure.TaxReportItemInfo;
import com.kingdee.eas.tm.td.structure.TaxReportSheetInfo;
import com.kingdee.eas.tm.td.structure.utils.StructureDynamicTableManager;
import com.kingdee.eas.tm.td.utils.CollectionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ItemAnalysisFacadeControllerBean
extends AbstractItemAnalysisFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.cloud.datamodel.app.ItemAnalysisFacadeControllerBean");
    private static final String TEMPITEMFIELD = "FTempItemValue";
    private static final String RES = "com.kingdee.eas.tm.td.ItemAnalysisResource";

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        ctx = EASEjbFactory.getCtx((String)this.getClass().getName(), (Context)ctx);
        this.dropTempTable(params.getString("tempTable"), ctx);
        this.initFieldsByItemDimension(ctx, params);
        String tempTable = this.createTempTable(ctx, this.getCreateTempTable(ctx, params));
        params.setString("tempTable", tempTable);
        TempTablePool tmpTblPool = TempTablePool.getInstance((Context)ctx);
        try {
            tmpTblPool.createIndex(tempTable, "FCompanyID,FYear,FMonth", false, false);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        this.insertGroupData(ctx, tempTable, params);
        this.insertOrgData(ctx, tempTable, params);
        this.updateItemData(ctx, tempTable, params);
        this.insertStatPeriodTotalData(ctx, tempTable, params);
        this.updateGroupTotalData(ctx, tempTable, params);
        this.insertSummaryDataByOrg(ctx, tempTable, params);
        this.buildRptHeader(ctx, tempTable, params);
        return params;
    }

    private void buildRptHeader(Context ctx, String tempTable, RptParams params) throws EASBizException, BOSException {
        RptTableHeader header = new RptTableHeader();
        List<String> listKey = this.getHeaderList(ctx);
        List<String> hideKey = this.getHeaderHideList();
        int statPeriod = 1;
        if (params.getObject("statPeriod") instanceof Integer) {
            statPeriod = params.getInt("statPeriod");
        }
        String itemDimensionId = params.getString("itemDimensionId");
        ItemDimensionInfo dimensionInfo = TDCloudUtil.getItemDimensionInfo(ctx, itemDimensionId);
        dimensionInfo.getEntry().sort("seq");
        int size = dimensionInfo.getEntry().size();
        for (int i = 0; i < size; ++i) {
            ItemDimensionEntryInfo info = dimensionInfo.getEntry().get(i);
            int stat = info.getStatPeriod().getValue();
            if (stat != statPeriod) continue;
            listKey.add(info.getAlias());
            if (!info.isIsHide()) continue;
            hideKey.add(info.getAlias());
        }
        String halfYear = TDUtils.getString(RES, "HalfYear", ctx.getLocale());
        String quarter = TDUtils.getString(RES, "Quarter", ctx.getLocale());
        String month = TDUtils.getString(RES, "Month", ctx.getLocale());
        if (statPeriod == 2) {
            hideKey.add(halfYear);
        } else if (statPeriod == 3) {
            hideKey.add(quarter);
        } else if (statPeriod == 4) {
            hideKey.add(month);
            hideKey.add(halfYear);
            hideKey.add(quarter);
        } else {
            hideKey.add(halfYear);
            hideKey.add(quarter);
        }
        int len = listKey.size();
        Object[][] labels = new Object[1][len];
        String[] keys = listKey.toArray(new String[len]);
        for (int i = 0; i < len; ++i) {
            RptTableColumn column = new RptTableColumn(keys[i]);
            if (hideKey.contains(keys[i])) {
                column.setHided(true);
            }
            labels[0][i] = keys[i];
            header.addColumn(column);
        }
        header.setLabels(labels);
        params.setObject("header", (Object)header);
    }

    private List<String> getHeaderHideList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("FID");
        list.add("FGroupID");
        list.add("FCompanyID");
        list.add("FParentID");
        list.add("FLevel");
        list.add("Fisleaf");
        list.add("Fisshow");
        list.add("Findex");
        list.add("Fareaname");
        return list;
    }

    private List<String> getHeaderList(Context ctx) {
        ArrayList<String> listKeyList = new ArrayList<String>();
        String company = TDUtils.getString(RES, "Company", ctx.getLocale());
        String region = TDUtils.getString(RES, "Region", ctx.getLocale());
        String city = TDUtils.getString(RES, "City", ctx.getLocale());
        String distract = TDUtils.getString(RES, "Distract", ctx.getLocale());
        String year = TDUtils.getString(RES, "Year", ctx.getLocale());
        String halfYear = TDUtils.getString(RES, "HalfYear", ctx.getLocale());
        String quarter = TDUtils.getString(RES, "Quarter", ctx.getLocale());
        String month = TDUtils.getString(RES, "Month", ctx.getLocale());
        String companyTotal = TDUtils.getString(RES, "CompanyTotal", ctx.getLocale());
        listKeyList.add("FID");
        listKeyList.add("FGroupID");
        listKeyList.add("FCompanyID");
        listKeyList.add("FParentID");
        listKeyList.add("FLevel");
        listKeyList.add("Fisleaf");
        listKeyList.add("Fisshow");
        listKeyList.add(company);
        listKeyList.add(companyTotal);
        listKeyList.add(region);
        listKeyList.add("Fareaname");
        listKeyList.add(city);
        listKeyList.add(distract);
        listKeyList.add(year);
        listKeyList.add(halfYear);
        listKeyList.add(quarter);
        listKeyList.add(month);
        listKeyList.add("Findex");
        return listKeyList;
    }

    private void insertSummaryDataByOrg(Context ctx, String tempTable, RptParams params) throws EASBizException, BOSException {
        List fields = (List)params.getObject("fields");
        StringBuffer sql = new StringBuffer();
        sql.append(" INSERT INTO ").append(tempTable);
        sql.append(" (");
        sql.append(" FID,FIsShow,FIndex,FSeq,");
        sql.append("FParentID, FCompanyID,fLevel,fIsleaf");
        if (fields.size() > 0) {
            sql.append(",");
            sql.append(this.getFieldsSQL(fields, null, false));
        }
        sql.append(" )");
        sql.append(" SELECT");
        sql.append(" newbosid('88888888'),0,0,9999,");
        sql.append("FParentID, FCompanyID,fLevel,0");
        if (fields.size() > 0) {
            sql.append(",");
            sql.append(this.getSumFieldsSQL(fields));
        }
        sql.append(" FROM ").append(tempTable);
        sql.append(" WHERE FIndex = 0");
        sql.append(" GROUP BY");
        sql.append(" FParentID, FCompanyID,fLevel,fIsleaf");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void insertStatPeriodTotalData(Context ctx, String tempTable, RptParams params) throws EASBizException, BOSException {
        int statPeriod = params.getObject("statPeriod") instanceof Integer ? params.getInt("statPeriod") : Integer.parseInt(params.getObject("statPeriod").toString());
        if (statPeriod == 1) {
            return;
        }
        List fields = (List)params.getObject("fields");
        StringBuffer sql = new StringBuffer();
        sql.append(" INSERT INTO ").append(tempTable);
        sql.append(" (");
        sql.append(" FID,FIsShow,FIndex,FSeq,");
        sql.append(this.getGroupByFileds(params));
        if (fields.size() > 0) {
            sql.append(",");
            sql.append(this.getFieldsSQL(fields, null, false));
        }
        sql.append(" )");
        sql.append(" SELECT");
        sql.append(" newbosid('88888888'),0,1,99,");
        sql.append(this.getGroupByFileds(params));
        if (fields.size() > 0) {
            sql.append(",");
            sql.append(this.getSumFieldsSQL(fields));
        }
        sql.append(" FROM ").append(tempTable);
        sql.append(" WHERE FIndex = 0");
        sql.append(" GROUP BY");
        sql.append(this.getGroupByFileds(params));
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private String getGroupByFileds(RptParams params) {
        int statPeriod = params.getObject("statPeriod") instanceof String ? Integer.parseInt(params.getString("statPeriod")) : params.getInt("statPeriod");
        StringBuffer sql = new StringBuffer();
        sql.append(" FParentID, FCompanyID,FYear,fLevel,fIsleaf,FLongNumber");
        if (statPeriod == 2) {
            sql.append(" ,FQuarter");
        } else if (statPeriod == 3) {
            sql.append(" ,FHalfYear");
        }
        return sql.toString();
    }

    private void insertGroupData(Context ctx, String tempTable, RptParams params) throws EASBizException, BOSException {
        String groupId = params.getString("groupId");
        GroupInfo groupInfo = GroupFactory.getLocalInstance(ctx).getGroupInfo((IObjectPK)new ObjectUuidPK(groupId));
        GroupCollection groupColl = GroupFactory.getLocalInstance(ctx).getGroupCollection(" where longNumber like '" + groupInfo.getLongNumber() + "%'");
        Connection conn = null;
        PreparedStatement pstmt = null;
        HashSet<String> groupIncludeChildrenIds = new HashSet<String>();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement("INSERT INTO " + tempTable + "(FID,FGroupID,FParentID,fLevel,fisleaf,FLongNumber,FIsShow,FIndex) values(?,?,?,?,?,?,?,?)");
            GroupInfo info = null;
            int size = groupColl.size();
            for (int i = 0; i < size; ++i) {
                info = groupColl.get(i);
                pstmt.setString(1, BOSUuid.create((String)"88888888").toString());
                pstmt.setString(2, info.getId().toString());
                pstmt.setString(3, info.getParent() != null ? info.getParent().getId().toString() : null);
                pstmt.setInt(4, info.getLevel());
                pstmt.setInt(5, 0);
                pstmt.setString(6, info.getLongNumber());
                pstmt.setInt(7, 1);
                pstmt.setInt(8, 2);
                pstmt.addBatch();
                groupIncludeChildrenIds.add(info.getId().toString());
            }
            pstmt.executeBatch();
            params.setObject("groupIncludeChildrenIds", groupIncludeChildrenIds);
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void insertOrgData(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        HashSet companyIds = (HashSet)params.getObject("companyIds");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> regiodCompany = null;
        OrgUnitCollection companys = TDUtils.getAuthOrgByPermItem(ctx, OrgType.Company, "td_itemanalysisrpt_view");
        HashSet<String> mainOrgComIds = new HashSet<String>();
        HashSet<String> companyids = new HashSet<String>();
        if (params.getObject("mainGovAgency") instanceof String) {
            String mainOrgAgency = params.getString("mainGovAgency");
            String[] mainOrgAgencies = mainOrgAgency.split(",");
            HashSet<String> mainOrgAgencySet = new HashSet<String>();
            int len = mainOrgAgencies.length;
            for (int i = 0; i < len; ++i) {
                mainOrgAgencySet.add(mainOrgAgencies[i]);
            }
            EntityViewInfo mainGovView = new EntityViewInfo();
            FilterInfo mainGovfilter = new FilterInfo();
            mainGovfilter.getFilterItems().add(new FilterItemInfo("mainGovAgency", mainOrgAgencySet, CompareType.INCLUDE));
            mainGovView.setFilter(mainGovfilter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("company.id"));
            sic.add(new SelectorItemInfo("company.number"));
            sic.add(new SelectorItemInfo("company.name"));
            sic.add(new SelectorItemInfo("group.id"));
            sic.add(new SelectorItemInfo("group.longNumber"));
            sic.add(new SelectorItemInfo("group.level"));
            mainGovView.setSelector(sic);
            TaxBaseCollection taxBaseCollection = TaxBaseFactory.getLocalInstance(ctx).getTaxBaseCollection(mainGovView);
            if (taxBaseCollection.size() == 0 && !"".equals(mainOrgAgency)) {
                throw new TDException(TDException.MAINGOVAGENCY_ERROR);
            }
            int len2 = taxBaseCollection.size();
            for (int i = 0; i < len2; ++i) {
                String companyId = taxBaseCollection.get(i).getCompany().getId().toString();
                if (!taxBaseCollection.get(i).getState().equals("1")) continue;
                mainOrgComIds.add(companyId);
            }
        }
        for (int i = 0; i < companys.size(); ++i) {
            String id = companys.get(i).getId().toString();
            if (mainOrgComIds.size() != 0) {
                if (!mainOrgComIds.contains(id)) continue;
                companyids.add(id);
                continue;
            }
            companyids.add(id);
        }
        if (params.getObject("webOrGui") == null) {
            HashSet companyOrgids = new HashSet();
            HashSet<Object> curCompanyId = new HashSet<Object>();
            if (params.getObject("curCompanyId") != null) {
                curCompanyId.add(params.getObject("curCompanyId"));
                TDUtils.getCompanyOrgUnitIds(ctx, curCompanyId, companyOrgids);
            }
            if (companyids.size() > 0) {
                companyids.retainAll(companyOrgids);
            }
        }
        companyids.add("");
        if ((companyIds == null || companyIds.size() == 0) && mainOrgComIds.size() == 0) {
            Set groupIncludeChildrenIds = (Set)params.getObject("groupIncludeChildrenIds");
            filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)groupIncludeChildrenIds, CompareType.INCLUDE));
            regiodCompany = this.getRegiodCompanySet(ctx, params);
            if (regiodCompany != null) {
                regiodCompany.retainAll(companyids);
            } else {
                regiodCompany = companyids;
            }
            filter.getFilterItems().add(new FilterItemInfo("company.id", regiodCompany, CompareType.INCLUDE));
        } else {
            if (companyIds == null) {
                companyIds = new HashSet();
            }
            companyIds.retainAll(companyids);
            filter.getFilterItems().add(new FilterItemInfo("company.id", companyIds, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("group.id"));
        sic.add(new SelectorItemInfo("group.longNumber"));
        sic.add(new SelectorItemInfo("group.level"));
        view.setSelector(sic);
        OrgGroupCollection orgGroupColl = OrgGroupFactory.getLocalInstance(ctx).getOrgGroupCollection(view);
        OrgGroupInfo orgGroupInfo = null;
        List<StatPeriodVo> statPeriodList = this.getStatPeriod(params);
        StatPeriodVo statPeriod = null;
        Iterator it = orgGroupColl.iterator();
        while (it.hasNext()) {
            orgGroupInfo = (OrgGroupInfo)it.next();
            StringBuffer sb = new StringBuffer();
            int size = statPeriodList.size();
            for (int i = 0; i < size; ++i) {
                statPeriod = statPeriodList.get(i);
                for (YearMonthVo vo : statPeriod.getYearMonth()) {
                    sb.append("INSERT INTO ").append(tempTable);
                    sb.append(" (FID,FCompanyID,FParentID,fLevel,fIsleaf,FYear,FMonth,FLongNumber,FIsShow,FIndex,FHalfYear,FQuarter)");
                    sb.append(" select '").append(BOSUuid.create((String)"88888888").toString()).append("',t.FID,'");
                    sb.append(orgGroupInfo.getGroup().getId().toString()).append("','");
                    sb.append(orgGroupInfo.getGroup().getLevel() + 1).append("',").append("'1','");
                    sb.append(vo.getYear()).append("','").append(vo.getMonth()).append("','");
                    sb.append(orgGroupInfo.getGroup().getLongNumber()).append("!").append(orgGroupInfo.getCompany().getNumber());
                    sb.append("','0','0'");
                    if (statPeriod.getType().equals("2")) {
                        sb.append(",'0','");
                        sb.append(statPeriod.getPeriod()).append("'");
                    } else if (statPeriod.getType().equals("3")) {
                        sb.append(",'").append(statPeriod.getPeriod()).append("'");
                        sb.append(",'0'");
                    } else {
                        sb.append(",'0','0'");
                    }
                    sb.append(" from T_ORG_COMPANY t");
                    sb.append(" Left JOIN T_TD_Group g on g.fid = t.Fparentid ");
                    sb.append(" Left JOIN T_TM_TaxBase taxbase on taxbase.fcompanyId = t.fid ");
                    sb.append(" where t.fid = '");
                    sb.append(orgGroupInfo.getCompany().getId().toString()).append("' and (taxbase.fstate = '1' or taxbase.fstate is null);");
                }
            }
            this.executeBatchUpdate(ctx, sb.toString().split(";"));
        }
    }

    private Set getRegiodCompanySet(Context ctx, RptParams params) throws BOSException {
        int dimType = params.getInt("dimType");
        Set dimIdSet = (Set)params.getObject("dimIdSet");
        String dimField = null;
        if (dimType == 0) {
            return null;
        }
        if (dimType == 1) {
            dimField = "FRegistCountry";
        } else if (dimType == 2) {
            dimField = "FID";
        } else if (dimType == 3) {
            dimField = "FRegistProvince";
        } else if (dimType == 4) {
            dimField = "FRegistCity";
        } else if (dimType == 5) {
            dimField = "FRegistRegionID";
        }
        HashSet<String> regiodCompany = new HashSet<String>();
        StringBuffer sql = new StringBuffer("");
        if (dimType != 2) {
            sql.append(" SELECT FCOMPANYID FROM T_TM_TaxBase where ");
            sql.append(dimField).append(" in (").append(CollectionUtil.convertSet2String(dimIdSet, ",", true)).append(")");
        } else {
            sql.append(" SELECT FCOMPANYID FROM T_TM_TaxBase base ");
            sql.append(" left join T_BD_Province province on base.FRegistProvince = province.fid");
            sql.append(" left join T_BD_Area area on province.fareaId = area.fid");
            sql.append(" where area.").append(dimField).append(" in (").append(CollectionUtil.convertSet2String(dimIdSet, ",", true)).append(")");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                regiodCompany.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return regiodCompany;
    }

    private List<StatPeriodVo> getStatPeriod(RptParams params) {
        List<Object> statPeriodList = new ArrayList();
        int statPeriod = 1;
        statPeriod = params.getObject("statPeriod") instanceof Integer ? params.getInt("statPeriod") : Integer.parseInt(params.getString("statPeriod"));
        if (statPeriod == 1) {
            statPeriodList = this.getStatPeriodByMonth(params);
        } else if (statPeriod == 2) {
            statPeriodList = this.getStatPeriodByQuarter(params);
        } else if (statPeriod == 3) {
            statPeriodList = this.getStatPeriodByHalfYear(params);
        } else if (statPeriod == 4) {
            statPeriodList = this.getStatPeriodByYear(params);
        }
        return statPeriodList;
    }

    private List<StatPeriodVo> getStatPeriodByMonth(RptParams params) {
        String periodFrom = params.getString("periodFrom");
        String periodTo = params.getString("periodTo");
        int statPeriod = 1;
        statPeriod = params.getObject("statPeriod") instanceof String ? Integer.parseInt(params.getString("statPeriod")) : params.getInt("statPeriod");
        int yearFrom = Integer.parseInt(periodFrom.split("-")[0]);
        int monthFrom = Integer.parseInt(periodFrom.split("-")[1]);
        int yearTo = Integer.parseInt(periodTo.split("-")[0]);
        int monthTo = Integer.parseInt(periodTo.split("-")[1]);
        List<StatPeriodVo> statPeriodList = this.buildPeriodYearVo(statPeriod, yearFrom, yearTo, monthFrom, monthTo, 12, 1);
        return statPeriodList;
    }

    private List<StatPeriodVo> getStatPeriodByQuarter(RptParams params) {
        int statPeriod = params.getObject("statPeriod") instanceof Integer ? params.getInt("statPeriod") : Integer.parseInt(params.getString("statPeriod"));
        int yearFrom = params.getObject("yearFrom") instanceof Integer ? params.getInt("yearFrom") : Integer.parseInt(params.getString("yearFrom"));
        int yearTo = params.getObject("yearTo") instanceof Integer ? params.getInt("yearTo") : Integer.parseInt(params.getString("yearTo"));
        int quarterFrom = params.getObject("quarterFrom") instanceof Integer ? params.getInt("quarterFrom") : Integer.parseInt(params.getString("quarterFrom"));
        int quarterTo = params.getObject("quarterTo") instanceof Integer ? params.getInt("quarterTo") : Integer.parseInt(params.getString("quarterTo"));
        List<StatPeriodVo> statPeriodList = this.buildPeriodYearVo(statPeriod, yearFrom, yearTo, quarterFrom, quarterTo, 4, 1);
        return statPeriodList;
    }

    private List<StatPeriodVo> getStatPeriodByHalfYear(RptParams params) {
        int statPeriod = params.getObject("statPeriod") instanceof Integer ? params.getInt("statPeriod") : Integer.parseInt(params.getString("statPeriod"));
        int yearFrom = params.getObject("yearFrom") instanceof Integer ? params.getInt("yearFrom") : Integer.parseInt(params.getString("yearFrom"));
        int yearTo = params.getObject("yearTo") instanceof Integer ? params.getInt("yearTo") : Integer.parseInt(params.getString("yearTo"));
        int halfYearFrom = params.getObject("halfYearFrom") instanceof Integer ? params.getInt("halfYearFrom") : Integer.parseInt(params.getString("halfYearFrom"));
        int halfYearTo = params.getObject("halfYearTo") instanceof Integer ? params.getInt("halfYearTo") : Integer.parseInt(params.getString("halfYearTo"));
        List<StatPeriodVo> statPeriodList = this.buildPeriodYearVo(statPeriod, yearFrom, yearTo, halfYearFrom, halfYearTo, 2, 1);
        return statPeriodList;
    }

    private List<StatPeriodVo> getStatPeriodByYear(RptParams params) {
        ArrayList<StatPeriodVo> rangePeriodList = new ArrayList<StatPeriodVo>();
        int yearFrom = params.getObject("yearFrom") instanceof Integer ? params.getInt("yearFrom") : Integer.parseInt(params.getString("yearFrom"));
        int yearTo = params.getObject("yearTo") instanceof Integer ? params.getInt("yearTo") : Integer.parseInt(params.getString("yearTo"));
        String statPeriod = params.getObject("statPeriod") instanceof String ? params.getString("statPeriod") : String.valueOf(params.getInt("statPeriod"));
        for (int yearNow = yearFrom; yearNow <= yearTo; ++yearNow) {
            StatPeriodVo periodYear = new StatPeriodVo(statPeriod, yearNow);
            rangePeriodList.add(periodYear);
        }
        return rangePeriodList;
    }

    private List<StatPeriodVo> buildPeriodYearVo(int statPeriodType, int yearFrom, int yearTo, int periodFrom, int periodTo, int maxPeriod, int minPeriod) {
        ArrayList<StatPeriodVo> statPeriodList = new ArrayList<StatPeriodVo>();
        int startPeriod = yearFrom * 100 + periodFrom;
        int endPeriod = yearTo * 100 + periodTo;
        for (int periodNow = startPeriod; periodNow <= endPeriod; ++periodNow) {
            int year = Integer.parseInt((periodNow + "").substring(0, 4));
            int period = Integer.parseInt((periodNow + "").substring(4, 6));
            if (period > maxPeriod || period < minPeriod) continue;
            StatPeriodVo statPeriod = new StatPeriodVo(String.valueOf(statPeriodType), year, period);
            statPeriodList.add(statPeriod);
        }
        return statPeriodList;
    }

    private void updateItemData(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        String taxTypeId = params.getString("taxTypeId");
        String itemDimensionId = params.getString("itemDimensionId");
        ItemDimensionInfo dimensionInfo = TDCloudUtil.getItemDimensionInfo(ctx, itemDimensionId);
        dimensionInfo.getEntry().sort("seq");
        StringBuffer sb = new StringBuffer();
        ItemDimensionEntryInfo entryInfo = null;
        String itemUpdateSQL = null;
        int size = dimensionInfo.getEntry().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = dimensionInfo.getEntry().get(i);
            if (!TDCloudUtil.isFitTaxType(entryInfo, taxTypeId) || (itemUpdateSQL = this.getItemUpdateSQL(ctx, tempTable, entryInfo, params)) == null) continue;
            sb.append(itemUpdateSQL).append(";");
        }
        if (sb.toString().length() != 0) {
            this.executeBatchUpdate(ctx, sb.toString().split(";"));
        }
    }

    private String getItemUpdateSQL(Context ctx, String tempTable, ItemDimensionEntryInfo entryInfo, RptParams params) throws EASBizException, BOSException {
        String fieldName = entryInfo.getItemField();
        String taxTypeId = params.getString("taxTypeId");
        int statPeriod = params.getObject("statPeriod") instanceof Integer ? params.getInt("statPeriod") : Integer.parseInt(params.getObject("statPeriod").toString());
        if (!TDCloudUtil.isNeedStat(entryInfo, statPeriod)) {
            return null;
        }
        TaxReportSheetInfo sheetInfo = null;
        TaxReportItemInfo rowItem = null;
        TaxReportItemInfo columnItem = null;
        AccountConfigInfo account = null;
        RealEstateGroupInfo taxesGroup = null;
        ArrayList<ItemInfo> itemList = new ArrayList<ItemInfo>();
        ItemInfo itemInfo = entryInfo.getItem();
        String itemField = "FTempItemValue0";
        if (itemInfo == null) {
            sheetInfo = entryInfo.getTaxReportSheet();
            rowItem = entryInfo.getReportRowItem();
            columnItem = entryInfo.getReportColumnItem();
            account = entryInfo.getAccountConfig();
            taxesGroup = entryInfo.getBuildTaxesGroup();
            itemInfo = new ItemInfo();
            itemInfo.setTaxReportSheet(sheetInfo);
            itemInfo.setReportRowItem(rowItem);
            itemInfo.setReportColumnItem(columnItem);
            itemInfo.setAccountConfig(account);
            itemInfo.setBuildTaxesGroup(taxesGroup);
            itemList.add(itemInfo);
        } else if (itemInfo != null) {
            if (itemInfo.isIsSumItem()) {
                ItemMappingCollection sumItems = itemInfo.getSumItems();
                HashMap<String, ItemInfo> sumItemsMap = new HashMap<String, ItemInfo>();
                Iterator sumItemsIter = sumItems.iterator();
                ItemMappingInfo mappingInfo = null;
                while (sumItemsIter.hasNext()) {
                    mappingInfo = (ItemMappingInfo)sumItemsIter.next();
                    sumItemsMap.put(mappingInfo.getSourceItem().getNumber(), mappingInfo.getSourceItem());
                    itemList.add(mappingInfo.getSourceItem());
                }
                Pattern pt = Pattern.compile("([\\(]*)([^\\+|^\\-|^\\*|^\\/|^\\(|^\\))]{1,})([\\+|\\-|\\*|\\/|\\(|\\)]*)");
                String sumItemFormula = itemInfo.getSumItemFormula();
                Matcher matcher = pt.matcher(sumItemFormula);
                String itemNumber = null;
                while (matcher.find()) {
                    itemNumber = matcher.group(2);
                    if (!sumItemsMap.containsKey(itemNumber)) continue;
                    sumItemFormula = sumItemFormula.replace(itemNumber, TEMPITEMFIELD + itemList.indexOf(sumItemsMap.get(itemNumber)));
                }
                itemField = sumItemFormula;
            } else {
                itemList.add(itemInfo);
            }
        } else {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE ").append(tempTable).append(" AS t").append("\n");
        sql.append(" SET (" + fieldName + ") =").append("\n");
        sql.append(" ( SELECT ").append(itemField).append(" FROM").append("\n");
        ItemInfo tempItem = null;
        String tblName = null;
        for (int i = 0; i < itemList.size(); ++i) {
            tempItem = (ItemInfo)itemList.get(i);
            sheetInfo = tempItem.getTaxReportSheet();
            rowItem = tempItem.getReportRowItem();
            columnItem = tempItem.getReportColumnItem();
            account = tempItem.getAccountConfig();
            taxesGroup = tempItem.getBuildTaxesGroup();
            tblName = StructureDynamicTableManager.getPhysicalTblName(ctx, sheetInfo.getId().toString());
            if (i > 0) {
                sql.append(" INNER JOIN ").append("\n");
            }
            sql.append("(SELECT temp.FID as FID,C.fvalue as ").append(TEMPITEMFIELD).append(i).append(" FROM").append("\n");
            sql.append("  (").append("\n");
            sql.append("    SELECT  B.fcompanyid,B.fperiodid,B.ftaxtypeid,B.faccountconfigid,B.fbuildingtaxesgroupid,B.fsheetid,B.frowitemid,B.fcolumnitemid,sum(isnull(fvalue1,0)) as fvalue").append("\n");
            sql.append("    FROM ").append(tblName).append(" as B").append("\n");
            sql.append("    INNER JOIN").append("\n");
            sql.append("    (").append("\n");
            sql.append("     SELECT fcompanyid,fperiodid,ftaxtypeid,frecordtype,faccountconfigid,fbuildingtaxesgroupid,fsheetid,frowitemid,fcolumnitemid,max(fdraftrecordType) as fmaxdraftrecordType").append("\n");
            sql.append("     FROM  ").append(tblName).append("\n");
            sql.append("     WHERE FSHEETID = '").append(sheetInfo.getId().toString()).append("'").append("\n");
            sql.append("     and FROWITEMID = '").append(rowItem.getId().toString()).append("'").append("\n");
            sql.append("     and FCOLUMNITEMID = '").append(columnItem.getId().toString()).append("'").append("\n");
            if (account != null) {
                sql.append(" and FACCOUNTCONFIGID = '").append(account.getId().toString()).append("'").append("\n");
            }
            if (taxesGroup != null) {
                sql.append(" and FBUILDINGTAXESGROUPID = '").append(taxesGroup.getId().toString()).append("'").append("\n");
            }
            if (!TDCloudUtil.isEmpty(taxTypeId)) {
                sql.append(" and FTAXTYPEID = '").append(taxTypeId).append("'").append("\n");
            }
            sql.append("  \t GROUP BY fcompanyid,fperiodid,ftaxtypeid,frecordtype,faccountconfigid,fbuildingtaxesgroupid,fsheetid,frowitemid,fcolumnitemid").append("\n");
            sql.append("    ) as A").append("\n");
            sql.append("    on B.fcompanyid = A.fcompanyid").append("\n");
            sql.append("    and B.fperiodid = A.fperiodid").append("\n");
            sql.append("  \tand B.ftaxtypeid = A.ftaxtypeid").append("\n");
            sql.append("  \tand B.frecordtype = A.frecordtype").append("\n");
            sql.append("  \tand ((B.faccountconfigid = A.faccountconfigid) or (B.faccountconfigid is null and A.faccountconfigid is null))").append("\n");
            sql.append("  \tand ((B.fbuildingtaxesgroupid = A.fbuildingtaxesgroupid) or (B.fbuildingtaxesgroupid is null and  A.fbuildingtaxesgroupid is null))").append("\n");
            sql.append("  \tand B.fsheetid = A.fsheetid").append("\n");
            sql.append("  \tand B.frowitemid = A.frowitemid").append("\n");
            sql.append("  \tand B.fcolumnitemid = A.fcolumnitemid").append("\n");
            sql.append("  \tand B.fdraftrecordType = A.fmaxdraftrecordType").append("\n");
            sql.append("  \tGROUP BY B.fcompanyid,B.fperiodid,B.ftaxtypeid,B.faccountconfigid,B.fbuildingtaxesgroupid,B.fsheetid,B.frowitemid,B.fcolumnitemid").append("\n");
            sql.append("  ) as C").append("\n");
            sql.append("  INNER JOIN T_BD_Period  period on period.fid = C.FPeriodID ").append("\n");
            sql.append("  INNER JOIN ").append(tempTable).append(" as temp  on temp.FCompanyID = C.FCompanyID  AND temp.fyear = period.FPeriodYear and temp.fmonth=period.FPeriodNumber").append("\n");
            sql.append("  where temp.FIndex = 0) AS item").append(i).append("\n");
            if (i <= 0) continue;
            sql.append(" on item").append(i - 1).append(".FID = item").append(i).append(".FID ").append("\n");
        }
        sql.append("  WHERE t.fid =item0.fid").append("\n");
        sql.append(" ) ");
        return sql.toString();
    }

    public void updateGroupTotalData(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT max(Flevel) FROM ").append(tempTable);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        int level = 0;
        try {
            while (rs.next()) {
                level = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        List fields = (List)params.getObject("fields");
        sb.setLength(0);
        sb.append(" UPDATE ").append(tempTable).append(" AS a ");
        sb.append(" SET ( FIsShow )").append("=");
        sb.append(" ( SELECT 0 FROM ").append(tempTable).append(" AS b ");
        sb.append("   INNER JOIN ( SELECT FPARENTID");
        if (fields.size() != 0) {
            sb.append(",").append(this.getSumFieldsSQL(fields));
        }
        sb.append("   FROM ").append(tempTable).append(" c");
        sb.append("   WHERE FIndex = 0  ");
        sb.append("   GROUP BY FPARENTID ) as t ON b.fgroupid = t.fparentid");
        sb.append(" WHERE a.fid = b.fid );");
        if (fields.size() != 0) {
            for (int i = level; i > 0; --i) {
                if (i == level) {
                    sb.append(" UPDATE ").append(tempTable).append(" AS a ");
                    sb.append(" SET (").append(this.getFieldsSQL(fields, null, false)).append(", FCompanyTotal").append(")=");
                    sb.append(" ( SELECT ").append(this.getFieldsSQL(fields, "_sum", false)).append(", FCompanyTotal_sum").append(" FROM ").append(tempTable).append(" AS b ");
                    sb.append("   INNER JOIN ( SELECT FPARENTID,").append(this.getSumFieldsSQL(fields)).append(",count(distinct FCompanyID) as FCompanyTotal_sum");
                    sb.append("   FROM ").append(tempTable).append(" c");
                    sb.append("   WHERE flevel=  ").append(i).append(" and FIndex <> 1");
                    sb.append("   GROUP BY FPARENTID) as t ON b.fgroupid = t.fparentid");
                    sb.append(" WHERE a.fid = b.fid );");
                    continue;
                }
                sb.append(" UPDATE ").append(tempTable).append(" AS a ");
                sb.append(" SET (").append(this.getFieldsSQL(fields, null, false)).append(", FCompanyTotal").append(")=");
                sb.append(" ( SELECT ").append(this.getFieldsSQL(fields, "_sum", false)).append(", FCompanyTotal_sum").append(" FROM ").append(tempTable).append(" AS b ");
                sb.append("   INNER JOIN ( SELECT FPARENTID,").append(this.getSumFieldsSQL(fields));
                sb.append(", count(distinct FCompanyID) as FCompanyTotal_sum");
                sb.append("   FROM ").append(tempTable).append(" c");
                sb.append("   WHERE flevel=  ").append(i).append(" and FIndex <> 1 and Fisleaf = 1");
                sb.append("   GROUP BY FPARENTID) as t ON b.fgroupid = t.fparentid");
                sb.append(" WHERE a.fid = b.fid );");
                sb.append(" UPDATE ").append(tempTable).append(" AS a ");
                sb.append(" SET (").append(this.getFieldsSQL(fields, null, false)).append(", FCompanyTotal").append(")=");
                sb.append(" ( SELECT ").append(this.getFieldsSQL(fields, "_sum", false)).append(", FCompanyTotal_sum").append(" FROM ").append(tempTable).append(" AS b ");
                sb.append("   INNER JOIN ( SELECT FPARENTID,").append(this.getSumFieldsSQL(fields));
                sb.append(", sum(FCompanyTotal) as FCompanyTotal_sum");
                sb.append("   FROM ").append(tempTable).append(" c");
                sb.append("   WHERE flevel=  ").append(i).append(" and FIndex <> 1 and Fisleaf = 0");
                sb.append("   GROUP BY FPARENTID) as t ON b.fgroupid = t.fparentid");
                sb.append(" WHERE a.fid = b.fid );");
            }
        }
        super.executeBatchUpdate(ctx, sb.toString().split(";"));
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        ctx = EASEjbFactory.getCtx((String)this.getClass().getName(), (Context)ctx);
        RptRowSet rs = null;
        String tempTable = params.getString("tempTable");
        this.initFieldsByItemDimension(ctx, params);
        rs = this.executeQuery(this.getSelectSQL(ctx, tempTable, params), null, from, len, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        RptRowSet countRs = null;
        int totalCount = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select count(*) as totalCount from ").append(tempTable);
        countRs = this.executeQuery(sql.toString(), null, ctx);
        if (countRs.next()) {
            totalCount = countRs.getInt("totalCount");
        }
        pp.setInt("totalCount", totalCount);
        return pp;
    }

    @Override
    protected Map _findDataByParent(Context ctx, Map params) throws BOSException, EASBizException {
        String parentId = (String)params.get("parentId");
        int level = (Integer)params.get("level");
        String itemDimensionId = (String)params.get("analysisDimensionId");
        String taxTypeId = (String)params.get("taxTypeId");
        String tempTable = (String)params.get("tempTable");
        String statPeriod = params.get("statPeriod") instanceof Integer ? String.valueOf(params.get("statPeriod")) : (String)params.get("statPeriod");
        List fields = this.getFieldsList(ctx, taxTypeId, itemDimensionId, statPeriod);
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT t.FID as FID,t.FGroupID as FGroupID,t.FCompanyID as FCompanyID,t.FParentID as FParentID,t.fLevel,t.fisLeaf,t.FIsShow,");
        sql.append(" case when t.findex=2 then");
        sql.append(" g.fname_").append(ctx.getLocale().toString());
        sql.append(" else company.fname_").append(ctx.getLocale().toString()).append(" end as FBillName,");
        sql.append(" t.FCompanyTotal,");
        sql.append(" province.fname_").append(ctx.getLocale().toString()).append(" as FPROVINCENAME,");
        sql.append(" area.fname_").append(ctx.getLocale().toString()).append(" as FAreaName,");
        sql.append(" city.fname_").append(ctx.getLocale().toString()).append(" as FCityName,");
        sql.append(" region.fname_").append(ctx.getLocale().toString()).append(" as FRegionName,");
        sql.append(" t.FYear as FYear,t.FHalfYear as FHALFYEAR,t.FQuarter as FQUARTER,t.FMonth as FMonth,t.FIndex as Findex");
        if (fields.size() > 0) {
            sql.append(",");
            sql.append(this.getFieldsSQL(fields, "t.", true));
        }
        sql.append(" FROM ").append(tempTable).append(" t ");
        sql.append(" Left JOIN T_TD_Group g on g.fid = t.FgroupID");
        sql.append(" Left JOIN t_org_company company on company.fid = t.fcompanyid");
        sql.append(" Left JOIN T_TM_TaxBase taxbase on taxbase.fcompanyId = company.fid");
        sql.append(" Left JOIN T_BD_Province province on province.fid = taxbase.fregistProvince");
        sql.append(" left join T_BD_Area area on province.fareaId = area.fid");
        sql.append(" left join T_BD_City city on city.FID = taxbase.fregistCity");
        sql.append(" left join T_BD_Region region on region.FID = taxbase.fregistRegionId");
        sql.append(" where t.FParentID = '").append(parentId).append("'");
        sql.append(" and t.FLevel = ").append(level + 1);
        if (this.isExistsStat(ctx, params)) {
            sql.append(" and t.FIndex <> 0 ");
        }
        sql.append("  and (taxbase.fstate = '1' or taxbase.fstate is null)");
        if (!"1".equals((String)params.get("isSummary"))) {
            sql.append(" and  t.FSeq != '9999' ");
        }
        sql.append(" ORDER BY t.FLongNumber asc,t.fyear desc,t.FHalfYear asc,t.FQuarter asc, t.fmonth asc,t.fseq asc");
        RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
        HashMap result = new HashMap();
        ArrayList rowDataList = new ArrayList();
        ArrayList<String> headerListKey = new ArrayList<String>();
        while (rs.next()) {
            HashMap<String, Object> rowData = new HashMap<String, Object>();
            int len = rs.getColumnCount();
            for (int i = 0; i < len; ++i) {
                rowData.put(rs.getColumnName(i).toUpperCase(), rs.getObject(i));
                if (headerListKey.size() >= len) continue;
                headerListKey.add(rs.getColumnName(i).toUpperCase());
            }
            if (rowData.get("FMONTH") == null && ((BigDecimal)rowData.get("FISLEAF")).intValue() != 0) {
                rowData.put("FBILLNAME", TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "SUBTOTAL", ctx.getLocale()));
            }
            rowDataList.add(rowData);
        }
        result.put("headerListKey", headerListKey);
        result.put("data", rowDataList);
        return result;
    }

    private boolean isExistsStat(Context ctx, Map params) throws BOSException {
        String tempTable = (String)params.get("tempTable");
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT 1 FROM ").append(tempTable).append(" where Findex = 1");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private String getSelectSQL(Context ctx, String tempTable, RptParams params) throws EASBizException, BOSException {
        List fields = (List)params.getObject("fields");
        String groupId = params.getString("groupId");
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT t.FID as FID,t.FGroupID as FGroupID,t.FCompanyID as FCompanyID,t.FParentID as FParentID,t.fLevel,t.fisLeaf,0 as fisshow,");
        sql.append(" case when t.findex=2 then");
        sql.append(" g.fname_").append(ctx.getLocale().toString());
        sql.append(" else company.fname_").append(ctx.getLocale().toString()).append(" end as FBillName,");
        sql.append(" FCompanyTotal,");
        sql.append(" province.fname_").append(ctx.getLocale().toString()).append(" as FProvinceName,");
        sql.append(" area.fname_").append(ctx.getLocale().toString()).append(" as FAreaName,");
        sql.append(" city.fname_").append(ctx.getLocale().toString()).append(" as FCityName,");
        sql.append(" region.fname_").append(ctx.getLocale().toString()).append(" as FRegionName,");
        sql.append(" t.FYear as FYear,t.FHalfYear as FHalfYear,t.FQuarter as FQuarter,t.FMonth as FMonth,t.findex as findex");
        if (fields.size() > 0) {
            sql.append(",");
            sql.append(this.getFieldsSQL(fields, "t.", true));
        }
        sql.append(" FROM ").append(tempTable).append(" t ");
        sql.append(" Left JOIN T_TD_Group g on g.fid = t.FgroupID");
        sql.append(" Left JOIN t_org_company company on company.fid = t.fcompanyid");
        sql.append(" Left JOIN T_TM_TaxBase taxbase on taxbase.fcompanyId = company.fid");
        sql.append(" Left JOIN T_BD_Province province on province.fid = taxbase.fregistProvince");
        sql.append(" left join T_BD_Area area on province.fareaId = area.fid");
        sql.append(" left join T_BD_City city on city.FID = taxbase.fregistCity");
        sql.append(" left join T_BD_Region region on region.FID = taxbase.fregistRegionId");
        if (!params.getBoolean("isSummary")) {
            sql.append(" WHERE t.findex = 2");
            sql.append(" AND t.FGROUPID = '").append(groupId).append("' ");
            sql.append(" and (taxbase.fstate = '1' or taxbase.fstate is null)");
        } else if (params.getObject("statPeriod") != null) {
            int statPeriod = params.getObject("statPeriod") instanceof Integer ? params.getInt("statPeriod") : Integer.parseInt(params.getString("statPeriod"));
            if (params.containsKey("FSeq") && statPeriod != 1) {
                sql.append(" WHERE FSeq = 99 OR t.findex = 2");
                sql.append(" and (taxbase.fstate = '1' or taxbase.fstate is null)");
            }
        }
        sql.append(" ORDER BY t.FLongNumber asc,t.fyear desc,FHalfYear asc,FQuarter asc, t.fmonth asc");
        return sql.toString();
    }

    private String getCreateTempTable(Context ctx, RptParams params) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table TempReportTable(");
        sql.append("FID varchar(44),");
        sql.append("FName nvarchar(255),");
        sql.append("FGroupID varchar(44),");
        sql.append("FParentID varchar(44),");
        sql.append("fLevel int,");
        sql.append("fIsleaf int,");
        sql.append("FCompanyID varchar(44),");
        sql.append("FCompanyTotal int default 0,");
        sql.append("FYear int,");
        sql.append("FHalfYear int,");
        sql.append("FQuarter int,");
        sql.append("FMonth int,");
        sql.append("FLongNumber varchar(255),");
        sql.append("FIsShow int,");
        sql.append("FIndex int,");
        sql.append("FSeq int default 0,");
        List fields = (List)params.getObject("fields");
        if (fields.size() == 0) {
            sql.deleteCharAt(sql.length() - 1);
        } else {
            sql.append(this.getCreateFieldsSQL(fields));
        }
        sql.append(");");
        return sql.toString();
    }

    private void initFieldsByItemDimension(Context ctx, RptParams params) throws EASBizException, BOSException {
        String taxTypeId = params.getString("taxTypeId");
        String itemDimensionId = params.getString("itemDimensionId");
        String statPeriod = null;
        statPeriod = params.getObject("statPeriod") instanceof Integer ? String.valueOf(params.getInt("statPeriod")) : params.getString("statPeriod");
        params.setObject("fields", (Object)this.getFieldsList(ctx, taxTypeId, itemDimensionId, statPeriod));
    }

    private List getFieldsList(Context ctx, String taxTypeId, String itemDimensionId, String statPeriod) throws EASBizException, BOSException {
        ArrayList<String> fields = new ArrayList<String>();
        ItemDimensionInfo dimensionInfo = TDCloudUtil.getItemDimensionInfo(ctx, itemDimensionId);
        dimensionInfo.getEntry().sort("seq");
        StringBuffer sb = new StringBuffer();
        ItemDimensionEntryInfo entryInfo = null;
        int size = dimensionInfo.getEntry().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = dimensionInfo.getEntry().get(i);
            if (!TDCloudUtil.isFitTaxType(entryInfo, taxTypeId) || !TDCloudUtil.isNeedStat(entryInfo, Integer.parseInt(statPeriod))) continue;
            fields.add(entryInfo.getItemField());
        }
        return fields;
    }

    private List getSumFieldsList(Context ctx, String taxTypeId, String itemDimensionId) throws EASBizException, BOSException {
        ArrayList<String> fields = new ArrayList<String>();
        ItemDimensionInfo dimensionInfo = TDCloudUtil.getItemDimensionInfo(ctx, itemDimensionId);
        dimensionInfo.getEntry().sort("seq");
        StringBuffer sb = new StringBuffer();
        ItemDimensionEntryInfo entryInfo = null;
        int size = dimensionInfo.getEntry().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = dimensionInfo.getEntry().get(i);
            if (!entryInfo.isIsSummary() || !TDCloudUtil.isFitTaxType(entryInfo, taxTypeId)) continue;
            fields.add(entryInfo.getItemField());
        }
        return fields;
    }

    private String getCreateFieldsSQL(List fieldsList) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        String fieldName = null;
        int size = fieldsList.size();
        for (int i = 0; i < size; ++i) {
            fieldName = (String)fieldsList.get(i);
            sb.append(fieldName).append(" ").append("NUMERIC(28,10) default 0");
            if (i == size - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private String getFieldsSQL(List fields, String prefix, boolean isFront) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        String fieldName = null;
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            fieldName = (String)fields.get(i);
            if (!StringUtils.isEmpty((String)prefix) && isFront) {
                sb.append(prefix);
            }
            sb.append(fieldName);
            if (!StringUtils.isEmpty((String)prefix) && !isFront) {
                sb.append(prefix);
            }
            if (i == size - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private String getSumFieldsSQL(List fieldsList) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        String fieldName = null;
        int size = fieldsList.size();
        for (int i = 0; i < size; ++i) {
            fieldName = (String)fieldsList.get(i);
            sb.append("sum(").append(fieldName).append(")").append(" AS ").append(fieldName).append("_sum");
            if (i == size - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    @Override
    protected Map _queryTotal(Context ctx, Map params) throws BOSException, EASBizException {
        boolean isRegion = (Boolean)params.get("isRegion");
        String groupId = (String)params.get("groupId");
        String itemDimensionId = (String)params.get("itemDimensionId");
        String taxTypeId = (String)params.get("taxTypeId");
        String tempTable = (String)params.get("tempTable");
        HashMap<String, BigDecimal> data = new HashMap<String, BigDecimal>();
        HashMap<String, HashMap<String, BigDecimal>> ret = new HashMap<String, HashMap<String, BigDecimal>>();
        ret.put("data", data);
        List fields = this.getSumFieldsList(ctx, taxTypeId, itemDimensionId);
        if (fields.size() == 0) {
            return ret;
        }
        StringBuffer sql = new StringBuffer();
        if (isRegion) {
            sql.append(" SELECT t.FID as FID,t.FGroupID as FGroupID,t.FCompanyID as FCompanyID,t.FParentID as FParentID,t.fLevel,t.fisLeaf,t.FIsShow,");
            sql.append(" case when t.findex=2 then");
            sql.append(" g.fname_").append(ctx.getLocale().toString());
            sql.append(" else company.fname_").append(ctx.getLocale().toString()).append(" end as FBillName,");
            sql.append(" t.FYear as FYear,t.FMonth as FMonth,t.FHalfYear as FHALFYEAR,t.FQuarter as FQUARTER,");
            sql.append(" province.fname_").append(ctx.getLocale().toString()).append(" as FPROVINCENAME,");
            sql.append(" province.fnumber as FPROVINCENUMBER,");
            sql.append(this.getFieldsSQL(fields, "t.", true));
            sql.append(" FROM ").append(tempTable).append(" t ");
            sql.append(" Left JOIN T_TD_Group g on g.fid = t.FgroupID");
            sql.append(" Left JOIN t_org_company company on company.fid = t.fcompanyid");
            sql.append(" Left JOIN T_TM_TaxBase taxbase on taxbase.fcompanyId = company.fid");
            sql.append(" Left JOIN T_BD_Province province on province.fid = taxbase.fregistProvince");
            sql.append(" where  t.FISLeaf = 1");
            sql.append(" and (taxbase.fstate = '1' or taxbase.fstate is null)");
            if (this.isExistsStat(ctx, params)) {
                sql.append(" and t.FIndex <> 0 ");
            }
        } else {
            sql.append(" SELECT t.FID as FID,t.FGroupID as FGroupID,t.FCompanyID as FCompanyID,t.FParentID as FParentID,t.fLevel,t.fisLeaf,t.FIsShow,");
            sql.append(" case when t.findex=2 then");
            sql.append(" g.fname_").append(ctx.getLocale().toString());
            sql.append(" else company.fname_").append(ctx.getLocale().toString()).append(" end as FBillName,");
            sql.append(" t.FYear as FYear,t.FMonth as FMonth,t.FHalfYear as FHalfYear,t.FQuarter as FQuarter,");
            sql.append(" province.fname_").append(ctx.getLocale().toString()).append(" as FProvinceName,");
            sql.append(this.getFieldsSQL(fields, "t.", true));
            sql.append(" FROM ").append(tempTable).append(" t ");
            sql.append(" Left JOIN T_TD_Group g on g.fid = t.FgroupID");
            sql.append(" Left JOIN t_org_company company on company.fid = t.fcompanyid");
            sql.append(" Left JOIN T_TM_TaxBase taxbase on taxbase.fcompanyId = company.fid");
            sql.append(" Left JOIN T_BD_Province province on province.fid = taxbase.fregistProvince");
            sql.append(" WHERE t.findex = 2 and t.FgroupID = '").append(groupId).append("'");
            sql.append(" and (taxbase.fstate = '1' or taxbase.fstate is null)");
        }
        RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
        BigDecimal value = BigDecimal.ZERO;
        if (isRegion) {
            String proviceNumber = null;
            String columnName = (String)fields.get(0);
            while (rs.next()) {
                proviceNumber = rs.getString("FPROVINCENUMBER");
                if (StringUtils.isEmpty((String)proviceNumber)) continue;
                value = rs.getBigDecimal(columnName);
                if (data.containsKey(proviceNumber)) {
                    data.put(proviceNumber, ((BigDecimal)data.get(proviceNumber)).add(value));
                    continue;
                }
                data.put(proviceNumber, value);
            }
        } else if (rs.next()) {
            String columnName = (String)fields.get(0);
            value = rs.getBigDecimal(columnName);
            data.put("value", value);
        }
        return ret;
    }
}

