/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ProvinceInfo;
import com.kingdee.eas.basedata.common.olap.EASEjbFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.tm.td.DraftStatusEnum;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftRecordCollection;
import com.kingdee.eas.tm.td.TaxDraftRecordFactory;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.basedata.TaxBaseCollection;
import com.kingdee.eas.tm.td.basedata.TaxBaseFactory;
import com.kingdee.eas.tm.td.basedata.TaxBaseInfo;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeCollection;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeFactory;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.cloud.AbstractTaxNotesInfo;
import com.kingdee.eas.tm.td.cloud.TaxNotesCollection;
import com.kingdee.eas.tm.td.cloud.TaxNotesFactory;
import com.kingdee.eas.tm.td.cloud.TaxNotesInfo;
import com.kingdee.eas.tm.td.cloud.TaxTimeTableCollection;
import com.kingdee.eas.tm.td.cloud.TaxTimeTableFactory;
import com.kingdee.eas.tm.td.cloud.TaxTimeTableInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.app.AbstractTaxDeclarationProgressFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class TaxDeclarationProgressFacadeControllerBean
extends AbstractTaxDeclarationProgressFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.cloud.datamodel.app.TaxDeclarationProgressFacadeControllerBean");
    private Map<String, TaxBaseInfo> cacheTaxBase = null;
    private Map<String, TaxTimeTableInfo> cacheTaxTimeTable = null;
    private Map<String, TaxNotesInfo> cacheTaxNotes = null;

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        ctx = EASEjbFactory.getCtx((String)this.getClass().getName(), (Context)ctx);
        this.dropTempTable(params.getString("tempTable"), ctx);
        this.cacheTaxBase = new HashMap<String, TaxBaseInfo>();
        this.cacheTaxTimeTable = new HashMap<String, TaxTimeTableInfo>();
        this.cacheTaxNotes = new HashMap<String, TaxNotesInfo>();
        String tempTable = this.createTempTable(ctx, this.getCreateTempTable(ctx, params));
        params.setString("tempTable", tempTable);
        this.insertData(ctx, tempTable, params);
        this.updateData(ctx, tempTable, params);
        return params;
    }

    protected void updateData(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        this.updateCompleteFlag(ctx, tempTable, params, 0);
        this.updateCompleteFlag(ctx, tempTable, params, 1);
        this.updateCompleteFlag(ctx, tempTable, params, 2);
    }

    protected void updateCompleteFlag(Context ctx, String tempTable, RptParams params, int updateFlag) throws BOSException, EASBizException {
        String field = null;
        String recordTypes = null;
        if (updateFlag == 0) {
            field = "FisAccountComplete";
            recordTypes = "0";
        } else if (updateFlag == 1) {
            field = "FisTaxDraftComplete";
            recordTypes = "1,3,5";
        } else if (updateFlag == 2) {
            field = "FisTaxDeclareComplete";
            recordTypes = "2,4,6";
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE ").append(tempTable).append(" as t SET (").append(field).append(")=");
        sql.append(" (SELECT isnull(max(case when record.fid is null then 0 else 1 end),0) FROM ").append(tempTable).append(" as t1 ");
        sql.append(" LEFT JOIN T_TD_TaxDraftRecord record ");
        sql.append(" ON t1.Fyear = record.fyear AND t1.Fmonth = record.fperiod");
        sql.append(" AND t1.FcompanyId = record.FCompanyOrgUnitID AND t1.FtaxTypeId = record.FTaxTypeID");
        sql.append(" WHERE record.FRecordType in (").append(recordTypes).append(") AND  record.FDraftStatus >1");
        sql.append(" AND t.fid = t1.fid)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        ctx = EASEjbFactory.getCtx((String)this.getClass().getName(), (Context)ctx);
        RptRowSet rs = null;
        String tempTable = params.getString("tempTable");
        rs = this.executeQuery(this.getSelectSQL(ctx, tempTable, params), null, from, len, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        int totalCount = 0;
        if (rs.next()) {
            totalCount = rs.getRowCount();
        }
        pp.setInt("totalCount", totalCount);
        return pp;
    }

    @Override
    protected ArrayList _queryTotal(Context ctx, Map param) throws BOSException, EASBizException {
        RptParams params = new RptParams();
        params.putAll(param);
        String tempTable = params.getString("tempTable");
        if (StringUtils.isEmpty((String)tempTable) || "null".equals(tempTable)) {
            RptParams tempParams = this.createTempTable(ctx, params);
            tempTable = tempParams.getString("tempTable");
        }
        int isOverDate = Integer.parseInt(params.getString("isOverDate"));
        String whereSql = this.getWhereFilter(ctx, params);
        StringBuffer sql = new StringBuffer();
        if (isOverDate == 1) {
            sql.append(" SELECT t.FtaxTypeId as taxType,count(1) as totalCount, sum(case when FisOverDate = 1 then 1  else 0 end) as completeCount ");
        } else {
            sql.append(" SELECT t.FtaxTypeId as taxType,count(1) as totalCount, sum(case when Fstatus = 4 then 1  else 0 end) as completeCount ");
        }
        sql.append(" FROM ").append(tempTable).append(" t ");
        sql.append(whereSql);
        sql.append(" GROUP BY t.FtaxTypeId ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap totalMap = new HashMap();
        Map<String, Integer> taxTotalMap = null;
        try {
            while (rs.next()) {
                taxTotalMap = new HashMap<String, Object>();
                taxTotalMap.put("taxType", (Integer)((Object)rs.getString("taxType")));
                taxTotalMap.put("totalCount", rs.getInt("totalCount"));
                taxTotalMap.put("completeCount", rs.getInt("completeCount"));
                totalMap.put(rs.getString("taxType"), taxTotalMap);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        EntityViewInfo TaxItemTypeEv = new EntityViewInfo();
        SorterItemCollection TaxItemTypesort = new SorterItemCollection();
        TaxItemTypesort.add(new SorterItemInfo("number"));
        FilterInfo taxTypeFilter = new FilterInfo();
        taxTypeFilter.getFilterItems().add(new FilterItemInfo("sign", (Object)"1", CompareType.EQUALS));
        TaxItemTypeEv.setFilter(taxTypeFilter);
        TaxItemTypeEv.setSorter(TaxItemTypesort);
        TaxItemTypeCollection taxItemTypeColl = TaxItemTypeFactory.getRemoteInstance().getTaxItemTypeCollection(TaxItemTypeEv);
        HashMap taxTypeMap = new HashMap();
        TaxItemTypeInfo taxItemTypeInfo = null;
        ArrayList<Map<String, Integer>> totalList = new ArrayList<Map<String, Integer>>();
        for (int i = 0; i < taxItemTypeColl.size(); ++i) {
            taxItemTypeInfo = taxItemTypeColl.get(i);
            taxTotalMap = (Map)totalMap.get(taxItemTypeInfo.getId().toString());
            if (taxTotalMap == null) {
                taxTotalMap = new HashMap();
                taxTotalMap.put("totalCount", 0);
                taxTotalMap.put("completeCount", 0);
            }
            taxTotalMap.put("taxType", (Integer)((Object)taxItemTypeInfo));
            totalList.add(taxTotalMap);
        }
        return totalList;
    }

    private String getWhereFilter(Context ctx, RptParams params) throws EASBizException, BOSException {
        HashSet group;
        HashSet companyIdsSet;
        StringBuffer whereSql = new StringBuffer();
        String areaId = params.getString("areaId");
        String taxTypeId = params.getString("taxTypeId");
        String status = params.getString("select");
        String rptPeriod = params.getString("rptPeriodF7");
        String year = params.getString("year");
        String month = params.getString("month");
        String periodFrom = params.getString("periodFrom");
        String periodTo = params.getString("periodTo");
        int yearFrom = Integer.parseInt(periodFrom.split("-")[0]);
        int monthFrom = Integer.parseInt(periodFrom.split("-")[1]);
        int yearTo = Integer.parseInt(periodTo.split("-")[0]);
        int monthTo = Integer.parseInt(periodTo.split("-")[1]);
        int isOverDate = Integer.parseInt(params.getString("isOverDate"));
        String companyID2 = "";
        String companyIDsStr = "";
        OrgUnitCollection companys = TDUtils.getAuthOrgByPermItem(ctx, OrgType.Company, "td_taxdeclarationprogress_view");
        HashSet companyids = new HashSet();
        for (int i = 0; i < companys.size(); ++i) {
            companyids.add(companys.get(i).getId().toString());
        }
        HashSet companyOrgids = new HashSet();
        HashSet<String> curCompanyId = new HashSet<String>();
        if (params.getObject("curCompanyId") != null) {
            curCompanyId.add(params.getString("curCompanyId"));
            TDUtils.getCompanyOrgUnitIds(ctx, curCompanyId, companyOrgids);
        }
        if (companyids.size() > 0) {
            companyids.retainAll(companyOrgids);
        }
        companyids.add("");
        if (params.getObject("companyIds") != null) {
            companyIdsSet = (HashSet)params.getObject("companyIds");
            companyIdsSet.retainAll(companyids);
            companyIdsSet.add("");
            for (String companyID2 : companyIdsSet) {
                companyIDsStr = companyIDsStr + "'" + companyID2 + "',";
            }
            companyIDsStr = companyIDsStr.substring(0, companyIDsStr.length() - 1);
        } else {
            companyIdsSet = companyids;
            for (String companyID2 : companyIdsSet) {
                companyIDsStr = companyIDsStr + "'" + companyID2 + "',";
            }
            companyIDsStr = companyIDsStr.substring(0, companyIDsStr.length() - 1);
        }
        whereSql.append(" WHERE 1 = 1");
        if (!companyIDsStr.equals("")) {
            whereSql.append(" AND t.FcompanyId in (" + companyIDsStr + ")");
        }
        if (areaId != null) {
            whereSql.append(" AND t.FareaId = '" + areaId + "'");
        }
        if (taxTypeId != null) {
            whereSql.append(" AND t.FTaxTypeId = '" + taxTypeId + "'");
        }
        if (status != null && Integer.valueOf(status) != -1) {
            whereSql.append(" AND t.Fstatus = " + status);
        }
        if (year != null && month != null) {
            whereSql.append(" AND YEAR(t.FendDate) =").append(year);
            whereSql.append(" AND MONTH(t.FendDate) = ").append(month);
        }
        if ((group = (HashSet)params.getObject("f7Group")) != null) {
            Iterator it = group.iterator();
            String groupString = "";
            groupString = groupString + " AND og.FGroupID in ('";
            while (it.hasNext()) {
                String groupId = (String)it.next();
                groupString = groupString + groupId + "','";
            }
            if (group.size() > 0) {
                groupString = groupString.substring(0, groupString.length() - 2);
                whereSql.append(groupString);
                whereSql.append(") ");
            }
        }
        if (isOverDate != 2) {
            whereSql.append(" AND t.FisOverDate = ").append(isOverDate);
        }
        whereSql.append(" AND (");
        whereSql.append(" FYear*100+FMonth >= ").append(yearFrom * 100 + monthFrom);
        whereSql.append(" and ").append(" FYear*100+FMonth <= ").append(yearTo * 100 + monthTo);
        whereSql.append(" ) ");
        return whereSql.toString();
    }

    private String getSelectSQL(Context ctx, String tempTable, RptParams params) throws EASBizException, BOSException {
        String whereSql = this.getWhereFilter(ctx, params);
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT t.FID as FID,t.FDraftRecordID as FDraftRecordID,t.FCompanyCode as FCompanyCode,t.FCompanyName as FCompanyName,t.FtaxType as FtaxType, ");
        sql.append(" t.FtaxReturnType as FtaxReturnType, t.FrptPeriod as FrptPeriod,t.FendDate as FendDate, t.Fstatus as Fstatus, t.Famount as Famount, t.Ftype as Ftype,t.FRecordType as FRecordType, ");
        sql.append(" t.FisOverDate as FisOverDate,t.FisAccountComplete as FisAccountComplete,t.FisTaxDraftComplete as FisTaxDraftComplete,t.FisTaxDeclareComplete as FisTaxDeclareComplete,t.FDraftDate as FDraftDate,t.FDraftUser as FDraftUser");
        sql.append(" FROM ").append(tempTable).append(" t ");
        HashSet group = (HashSet)params.getObject("f7Group");
        if (group != null) {
            sql.append(" inner join T_TD_OrgGroup as og on t.FCompanyId=og.FCompanyID inner join T_TD_Group as g on g.FID=og.FGroupID ");
        }
        sql.append(whereSql);
        sql.append(" ORDER BY FCompanyCode");
        return sql.toString();
    }

    private void insertData(Context ctx, String tempTable, RptParams params) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> recordTypeSet = new HashSet<Integer>();
        recordTypeSet.add(2);
        recordTypeSet.add(4);
        recordTypeSet.add(6);
        filter.getFilterItems().add(new FilterItemInfo("recordType", recordTypeSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.isBizUnit", (Object)1, CompareType.EQUALS));
        ev.setFilter(filter);
        SelectorItemCollection select = new SelectorItemCollection();
        select.add(new SelectorItemInfo("*"));
        select.add(new SelectorItemInfo("rptPeriod.*"));
        select.add(new SelectorItemInfo("companyOrgUnit.id"));
        select.add(new SelectorItemInfo("companyOrgUnit.name"));
        select.add(new SelectorItemInfo("companyOrgUnit.number"));
        select.add(new SelectorItemInfo("taxType.id"));
        select.add(new SelectorItemInfo("taxType.simName"));
        select.add(new SelectorItemInfo("taxType.name"));
        ev.setSelector(select);
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("companyOrgUnit.number"));
        ev.setSorter(sort);
        TaxDraftRecordCollection TaxDraftRecordColl = TaxDraftRecordFactory.getLocalInstance(ctx).getTaxDraftRecordCollection(ev);
        this.cacheMap(ctx, TaxDraftRecordColl);
        TaxDraftRecordInfo info = null;
        CompanyOrgUnitInfo orgUnit = null;
        Date endDate = null;
        String areaId = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement("INSERT INTO " + tempTable + "(FID,FDraftRecordID,FCompanyCode,FCompanyName,FtaxType,FtaxReturnType,FrptPeriod,FendDate,Fstatus,Famount,Ftype,FRecordType,FareaId,FcompanyId,FtaxTypeId,Fyear,Fmonth,FisOverDate,FisAccountComplete,FisTaxDraftComplete,FisTaxDeclareComplete,FDraftDate,FDraftUser) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            int len = TaxDraftRecordColl.size();
            for (int i = 0; i < len; ++i) {
                info = TaxDraftRecordColl.get(i);
                orgUnit = info.getCompanyOrgUnit();
                pstmt.setString(1, BOSUuid.create((String)"88888888").toString());
                pstmt.setString(2, info.getId().toString());
                pstmt.setString(3, orgUnit.getNumber());
                pstmt.setString(4, orgUnit.getName());
                pstmt.setString(5, info.getTaxType().getName());
                pstmt.setInt(6, this.getTaxTeturnType(info));
                pstmt.setString(7, String.valueOf(info.getRptPeriod().getNumber()));
                endDate = this.getEndDate(ctx, info);
                pstmt.setDate(8, endDate);
                pstmt.setInt(9, info.getDraftStatus() == null ? -1 : info.getDraftStatus().getValue());
                pstmt.setBigDecimal(10, info.getPayAmount());
                pstmt.setInt(11, info.getDeclaredType() == null ? 0 : info.getDeclaredType().getValue());
                pstmt.setInt(12, info.getRecordType() == null ? null : Integer.valueOf(info.getRecordType().getValue()));
                areaId = this.getAreaId(orgUnit);
                pstmt.setString(13, areaId);
                pstmt.setString(14, orgUnit.getId().toString());
                pstmt.setString(15, info.getTaxType().getId().toString());
                pstmt.setInt(16, info.getYear());
                pstmt.setInt(17, info.getPeriod());
                if (endDate != null && endDate.before(new java.util.Date()) && !DraftStatusEnum.DECLARED.equals((Object)info.getDraftStatus())) {
                    pstmt.setInt(18, 1);
                } else {
                    pstmt.setInt(18, 0);
                }
                pstmt.setInt(19, 0);
                pstmt.setInt(20, 0);
                pstmt.setInt(21, 0);
                Date draftDate = (Date)info.getDraftDate();
                pstmt.setDate(22, draftDate);
                pstmt.setString(23, info.getDraftUser());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private String getAreaId(CompanyOrgUnitInfo orgUnit) {
        String areaId = "";
        ProvinceInfo provinceInfo = null;
        TaxBaseInfo taxBaseInfo = this.cacheTaxBase.get(orgUnit.getId().toString());
        if (taxBaseInfo != null && (provinceInfo = taxBaseInfo.getRegistProvince()) != null) {
            areaId = provinceInfo.getId().toString();
        }
        return areaId;
    }

    private int getTaxTeturnType(TaxDraftRecordInfo info) {
        int taxReturnType = -1;
        AbstractTaxNotesInfo taxNotesInfo = null;
        if (info.getTaxType() != null) {
            String key = info.getTaxType().getId().toString() + info.getRecordType().getValue();
            taxNotesInfo = this.cacheTaxNotes.get(key);
        }
        if (taxNotesInfo != null) {
            taxReturnType = taxNotesInfo.getTaxReturnType() == null ? -1 : taxNotesInfo.getTaxReturnType().getValue();
        }
        return taxReturnType;
    }

    private void cacheMap(Context ctx, TaxDraftRecordCollection taxDraftRecordColl) throws BOSException {
        TaxDraftRecordInfo info = null;
        ProvinceInfo provinceInfo = null;
        TaxTimeTableInfo taxTimeTableInfo = null;
        TaxNotesInfo taxNotes = null;
        String companyIds = "";
        String proviceIds = "";
        String taxTypeIds = "";
        int len = taxDraftRecordColl.size();
        for (int i = 0; i < len; ++i) {
            info = taxDraftRecordColl.get(i);
            companyIds = companyIds + info.getCompanyOrgUnit().getId().toString();
            taxTypeIds = taxTypeIds + info.getTaxType().getId().toString();
            if (i == len - 1) continue;
            companyIds = companyIds + ",";
            taxTypeIds = taxTypeIds + ",";
        }
        EntityViewInfo evType = new EntityViewInfo();
        FilterInfo filterType = new FilterInfo();
        filterType.getFilterItems().add(new FilterItemInfo("taxItemType.id", (Object)taxTypeIds, CompareType.INCLUDE));
        filterType.getFilterItems().add(new FilterItemInfo("state", (Object)0, CompareType.EQUALS));
        evType.setFilter(filterType);
        TaxNotesCollection taxNoteColl = TaxNotesFactory.getLocalInstance(ctx).getTaxNotesCollection(evType);
        int len2 = taxNoteColl.size();
        for (int i = 0; i < len2; ++i) {
            taxNotes = taxNoteColl.get(i);
            String key = taxNotes.getTaxItemType().getId().toString() + taxNotes.getRecordType().getValue();
            this.cacheTaxNotes.put(key, taxNotes);
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyIds, CompareType.INCLUDE));
        ev.setFilter(filter);
        TaxBaseCollection taxBaseColl = TaxBaseFactory.getLocalInstance(ctx).getTaxBaseCollection(ev);
        if (taxBaseColl != null && taxBaseColl.size() > 0) {
            int len3 = taxBaseColl.size();
            for (int i = 0; i < len3; ++i) {
                TaxBaseInfo taxBaseInfo = taxBaseColl.get(i);
                this.cacheTaxBase.put(taxBaseInfo.getCompany().getId().toString(), taxBaseInfo);
                provinceInfo = taxBaseInfo.getRegistProvince();
                if (provinceInfo == null) continue;
                proviceIds = proviceIds + provinceInfo.getId().toString();
                if (i == len3 - 1) continue;
                proviceIds = proviceIds + ",";
            }
        }
        EntityViewInfo ev1 = new EntityViewInfo();
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("province.id", (Object)proviceIds, CompareType.INCLUDE));
        filter1.getFilterItems().add(new FilterItemInfo("province.id", null, CompareType.EQUALS));
        filter1.getFilterItems().add(new FilterItemInfo("state", (Object)0, CompareType.EQUALS));
        filter1.setMaskString("(#0 or #1) and #2");
        SelectorItemCollection select = new SelectorItemCollection();
        select.add(new SelectorItemInfo("*"));
        select.add(new SelectorItemInfo("taxNotes.*"));
        ev1.setSelector(select);
        ev1.setFilter(filter1);
        TaxTimeTableCollection taxTimeTableColl = TaxTimeTableFactory.getLocalInstance(ctx).getTaxTimeTableCollection(ev1);
        if (taxTimeTableColl != null && taxTimeTableColl.size() > 0) {
            int len4 = taxTimeTableColl.size();
            for (int i = 0; i < len4; ++i) {
                String dim = "";
                taxTimeTableInfo = taxTimeTableColl.get(i);
                if (taxTimeTableInfo.getProvince() != null) {
                    dim = taxTimeTableInfo.getProvince().getId().toString();
                }
                if (info != null && info.getTaxType() != null) {
                    dim = dim + taxTimeTableInfo.getTaxNotes().getTaxItemType().getId().toString();
                }
                dim = dim + taxTimeTableInfo.getTaxNotes().getRecordType().getValue();
                if (taxTimeTableInfo.getRptPeriod() != null) {
                    dim = dim + taxTimeTableInfo.getRptPeriod();
                }
                this.cacheTaxTimeTable.put(dim, taxTimeTableInfo);
            }
        }
    }

    private Date getEndDate(Context ctx, TaxDraftRecordInfo info) throws BOSException {
        TaxTimeTableInfo taxTimeTableInfo;
        String dimKey = "";
        TaxBaseInfo taxBaseInfo = this.cacheTaxBase.get(info.getCompanyOrgUnit().getId().toString());
        if (taxBaseInfo != null && taxBaseInfo.getRegistProvince() != null) {
            dimKey = dimKey + taxBaseInfo.getRegistProvince().getId().toString();
        }
        String otherKey = "";
        if (info.getTaxType() != null) {
            otherKey = otherKey + info.getTaxType().getId().toString();
        }
        otherKey = otherKey + info.getRecordType().getValue();
        if (info.getRptPeriod() != null) {
            otherKey = otherKey + info.getRptPeriod().getNumber();
        }
        taxTimeTableInfo = null == (taxTimeTableInfo = this.cacheTaxTimeTable.get(dimKey + otherKey)) ? this.cacheTaxTimeTable.get(otherKey) : taxTimeTableInfo;
        return null == taxTimeTableInfo ? null : new Date(taxTimeTableInfo.getTaxDate().getTime());
    }

    private String getCreateTempTable(Context ctx, RptParams params) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table TempReportTable(");
        sql.append("FID varchar(44),");
        sql.append("FDraftRecordID varchar(44),");
        sql.append("FCompanyCode varchar(255),");
        sql.append("FCompanyName nvarchar(255),");
        sql.append("FtaxType varchar(44),");
        sql.append("FtaxReturnType int,");
        sql.append("FrptPeriod varchar(100),");
        sql.append("FendDate  DateTime,");
        sql.append("Fstatus int,");
        sql.append("Famount NUMERIC(21,8),");
        sql.append("Ftype int,");
        sql.append("FDraftDate DateTime,");
        sql.append("FDraftUser varchar(44),");
        sql.append("FRecordType int,");
        sql.append("FareaId varchar(44),");
        sql.append("FcompanyId varchar(44),");
        sql.append("FtaxTypeId varchar(44),");
        sql.append("Fyear  int ,");
        sql.append("Fmonth int ,");
        sql.append("FisOverDate int,");
        sql.append("FisAccountComplete int,");
        sql.append("FisTaxDraftComplete int,");
        sql.append("FisTaxDeclareComplete int");
        sql.append(");");
        return sql.toString();
    }
}

