/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.check;

import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckItemInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckResultTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.check.info.CheckAccountDetailResultVo;
import com.kingdee.eas.tm.td.cloud.datamodel.check.info.CheckAccountResultVo;
import com.kingdee.eas.tm.td.cloud.datamodel.check.info.CheckResultVo;
import com.kingdee.eas.tm.td.cloud.datamodel.check.info.CheckVo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ReportCheck {
    public String[] exportCheckResult(Map params) throws Exception {
        ArrayList<String> htmls = new ArrayList<String>();
        Map map = null;
        String html = null;
        map = (Map)params.get("checkResultMap");
        html = this.exportCheckItemResult(map);
        htmls.add(html);
        map = (Map)params.get("checkAccountResultMap");
        html = this.exportCheckAccountResult(map);
        htmls.add(html);
        return htmls.toArray(new String[htmls.size()]);
    }

    public String exportCheckItemResult(Map map) {
        if (map == null) {
            return "";
        }
        CheckResultVo checkResult = null;
        String reportID = null;
        TaxDraftRecordInfo reportInfo = null;
        CheckVo checkVo = null;
        CheckItemInfo checkItemInfo = null;
        StringBuffer promptMsg = new StringBuffer();
        StringBuffer html = new StringBuffer();
        SimpleDateFormat aDate = new SimpleDateFormat("yyyy-MM-dd");
        long now = System.currentTimeMillis();
        if (map.entrySet().size() == 0) {
            return "";
        }
        html.append("<font >").append("\u62a5\u8868\u63d0\u4ea4\u4e8b\u9879\u68c0\u67e5\uff0c\u63d0\u4ea4\u65e5\u671f\uff1a").append(aDate.format(now)).append("</font><br>");
        html.append("===================================================================<br>");
        for (Map.Entry entry : map.entrySet()) {
            reportID = (String)entry.getKey();
            checkResult = (CheckResultVo)map.get(reportID);
            reportInfo = checkResult.getReportInfo();
            html.append("<font>").append(this.getReportTitle(reportInfo)).append("</font><br>");
            int size = checkResult.getErrorCheckList().size();
            for (int i = 0; i < size; ++i) {
                checkVo = (CheckVo)checkResult.getErrorCheckList().get(i);
                if (checkResult.isPass()) continue;
                checkItemInfo = (CheckItemInfo)checkVo.getCheckInfo();
                html.append("\u4e8b\u9879\u68c0\u67e5\u540d\u79f0\uff1a<font >").append(checkItemInfo.getName()).append("</font>  <br>");
                html.append("\u4e8b\u9879\u68c0\u67e5\u7f16\u7801\uff1a<a href=\"1," + checkItemInfo.getId().toString() + "\">").append(checkItemInfo.getNumber()).append("</a>").append("<br>");
                html.append("\u68c0\u67e5\u7ed3\u679c: \u4e0d\u901a\u8fc7\uff0c");
                if (CheckResultTypeEnum.UNCONFIRM.equals((Object)checkItemInfo.getCheckResult())) {
                    html.append("\u7981\u6b62\u63d0\u4ea4\uff08\u6216\u5ba1\u6279\uff09\uff0c\u8bf7\u4fee\u6539\uff01");
                } else if (CheckResultTypeEnum.SHOWERROR.equals((Object)checkItemInfo.getCheckResult())) {
                    html.append("\u4ec5\u63d0\u793a\u9519\u8bef\u7ed3\u679c  ");
                }
                html.append("<br>");
                html.append("<xmp>\u5de6\u8868\u8fbe\u5f0f\uff1a").append(checkItemInfo.getLFormula()).append("=").append(checkVo.getlValue()).append("</xmp><br>");
                html.append("<xmp>\u53f3\u8868\u8fbe\u5f0f\uff1a").append(checkItemInfo.getRFormula()).append("=").append(checkVo.getrValue()).append("</xmp><br>");
                html.append("\u6ee1\u8db3\u68c0\u67e5\u5173\u7cfb\u8981\u6c42\uff1a\u5de6\u8868\u8fbe\u5f0f").append(ReportCheck.toXmlString(checkItemInfo.getOperateSymbol().getAlias())).append("\u53f3\u8868\u8fbe\u5f0f    ");
                html.append("\u5141\u8bb8\u8bef\u5dee\u8303\u56f4\uff1a").append(checkItemInfo.getRange()).append("<br>");
                html.append("\u63d0\u793a\u5185\u5bb9\uff1a<font ><xmp>").append(this.getText(checkItemInfo.getPrompt())).append("</xmp></font><br>");
                html.append("\u4e1a\u52a1\u63cf\u8ff0\uff1a<font color=\"#a0a0a0\"><xmp>").append(this.getText(checkItemInfo.getDescription())).append("</xmp></font><br>");
                html.append("<br>");
            }
        }
        return html.toString();
    }

    public String exportCheckAccountResult(Map map) {
        if (map == null) {
            return "";
        }
        List resultList = (List)map.get("resultList");
        if (resultList == null || resultList.size() == 0) {
            return "";
        }
        CheckAccountResultVo resultVo2 = null;
        CheckAccountDetailResultVo detailResultVo = null;
        TaxDraftRecordInfo reportInfo = null;
        StringBuffer html = new StringBuffer();
        SimpleDateFormat aDate = new SimpleDateFormat("yyyy-MM-dd");
        long now = System.currentTimeMillis();
        html.append("<font>").append("\u62a5\u8868\u63d0\u4ea4\u53f0\u8d26\u68c0\u67e5\uff0c\u63d0\u4ea4\u65e5\u671f\uff1a").append(aDate.format(now)).append("</font><br>");
        html.append("===================================================================<br>");
        for (CheckAccountResultVo resultVo2 : resultList) {
            if (resultVo2.getErrorList().size() == 0) continue;
            reportInfo = resultVo2.getReportInfo();
            html.append("<font>").append(this.getReportTitle(reportInfo)).append("</font><br>");
            html.append("\u53f0\u8d26\u68c0\u67e5\u540d\u79f0\uff1a<font >").append(resultVo2.getCheckInfo().getName()).append("</font>  <br>");
            html.append("\u53f0\u8d26\u68c0\u67e5\u7f16\u7801\uff1a<a href=\"1," + resultVo2.getCheckInfo().getId().toString() + "\">").append(resultVo2.getCheckInfo().getNumber()).append("</a>").append("<br>");
            html.append("\u4e1a\u52a1\u63cf\u8ff0\uff1a<font color=\"#a0a0a0\"><xmp>").append(this.getText(resultVo2.getCheckInfo().getDescription())).append("<xmp></font><br><br>");
            int size = resultVo2.getErrorList().size();
            for (int i = 0; i < size; ++i) {
                detailResultVo = resultVo2.getErrorList().get(i);
                if (detailResultVo.getEntryInfo() != null) {
                    html.append("<xmp>\u68c0\u67e5\u5185\u5bb9\uff1a").append(detailResultVo.getEntryInfo().getCheckFormulaAlias()).append("</xmp>");
                    html.append("<br>");
                    html.append("<xmp>\u68c0\u67e5\u9875\u7b7e\uff1a").append(detailResultVo.getSheetName()).append("</xmp><br>");
                    if (detailResultVo.isPass()) {
                        html.append("\u68c0\u67e5\u7ed3\u679c\uff1a\u68c0\u67e5\u901a\u8fc7").append("<br>");
                    } else {
                        html.append("\u68c0\u67e5\u7ed3\u679c\uff1a\u4e0d\u901a\u8fc7\uff0c");
                        if (CheckResultTypeEnum.UNCONFIRM.equals((Object)detailResultVo.getEntryInfo().getCheckResult())) {
                            html.append("\u7981\u6b62\u63d0\u4ea4\uff08\u6216\u5ba1\u6279\uff09\uff0c\u8bf7\u4fee\u6539\uff01");
                        } else if (CheckResultTypeEnum.SHOWERROR.equals((Object)detailResultVo.getEntryInfo().getCheckResult())) {
                            html.append("\u4ec5\u63d0\u793a\u9519\u8bef\u7ed3\u679c  ");
                        }
                        html.append("<br>");
                    }
                    html.append("\u98ce\u9669\u7b49\u7ea7\uff1a").append("\u3010").append(detailResultVo.getEntryInfo().getRiskLevel().getAlias()).append("\u3011").append("<br>");
                    html.append("<xmp>").append(this.getText(detailResultVo.getCheckDetial())).append("</xmp>").append("<br>");
                    html.append("\u63d0\u793a\u5185\u5bb9\uff1a<font color=\"#a0a0a0\"><xmp>").append(this.getText(detailResultVo.getEntryInfo().getPrompt())).append("<xmp></font><br>");
                    html.append("<br>");
                    continue;
                }
                html.append("\u68c0\u67e5\u9875\u7b7e\uff1a").append(detailResultVo.getSheetName()).append("<br>");
                if (detailResultVo.isPass()) {
                    html.append("\u68c0\u67e5\u7ed3\u679c\uff1a\u68c0\u67e5\u901a\u8fc7").append("<br>");
                    continue;
                }
                html.append("\u68c0\u67e5\u7ed3\u679c\uff1a\u4e0d\u901a\u8fc7\uff0c");
                html.append(detailResultVo.getErrorMsg());
                html.append("<br>");
            }
        }
        return html.toString();
    }

    private String getText(Object value) {
        return value == null ? "" : value.toString();
    }

    public String getReportTitle(TaxDraftRecordInfo reportInfo) {
        String reportTitle = "\u62a5\u8868\u540d\u79f0\uff1a" + reportInfo.getName() + "<br>\u62a5\u8868\u7f16\u7801\uff1a<a href=\"" + 0 + "," + reportInfo.getId().toString() + "\">" + reportInfo.getNumber() + "</a><br>\u8d22\u52a1\u7ec4\u7ec7\uff1a" + reportInfo.getCompanyOrgUnit().getName() + "<br>\u7eb3\u7a0e\u671f\u95f4\uff1a" + reportInfo.getRptPeriod().getNumber() + "<br>";
        return reportTitle;
    }

    static String toXmlString(String str) {
        String ret = str.replaceAll("&", "&amp;");
        ret = ret.replaceAll("\"", "&quot;");
        ret = ret.replaceAll("<", "&lt;");
        ret = ret.replaceAll(">", "&gt;");
        return ret;
    }
}

