/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.check.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckBaseInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.OperateSymbolEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.check.info.CheckVo;
import com.kingdee.eas.tm.td.cloud.datamodel.check.processor.ICheckProcessor;
import com.kingdee.eas.tm.td.cloud.utils.TDCloudUtil;
import java.math.BigDecimal;

public abstract class AbstractCheckProcessor
implements ICheckProcessor {
    protected static final int ID = 0;
    protected static final int LFORMULA = 1;
    protected static final int RFORMULA = 2;
    protected static final int DIFFSTANDVALUE = 2;
    protected static final int OPERATER = 3;
    protected static final int RANGE = 4;
    protected static final int REPORT = 5;
    protected static final int CHECK = 6;
    protected static final String SEPARATOR = "-";

    public void fillFormulaIntoCalculateBook(Context ctx, Sheet calculateSheet, int row, CheckVo checkVo) throws EASBizException, BOSException {
        CheckBaseInfo checkInfo = checkVo.getCheckInfo();
        calculateSheet.getRange(row, 0).setValue(new Variant((Object)checkInfo.getId().toString()));
        String lformula = checkInfo.getLFormula();
        calculateSheet.getRange(row, 1).setFormula("=" + lformula);
        String rformula = checkInfo.getRFormula();
        calculateSheet.getRange(row, 2).setFormula("=" + rformula);
        calculateSheet.getRange(row, 3).setValue(new Variant((Object)checkInfo.getOperateSymbol()));
        calculateSheet.getRange(row, 6).setValue(new Variant((Object)checkVo));
    }

    protected Object getCalculateValue(CheckVo checkVo, Variant objValue, String formula, boolean isLeft) throws EASBizException, BOSException {
        String formulaText;
        String string = formulaText = isLeft ? "\u5de6\u8868\u8fbe\u5f0f" : "\u53f3\u8868\u8fbe\u5f0f";
        if (objValue == null || objValue.isNull()) {
            objValue = new Variant((Object)new BigDecimal("0"));
        }
        if (objValue.isString()) {
            boolean isNumeric = false;
            try {
                new BigDecimal(objValue.toString());
                isNumeric = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (!isNumeric) {
                checkVo.setAvailable(false);
                if (checkVo.getDescription() != null) {
                    checkVo.setDescription(checkVo.getDescription() + ";" + formulaText + ",\u503c\u975e\u6570\u5b57");
                } else {
                    checkVo.setDescription(formulaText + ",\u503c\u975e\u6570\u5b57");
                }
                return null;
            }
        }
        Object value = null;
        if (objValue.getValue() instanceof Throwable) {
            value = objValue.getValue();
            checkVo.setAvailable(false);
            if (checkVo.getDescription() != null) {
                checkVo.setDescription(checkVo.getDescription() + ";" + formulaText + ",\u9519\u8bef\u7684\u8868\u8fbe\u5f0f");
            } else {
                checkVo.setDescription(formulaText + ",\u9519\u8bef\u7684\u8868\u8fbe\u5f0f");
            }
            return null;
        }
        value = TDCloudUtil.toBigDecimal(objValue);
        return value;
    }

    protected boolean isIndexComparePass(Object left, Object right, OperateSymbolEnum operator, BigDecimal bdRange) {
        if (left instanceof Throwable || right instanceof Throwable) {
            return false;
        }
        BigDecimal bdLeftValue = (BigDecimal)left;
        BigDecimal bdRightValue = (BigDecimal)right;
        if (bdRange == null) {
            bdRange = BigDecimal.ZERO;
        }
        if (operator.equals((Object)OperateSymbolEnum.EQUAL)) {
            return bdLeftValue.subtract(bdRightValue).abs().compareTo(bdRange.abs()) <= 0;
        }
        if (operator.equals((Object)OperateSymbolEnum.LESS)) {
            return bdLeftValue.subtract(bdRightValue).abs().compareTo(bdRange.abs()) < 0;
        }
        if (operator.equals((Object)OperateSymbolEnum.LESSANDEQUAL)) {
            return bdLeftValue.subtract(bdRightValue).abs().compareTo(bdRange.abs()) <= 0;
        }
        if (operator.equals((Object)OperateSymbolEnum.MORE)) {
            return bdLeftValue.subtract(bdRightValue).abs().compareTo(bdRange.abs()) > 0;
        }
        if (operator.equals((Object)OperateSymbolEnum.MOREANDEQUAL)) {
            return bdLeftValue.subtract(bdRightValue).abs().compareTo(bdRange.abs()) >= 0;
        }
        if (operator.equals((Object)OperateSymbolEnum.UNEQUAL)) {
            return !bdLeftValue.equals(bdRightValue);
        }
        return false;
    }

    protected boolean isComparePass(Object left, Object right, OperateSymbolEnum operator, BigDecimal bdRange) {
        if (left instanceof Throwable || right instanceof Throwable) {
            return true;
        }
        BigDecimal bdLeftValue = (BigDecimal)left;
        BigDecimal bdRightValue = (BigDecimal)right;
        if (operator.equals((Object)OperateSymbolEnum.EQUAL)) {
            if (bdRange == null || bdRange.compareTo(new BigDecimal("0")) == 0) {
                return bdLeftValue.equals(bdRightValue);
            }
            return bdLeftValue.equals(bdRightValue) || bdLeftValue.subtract(bdRightValue).abs().compareTo(bdRange.abs()) <= 0;
        }
        if (operator.equals((Object)OperateSymbolEnum.LESS)) {
            if (bdRange == null || bdRange.compareTo(new BigDecimal("0")) == 0) {
                return bdLeftValue.compareTo(bdRightValue) < 0;
            }
            return bdLeftValue.compareTo(bdRightValue) < 0 || bdLeftValue.compareTo(bdRange.add(bdRightValue)) <= 0;
        }
        if (operator.equals((Object)OperateSymbolEnum.LESSANDEQUAL)) {
            if (bdRange == null || bdRange.compareTo(new BigDecimal("0")) == 0) {
                return this.isComparePass(bdLeftValue, bdRightValue, OperateSymbolEnum.EQUAL, null) || this.isComparePass(bdLeftValue, bdRightValue, OperateSymbolEnum.LESS, null);
            }
            return this.isComparePass(bdLeftValue, bdRightValue, OperateSymbolEnum.EQUAL, bdRange) || this.isComparePass(bdLeftValue, bdRightValue, OperateSymbolEnum.LESS, bdRange);
        }
        if (operator.equals((Object)OperateSymbolEnum.MORE)) {
            if (bdRange == null || bdRange.compareTo(new BigDecimal("0")) == 0) {
                return bdLeftValue.compareTo(bdRightValue) > 0;
            }
            return bdLeftValue.compareTo(bdRightValue) > 0 || bdLeftValue.compareTo(bdRightValue.subtract(bdRange)) >= 0;
        }
        if (operator.equals((Object)OperateSymbolEnum.MOREANDEQUAL)) {
            if (bdRange == null || bdRange.compareTo(new BigDecimal("0")) == 0) {
                return this.isComparePass(bdLeftValue, bdRightValue, OperateSymbolEnum.EQUAL, null) || this.isComparePass(bdLeftValue, bdRightValue, OperateSymbolEnum.MORE, null);
            }
            return this.isComparePass(bdLeftValue, bdRightValue, OperateSymbolEnum.EQUAL, bdRange) || this.isComparePass(bdLeftValue, bdRightValue, OperateSymbolEnum.MORE, bdRange);
        }
        if (operator.equals((Object)OperateSymbolEnum.UNEQUAL)) {
            return !this.isComparePass(bdLeftValue, bdRightValue, OperateSymbolEnum.EQUAL, bdRange);
        }
        return false;
    }

    protected String getCheckResultInsertSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append(" INSERT INTO T_TD_CheckResult(");
        sb.append(" FID,FCompanyID,FTaxTypeID,FPeriodID,FCheckType,FItemID,FIndexID,FState,");
        sb.append(" FRiskLevel,FLValue,FRValue,FRange,FReportID,FPrompt,FYear,FMonth,FCreateTime,FDescription,FContent,FRangeType,FLValueDesc,FRValueDesc)");
        sb.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        return sb.toString();
    }
}

