/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.check.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.FormulaRuntimeFactory;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.ReportCalculateContext;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftRecordCollection;
import com.kingdee.eas.tm.td.TaxDraftRecordFactory;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckItemCollection;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckItemInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckResultTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.DiffTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.OperateSymbolEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.RiskLevelEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.check.info.CheckResultVo;
import com.kingdee.eas.tm.td.cloud.datamodel.check.info.CheckVo;
import com.kingdee.eas.tm.td.cloud.datamodel.check.processor.AbstractCheckProcessor;
import com.kingdee.eas.tm.td.cloud.utils.TDCloudUtil;
import com.kingdee.eas.tm.td.utils.TDSelectorFactory;
import com.kingdee.eas.tm.td.utils.TaxDraftRptPropertyAdapter;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class CheckItemProcessor
extends AbstractCheckProcessor {
    @Override
    public Map check(Context ctx, Map params, CheckTypeEnum checkType) throws EASBizException, BOSException {
        Map ret = this.buildCheck(ctx, params);
        Map values = (Map)params.get("values");
        Map report = (Map)ret.get("report");
        Map reportCheck = (Map)ret.get("reportCheck");
        HashMap<String, CheckResultVo> checkResultMap = new HashMap<String, CheckResultVo>();
        FormulaRuntimeFactory.FormulaRuntimeEnv formulaRuntimeEnv = null;
        TaxDraftRecordInfo reportInfo = null;
        List checkList = null;
        CheckResultVo checkResult = null;
        CheckVo check = null;
        for (Map.Entry entry : reportCheck.entrySet()) {
            String reportID = (String)entry.getKey();
            reportInfo = values != null && values.containsKey(reportID) ? (TaxDraftRecordInfo)values.get(reportID) : (TaxDraftRecordInfo)report.get(reportID);
            boolean isSubmit2Cacl = TDUtils.getBooleanParam(ctx, reportInfo.getCompanyOrgUnit().getId().toString(), "VATD004");
            if (isSubmit2Cacl) {
                try {
                    TDUtils.calculateReport(ctx, reportInfo);
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
            checkList = (List)entry.getValue();
            checkResult = new CheckResultVo(reportInfo);
            checkResultMap.put(reportID, checkResult);
            formulaRuntimeEnv = this.getCalculateFormulaRuntimeEnv(ctx, reportInfo);
            Sheet calculateSheet = formulaRuntimeEnv.getCalculateSheet();
            int row = calculateSheet.getMaxRowIndex() + 1;
            boolean hasCheck = false;
            int size = checkList.size();
            for (int i = 0; i < size; ++i) {
                check = (CheckVo)checkList.get(i);
                checkResult.setCheck(check);
                this.verifyCheck(ctx, check);
                if (!check.isAvailable()) continue;
                hasCheck = true;
                checkResult.getCheckList().add(check);
                this.fillFormulaIntoCalculateBook(ctx, calculateSheet, row, check);
                ++row;
            }
            if (hasCheck) {
                formulaRuntimeEnv.getCalculateBook().calc();
                Sheet sheet = formulaRuntimeEnv.getCalculateSheet();
                for (int rowIndex = 0; rowIndex <= sheet.getMaxRowIndex(); ++rowIndex) {
                    this.compareCalculateValue(checkResultMap, sheet, rowIndex);
                }
                this.writeCheckResultRecord(ctx, checkResultMap);
                continue;
            }
            checkResultMap.remove(reportID);
        }
        return checkResultMap;
    }

    public Map buildCheck(Context ctx, Map params) throws EASBizException, BOSException {
        Set idSet = (Set)params.get("checkIds");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(TDSelectorFactory.getAllReportSelectors());
        TaxDraftRecordCollection reportColl = TaxDraftRecordFactory.getLocalInstance(ctx).getTaxDraftRecordCollection(view);
        HashMap<String, TaxDraftRecordInfo> report = new HashMap<String, TaxDraftRecordInfo>();
        List checkList = new ArrayList();
        TaxDraftRecordInfo reportInfo = null;
        HashMap reportCheck = new HashMap();
        HashMap checkItemCache = new HashMap();
        int size = reportColl.size();
        for (int i = 0; i < size; ++i) {
            reportInfo = reportColl.get(i);
            checkList = this.getCheckList(ctx, reportInfo, checkItemCache);
            if (checkList != null && checkList.size() > 0) {
                reportCheck.put(reportInfo.getId().toString(), checkList);
            }
            report.put(reportInfo.getId().toString(), reportInfo);
        }
        HashMap<String, HashMap<String, Object>> ret = new HashMap<String, HashMap<String, Object>>();
        ret.put("report", report);
        ret.put("reportCheck", reportCheck);
        return ret;
    }

    private boolean verifyCheck(Context ctx, CheckVo check) throws BOSException {
        if (!StringUtils.isEmpty((String)check.getCheckInfo().getIfClause())) {
            String ifClause = check.getCheckInfo().getIfClause();
            String filterItems = ifClause + " and id ='" + check.getReportInfo().getId().toString() + "'";
            String reportQueryPK = "com.kingdee.eas.tm.td.app.TaxDraftReportQuery";
            String sql = TDCloudUtil.structureFilter(ctx, filterItems, reportQueryPK);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                if (rs.next()) {
                    return true;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            check.setAvailable(false);
            return false;
        }
        int state = this.isExists(ctx, check);
        if (3 == state) {
            check.setAvailable(false);
            return false;
        }
        return true;
    }

    private FormulaRuntimeFactory.FormulaRuntimeEnv getCalculateFormulaRuntimeEnv(Context ctx, TaxDraftRecordInfo reportInfo) throws EASBizException, BOSException {
        FormulaRuntimeFactory.FormulaRuntimeEnv formulaRuntimeEnv = null;
        try {
            ICalculateContextProvider calculateContextProvider = this.getCalculateContextProvider(ctx, reportInfo);
            formulaRuntimeEnv = FormulaRuntimeFactory.getInstance().getFormulaRuntime(calculateContextProvider);
        }
        catch (Exception ex) {
            throw new TDException(TDException.ERROR_MSG, new Object[]{"\u7533\u62a5\u8868\u672a\u7f16\u5236"});
        }
        return formulaRuntimeEnv;
    }

    private ICalculateContextProvider getCalculateContextProvider(Context ctx, TaxDraftRecordInfo reportInfo) throws BOSException {
        ReportCalculateContext calcContext = new ReportCalculateContext(ctx);
        TaxDraftRptPropertyAdapter adapter = new TaxDraftRptPropertyAdapter();
        adapter.initReportProperties((IObjectValue)reportInfo, ctx);
        calcContext.setReportAdapter((IReportPropertyAdapter)adapter);
        try {
            ReportVariables reportVariables = ReportVariables.loadFromBook((Book)reportInfo.getBook());
            calcContext.setReportVariables(reportVariables);
        }
        catch (Exception ex) {
            throw new BOSException("UnpackBook Exception", (Throwable)ex);
        }
        return calcContext;
    }

    private List getCheckList(Context ctx, TaxDraftRecordInfo reportInfo, Map checkItemCache) throws EASBizException, BOSException {
        CheckItemInfo checkInfo;
        String key = reportInfo.getCompanyOrgUnit().getId().toString() + "-" + this.getCheckType().getValue() + "-" + reportInfo.getTaxType().getId().toString();
        CheckItemCollection itemColl = (CheckItemCollection)((Object)checkItemCache.get(key));
        if (itemColl == null) {
            StringBuffer sql = new StringBuffer();
            sql.append(" select item.FID, item.FNumber, item.FName_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale())).append(" as FName,item.FIfClause, item.FLFormula,");
            sql.append(" item.FOperateSymbol, item.FRFormula, item.FRange, item.FCheckResult, item.FPrompt,item.FRiskLevel,item.FRangeType,item.FDescription ");
            sql.append(" from T_TD_CheckView checkview");
            sql.append(" left join T_TD_CheckItem item on checkview.FItemID = item.FID");
            sql.append(" where checkview.FCompanyId = '").append(reportInfo.getCompanyOrgUnit().getId().toString()).append("'");
            sql.append(" and checkview.fcheckType = '").append(this.getCheckType().getValue()).append("'");
            sql.append(" and item.FTaxTypeID = '").append(reportInfo.getTaxType().getId().toString()).append("'");
            sql.append(" and item.FState = 0");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            itemColl = new CheckItemCollection();
            checkInfo = null;
            try {
                while (rs.next()) {
                    checkInfo = new CheckItemInfo();
                    checkInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                    checkInfo.setNumber(rs.getString("FNumber"));
                    checkInfo.setName(rs.getString("FName"));
                    checkInfo.setIfClause(rs.getString("FIfClause"));
                    checkInfo.setLFormula(rs.getString("FLFormula"));
                    checkInfo.setOperateSymbol(OperateSymbolEnum.getEnum(rs.getInt("FOperateSymbol")));
                    checkInfo.setRFormula(rs.getString("FRFormula"));
                    checkInfo.setRange(rs.getBigDecimal("FRange"));
                    checkInfo.setCheckResult(CheckResultTypeEnum.getEnum(rs.getInt("FCheckResult")));
                    checkInfo.setPrompt(rs.getString("FPrompt"));
                    checkInfo.setRiskLevel(RiskLevelEnum.getEnum(rs.getString("FRiskLevel")));
                    checkInfo.setRangeType(DiffTypeEnum.getEnum(rs.getInt("FRangeType")));
                    checkInfo.setDescription(rs.getString("FDescription"));
                    itemColl.add(checkInfo);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            checkItemCache.put(key, itemColl);
        }
        ArrayList<CheckVo> checkList = new ArrayList<CheckVo>();
        CheckVo check = null;
        checkInfo = null;
        int size = itemColl.size();
        for (int i = 0; i < size; ++i) {
            checkInfo = itemColl.get(i);
            check = new CheckVo();
            check.setCheckInfo(checkInfo);
            check.setReportInfo(reportInfo);
            check.setCheckType(this.getCheckType());
            checkList.add(check);
        }
        return checkList;
    }

    @Override
    public CheckTypeEnum getCheckType() {
        return CheckTypeEnum.TAXDECLARE;
    }

    @Override
    public void fillFormulaIntoCalculateBook(Context ctx, Sheet calculateSheet, int row, CheckVo checkVo) throws EASBizException, BOSException {
        super.fillFormulaIntoCalculateBook(ctx, calculateSheet, row, checkVo);
        CheckItemInfo checkInfo = (CheckItemInfo)checkVo.getCheckInfo();
        calculateSheet.getRange(row, 4).setValue(new Variant((Object)checkInfo.getRange()));
        calculateSheet.getRange(row, 5).setValue(new Variant((Object)checkVo.getReportInfo()));
    }

    public void compareCalculateValue(Map checkResultMap, Sheet calculateSheet, int row) throws EASBizException, BOSException {
        CheckVo check = (CheckVo)calculateSheet.getRange(row, 6).getValue().getValue();
        TaxDraftRecordInfo reportInfo = check.getReportInfo();
        CheckItemInfo checkInfo = (CheckItemInfo)check.getCheckInfo();
        Variant objLValue = calculateSheet.getRange(row, 1).getValue();
        Object lValue = this.getCalculateValue(check, objLValue, checkInfo.getLFormula(), true);
        check.setlValue(lValue);
        Variant objRValue = calculateSheet.getRange(row, 2).getValue();
        Object rValue = this.getCalculateValue(check, objRValue, checkInfo.getRFormula(), false);
        check.setrValue(rValue);
        BigDecimal range = checkInfo.getRange();
        if (range != null && DiffTypeEnum.STANDARDPERENT.equals((Object)checkInfo.getRangeType())) {
            range = range.divide(new BigDecimal(100), 5, 4);
        }
        OperateSymbolEnum operateSymbol = checkInfo.getOperateSymbol();
        CheckResultVo checkResult = (CheckResultVo)checkResultMap.get(reportInfo.getId().toString());
        if (!check.isAvailable()) {
            check.setCheckResultCode(2);
            checkResult.getErrorCheckList().add(check);
            checkResult.setFailCheckResultCode();
            return;
        }
        BigDecimal bdLeftValue = (BigDecimal)lValue;
        BigDecimal bdRightValue = (BigDecimal)rValue;
        check.setRange(bdRightValue.subtract(bdLeftValue).abs());
        if (this.isComparePass(lValue, rValue, operateSymbol, range)) {
            check.setCheckResultCode(2);
            checkResult.getErrorCheckList().add(check);
            checkResult.setFailCheckResultCode();
        } else {
            check.setCheckResultCode(1);
            checkResult.setPassCheckResultCode();
        }
    }

    public void writeCheckResultRecord(Context ctx, Map checkResultMap) throws EASBizException, BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(this.getCheckResultInsertSQL());
            CheckResultVo checkResult = null;
            CheckVo check = null;
            int state = -1;
            ArrayList<Object[]> updateParamsList = new ArrayList<Object[]>();
            for (Map.Entry entry : checkResultMap.entrySet()) {
                String reportID = (String)entry.getKey();
                checkResult = (CheckResultVo)entry.getValue();
                String riskLevel = null;
                int size = checkResult.getCheckList().size();
                for (int i = 0; i < size; ++i) {
                    check = (CheckVo)checkResult.getCheckList().get(i);
                    if (((CheckItemInfo)check.getCheckInfo()).getRiskLevel() != null) {
                        riskLevel = ((CheckItemInfo)check.getCheckInfo()).getRiskLevel().getValue();
                    }
                    if (3 == (state = this.isExists(ctx, check))) continue;
                    if (state > 0) {
                        Object[] updateParams = new Object[]{check.getlValue(), check.getrValue(), check.getRange(), riskLevel, check.getCheckResultState().getValue(), check.getCheckInfo().getDescription(), timestamp, ((CheckItemInfo)check.getCheckInfo()).getPrompt(), check.getReportInfo().getCompanyOrgUnit().getId().toString(), check.getReportInfo().getTaxType().getId().toString(), this.getCheckType().getValue(), check.getCheckInfo().getId().toString(), check.getReportInfo().getId().toString(), check.getReportInfo().getYear(), check.getReportInfo().getPeriod()};
                        updateParamsList.add(updateParams);
                        continue;
                    }
                    pstmt.setString(1, BOSUuid.create((String)"086D8622").toString());
                    pstmt.setString(2, check.getReportInfo().getCompanyOrgUnit().getId().toString());
                    pstmt.setString(3, check.getReportInfo().getTaxType().getId().toString());
                    pstmt.setString(4, check.getReportInfo().getRptPeriod().getId().toString());
                    pstmt.setString(5, this.getCheckType().getValue());
                    pstmt.setString(6, check.getCheckInfo().getId().toString());
                    pstmt.setObject(7, null);
                    pstmt.setInt(8, check.getCheckResultState().getValue());
                    pstmt.setString(9, riskLevel);
                    pstmt.setBigDecimal(10, (BigDecimal)check.getlValue());
                    pstmt.setBigDecimal(11, (BigDecimal)check.getrValue());
                    pstmt.setBigDecimal(12, check.getRange());
                    pstmt.setString(13, check.getReportInfo().getId().toString());
                    pstmt.setString(14, null);
                    pstmt.setInt(15, check.getReportInfo().getYear());
                    pstmt.setInt(16, check.getReportInfo().getPeriod());
                    pstmt.setTimestamp(17, timestamp);
                    pstmt.setString(18, check.getDescription());
                    pstmt.setString(19, ((CheckItemInfo)check.getCheckInfo()).getPrompt());
                    pstmt.setInt(20, check.getCheckInfo().getRangeType().getValue());
                    pstmt.setString(21, null);
                    pstmt.setString(22, null);
                    pstmt.addBatch();
                }
            }
            pstmt.executeBatch();
            if (updateParamsList.size() > 0) {
                StringBuffer sql = new StringBuffer();
                sql.append(" update T_TD_CheckResult set FLValue=?,FRValue=?,FRange=?,FRiskLevel=?,FState=?,FDescription=?,FCreateTime=?,FContent=?");
                sql.append(" WHERE FCompanyID=? and FTaxTypeID=? and FCheckType=? and FItemID=? and FReportID=? and FYear =? and FMonth=?");
                DbUtil.executeBatch((Context)ctx, (String)sql.toString(), updateParamsList);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private int isExists(Context ctx, CheckVo check) throws BOSException {
        int state = -1;
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT FState from T_TD_CheckResult ");
        sb.append(" WHERE FCompanyID=? and FTaxTypeID=? and FCheckType=? and FItemID=? and FReportID=? and FYear =? and FMonth=?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{check.getReportInfo().getCompanyOrgUnit().getId().toString(), check.getReportInfo().getTaxType().getId().toString(), this.getCheckType().getValue(), check.getCheckInfo().getId().toString(), check.getReportInfo().getId().toString(), check.getReportInfo().getYear(), check.getReportInfo().getPeriod()});
        try {
            if (rs.next()) {
                state = rs.getInt("FState");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return state;
    }
}

