/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.common.olap.EASEjbFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.tm.td.account.engine.interfaces.ISQLBuilder;
import com.kingdee.eas.tm.td.account.engine.thread.QueryDataSyncLock;
import com.kingdee.eas.tm.td.account.engine.thread.QueryDataTask;
import com.kingdee.eas.tm.td.account.engine.thread.ThreadPool;
import com.kingdee.eas.tm.td.basedata.TakeDataContditionCollection;
import com.kingdee.eas.tm.td.basedata.TakeDataContditionFactory;
import com.kingdee.eas.tm.td.basedata.TakeDataContditionInfo;
import com.kingdee.eas.tm.td.cloud.GroupCollection;
import com.kingdee.eas.tm.td.cloud.GroupFactory;
import com.kingdee.eas.tm.td.cloud.GroupInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchEntryCollection;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchEntryInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.DataSourceToDataFetchCollection;
import com.kingdee.eas.tm.td.cloud.datamodel.DataSourceToDataFetchFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.rpt.app.AbstractDataFetchAnalysisFacadeControllerBean;
import com.kingdee.eas.tm.td.cloud.datamodel.rpt.app.DataFetchSQLBuilder;
import com.kingdee.eas.tm.td.cloud.datamodel.utils.DataModelUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class DataFetchAnalysisFacadeControllerBean
extends AbstractDataFetchAnalysisFacadeControllerBean {
    private static final long serialVersionUID = -2005271783049292541L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.cloud.datamodel.rpt.app.DataFetchAnalysisFacadeControllerBean");

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        ctx = EASEjbFactory.getCtx((String)this.getClass().getName(), (Context)ctx);
        this.dropTempTable(params.getString("tempTable"), ctx);
        this.initParams(ctx, params);
        String tempTable = this.createTempTable(ctx, this.getCreateTempTable(ctx, params));
        params.setString("tempTable", tempTable);
        this.insertBillData(ctx, params);
        this.doService(ctx, params);
        RptTableHeader header = this.buildHead(ctx, params);
        RptParams result = new RptParams();
        result.setString("tempTable", tempTable);
        result.setObject("header", (Object)header);
        result.setObject("dataFetch", params.getObject("dataFetch"));
        return result;
    }

    protected void doService(Context ctx, RptParams params) throws BOSException, EASBizException {
    }

    protected void initParams(Context ctx, RptParams params) throws BOSException, EASBizException {
        DataFetchInfo dataFecthInfo = (DataFetchInfo)params.getObject("dataFetch");
        ObjectUuidPK pk = new ObjectUuidPK(dataFecthInfo.getId().toString());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entry.*"));
        dataFecthInfo = DataFetchFactory.getLocalInstance(ctx).getDataFetchInfo((IObjectPK)pk, sic);
        params.setObject("dataFetch", (Object)dataFecthInfo);
        GroupInfo groupInfo = (GroupInfo)params.getObject("group");
        groupInfo = GroupFactory.getLocalInstance(ctx).getGroupInfo((IObjectPK)new ObjectUuidPK(groupInfo.getId().toString()));
        GroupCollection groupColl = GroupFactory.getLocalInstance(ctx).getGroupCollection(" where longNumber like '" + groupInfo.getLongNumber() + "%'");
        HashSet<String> groupIncludeChildrenIds = new HashSet<String>();
        GroupInfo info = null;
        int size = groupColl.size();
        for (int i = 0; i < size; ++i) {
            info = groupColl.get(i);
            groupIncludeChildrenIds.add(info.getId().toString());
        }
        params.setObject("groupIncludeChildrenIds", groupIncludeChildrenIds);
        List<String> dim = DataModelUtil.getDataFetchDimFields(dataFecthInfo);
        params.setObject("dim", dim);
    }

    protected void insertBillData(Context ctx, RptParams params) throws BOSException, EASBizException {
        ISQLBuilder sqlBuilder = null;
        List<ISQLBuilder> sqlBuilderList = this.getSQLBuilder(ctx, params);
        Connection conn = null;
        QueryDataSyncLock lock = new QueryDataSyncLock();
        ThreadPool threadPool = ThreadPool.getInstance();
        int size = sqlBuilderList.size();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String insertSQL = this.getInsertSQL(params);
            StringBuffer sSQL = new StringBuffer();
            for (int i = 0; i < size; ++i) {
                sqlBuilder = sqlBuilderList.get(i);
                String selectSQL = sqlBuilder.getSQL();
                if (StringUtils.isEmpty((String)selectSQL)) continue;
                sSQL.setLength(0);
                sSQL.append(insertSQL).append("\r\n").append(selectSQL);
                QueryDataTask thread = new QueryDataTask(lock, sqlBuilder.getExecuteLockName(), conn, sSQL.toString());
                lock.addLock(sqlBuilder.getExecuteLockName());
                threadPool.addTask(thread);
            }
            lock.waitFinish();
        }
        catch (BOSException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    protected List<ISQLBuilder> getSQLBuilder(Context ctx, RptParams params) throws EASBizException, BOSException {
        TakeDataContditionCollection conditionList = this.getCondition(ctx, params);
        DataFetchInfo dataFetchInfo = (DataFetchInfo)params.getObject("dataFetch");
        ISQLBuilder sqlBuilder = null;
        ArrayList<ISQLBuilder> sqlBuilderList = new ArrayList<ISQLBuilder>();
        if (conditionList == null || conditionList.size() == 0) {
            return sqlBuilderList;
        }
        int size = conditionList.size();
        TakeDataContditionInfo conditionInfo = null;
        for (int i = 0; i < size; ++i) {
            conditionInfo = conditionList.get(i);
            sqlBuilder = this.getSQLBuilder(ctx, dataFetchInfo, conditionInfo, params);
            sqlBuilderList.add(sqlBuilder);
        }
        return sqlBuilderList;
    }

    protected ISQLBuilder getSQLBuilder(Context ctx, DataFetchInfo dataFetchInfo, TakeDataContditionInfo conditionInfo, RptParams params) {
        DataFetchSQLBuilder sqlBuilder = new DataFetchSQLBuilder(ctx, dataFetchInfo, conditionInfo, params);
        return sqlBuilder;
    }

    protected TakeDataContditionCollection getCondition(Context ctx, RptParams params) throws EASBizException, BOSException {
        DataFetchInfo dataFetchInfo = (DataFetchInfo)params.getObject("dataFetch");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("dataFetch.id", (Object)dataFetchInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("dataSource.state", (Object)"2", CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("dataSource.id"));
        view.setSelector(sic);
        DataSourceToDataFetchCollection dsColl = DataSourceToDataFetchFactory.getLocalInstance(ctx).getDataSourceToDataFetchCollection(view);
        HashSet<String> dataSourceIds = new HashSet<String>();
        int size = dsColl.size();
        for (int i = 0; i < size; ++i) {
            dataSourceIds.add(dsColl.get(i).getDataSource().getId().toString());
        }
        if (dataSourceIds.size() == 0) {
            return null;
        }
        view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("dataSource.id", dataSourceIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)"1", CompareType.EQUALS));
        view.setFilter(filter);
        sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("dataSource.*"));
        sic.add(new SelectorItemInfo("dataSource.entry.*"));
        view.setSelector(sic);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("dataSource.number"));
        view.setSorter(sorter);
        TakeDataContditionCollection coll = TakeDataContditionFactory.getLocalInstance(ctx).getTakeDataContditionCollection(view);
        return coll;
    }

    protected String getInsertSQL(RptParams params) {
        String tableName = params.getString("tempTable");
        DataFetchInfo dataFetchInfo = (DataFetchInfo)params.getObject("dataFetch");
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("INSERT INTO ").append(tableName).append("(");
        insertSQL.append(DataModelUtil.getDataFetchFieldStr(dataFetchInfo, null));
        insertSQL.append(")");
        return insertSQL.toString();
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        this.initParams(ctx, params);
        ctx = EASEjbFactory.getCtx((String)this.getClass().getName(), (Context)ctx);
        RptRowSet rs = null;
        String tempTable = params.getString("tempTable");
        rs = this.executeQuery(this.getQuerySelectSQL(ctx, params), null, from, len, ctx);
        RptParams result = new RptParams();
        result.setObject("rowset", (Object)rs);
        RptRowSet countRs = null;
        int totalCount = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select count(*) as totalCount from ").append(tempTable);
        countRs = this.executeQuery(sql.toString(), null, ctx);
        if (countRs.next()) {
            totalCount = countRs.getInt("totalCount");
        }
        result.setInt("totalCount", totalCount);
        return result;
    }

    protected String getQuerySelectSQL(Context ctx, RptParams params) throws EASBizException, BOSException {
        String tempTable = params.getString("tempTable");
        DataFetchInfo dataFetchInfo = (DataFetchInfo)params.getObject("dataFetch");
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT '' AS selected,");
        sql.append(DataModelUtil.getDataFetchFieldStr(dataFetchInfo, null));
        sql.append(" FROM ").append(tempTable);
        return sql.toString();
    }

    protected RptTableHeader buildHead(Context ctx, RptParams params) throws BOSException {
        RptTableHeader header = new RptTableHeader();
        RptTableColumn col = null;
        col = new RptTableColumn("selected");
        col.setWidth(50);
        header.addColumn(col);
        DataFetchInfo dataFetchInfo = (DataFetchInfo)params.getObject("dataFetch");
        DataFetchEntryCollection coll = dataFetchInfo.getEntry();
        coll.sort("seq");
        DataFetchEntryInfo entryInfo = null;
        Object[][] labels = new Object[1][coll.size() + 1];
        labels[0][0] = "\u9009\u62e9";
        for (int i = 0; i < coll.size(); ++i) {
            entryInfo = coll.get(i);
            col = new RptTableColumn(entryInfo.getName());
            if (entryInfo.getWidth() == 0) {
                col.setWidth(entryInfo.isIsVisible() ? 100 : -1);
            } else {
                col.setWidth(entryInfo.getWidth());
            }
            col.setHided(!entryInfo.isIsVisible());
            header.addColumn(col);
            labels[0][i + 1] = entryInfo.getAlias();
        }
        header.setLabels(labels);
        return header;
    }

    private String getCreateTempTable(Context ctx, RptParams params) throws EASBizException, BOSException {
        DataFetchInfo info = (DataFetchInfo)params.getObject("dataFetch");
        return DataModelUtil.getCreateSQLByDataFetch(ctx, info);
    }
}

