/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.tm.td.account.engine.interfaces.ISQLBuilder;
import com.kingdee.eas.tm.td.basedata.DataFilterTypeEnum;
import com.kingdee.eas.tm.td.basedata.DataSourceInfo;
import com.kingdee.eas.tm.td.basedata.TakeDataContditionInfo;
import com.kingdee.eas.tm.td.cloud.OrgGroupCollection;
import com.kingdee.eas.tm.td.cloud.OrgGroupFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchEntryCollection;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchEntryInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchFieldsMappingCollection;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchFieldsMappingFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchFieldsMappingInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.utils.DataModelUtil;
import com.kingdee.eas.tm.td.cloud.utils.TDCloudUtil;
import com.kingdee.eas.tm.td.utils.CollectionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class DataFetchSQLBuilder
implements ISQLBuilder {
    protected Context ctx;
    protected DataFetchInfo dataFetchInfo = null;
    protected TakeDataContditionInfo conditionInfo = null;
    protected RptParams params = null;
    protected boolean isPreview = false;

    public DataFetchSQLBuilder(Context ctx, DataFetchInfo dataFetchInfo, TakeDataContditionInfo conditionInfo, RptParams params) {
        this.ctx = ctx;
        this.dataFetchInfo = dataFetchInfo;
        this.conditionInfo = conditionInfo;
        this.params = params;
    }

    public DataFetchSQLBuilder(Context ctx, DataFetchInfo dataFetchInfo, TakeDataContditionInfo conditionInfo, RptParams params, boolean isPreview) {
        this.ctx = ctx;
        this.dataFetchInfo = dataFetchInfo;
        this.conditionInfo = conditionInfo;
        this.params = params;
        this.isPreview = isPreview;
    }

    @Override
    public String getSQL() throws EASBizException, BOSException {
        String orderSql;
        StringBuffer result = new StringBuffer();
        result.append(this.getSelectSQL()).append("\r\n");
        result.append(this.getFromSQL());
        FilterInfo filter = this.getFilterInfo();
        String filterSql = filter.toSql();
        if (!StringUtils.isEmpty((String)filterSql)) {
            result.append("Where ").append(filterSql).append("\r\n");
        }
        if (!this.isPreview && !StringUtils.isEmpty((String)this.conditionInfo.getCustomFilter())) {
            result.append(" AND (").append(this.conditionInfo.getCustomFilter()).append(")");
        }
        if (!StringUtils.isEmpty((String)(orderSql = this.getOrderSQL()))) {
            result.append(this.getOrderSQL());
        }
        return result.toString().replaceAll("\"", "'");
    }

    protected String getSelectSQL() throws EASBizException, BOSException {
        StringBuffer result = new StringBuffer("Select ").append("\r\n");
        DataFetchFieldsMappingInfo mappingInfo = null;
        DataFetchEntryCollection fieldColl = this.dataFetchInfo.getEntry();
        DataFetchEntryInfo entryInfo = null;
        fieldColl.sort("seq");
        for (int i = 0; i < fieldColl.size(); ++i) {
            entryInfo = fieldColl.get(i);
            if (i > 0) {
                result.append(",").append("\r\n");
            }
            if ((mappingInfo = this.getFieldsMappingByEntry(entryInfo.getId().toString(), this.conditionInfo.getId().toString())) == null) {
                result.append(this.getFieldSQL(entryInfo));
                continue;
            }
            result.append(this.getFieldFormulaSQL(entryInfo, mappingInfo));
        }
        return result.toString();
    }

    private DataFetchFieldsMappingInfo getFieldsMappingByEntry(String entryId, String conditionId) throws BOSException {
        DataFetchFieldsMappingInfo fieldsMappingInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("dataFetchEntry.id", (Object)entryId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("condition.id", (Object)conditionId, CompareType.EQUALS));
        view.setFilter(filter);
        DataFetchFieldsMappingCollection coll = DataFetchFieldsMappingFactory.getLocalInstance(this.ctx).getDataFetchFieldsMappingCollection(view);
        if (coll != null && coll.size() > 0) {
            fieldsMappingInfo = coll.get(0);
        }
        return fieldsMappingInfo;
    }

    protected String getFieldSQL(DataFetchEntryInfo entryInfo) {
        String defaultValue;
        String result = "";
        result = entryInfo.getName().equalsIgnoreCase("FID") ? this.conditionInfo.getDataSource().getMainTable().getTableAlias() + ".FID AS FID" : (StringUtils.isEmpty((String)(defaultValue = DataModelUtil.getDefaultValueSQL(entryInfo, false))) ? "NULL AS " + entryInfo.getName() : defaultValue + " AS " + entryInfo.getName());
        return result;
    }

    protected String getFieldFormulaSQL(DataFetchEntryInfo entryInfo, DataFetchFieldsMappingInfo fieldDataModel) {
        if (StringUtils.isEmpty((String)entryInfo.getDefaultValue())) {
            return fieldDataModel.getValueExpression() + " AS " + entryInfo.getName();
        }
        String defaultValue = DataModelUtil.getDefaultValueSQL(entryInfo, false);
        return "ISNULL(" + fieldDataModel.getValueExpression() + ", " + defaultValue + ")" + " AS " + entryInfo.getName();
    }

    protected String getFromSQL() throws EASBizException, BOSException {
        String fromSQL = null;
        try {
            DataSourceInfo dataQuery = this.conditionInfo.getDataSource();
            fromSQL = dataQuery.getFromSQL();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return fromSQL;
    }

    protected FilterInfo getFilterInfo() throws EASBizException, BOSException {
        FilterInfo filter = this.conditionInfo.getQueryFilterInfo();
        DataSourceInfo dataQuery = this.conditionInfo.getDataSource();
        filter.mergeFilter(dataQuery.getFilterInfo(), "AND");
        if (!this.isPreview) {
            filter.mergeFilter(this.getExtendFilter(), "AND");
        }
        return filter;
    }

    protected FilterInfo getExtendFilter() throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.mergeFilter(this.getOrgFilter(), "AND");
        filter.mergeFilter(this.getDateFilter(), "AND");
        return filter;
    }

    protected FilterInfo getOrgFilter() throws EASBizException, BOSException {
        if (this.conditionInfo.getOrgField() == null) {
            return null;
        }
        Object[] companys = (Object[])this.params.getObject("companys");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> companyIds = new HashSet<String>();
        CompanyOrgUnitInfo company = null;
        if (companys != null && companys.length > 0) {
            int length = companys.length;
            for (int i = 0; i < length; ++i) {
                company = (CompanyOrgUnitInfo)companys[i];
                companyIds.add(company.getId().toString());
            }
        } else {
            Set groupIncludeChildrenIds = (Set)this.params.getObject("groupIncludeChildrenIds");
            filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)groupIncludeChildrenIds, CompareType.INCLUDE));
            view.setFilter(filter);
            OrgGroupCollection orgGroupColl = OrgGroupFactory.getLocalInstance(this.ctx).getOrgGroupCollection(view);
            int size = orgGroupColl.size();
            for (int i = 0; i < size; ++i) {
                companyIds.add(orgGroupColl.get(i).getCompany().getId().toString());
            }
        }
        StringBuffer orgFilterStr = new StringBuffer();
        orgFilterStr.append(this.conditionInfo.getOrgField()).append(" IN ");
        orgFilterStr.append("(").append(CollectionUtil.convertSet2String(companyIds, ",", true)).append(")");
        FilterInfo orgFilter = new FilterInfo();
        try {
            orgFilter = new FilterInfo(orgFilterStr.toString());
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        return orgFilter;
    }

    protected FilterInfo getDateFilter() throws EASBizException, BOSException {
        int yearFrom = this.params.getInt("yearFrom");
        int monthFrom = this.params.getInt("monthFrom");
        int yearTo = this.params.getInt("yearTo");
        int monthTo = this.params.getInt("monthTo");
        FilterInfo filter = null;
        StringBuffer dateFilter = new StringBuffer();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        if (this.conditionInfo.getDateFilterType().equals((Object)DataFilterTypeEnum.BizDate)) {
            Date startDate = TDCloudUtil.getMonthFirstDay(yearFrom, monthFrom);
            Date endDate = TDCloudUtil.getMonthLastDay(yearTo, monthTo);
            dateFilter.append(" (").append(this.conditionInfo.getBizDateField()).append(" >= {ts'").append(sf.format(startDate)).append(" 00:00:00'}");
            dateFilter.append(" and ").append(this.conditionInfo.getBizDateField()).append(" <= {ts'").append(sf.format(endDate)).append(" 23:59:59'})");
        } else if (this.conditionInfo.getDateFilterType().equals((Object)DataFilterTypeEnum.PeriodID)) {
            String monthFromStr = monthFrom < 10 ? "0" + monthFrom : "" + monthFrom;
            String monthToStr = monthTo < 10 ? "0" + monthTo : "" + monthTo;
            String periodFromNumber = yearFrom + monthFromStr;
            String periodToNumber = yearTo + monthToStr;
            StringBuffer periodSql = new StringBuffer();
            periodSql.append(" select fid  FROM T_BD_Period WHERE fnumber>=").append(periodFromNumber).append(" and fnumber<=").append(periodToNumber);
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)periodSql.toString());
            HashSet<String> periodIds = new HashSet<String>();
            try {
                while (rs.next()) {
                    periodIds.add(rs.getString("fid"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            String periodIdstr = CollectionUtil.convertSet2String(periodIds, ",", true);
            dateFilter.append(" ").append(this.conditionInfo.getPeriodIdField()).append(" in (").append(periodIdstr).append(")");
        } else if (this.conditionInfo.getDateFilterType().equals((Object)DataFilterTypeEnum.YearAndMonth)) {
            dateFilter.append(" (");
            dateFilter.append(this.conditionInfo.getPeriodYear()).append("*100+").append(this.conditionInfo.getPeriodMonth()).append(" >= ");
            dateFilter.append(yearFrom * 100 + monthFrom);
            dateFilter.append(" and ");
            dateFilter.append(this.conditionInfo.getPeriodYear()).append("*100+").append(this.conditionInfo.getPeriodMonth()).append(" <= ");
            dateFilter.append(yearTo * 100 + monthTo);
            dateFilter.append(") ");
        }
        try {
            filter = new FilterInfo(dateFilter.toString());
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        return filter;
    }

    protected String getOrderSQL() throws EASBizException, BOSException {
        return null;
    }

    @Override
    public String getExecuteLockName() {
        return this.conditionInfo.getId().toString();
    }
}

