/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.tm.td.cloud.GroupCollection;
import com.kingdee.eas.tm.td.cloud.GroupFactory;
import com.kingdee.eas.tm.td.cloud.GroupInfo;
import com.kingdee.eas.tm.td.cloud.OrgGroupCollection;
import com.kingdee.eas.tm.td.cloud.OrgGroupFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.rpt.app.AbstractRiskScreeningRecordFacadeControllerBean;
import com.kingdee.eas.tm.td.cloud.datamodel.utils.DataModelUtil;
import com.kingdee.eas.tm.td.utils.CollectionUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class RiskScreeningRecordFacadeControllerBean
extends AbstractRiskScreeningRecordFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.cloud.datamodel.rpt.app.RiskScreeningRecordFacadeControllerBean");

    @Override
    protected void initParams(Context ctx, RptParams params) throws BOSException, EASBizException {
        ObjectUuidPK pk = null;
        if (params.getObject("dataFetch") instanceof String) {
            String dataFecth = (String)params.getObject("dataFetch");
            pk = new ObjectUuidPK(dataFecth);
        } else if (params.getObject("dataFetch") instanceof DataFetchInfo) {
            DataFetchInfo dataFecthInfo = (DataFetchInfo)params.getObject("dataFetch");
            pk = new ObjectUuidPK(dataFecthInfo.getId().toString());
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entry.*"));
        DataFetchInfo dataFecthInfo = DataFetchFactory.getLocalInstance(ctx).getDataFetchInfo((IObjectPK)pk, sic);
        params.setObject("dataFetch", (Object)dataFecthInfo);
        String group = (String)params.getObject("group");
        GroupInfo groupInfo = GroupFactory.getLocalInstance(ctx).getGroupInfo((IObjectPK)new ObjectUuidPK(group));
        GroupCollection groupColl = GroupFactory.getLocalInstance(ctx).getGroupCollection(" where longNumber like '" + groupInfo.getLongNumber() + "%'");
        HashSet<String> groupIncludeChildrenIds = new HashSet<String>();
        GroupInfo info = null;
        int size = groupColl.size();
        for (int i = 0; i < size; ++i) {
            info = groupColl.get(i);
            groupIncludeChildrenIds.add(info.getId().toString());
        }
        params.setObject("groupIncludeChildrenIds", groupIncludeChildrenIds);
        List<String> dim = DataModelUtil.getDataFetchDimFields(dataFecthInfo);
        params.setObject("dim", dim);
    }

    @Override
    protected void insertBillData(Context ctx, RptParams params) throws BOSException, EASBizException {
        HashSet companyIds = new HashSet();
        if (params.getObject("companyIds") != null) {
            companyIds = (HashSet)params.getObject("companyIds");
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        Object company = null;
        if (companyIds.size() == 0) {
            Set groupIncludeChildrenIds = (Set)params.getObject("groupIncludeChildrenIds");
            filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)groupIncludeChildrenIds, CompareType.INCLUDE));
            view.setFilter(filter);
            OrgGroupCollection orgGroupColl = OrgGroupFactory.getLocalInstance(ctx).getOrgGroupCollection(view);
            int size = orgGroupColl.size();
            for (int i = 0; i < size; ++i) {
                companyIds.add(orgGroupColl.get(i).getCompany().getId().toString());
            }
        }
        int yearFrom = Integer.valueOf(params.getString("yearFrom"));
        int monthFrom = Integer.valueOf(params.getString("monthFrom"));
        int yearTo = Integer.valueOf(params.getString("yearTo"));
        int monthTo = Integer.valueOf(params.getString("monthTo"));
        String tempTable = params.getString("tempTable");
        DataFetchInfo dataFetchInfo = (DataFetchInfo)params.getObject("dataFetch");
        StringBuffer sql = new StringBuffer();
        sql.append(" INSERT INTO ").append(tempTable).append("(");
        sql.append(DataModelUtil.getDataFetchFieldStr(dataFetchInfo, null));
        sql.append(") ").append("\r\n");
        sql.append(" SELECT ").append(DataModelUtil.getDataFetchFieldStr(dataFetchInfo, null));
        sql.append(" FROM ").append(dataFetchInfo.getTblName()).append(" as a");
        sql.append(" WHERE 1=1 ");
        if (companyIds.size() > 0) {
            sql.append(" and a.FCompany in (").append(CollectionUtil.convertSet2String(companyIds, ",", true)).append(")");
        }
        sql.append(" AND (");
        sql.append(" a.FYear*100+a.FMonth >= ").append(yearFrom * 100 + monthFrom);
        sql.append(" and ").append(" a.FYear*100+a.FMonth <= ").append(yearTo * 100 + monthTo);
        sql.append(" ) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }
}

