/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorResultProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.eas.base.commonquery.RowObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.rpt.RptReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.AccountConfigEntryCollection;
import com.kingdee.eas.tm.td.basedata.AccountConfigEntryInfo;
import com.kingdee.eas.tm.td.basedata.AccountConfigInfo;
import com.kingdee.eas.tm.td.basedata.DataTypeEnum;
import com.kingdee.eas.tm.td.basedata.util.CommonFilterPanelUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.tmatesoft.svn.core.internal.util.jna.ISVNSecurityLibrary;

public class CheckFormulaUtil {
    private static Logger logger = Logger.getLogger(CheckFormulaUtil.class);

    public static boolean computeIfClause(Context ctx, String formula, Map param, IObjectValue vo) throws EASBizException, BOSException {
        block11: {
            formula = CheckFormulaUtil.replaceParam(ctx, formula, param);
            Pattern patt = Pattern.compile(" and ", 2);
            Matcher m = patt.matcher(formula);
            formula = m.replaceAll("\\)\\*\\(");
            patt = Pattern.compile("\\)and ", 2);
            m = patt.matcher(formula);
            formula = m.replaceAll("\\)\\)\\*\\(");
            patt = Pattern.compile(" and\\(", 2);
            m = patt.matcher(formula);
            formula = m.replaceAll("\\)\\*\\(\\(");
            patt = Pattern.compile(" or ", 2);
            m = patt.matcher(formula);
            formula = m.replaceAll("\\)\\+\\(");
            patt = Pattern.compile("\\)or ", 2);
            m = patt.matcher(formula);
            formula = m.replaceAll("\\)\\)\\+\\(");
            patt = Pattern.compile(" or\\(", 2);
            m = patt.matcher(formula);
            formula = m.replaceAll("\\)\\+\\(\\(");
            formula = "(" + formula + ")";
            Book book = Book.Manager.getNewBook(null, (int)1);
            try {
                CheckFormulaUtil.initFormulaRuntimeEnv(ctx, book, vo);
            }
            catch (Exception e1) {
                return false;
            }
            book.setCalculate(false);
            Sheet sheet = book.getSheet(0);
            Range rg = sheet.getRange(0, 0);
            rg.setFormula("=" + formula);
            book.calc();
            Variant obj = rg.getValue();
            if (obj != null) {
                if (obj.getVt() == 8) {
                    try {
                        if (obj.booleanValue()) {
                            return true;
                        }
                        break block11;
                    }
                    catch (SyntaxErrorException e) {
                        return false;
                    }
                }
                if (obj.isNumeric()) {
                    try {
                        if (obj.toBigDecimal().compareTo(new BigDecimal(0)) > 0) {
                            return true;
                        }
                    }
                    catch (SyntaxErrorException e) {
                        return false;
                    }
                }
            }
        }
        return false;
    }

    public static List<Boolean> computeIfClause(Context ctx, List<String> clauseFormulaList) throws EASBizException, BOSException {
        Book book = Book.Manager.getNewBook(null, (int)1);
        try {
            CheckFormulaUtil.initFormulaRuntimeEnv(ctx, book, null);
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        book.setCalculate(false);
        Sheet sheet = book.getSheet(0);
        Range range = null;
        int size = clauseFormulaList.size();
        for (int i = 0; i < size; ++i) {
            range = sheet.getRange(i, 0);
            range.setFormula(clauseFormulaList.get(i));
        }
        book.calc();
        ArrayList<Boolean> clauseResultList = new ArrayList<Boolean>();
        int size2 = clauseFormulaList.size();
        for (int i = 0; i < size2; ++i) {
            range = sheet.getRange(i, 0);
            clauseResultList.add(CheckFormulaUtil.getCalculateValue(range));
        }
        return clauseResultList;
    }

    public static String getIfClauseFormula(Context ctx, String formula, Map param, IObjectValue vo) throws EASBizException, BOSException {
        formula = CheckFormulaUtil.replaceParam(ctx, formula, param);
        Pattern patt = Pattern.compile(" and ", 2);
        Matcher m = patt.matcher(formula);
        formula = m.replaceAll("\\)\\*\\(");
        patt = Pattern.compile("\\)and ", 2);
        m = patt.matcher(formula);
        formula = m.replaceAll("\\)\\)\\*\\(");
        patt = Pattern.compile(" and\\(", 2);
        m = patt.matcher(formula);
        formula = m.replaceAll("\\)\\*\\(\\(");
        patt = Pattern.compile(" or ", 2);
        m = patt.matcher(formula);
        formula = m.replaceAll("\\)\\+\\(");
        patt = Pattern.compile("\\)or ", 2);
        m = patt.matcher(formula);
        formula = m.replaceAll("\\)\\)\\+\\(");
        patt = Pattern.compile(" or\\(", 2);
        m = patt.matcher(formula);
        formula = m.replaceAll("\\)\\+\\(\\(");
        formula = "=(" + formula + ")";
        return formula;
    }

    public static boolean getCalculateValue(Range range) {
        block9: {
            Variant obj = range.getValue();
            if (obj != null) {
                if (obj.getVt() == 8) {
                    try {
                        if (obj.booleanValue()) {
                            return true;
                        }
                        break block9;
                    }
                    catch (SyntaxErrorException e) {
                        return false;
                    }
                }
                if (obj.isNumeric()) {
                    try {
                        if (obj.toBigDecimal().compareTo(new BigDecimal(0)) > 0) {
                            return true;
                        }
                    }
                    catch (SyntaxErrorException e) {
                        return false;
                    }
                }
            }
        }
        return false;
    }

    protected static void initFormulaRuntimeEnv(final Context ctx, Book book, final IObjectValue vo) throws Exception {
        FormulaDefinition.registerFormulaToBook((Book)book, (ICalculateContextProvider)new ICalculateContextProvider(){

            public Context getServerContext() {
                return ctx;
            }

            public IReportPropertyAdapter getReportAdapter() {
                RptReportPropertyAdapter propertyAdapter = new RptReportPropertyAdapter();
                propertyAdapter.initReportProperties(vo, ctx);
                return propertyAdapter;
            }

            public ReportVariables getReportVariables() {
                return new ReportVariables();
            }

            public IErrorProvider getErrorProvider() {
                return null;
            }

            public IErrorResultProvider getErrorResultProvider() {
                return null;
            }
        });
    }

    private static String replaceParam(Context ctx, String f, Map param) throws EASBizException, BOSException {
        Object[] rowData = (Object[])param.get("rowData");
        AccountConfigInfo configInfo = (AccountConfigInfo)param.get("configInfo");
        FilterInfo filterInfo = (FilterInfo)param.get("filterInfo");
        AccountConfigEntryCollection coll = configInfo.getEntry();
        int filterSize = filterInfo.getFilterItems().size();
        ArrayList rowInfos = CommonFilterPanelUtil.getRowInfos(filterInfo);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filterSize; ++i) {
            RowObject rowObject = (RowObject)rowInfos.get(i);
            FilterItemInfo filterItemInfo = filterInfo.getFilterItems().get(i);
            rowObject.setLeftBracket(rowObject.getLeftBracket());
            rowObject.setCondition(filterItemInfo.getPropertyName());
            if (filterItemInfo.getCompareValue() == null) {
                if (CompareType.EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                    rowObject.setCompare(CompareType.EMPTY.getName());
                } else {
                    rowObject.setCompare(CompareType.NOTEMPTY.getName());
                }
            } else {
                rowObject.setCompare(filterItemInfo.getCompareType().getName());
            }
            sb.append(rowObject.getLeftBracket().toString());
            sb.append(CheckFormulaUtil.getFormulaValue(rowData, coll, rowObject, filterItemInfo));
            sb.append(rowObject.getRightBracket().toString()).append(" ");
            sb.append(rowObject.getLogic().toString()).append(" ");
        }
        f = sb.toString();
        return f;
    }

    private static String getFormulaValue(Object[] rowData, AccountConfigEntryCollection coll, RowObject rowObject, FilterItemInfo filterItemInfo) throws EASBizException, BOSException {
        String TRUE = "1";
        String FALSE = "0";
        StringBuffer sb = new StringBuffer();
        rowObject.setCompareValue(filterItemInfo.getCompareValue());
        int index = CheckFormulaUtil.getPropertyIndex(coll, filterItemInfo.getPropertyName());
        if (index < 0) {
            return FALSE;
        }
        AccountConfigEntryInfo entryInfo = coll.get(index);
        Object value = rowData[index];
        Object companyValue = rowObject.getCompareValue();
        if (rowObject.getCompare().equalsIgnoreCase("IS")) {
            return value == null ? TRUE : FALSE;
        }
        if (rowObject.getCompare().equalsIgnoreCase("IS NOT")) {
            return value != null ? TRUE : FALSE;
        }
        if (value == null || companyValue == null) {
            return FALSE;
        }
        if (rowObject.getCompare().equalsIgnoreCase("LIKE") || rowObject.getCompare().equalsIgnoreCase("LEFT LIKE") || rowObject.getCompare().equalsIgnoreCase("RIGHT LIKE") || rowObject.getCompare().equalsIgnoreCase("NOT LIKE") || rowObject.getCompare().equalsIgnoreCase("NOT LEFT LIKE")) {
            String likeValue = value.toString();
            String likeCompareValue = CheckFormulaUtil.getCompareValue(rowObject, entryInfo);
            if (rowObject.getCompare().equalsIgnoreCase("LIKE")) {
                return likeValue.indexOf(likeCompareValue) >= 0 ? TRUE : FALSE;
            }
            if (rowObject.getCompare().equalsIgnoreCase("LEFT LIKE")) {
                return likeValue.startsWith(likeCompareValue) ? TRUE : FALSE;
            }
            if (rowObject.getCompare().equalsIgnoreCase("RIGHT LIKE")) {
                return likeValue.endsWith(likeCompareValue) ? TRUE : FALSE;
            }
            if (rowObject.getCompare().equalsIgnoreCase("NOT LIKE")) {
                return likeValue.indexOf(likeCompareValue) < 0 ? TRUE : FALSE;
            }
            if (rowObject.getCompare().equalsIgnoreCase("NOT LEFT LIKE")) {
                return !likeValue.startsWith(likeCompareValue) ? TRUE : FALSE;
            }
        } else if (DataTypeEnum.Date.equals((Object)entryInfo.getDataType()) || DataTypeEnum.Timestamp.equals((Object)entryInfo.getDataType())) {
            sb.append(CheckFormulaUtil.getDateFormulaValue(value, entryInfo, filterItemInfo));
        } else if (DataTypeEnum.Price.equals((Object)entryInfo.getDataType()) || DataTypeEnum.Amount.equals((Object)entryInfo.getDataType()) || DataTypeEnum.Qty.equals((Object)entryInfo.getDataType())) {
            sb.append(rowData[index].toString());
            sb.append(rowObject.getCompare().toString()).append(" ");
            sb.append(CheckFormulaUtil.getCompareValue(rowObject, entryInfo)).append(" ");
        } else {
            sb.append("\"").append(rowData[index].toString()).append("\" ");
            sb.append(rowObject.getCompare().toString()).append(" ");
            sb.append("\"").append(CheckFormulaUtil.getCompareValue(rowObject, entryInfo)).append("\" ");
        }
        return sb.toString();
    }

    private static String getDateFormulaValue(Object value, AccountConfigEntryInfo entryInfo, FilterItemInfo filterItem) throws EASBizException, BOSException {
        FilterInfo filterInfo = CheckFormulaUtil.getDataFilterInfo(filterItem);
        int filterSize = filterInfo.getFilterItems().size();
        ArrayList rowInfos = CommonFilterPanelUtil.getRowInfos(filterInfo);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filterSize; ++i) {
            RowObject rowObject = (RowObject)rowInfos.get(i);
            FilterItemInfo filterItemInfo = filterInfo.getFilterItems().get(i);
            rowObject.setLeftBracket(rowObject.getLeftBracket());
            rowObject.setCondition(filterItemInfo.getPropertyName());
            rowObject.setCompare(filterItemInfo.getCompareType().getName());
            sb.append(rowObject.getLeftBracket().toString());
            sb.append("\"").append(CheckFormulaUtil.getDateValue(value, entryInfo)).append("\" ");
            sb.append(rowObject.getCompare().toString()).append(" ");
            sb.append("\"").append(CheckFormulaUtil.getDateValue(filterItemInfo.getCompareValue(), entryInfo)).append("\" ");
            sb.append(rowObject.getRightBracket().toString()).append(" ");
            sb.append(rowObject.getLogic().toString()).append(" ");
        }
        return "(" + sb.toString() + ")";
    }

    private static FilterInfo getDataFilterInfo(FilterItemInfo filterItemInfo) {
        FilterInfo newFilterInfo = new FilterInfo();
        String itemCompareValue = filterItemInfo.getCompareValue().toString();
        String condition = filterItemInfo.getPropertyName();
        if (filterItemInfo.getCompareType().equals((Object)CompareType.EQUALS) && (filterItemInfo.getCompareValue().getClass().getName().equals("java.sql.Timestamp") || filterItemInfo.getCompareValue().getClass().getName().equals("java.sql.Date"))) {
            Calendar worldTour = Calendar.getInstance();
            worldTour.setTime((Date)filterItemInfo.getCompareValue());
            worldTour.add(5, 0);
            Date startDay = worldTour.getTime();
            worldTour.add(5, 1);
            Date endDay = worldTour.getTime();
            FilterItemInfo filterItemInfo1 = new FilterItemInfo(condition, (Object)startDay, CompareType.getEnum((String)">="));
            newFilterInfo.getFilterItems().add(filterItemInfo1);
            FilterItemInfo filterItemInfo2 = new FilterItemInfo(condition, (Object)endDay, CompareType.getEnum((String)"<"));
            newFilterInfo.getFilterItems().add(filterItemInfo2);
            newFilterInfo.setMaskString("#1 and #2");
        } else if (filterItemInfo.getCompareType().equals((Object)CompareType.NOTEQUALS) && (filterItemInfo.getCompareValue().getClass().getName().equals("java.sql.Timestamp") || filterItemInfo.getCompareValue().getClass().getName().equals("java.sql.Date"))) {
            Calendar worldTour = Calendar.getInstance();
            worldTour.setTime((Date)filterItemInfo.getCompareValue());
            worldTour.add(5, 0);
            Date startDay = worldTour.getTime();
            worldTour.add(5, 1);
            Date endDay = worldTour.getTime();
            FilterItemInfo filterItemInfo1 = new FilterItemInfo(condition, (Object)startDay, CompareType.getEnum((String)"<"));
            newFilterInfo.getFilterItems().add(filterItemInfo1);
            FilterItemInfo filterItemInfo2 = new FilterItemInfo(condition, (Object)endDay, CompareType.getEnum((String)">="));
            newFilterInfo.getFilterItems().add(filterItemInfo2);
            newFilterInfo.setMaskString("#1 or #2");
        } else if (StringUtils.equalsIgnoreCase((String)itemCompareValue, (String)"YESTERDAY") || StringUtils.equalsIgnoreCase((String)itemCompareValue, (String)"TODAY") || StringUtils.equalsIgnoreCase((String)itemCompareValue, (String)"TOMORROW") || StringUtils.equalsIgnoreCase((String)itemCompareValue, (String)"LASTWEEK") || StringUtils.equalsIgnoreCase((String)itemCompareValue, (String)"THISWEEK") || StringUtils.equalsIgnoreCase((String)itemCompareValue, (String)"NEXTWEEK") || StringUtils.equalsIgnoreCase((String)itemCompareValue, (String)"LASTMONTH") || StringUtils.equalsIgnoreCase((String)itemCompareValue, (String)"THISMONTH") || StringUtils.equalsIgnoreCase((String)itemCompareValue, (String)"NEXTMONTH")) {
            FilterInfo tempFilterInfo = QueryUtils.getDateFunctionFilterInfo((String)condition, (String)itemCompareValue);
            FilterItemCollection filterItemCol = tempFilterInfo.getFilterItems();
            int size = filterItemCol.size();
            for (int j = 0; j < size; ++j) {
                newFilterInfo.getFilterItems().add(filterItemCol.get(j));
            }
            newFilterInfo.setMaskString("#1 and #2");
        } else if (StringUtils.equalsIgnoreCase((String)itemCompareValue, (String)"BEFORETODAY")) {
            QueryUtils.getBeforetoDayFilterInfo((FilterInfo)newFilterInfo, (String)condition);
        } else if (StringUtils.equalsIgnoreCase((String)itemCompareValue, (String)"AFTERTODAY")) {
            QueryUtils.getAftertoDayFilterInfo((FilterInfo)newFilterInfo, (String)condition);
        } else {
            newFilterInfo.getFilterItems().add(filterItemInfo);
        }
        return newFilterInfo;
    }

    private static String getDateValue(Object value, AccountConfigEntryInfo entryInfo) {
        String dateStr = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat timeStampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (value instanceof Date || value instanceof ISVNSecurityLibrary.TimeStamp || value instanceof GregorianCalendar) {
            if (value instanceof GregorianCalendar) {
                value = ((GregorianCalendar)value).getTime().getTime();
            }
            if (entryInfo.getDataType().equals((Object)DataTypeEnum.Date)) {
                dateStr = dateFormat.format(value);
            } else if (entryInfo.getDataType().equals((Object)DataTypeEnum.Timestamp)) {
                dateStr = timeStampFormat.format(value);
            }
        } else {
            dateStr = value.toString();
        }
        return dateStr;
    }

    private static String getCompareValue(RowObject rowObject, AccountConfigEntryInfo entryInfo) throws EASBizException, BOSException {
        String value = "";
        if (rowObject.getCompare().equalsIgnoreCase("LIKE") || rowObject.getCompare().equalsIgnoreCase("LEFT LIKE") || rowObject.getCompare().equalsIgnoreCase("RIGHT LIKE") || rowObject.getCompare().equalsIgnoreCase("NOT LIKE") || rowObject.getCompare().equalsIgnoreCase("NOT LEFT LIKE")) {
            value = rowObject.getCompareValue().toString().replaceAll("%", "");
        } else if (DataTypeEnum.Boolean.equals((Object)entryInfo.getDataType())) {
            value = TDUtils.getEnumValue("com.kingdee.eas.base.commonquery.BooleanEnum", rowObject.getCompareValue()).getAlias();
        } else if (DataTypeEnum.Enum.equals((Object)entryInfo.getDataType())) {
            Enum enumValue = TDUtils.getEnumValue(entryInfo.getBaseDataBOSType(), rowObject.getCompareValue());
            if (enumValue != null) {
                value = enumValue.getAlias();
            }
        } else {
            value = rowObject.getCompareValue().toString();
        }
        return value;
    }

    public static int getPropertyIndex(AccountConfigEntryCollection coll, String propertyName) {
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            if (!coll.get(i).getName().equals(propertyName)) continue;
            return i;
        }
        return -1;
    }

    private static String computeLike(Context ctx, String formula) {
        String rv;
        String lf;
        String[] strs;
        String f;
        Locale l = ctx.getLocale();
        String llike = "left like";
        String rlike = "right like";
        String like = "like";
        HashMap<String, String> likeResult = new HashMap<String, String>();
        String pattern = "\\\"[^\\\"]{1,}\\\"\\s{1,}(" + llike + ")\\s{1,}\\\"[^\\\"]{1,}\\\"";
        Pattern patt = Pattern.compile(pattern);
        Matcher m = patt.matcher(formula);
        while (m.find()) {
            f = m.group();
            strs = f.split(llike);
            lf = strs[0].trim().replaceAll("\\\"", "");
            if (lf.startsWith(rv = strs[1].trim().replaceAll("\\\"", ""))) {
                likeResult.put(f, "1");
                continue;
            }
            likeResult.put(f, "0");
        }
        pattern = "\\\"[^\\\"]{1,}\\\"\\s{1,}(" + rlike + ")\\s{1,}\\\"[^\\\"]{1,}\\\"";
        patt = Pattern.compile(pattern);
        m = patt.matcher(formula);
        while (m.find()) {
            f = m.group();
            strs = f.split(rlike);
            lf = strs[0].trim().replaceAll("\\\"", "");
            if (lf.endsWith(rv = strs[1].trim().replaceAll("\\\"", ""))) {
                likeResult.put(f, "1");
                continue;
            }
            likeResult.put(f, "0");
        }
        pattern = "\\\"[^\\\"]{1,}\\\"\\s{1,}(" + like + ")\\s{1,}\\\"[^\\\"]{1,}\\\"";
        patt = Pattern.compile(pattern);
        m = patt.matcher(formula);
        while (m.find()) {
            f = m.group();
            strs = f.split(like);
            lf = strs[0].trim().replaceAll("\\\"", "");
            if (lf.indexOf(rv = strs[1].trim().replaceAll("\\\"", "")) >= 0) {
                likeResult.put(f, "1");
                continue;
            }
            likeResult.put(f, "0");
        }
        for (String key : likeResult.keySet()) {
            String value = (String)likeResult.get(key);
            formula = formula.replaceAll(key, value);
        }
        return formula;
    }
}

