/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.directdeclare.comm.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.json.Kson;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.directdeclare.TeException;
import com.kingdee.eas.tm.td.directdeclare.comm.util.SSLClientBuilder;
import com.kingdee.eas.tm.td.directdeclare.comm.util.SSLClientConfig;
import com.kingdee.util.StringUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class HttpClientUtil {
    private static Logger logger = Logger.getLogger(HttpClientUtil.class);

    public static String doPost(String url, Map param) throws EASBizException, BOSException {
        return HttpClientUtil.doPost(url, param, SSLClientConfig.custom().build());
    }

    public static String doPost(String url, Map param, SSLClientConfig config) throws EASBizException, BOSException {
        logger.error((Object)("HttpClientUtil doPost url=" + url + ",param=" + param));
        HttpClient httpClient = null;
        HttpPost httpPost = null;
        String result = null;
        String contentType = null;
        try {
            httpClient = SSLClientBuilder.create().setConfig(config).builder();
            httpPost = new HttpPost(url);
            contentType = config != null ? config.getContentType() : "application/json";
            HttpClientUtil.setHeaders((HttpRequestBase)httpPost, config);
            String paramStr = Kson.getGson().toJson((Object)param);
            StringEntity se = new StringEntity(paramStr, StandardCharsets.UTF_8);
            se.setContentEncoding((Header)new BasicHeader("Content-Type", contentType));
            se.setContentType(contentType);
            httpPost.setEntity((HttpEntity)se);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response != null) {
                if (response.getStatusLine() != null && response.getStatusLine().getStatusCode() == 404) {
                    throw new TeException(TeException.CON_TIME_OUT);
                }
                HttpEntity resEntity = response.getEntity();
                if (resEntity != null) {
                    result = EntityUtils.toString((HttpEntity)resEntity, (Charset)StandardCharsets.UTF_8);
                }
            }
        }
        catch (Exception ex) {
            throw new TeException(TeException.CON_TIME_OUT);
        }
        return result;
    }

    public static String doGet(String url, Map<String, String> param) throws EASBizException, BOSException {
        return HttpClientUtil.doGet(url, param, SSLClientConfig.custom().build());
    }

    public static String doGet(String url, Map<String, String> param, SSLClientConfig config) throws EASBizException, BOSException {
        String paramStr = "";
        if (param != null) {
            Set<String> keySet = param.keySet();
            for (String keyStr : keySet) {
                paramStr = paramStr + keyStr + "=" + param.get(keyStr) + "&";
            }
        }
        if (!StringUtils.isEmpty((String)paramStr)) {
            url = url + "?" + paramStr.substring(0, paramStr.length() - 1);
        }
        HttpClient httpClient = null;
        HttpGet httpGet = null;
        String result = null;
        try {
            HttpEntity resEntity;
            httpClient = SSLClientBuilder.create().setConfig(config).builder();
            httpGet = new HttpGet(url);
            HttpClientUtil.setHeaders((HttpRequestBase)httpGet, config);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (Exception ex) {
            throw new BOSException("\u8fde\u63a5\u8d85\u65f6,\u8fde\u63a5\u4fe1\u606f\uff1a" + ex.getMessage());
        }
        return result;
    }

    private static void setHeaders(HttpRequestBase httpPost, SSLClientConfig config) {
        if (config == null) {
            return;
        }
        Map<String, String> headers = config.getHeaders();
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpPost.setHeader(entry.getKey(), entry.getValue());
            }
        }
    }
}

