/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.directdeclare.comm.util;

import com.kingdee.eas.tm.td.directdeclare.comm.util.SSLClientConfig;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.log4j.Logger;

public class SSLClientBuilder {
    private static Logger logger = Logger.getLogger(SSLClientBuilder.class);
    private int connectionRequestTimeout = 0;
    private int connectTimeout = 0;
    private int socketTimeout = 0;

    protected SSLClientBuilder() {
    }

    public static SSLClientBuilder create() {
        return new SSLClientBuilder();
    }

    public SSLClientBuilder setConfig(SSLClientConfig config) {
        if (config != null) {
            this.connectionRequestTimeout = config.getConnectTimeout();
            this.connectTimeout = config.getConnectTimeout();
            this.socketTimeout = config.getSocketTimeout();
        }
        return this;
    }

    public SSLClientBuilder setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
        return this;
    }

    public SSLClientBuilder setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public SSLClientBuilder setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    public HttpClient builder() throws Exception {
        return this.wrapClient();
    }

    private HttpClient wrapClient() throws Exception {
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(this.connectionRequestTimeout).setConnectTimeout(this.connectTimeout).setSocketTimeout(this.socketTimeout).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }
}

