/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.est.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.RefCheckerFactory;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.est.CalcFormulaCollection;
import com.kingdee.eas.tm.td.est.CalcFormulaFactory;
import com.kingdee.eas.tm.td.est.CalcFormulaInfo;
import com.kingdee.eas.tm.td.est.EstStateEnum;
import com.kingdee.eas.tm.td.est.app.AbstractCalcFormulaControllerBean;
import com.kingdee.eas.tm.td.utils.LogUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CalcFormulaControllerBean
extends AbstractCalcFormulaControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.est.app.CalcFormulaControllerBean");
    private static final String RES = "com.kingdee.eas.tm.td.est.ESTResource";

    private String getResource(String proper, Context ctx) {
        return ResourceBase.getString((String)RES, (String)proper, (Locale)ctx.getLocale());
    }

    private String getResource(String proper, Context ctx, Object[] params) {
        return ResourceBase.getString((String)RES, (String)proper, (Locale)ctx.getLocale(), (Object[])params);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CalcFormulaInfo info;
        if (model == null) {
            model = this.getValue(ctx, pk);
        }
        if (EstStateEnum.FORBIDDEN.equals((Object)(info = (CalcFormulaInfo)model).getState())) {
            throw new TDException(TDException.ERROR_MSG, new Object[]{TDUtils.getString(RES, "Error_Cancel", ctx.getLocale())});
        }
        info.setState(EstStateEnum.FORBIDDEN);
        this._update(ctx, pk, (IObjectValue)info);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CalcFormulaInfo info;
        if (model == null) {
            model = this.getValue(ctx, pk);
        }
        if (EstStateEnum.USING.equals((Object)(info = (CalcFormulaInfo)model).getState())) {
            throw new TDException(TDException.ERROR_MSG, new Object[]{TDUtils.getString(RES, "Error_Cancelcancel", ctx.getLocale())});
        }
        info.setState(EstStateEnum.USING);
        this._update(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CalcFormulaInfo info = this.getCalcFormulaInfo(ctx, pk);
        if (EstStateEnum.USING.equals((Object)info.getState())) {
            throw new TDException(TDException.ERROR_MSG, new Object[]{TDUtils.getString(RES, "Error_USINGDelete", ctx.getLocale())});
        }
        if (info.isIsPreset()) {
            throw new TDException(TDException.ERROR_MSG, new Object[]{TDUtils.getString(RES, "Error_PresetData", ctx.getLocale())});
        }
        Boolean isReference = RefCheckerFactory.getLocalInstance((Context)ctx).isReferenced(BOSUuid.read((String)pk.toString()));
        if (isReference.booleanValue()) {
            throw new TDException(TDException.ERROR_MSG, new Object[]{TDUtils.getString(RES, "Error_RefDelete", ctx.getLocale())});
        }
        super._delete(ctx, pk);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CalcFormulaInfo info = (CalcFormulaInfo)model;
        info.setId(BOSUuid.create((String)"6C3ED36E"));
        IObjectPK logPk = LogUtils.beginLog(ctx, "addNew", BOSObjectType.create((String)"6C3ED36E"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "estateData_calcFormula_new", info.getCU().getId().toString());
        this.checkBefore(ctx, info);
        if (info.isIsDefault()) {
            this.cleanOtherDefault(ctx, info);
        }
        IObjectPK pk = super._addnew(ctx, model);
        LogUtils.afterLog(ctx, logPk);
        return pk;
    }

    private void cleanOtherDefault(Context ctx, CalcFormulaInfo info) {
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" update T_TD_CalcFormula set FIsDefault = 0 where FTaxItemTypeID = '");
            sql.append(info.getTaxItemType().getId().toString()).append("'");
            if (info.getTaxMethod() != null) {
                sql.append(" and FTaxMethod = '");
                sql.append(info.getTaxMethod().getValue());
                sql.append("' ");
            } else {
                sql.append(" and FTaxMehod is null");
            }
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            model = this.getCalcFormulaInfo(ctx, pk);
        }
        CalcFormulaInfo info = (CalcFormulaInfo)model;
        IObjectPK logPk = LogUtils.beginLog(ctx, "edit", BOSObjectType.create((String)"6C3ED36E"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "estateData_calcFormula_edit", info.getCU().getId().toString());
        this.checkBefore(ctx, info);
        if (info.isIsDefault()) {
            this.cleanOtherDefault(ctx, info);
        }
        super._update(ctx, pk, (IObjectValue)model);
        LogUtils.afterLog(ctx, logPk);
    }

    private void checkBefore(Context ctx, CalcFormulaInfo info) throws EASBizException, BOSException {
        this._checkNumberDup(ctx, (IObjectValue)info);
        StringBuffer errorList = new StringBuffer();
        if (info.getNumber() == null || info.getNumber().isEmpty()) {
            errorList.append(this.getResource("Calc_Number", ctx));
        }
        if (info.getName() == null || info.getName().isEmpty()) {
            errorList.append(this.getResource("Calc_Name", ctx));
        }
        if (info.getTaxItemType() == null || info.getTaxItemType().toString().isEmpty()) {
            errorList.append(this.getResource("Calc_TaxItem", ctx));
        }
        if (info.getDataSource() == null || info.getDataSource().toString().isEmpty()) {
            errorList.append(this.getResource("Calc_DataSource", ctx));
        }
        if (info.getDisplayBasisExpr() == null || info.getDisplayBasisExpr().toString().isEmpty()) {
            errorList.append(this.getResource("Calc_DisplayBasisExpr", ctx));
        }
        if (info.getDisplayExpr() == null || info.getDisplayExpr().toString().isEmpty()) {
            errorList.append(this.getResource("Calc_DisplayExpr", ctx));
        }
        if (errorList.length() > 0) {
            errorList.append(this.getResource("NOTNULL", ctx));
            throw new TDException(TDException.ERROR_MSG, new Object[]{errorList.toString().substring(1)});
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CalcFormulaInfo info = (CalcFormulaInfo)model;
        this.checkBefore(ctx, info);
        if (info.isIsDefault()) {
            this.cleanOtherDefault(ctx, info);
        }
        IObjectPK pk = super._submit(ctx, model);
        return pk;
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return new FilterInfo();
    }

    @Override
    protected CalcFormulaInfo _getDefaultCalcFormula(Context ctx, Map params) throws BOSException {
        String taxItemTypeId = (String)params.get("taxItemType");
        String taxMethod = (String)params.get("taxMethod");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"1", CompareType.EQUALS));
        if (taxItemTypeId != null && !taxItemTypeId.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("taxItemType.id", (Object)taxItemTypeId, CompareType.EQUALS));
        }
        if (taxMethod != null && !taxMethod.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("taxMethod", (Object)taxMethod, CompareType.EQUALS));
        }
        FilterItemInfo filterItem = new FilterItemInfo("isDefault", (Object)true, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        view.setFilter(filter);
        CalcFormulaCollection calcColl = CalcFormulaFactory.getLocalInstance(ctx).getCalcFormulaCollection(view);
        if (calcColl != null && calcColl.size() > 0) {
            return calcColl.get(0);
        }
        filter.getFilterItems().remove(filterItem);
        view.setFilter(filter);
        calcColl = CalcFormulaFactory.getLocalInstance(ctx).getCalcFormulaCollection(view);
        if (calcColl != null && calcColl.size() > 0) {
            return calcColl.get(0);
        }
        return null;
    }

    @Override
    protected ArrayList _cancel(Context ctx, Set ids) throws BOSException, EASBizException {
        int i;
        StringBuffer idStr = new StringBuffer();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        CalcFormulaCollection collection = CalcFormulaFactory.getLocalInstance(ctx).getCalcFormulaCollection(view);
        ArrayList<String> error = new ArrayList<String>();
        IObjectPK logPk = null;
        ArrayList<IObjectPK> logPkList = new ArrayList<IObjectPK>();
        if (collection.size() > 0) {
            for (i = 0; i < collection.size(); ++i) {
                CalcFormulaInfo info = collection.get(i);
                logPk = LogUtils.beginLog(ctx, "cancel", BOSObjectType.create((String)"6C3ED36E"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "estateData_calcFormula_cancel", info.getCU().getId().toString());
                if (EstStateEnum.FORBIDDEN.equals((Object)info.getState())) {
                    error.add(info.getNumber() + ":" + TDUtils.getString(RES, "Error_Cancel", ctx.getLocale()));
                    continue;
                }
                idStr.append("'").append(info.getId().toString()).append("',");
                logPkList.add(logPk);
            }
        }
        if (!StringUtils.isEmpty((String)idStr.toString())) {
            String sql = "UPDATE T_TD_CalcFormula SET FState = 0 WHERE FID IN (" + idStr.toString().substring(0, idStr.toString().length() - 1) + ")";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        int j = logPkList.size();
        for (i = 0; i < j; ++i) {
            LogUtils.afterLog(ctx, (IObjectPK)logPkList.get(i));
        }
        return error;
    }

    @Override
    protected ArrayList _cancelCancel(Context ctx, Set ids) throws BOSException, EASBizException {
        int i;
        String idStr = "";
        ArrayList<String> error = new ArrayList<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        CalcFormulaCollection coll = this.getCalcFormulaCollection(ctx, view);
        IObjectPK logPk = null;
        ArrayList<IObjectPK> logPkList = new ArrayList<IObjectPK>();
        int size = coll.size();
        for (i = 0; i < size; ++i) {
            CalcFormulaInfo info = coll.get(i);
            logPk = LogUtils.beginLog(ctx, "cancelcancel", BOSObjectType.create((String)"6C3ED36E"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "estateData_calcFormula_cancelcancel", info.getCU().getId().toString());
            if (EstStateEnum.USING.equals((Object)info.getState())) {
                error.add(info.getNumber() + ":" + TDUtils.getString(RES, "Error_Cancelcancel", ctx.getLocale()));
                continue;
            }
            idStr = idStr + "'" + info.getId().toString() + "',";
            logPkList.add(logPk);
        }
        if (!StringUtils.isEmpty((String)idStr)) {
            StringBuffer sb = new StringBuffer();
            idStr = idStr.substring(0, idStr.length() - 1);
            sb.append("UPDATE T_TD_CalcFormula SET FState = 1 WHERE FID IN (").append(idStr).append(")");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        int j = logPkList.size();
        for (i = 0; i < j; ++i) {
            LogUtils.afterLog(ctx, (IObjectPK)logPkList.get(i));
        }
        return error;
    }

    @Override
    protected ArrayList _deleteBatch(Context ctx, Set ids) throws BOSException, EASBizException {
        ArrayList<String> error = new ArrayList<String>();
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)iterator.next().toString()));
            CalcFormulaInfo info = this.getCalcFormulaInfo(ctx, (IObjectPK)pk);
            try {
                IObjectPK logPk = LogUtils.beginLog(ctx, "delete", BOSObjectType.create((String)"6C3ED36E"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "estateData_calcFormula_delete", info.getCU().getId().toString());
                this._delete(ctx, (IObjectPK)pk);
                LogUtils.afterLog(ctx, logPk);
            }
            catch (Exception e) {
                error.add(info.getNumber() + ":" + e.getMessage());
            }
        }
        return error;
    }
}

