/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.est.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.common.perf.CreateJobFacadeFactory;
import com.kingdee.eas.basedata.common.perf.ICreateJobFacade;
import com.kingdee.eas.basedata.common.perf.JobConfig;
import com.kingdee.eas.basedata.common.perf.JobParam;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftRecordCollection;
import com.kingdee.eas.tm.td.est.EstCalculateRecordCollection;
import com.kingdee.eas.tm.td.est.EstCalculateRecordInfo;
import com.kingdee.eas.tm.td.est.RealEstateGroupEntryInfo;
import com.kingdee.eas.tm.td.est.app.AbstractESTFacadeControllerBean;
import com.kingdee.eas.tm.td.est.util.EstReportHelper;
import com.kingdee.eas.tm.td.est.util.EstTaxDeclareParam;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.BaseException;
import com.kingdee.util.LowTimer;
import com.kingdee.util.NumericExceptionSubItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ESTFacadeControllerBean
extends AbstractESTFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.est.app.ESTFacadeControllerBean");

    @Override
    protected Map _calculateAndDeclare(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Set companyIds = (Set)params.get("companyIds");
        Integer periodFrom = (Integer)params.get("periodFrom");
        Integer periodTo = (Integer)params.get("periodTo");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)companyIds, CompareType.INCLUDE));
        view.setFilter(filter);
        CompanyOrgUnitCollection companyColl = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        ICreateJobFacade iJob = CreateJobFacadeFactory.getLocalInstance((Context)ctx);
        ArrayList<String> errorList = new ArrayList<String>();
        ArrayList<Map> jobList = new ArrayList<Map>();
        for (int i = 0; i < companyColl.size(); ++i) {
            CompanyOrgUnitInfo company = companyColl.get(i);
            JobConfig jobCfg = this.creteJobCfg(ctx, company, periodFrom, periodTo);
            if (iJob.checkDuplicateTask(jobCfg.getTaskType())) {
                errorList.add(TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Error_DuplicatedTask", ctx.getLocale(), new Object[]{company.getName()}));
                continue;
            }
            HashMap<String, Object> jobParam = new HashMap<String, Object>();
            jobParam.putAll(params);
            jobParam.put("company", company);
            jobParam.put("context", ctx);
            jobParam.put("title", jobCfg.getTitle());
            Map jobMap = iJob.executeJob(new JobParam(jobParam), jobCfg);
            jobMap.put("title", jobCfg.getTitle());
            jobList.add(jobMap);
        }
        if (errorList.size() > 0) {
            resultMap.put("error", TDUtils.buildErrorMsg(errorList));
        }
        resultMap.put("jobList", jobList);
        return resultMap;
    }

    private JobConfig creteJobCfg(Context ctx, CompanyOrgUnitInfo company, Integer periodForm, Integer periodTo) {
        String title = TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Msg_CalculaterTitle", ctx.getLocale(), new Object[]{company.getName(), periodForm.toString(), periodTo.toString()});
        String taskType = "TD_CALC_0004" + company.getId().toString();
        JobConfig jobCfg = new JobConfig();
        jobCfg.setNumber("TD_CALC_0004");
        jobCfg.setTitle(title);
        jobCfg.setDescription(title);
        jobCfg.setTaskType(taskType);
        jobCfg.setNeedCheckTaskType(false);
        jobCfg.setMutex("ESTCalculateAndDeclare");
        return jobCfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _autoCreateReport(Context ctx, Map params) throws BOSException, EASBizException {
        int accountCount;
        int taxDeclareCount;
        ArrayList<String> exceptionIds;
        HashMap<String, Throwable> exceptionMap;
        Map exceptionNumber;
        LowTimer timer;
        block11: {
            timer = new LowTimer();
            timer.reset();
            Set companyIds = (Set)params.get("companyIds");
            Set groupIds = (Set)params.get("groupIds");
            int periodFrom = (Integer)params.get("periodFrom");
            int periodTo = (Integer)params.get("periodTo");
            List<String> ids = EstReportHelper.getCreateReportRange(ctx, companyIds, periodFrom, periodTo);
            exceptionNumber = EstReportHelper.getExceptionNumber(ctx, ids);
            IMutexServiceControl mutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            exceptionMap = new HashMap<String, Throwable>();
            exceptionIds = new ArrayList<String>();
            taxDeclareCount = 0;
            accountCount = 0;
            try {
                Map map = mutexServiceControl.batchRequestObjIDForUpdate(ids);
                Iterator<String> lt = ids.iterator();
                while (lt.hasNext()) {
                    String id = lt.next();
                    Object value = map.get(id);
                    if (value == null || Boolean.valueOf(value.toString()).booleanValue()) continue;
                    String mutexMsg = ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource", (String)"Error_ObjectUpdateLock_Request", (Locale)ctx.getLocale());
                    EASBizException mutexException = new EASBizException(new NumericExceptionSubItem("100", mutexMsg));
                    exceptionMap.put(id, mutexException);
                    exceptionIds.add(id);
                    lt.remove();
                }
                if (ids.size() <= 0) break block11;
                BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[ids.size()];
                HashMap<String, Object> pm = null;
                for (int i = 0; i < ids.size(); ++i) {
                    BatchExecuteParamsEntry entry;
                    if (ids.get(i) == null) continue;
                    pm = new HashMap<String, Object>();
                    pm.put("id", ids.get(i));
                    pm.put("groupIds", groupIds);
                    paramEntries[i] = entry = new BatchExecuteParamsEntry(new Class[]{Map.class}, new Object[]{pm});
                }
                BatchExecuteResult result = null;
                Throwable[] ex = null;
                Object[] rets = null;
                try {
                    int i;
                    IBizCtrl bizCtrl = (IBizCtrl)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSObjectType.create((String)"9797071D"));
                    result = bizCtrl.batchExecute("createReport", new Class[]{Map.class}, paramEntries);
                    ex = result.getExceptions();
                    for (i = 0; i < ex.length; ++i) {
                        if (ex[i] == null) continue;
                        exceptionMap.put(ids.get(i), ex[i]);
                        exceptionIds.add(ids.get(i));
                    }
                    rets = result.getReturnValues();
                    for (i = 0; i < rets.length; ++i) {
                        if (rets[i] == null) continue;
                        taxDeclareCount += ((Integer)((Map)rets[i]).get("taxDeclareCount")).intValue();
                        accountCount += ((Integer)((Map)rets[i]).get("accountCount")).intValue();
                    }
                }
                catch (BaseException e) {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
            }
            finally {
                mutexServiceControl.batchReleaseObjIDForUpdate(ids);
            }
        }
        ArrayList<String> errorMsg = new ArrayList<String>();
        if (exceptionIds.size() > 0) {
            for (String id : exceptionIds) {
                errorMsg.add(exceptionNumber.get(id) + ":" + ((Throwable)exceptionMap.get(id)).getMessage());
            }
        }
        logger.error((Object)("\u81ea\u52a8\u751f\u6210\u7533\u62a5\u8868\uff0c\u82b1\u8d39\uff1a" + timer.msValue()));
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        ret.put("taxDeclareCount", Integer.valueOf(taxDeclareCount));
        ret.put("accountCount", Integer.valueOf(accountCount));
        ret.put("errorMsg", errorMsg);
        return ret;
    }

    @Override
    protected Map _createReport(Context ctx, Map params) throws BOSException, EASBizException {
        String id = (String)params.get("id");
        Set groupIds = (Set)params.get("groupIds");
        String[] arr = id.split("_");
        String companyID = arr[0];
        String taxPeriodID = arr[1];
        HashMap<String, Integer> retMap = new HashMap<String, Integer>();
        retMap.put("accountCount", 0);
        retMap.put("taxDeclareCount", 0);
        EstReportHelper.removeOldReport(ctx, companyID, taxPeriodID, groupIds);
        EstCalculateRecordCollection recordColl = EstReportHelper.getEstCalculateRecordColl(ctx, companyID, taxPeriodID, groupIds);
        EstCalculateRecordInfo recordInfo = null;
        if (recordColl.size() == 0) {
            return retMap;
        }
        Map<String, RealEstateGroupEntryInfo> groupEntryMap = EstReportHelper.initRealEstateGroupEntryMap(ctx, recordColl);
        TaxDraftRecordCollection accountColl = new TaxDraftRecordCollection();
        TaxDraftRecordCollection taxDeclareColl = new TaxDraftRecordCollection();
        HashMap accountMap = new HashMap();
        HashMap taxDeclareMap = new HashMap();
        HashMap<String, EstTaxDeclareParam> estParamMap = new HashMap<String, EstTaxDeclareParam>();
        String estSheetName = TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "EstSheetName", ctx.getLocale());
        String vatSheetName = TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "VatSheetName", ctx.getLocale());
        String vatAddSheetName = TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "VatAddSheetName", ctx.getLocale());
        String[] vatSheetNames = new String[]{vatSheetName, vatAddSheetName};
        int size = recordColl.size();
        for (int i = 0; i < size; ++i) {
            EstTaxDeclareParam param;
            recordInfo = recordColl.get(i);
            EstReportHelper.createAccountReport(ctx, recordInfo, accountColl, groupEntryMap, accountMap);
            EstReportHelper.createTaxDeclareReport(ctx, recordInfo, taxDeclareColl, groupEntryMap, taxDeclareMap);
            String taxItemTypeID = recordInfo.getTaxItemType().getId().toString();
            if (!"ZCyrvv6oAnPgU0ETqMCc49uK96Y=".equals(taxItemTypeID) && !"d8umkg7qNn3gU0ETqMCsX9uK96Y=".equals(taxItemTypeID) && !"Xip0em3cA6rgU0ETqMAGKduK96Y=".equals(taxItemTypeID)) continue;
            String key = EstReportHelper.getTaxDeclareKey(recordInfo);
            if (estParamMap.containsKey(key)) {
                param = (EstTaxDeclareParam)estParamMap.get(key);
            } else {
                param = new EstTaxDeclareParam(key);
                estParamMap.put(key, param);
            }
            param.addRecord(recordInfo);
        }
        for (EstTaxDeclareParam param : estParamMap.values()) {
            EstReportHelper.taxDeclareEstHandle(ctx, param, taxDeclareMap, estSheetName);
            EstReportHelper.taxDeclareVatHandle(ctx, param, taxDeclareMap, vatSheetNames);
        }
        try {
            EstReportHelper.saveAndCalcReport(ctx, accountColl, taxDeclareColl);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        retMap.put("accountCount", accountColl.size());
        retMap.put("taxDeclareCount", taxDeclareColl.size());
        return retMap;
    }
}

