/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.est.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.RefCheckerFactory;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.est.EstStateEnum;
import com.kingdee.eas.tm.td.est.LandDataCollection;
import com.kingdee.eas.tm.td.est.LandDataFactory;
import com.kingdee.eas.tm.td.est.LandDataInfo;
import com.kingdee.eas.tm.td.est.MonthEnum;
import com.kingdee.eas.tm.td.est.app.AbstractLandDataControllerBean;
import com.kingdee.eas.tm.td.utils.LogUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class LandDataControllerBean
extends AbstractLandDataControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.est.app.LandDataControllerBean");

    private String getResource(String proper, Context ctx) {
        return ResourceBase.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)proper, (Locale)ctx.getLocale());
    }

    private void checkBeforeSubmit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        if (model == null) {
            throw new TDException(TDException.ERROR_MSG, new Object[]{this.getResource("EntityNotNull", ctx)});
        }
        this._checkNumberDup(ctx, null, model);
        LandDataInfo info = (LandDataInfo)model;
        StringBuffer sb = new StringBuffer();
        if (info.getCompany() == null) {
            sb.append(this.getResource("Company", ctx));
        }
        if (StringUtils.isEmpty((String)info.getNumber())) {
            sb.append(this.getResource("Calc_Number", ctx));
        }
        if (info.getRealEstateGroup() == null) {
            sb.append(this.getResource("RealEstateGroup", ctx));
        }
        if (StringUtils.isEmpty((String)info.getName())) {
            sb.append(this.getResource("LandName", ctx));
        }
        if (info.getLandTime() == null) {
            sb.append(this.getResource("LandTime", ctx));
        }
        if (info.getState() == null) {
            sb.append(this.getResource("State", ctx));
        }
        if (StringUtils.isEmpty((String)info.getArea().toString())) {
            sb.append(this.getResource("Area", ctx));
        }
        if (StringUtils.isEmpty((String)info.getTaxStandard().toString())) {
            sb.append(this.getResource("Tax", ctx));
        }
        if (info.getTaxCycle() == null) {
            sb.append(this.getResource("StatePeriod", ctx));
        }
        if (info.getFirstPaymentMonth() == null || MonthEnum.Null.equals((Object)info.getFirstPaymentMonth())) {
            sb.append(this.getResource("FirstPaymentMonth", ctx));
        }
        if (info.getCalcFormula() == null) {
            sb.append(this.getResource("CalcFormula", ctx));
        }
        if (sb.length() > 0) {
            sb.append(this.getResource("NOTNULL", ctx));
            throw new TDException(TDException.ERROR_MSG, new Object[]{sb.toString().substring(1)});
        }
    }

    protected boolean _checkNumberDup(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        boolean exists;
        LandDataInfo info = (LandDataInfo)model;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
        if (info.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (exists = LandDataFactory.getLocalInstance(ctx).exists(filterInfo)) {
            String str = ResourceBase.getString((String)"com.kingdee.eas.tm.td.TDCommonResource", (String)"EXIST_SAME_NUMBER", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{info.getNumber()});
            throw new TDException(TDException.ERROR_MSG, new Object[]{str});
        }
        return true;
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LandDataInfo info = (LandDataInfo)model;
        info.setId(BOSUuid.create((String)"A4484738"));
        IObjectPK logPk = LogUtils.beginLog(ctx, "addNew", BOSObjectType.create((String)"A4484738"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "landData_new", info.getCompany().getId().toString());
        IObjectPK pk = super._addnew(ctx, model);
        LogUtils.afterLog(ctx, logPk);
        return pk;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        LandDataInfo info = (LandDataInfo)model;
        IObjectPK logPk = LogUtils.beginLog(ctx, "edit", BOSObjectType.create((String)"A4484738"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "landData_edit", info.getCompany().getId().toString());
        super._update(ctx, pk, model);
        LogUtils.afterLog(ctx, logPk);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkBeforeSubmit(ctx, model);
        return super._submit(ctx, model);
    }

    @Override
    protected ArrayList _deleteBatch(Context ctx, Set ids) throws BOSException, EASBizException {
        ArrayList<String> error = new ArrayList<String>();
        Iterator iterator = ids.iterator();
        IObjectPK logPk = null;
        while (iterator.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)iterator.next().toString()));
            LandDataInfo info = this.getLandDataInfo(ctx, (IObjectPK)pk);
            if (EstStateEnum.USING.equals((Object)info.getState())) {
                error.add(info.getNumber() + "\uff1a" + TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Error_USINGDelete", ctx.getLocale()));
                continue;
            }
            try {
                logPk = LogUtils.beginLog(ctx, "delete", BOSObjectType.create((String)"A4484738"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "landData_delete", info.getCompany().getId().toString());
                this.delete(ctx, (IObjectPK)pk);
                LogUtils.afterLog(ctx, logPk);
            }
            catch (Exception e) {
                error.add(info.getNumber() + ":" + e.getMessage());
            }
        }
        return error;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LandDataInfo info = this.getLandDataInfo(ctx, pk);
        if (EstStateEnum.USING.equals((Object)info.getState())) {
            throw new TDException(TDException.ERROR_MSG, new Object[]{TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Error_USINGDelete", ctx.getLocale())});
        }
        Boolean isReference = RefCheckerFactory.getLocalInstance((Context)ctx).isReferenced(BOSUuid.read((String)pk.toString()));
        if (isReference.booleanValue()) {
            throw new TDException(TDException.ERROR_MSG, new Object[]{TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Error_RefDelete", ctx.getLocale())});
        }
        super._delete(ctx, pk);
    }

    @Override
    protected ArrayList _cancel(Context ctx, Set ids) throws BOSException, EASBizException {
        int i;
        StringBuffer idStr = new StringBuffer();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        LandDataCollection collection = LandDataFactory.getLocalInstance(ctx).getLandDataCollection(view);
        ArrayList<String> error = new ArrayList<String>();
        IObjectPK logPk = null;
        ArrayList<IObjectPK> logPkList = new ArrayList<IObjectPK>();
        if (collection.size() > 0) {
            for (i = 0; i < collection.size(); ++i) {
                LandDataInfo info = collection.get(i);
                logPk = LogUtils.beginLog(ctx, "cancel", BOSObjectType.create((String)"A4484738"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "landData_cancel", info.getCompany().getId().toString());
                if (EstStateEnum.FORBIDDEN.equals((Object)info.getState())) {
                    error.add(info.getNumber() + ":" + TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Error_Cancel", ctx.getOriginLocale()));
                    continue;
                }
                idStr.append("'").append(info.getId().toString()).append("',");
                logPkList.add(logPk);
            }
        }
        if (!StringUtils.isEmpty((String)idStr.toString())) {
            String sql = "UPDATE T_TD_LandData SET FState = 0 WHERE FID IN (" + idStr.toString().substring(0, idStr.toString().length() - 1) + ")";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        int j = logPkList.size();
        for (i = 0; i < j; ++i) {
            LogUtils.afterLog(ctx, (IObjectPK)logPkList.get(i));
        }
        return error;
    }

    @Override
    protected ArrayList _cancelCancel(Context ctx, Set ids) throws BOSException, EASBizException {
        int i;
        String idStr = "";
        ArrayList<String> error = new ArrayList<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        LandDataCollection coll = this.getLandDataCollection(ctx, view);
        IObjectPK logPk = null;
        ArrayList<IObjectPK> logPkList = new ArrayList<IObjectPK>();
        int size = coll.size();
        for (i = 0; i < size; ++i) {
            LandDataInfo info = coll.get(i);
            logPk = LogUtils.beginLog(ctx, "cancelcancel", BOSObjectType.create((String)"A4484738"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "landData_cancelcancel", info.getCompany().getId().toString());
            if (EstStateEnum.USING.equals((Object)info.getState())) {
                error.add(info.getNumber() + ":" + TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Error_Cancelcancel", ctx.getLocale()));
                continue;
            }
            idStr = idStr + "'" + info.getId().toString() + "',";
            logPkList.add(logPk);
        }
        if (!StringUtils.isEmpty((String)idStr)) {
            StringBuffer sb = new StringBuffer();
            idStr = idStr.substring(0, idStr.length() - 1);
            sb.append("UPDATE T_TD_LandData SET FState = 1 WHERE FID IN (").append(idStr).append(")");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        int j = logPkList.size();
        for (i = 0; i < j; ++i) {
            LogUtils.afterLog(ctx, (IObjectPK)logPkList.get(i));
        }
        return error;
    }
}

