/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.est.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.est.EstStateEnum;
import com.kingdee.eas.tm.td.est.EstTaxCycleEnum;
import com.kingdee.eas.tm.td.est.MonthEnum;
import com.kingdee.eas.tm.td.est.RealEstateCollection;
import com.kingdee.eas.tm.td.est.RealEstateFactory;
import com.kingdee.eas.tm.td.est.RealEstateInfo;
import com.kingdee.eas.tm.td.est.app.AbstractRealEstateControllerBean;
import com.kingdee.eas.tm.td.utils.LogUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RealEstateControllerBean
extends AbstractRealEstateControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.est.app.RealEstateControllerBean");

    private String getResource(String proper, Context ctx) {
        return ResourceBase.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)proper, (Locale)ctx.getLocale());
    }

    private void checkBeforeSave(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        this._checkNumberDup(ctx, model);
        RealEstateInfo info = (RealEstateInfo)model;
        StringBuffer sb = new StringBuffer();
        if (info.getCompany() == null) {
            sb.append(this.getResource("Company", ctx));
        }
        if (info.getNumber() == null || info.getNumber().isEmpty()) {
            sb.append(this.getResource("Number", ctx));
        }
        if (info.getRealEstateGroup() == null) {
            sb.append(this.getResource("RealEstateGroup", ctx));
        }
        if (info.getName() == null || info.getName().isEmpty()) {
            sb.append(this.getResource("Name", ctx));
        }
        if (info.getLandData() == null) {
            sb.append(this.getResource("LandData", ctx));
        }
        if (info.getTaxPayerType() == null) {
            sb.append(this.getResource("TaxPayerType", ctx));
        }
        if (info.getPurpose() == null) {
            sb.append(this.getResource("Purpose", ctx));
        }
        if (info.getCalcFormula() == null) {
            sb.append(this.getResource("CalcFormula", ctx));
        }
        if (!EstTaxCycleEnum.ASRENTCYCLE.equals((Object)info.getTaxCycle()) && (info.getFirstPaymentMonth() == null || MonthEnum.Null.equals((Object)info.getFirstPaymentMonth()))) {
            sb.append(this.getResource("FirstPaymentMonth", ctx));
        }
        if (sb.length() > 0) {
            sb.append(this.getResource("NOTNULL", ctx));
            throw new TDException(TDException.ERROR_MSG, new Object[]{sb.toString().substring(1)});
        }
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RealEstateInfo info = (RealEstateInfo)model;
        info.setId(BOSUuid.create((String)"2192DCCD"));
        IObjectPK logPk = LogUtils.beginLog(ctx, "addNew", BOSObjectType.create((String)"2192DCCD"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "estateData_realEstate_new", info.getCompany().getId().toString());
        IObjectPK pk = super._addnew(ctx, model);
        LogUtils.afterLog(ctx, logPk);
        return pk;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RealEstateInfo info = (RealEstateInfo)model;
        this.checkBeforeSave(ctx, model);
        IObjectPK pk = super._save(ctx, model);
        return pk;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RealEstateInfo info = (RealEstateInfo)model;
        this.checkBeforeSave(ctx, model);
        IObjectPK pk = super._submit(ctx, model);
        return pk;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            model = this.getRealEstateInfo(ctx, pk);
        }
        RealEstateInfo info = (RealEstateInfo)model;
        IObjectPK logPk = LogUtils.beginLog(ctx, "edit", BOSObjectType.create((String)"2192DCCD"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "estateData_realEstate_edit", info.getCompany().getId().toString());
        super._update(ctx, pk, (IObjectValue)model);
        LogUtils.afterLog(ctx, logPk);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RealEstateInfo info = (RealEstateInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (info.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        if (super._exists(ctx, filter)) {
            throw new TDException(TDException.ERROR_MSG, new Object[]{this.getResource("Number_Exist", ctx)});
        }
    }

    @Override
    protected ArrayList _batchDelete(Context ctx, Set ids) throws BOSException, EASBizException {
        ArrayList<String> errors = new ArrayList<String>();
        Iterator idIter = ids.iterator();
        while (idIter.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)idIter.next().toString()));
            RealEstateInfo info = this.getRealEstateInfo(ctx, (IObjectPK)pk);
            if (EstStateEnum.USING.equals((Object)info.getState())) {
                errors.add(info.getNumber() + "\uff1a" + TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Error_USINGDelete", ctx.getLocale()));
                continue;
            }
            StringBuffer sql = new StringBuffer();
            String rentalEstateNumber = "";
            sql.append(" SELECT  FRealEstateID,FNumber FROM T_TD_RentalEstate AS rentalEstate  where FRealEstateID = '" + info.getId().toString() + "'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (rs.next()) {
                    rentalEstateNumber = "";
                    rentalEstateNumber = rs.getString("FNumber");
                    errors.add(TDUtils.getString("com.kingdee.eas.tm.td.est.RealEstateResource", "RefDelete_Rentalestate", ctx.getLocale(), new Object[]{info.getNumber(), rentalEstateNumber}));
                    continue;
                }
                super.delete(ctx, (IObjectPK)pk);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return errors;
    }

    @Override
    protected ArrayList _cancel(Context ctx, Set ids) throws BOSException, EASBizException {
        int i;
        String idStr = "";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        RealEstateCollection coll = RealEstateFactory.getLocalInstance(ctx).getRealEstateCollection(view);
        RealEstateInfo info = null;
        ArrayList<String> errors = new ArrayList<String>();
        IObjectPK logPk = null;
        ArrayList<IObjectPK> logPkList = new ArrayList<IObjectPK>();
        for (i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            logPk = LogUtils.beginLog(ctx, "cancel", BOSObjectType.create((String)"2192DCCD"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "estateData_realEstate_cancel", info.getCompany().getId().toString());
            if (!EstStateEnum.USING.equals((Object)info.getState())) {
                errors.add(info.getNumber() + " : " + TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Error_Cancel", ctx.getLocale()));
                continue;
            }
            idStr = idStr + "'" + info.getId().toString() + "',";
            logPkList.add(logPk);
        }
        if (!StringUtils.isEmpty((String)idStr)) {
            StringBuffer sb = new StringBuffer();
            idStr = idStr.substring(0, idStr.length() - 1);
            sb.append("update T_TD_RealEstate set FState = '0' where FID in (").append(idStr).append(")");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        int j = logPkList.size();
        for (i = 0; i < j; ++i) {
            LogUtils.afterLog(ctx, (IObjectPK)logPkList.get(i));
        }
        return errors;
    }

    @Override
    protected ArrayList _cancelCancel(Context ctx, Set ids) throws BOSException, EASBizException {
        int i;
        String idStr = "";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        RealEstateCollection coll = RealEstateFactory.getLocalInstance(ctx).getRealEstateCollection(view);
        RealEstateInfo info = null;
        ArrayList<String> errors = new ArrayList<String>();
        IObjectPK logPk = null;
        ArrayList<IObjectPK> logPkList = new ArrayList<IObjectPK>();
        for (i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            logPk = LogUtils.beginLog(ctx, "cancelcancel", BOSObjectType.create((String)"2192DCCD"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "estateData_realEstate_cancelcancel", info.getCompany().getId().toString());
            if (!EstStateEnum.FORBIDDEN.equals((Object)info.getState())) {
                errors.add(info.getNumber() + " : " + TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Error_Cancelcancel", ctx.getLocale()));
                continue;
            }
            idStr = idStr + "'" + info.getId().toString() + "',";
            logPkList.add(logPk);
        }
        if (!StringUtils.isEmpty((String)idStr)) {
            StringBuffer sb = new StringBuffer();
            idStr = idStr.substring(0, idStr.length() - 1);
            sb.append("update T_TD_RealEstate set FState = '1' where FID in (").append(idStr).append(")");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        int j = logPkList.size();
        for (i = 0; i < j; ++i) {
            LogUtils.afterLog(ctx, (IObjectPK)logPkList.get(i));
        }
        return errors;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        RealEstateInfo info = RealEstateFactory.getLocalInstance(ctx).getRealEstateInfo(pk);
        IObjectPK logPk = LogUtils.beginLog(ctx, "delete", BOSObjectType.create((String)"2192DCCD"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "estateData_realEstate_delete", info.getCompany().getId().toString());
        this.checkBeforeDelete(ctx, info);
        super._delete(ctx, pk);
        LogUtils.afterLog(ctx, logPk);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        RealEstateInfo info = RealEstateFactory.getLocalInstance(ctx).getRealEstateInfo(pk);
        this.checkBeforeCancel(ctx, info);
        info.setState(EstStateEnum.FORBIDDEN);
        super._update(ctx, pk, (IObjectValue)info);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        RealEstateInfo info = RealEstateFactory.getLocalInstance(ctx).getRealEstateInfo(pk);
        this.checkBeforeCancelCancel(ctx, info);
        info.setState(EstStateEnum.USING);
        super._update(ctx, pk, (IObjectValue)info);
    }

    private void checkBeforeDelete(Context ctx, RealEstateInfo info) throws BOSException, EASBizException {
    }

    private void checkBeforeCancel(Context ctx, RealEstateInfo info) throws BOSException, EASBizException {
        if (!EstStateEnum.USING.equals((Object)info.getState())) {
            throw new TDException(TDException.ERROR_MSG, new Object[]{this.getResource("Error_Cancel", ctx)});
        }
    }

    private void checkBeforeCancelCancel(Context ctx, RealEstateInfo info) throws BOSException, EASBizException {
        if (EstStateEnum.USING.equals((Object)info.getState())) {
            throw new TDException(TDException.ERROR_MSG, new Object[]{this.getResource("Error_Cancelcancel", ctx)});
        }
    }

    @Override
    protected Map _getRentArea(Context ctx, String id, List dateList) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        String day = "01";
        String Separator = "-";
        try {
            for (int i = 0; i < dateList.size(); ++i) {
                String date = dateList.get(i).toString() + day;
                StringBuffer sql = new StringBuffer();
                sql.append(" Select sum(rental.FRentalArea) area From T_TD_RealEstate real ").append(" Left Join T_TD_RentalEstate rental on real.FID = rental.FRealEstateID ").append(" Left Join T_TD_ContractEntry contract on rental.FID = contract.FRentalEstateID ").append(" Where rental.FState = '").append("1").append("' ").append(" And contract.FState = '").append("1").append("' ").append(" And {d'").append(date.substring(0, 4)).append(Separator).append(date.substring(4, 6)).append(Separator).append(date.substring(6, 8)).append("'} between contract.FirstDate and contract.FLastDate ").append(" And real.FID = '").append(id).append("' ");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (!rs.next()) continue;
                result.put(dateList.get(i), rs.getBigDecimal("area") == null ? BigDecimal.ZERO : rs.getBigDecimal("area"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }
}

