/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.est.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.RefCheckerFactory;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.cloud.TDCloudException;
import com.kingdee.eas.tm.td.est.EstStateEnum;
import com.kingdee.eas.tm.td.est.RentalEstateCollection;
import com.kingdee.eas.tm.td.est.RentalEstateFactory;
import com.kingdee.eas.tm.td.est.RentalEstateInfo;
import com.kingdee.eas.tm.td.est.app.AbstractRentalEstateControllerBean;
import com.kingdee.eas.tm.td.utils.LogUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class RentalEstateControllerBean
extends AbstractRentalEstateControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.est.app.RentalEstateControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RentalEstateInfo info = (RentalEstateInfo)model;
        info.setId(BOSUuid.create((String)"AD4C3F13"));
        IObjectPK logPk = LogUtils.beginLog(ctx, "addNew", BOSObjectType.create((String)"AD4C3F13"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "estateData_rentalEstate_new", info.getCompany().getId().toString());
        IObjectPK pk = super._addnew(ctx, model);
        LogUtils.afterLog(ctx, logPk);
        return pk;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkBefore(ctx, model);
        return super._save(ctx, model);
    }

    private void checkBefore(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        this._checkNumberDup(ctx, model);
        RentalEstateInfo info = (RentalEstateInfo)model;
        StringBuffer sb = new StringBuffer();
        if (info.getCompany() == null) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"Company"));
        }
        if (info.getNumber() == null || info.getNumber().isEmpty()) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"Number"));
        }
        if (info.getRealEstate() == null) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"RealEstate"));
        }
        if (info.getName() == null || info.getName().isEmpty()) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"Name"));
        }
        if (sb.length() > 0) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"NOTNULL"));
            throw new TDException(TDException.ERROR_MSG, new Object[]{sb.toString().substring(1)});
        }
    }

    private String getResource(String proper, Context ctx) {
        return ResourceBase.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)proper, (Locale)ctx.getLocale());
    }

    private String getResource(String proper, Context ctx, Object[] params) {
        return ResourceBase.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)proper, (Locale)ctx.getLocale(), (Object[])params);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkBefore(ctx, model);
        return super._submit(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            model = this.getRentalEstateInfo(ctx, pk);
        }
        RentalEstateInfo info = (RentalEstateInfo)model;
        IObjectPK logPk = LogUtils.beginLog(ctx, "edit", BOSObjectType.create((String)"AD4C3F13"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "estateData_rentalEstate_edit", info.getCompany().getId().toString());
        super._update(ctx, pk, (IObjectValue)model);
        LogUtils.afterLog(ctx, logPk);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RentalEstateInfo info = (RentalEstateInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (info.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        if (super._exists(ctx, filter)) {
            throw new TDCloudException(TDCloudException.NUMBER_EXIST_ERROR, new Object[]{info.getNumber()});
        }
    }

    @Override
    protected ArrayList _batchDelete(Context ctx, Set ids) throws BOSException, EASBizException {
        ArrayList<String> errors = new ArrayList<String>();
        Iterator idIter = ids.iterator();
        while (idIter.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)idIter.next().toString()));
            RentalEstateInfo info = this.getRentalEstateInfo(ctx, (IObjectPK)pk);
            try {
                RentalEstateFactory.getLocalInstance(ctx).delete((IObjectPK)pk);
            }
            catch (Exception e) {
                errors.add(info.getNumber() + ":" + e.getMessage());
            }
        }
        return errors;
    }

    @Override
    protected ArrayList _cancel(Context ctx, Set ids) throws BOSException, EASBizException {
        int i;
        String idStr = "";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        RentalEstateCollection coll = RentalEstateFactory.getLocalInstance(ctx).getRentalEstateCollection(view);
        RentalEstateInfo info = null;
        ArrayList<String> errors = new ArrayList<String>();
        IObjectPK logPk = null;
        ArrayList<IObjectPK> logPkList = new ArrayList<IObjectPK>();
        for (i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            logPk = LogUtils.beginLog(ctx, "cancel", BOSObjectType.create((String)"AD4C3F13"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "estateData_rentalEstate_cancel", info.getCompany().getId().toString());
            if (!EstStateEnum.USING.equals((Object)info.getState())) {
                errors.add(info.getNumber() + " : " + TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Error_Cancel", ctx.getLocale()));
                continue;
            }
            idStr = idStr + "'" + info.getId().toString() + "',";
            logPkList.add(logPk);
        }
        if (!StringUtils.isEmpty((String)idStr)) {
            StringBuffer sb = new StringBuffer();
            idStr = idStr.substring(0, idStr.length() - 1);
            sb.append("update T_TD_RentalEstate set FState = '0' where FID in (").append(idStr).append(")");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        int j = logPkList.size();
        for (i = 0; i < j; ++i) {
            LogUtils.afterLog(ctx, (IObjectPK)logPkList.get(i));
        }
        return errors;
    }

    @Override
    protected ArrayList _cancelCancel(Context ctx, Set ids) throws BOSException, EASBizException {
        int i;
        String idStr = "";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        RentalEstateCollection coll = RentalEstateFactory.getLocalInstance(ctx).getRentalEstateCollection(view);
        RentalEstateInfo info = null;
        ArrayList<String> errors = new ArrayList<String>();
        IObjectPK logPk = null;
        ArrayList<IObjectPK> logPkList = new ArrayList<IObjectPK>();
        for (i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            logPk = LogUtils.beginLog(ctx, "cancelcancel", BOSObjectType.create((String)"AD4C3F13"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "estateData_rentalEstate_cancelcancel", info.getCompany().getId().toString());
            if (!EstStateEnum.FORBIDDEN.equals((Object)info.getState())) {
                errors.add(info.getNumber() + " : " + TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Error_Cancelcancel", ctx.getLocale()));
                continue;
            }
            idStr = idStr + "'" + info.getId().toString() + "',";
            logPkList.add(logPk);
        }
        if (!StringUtils.isEmpty((String)idStr)) {
            StringBuffer sb = new StringBuffer();
            idStr = idStr.substring(0, idStr.length() - 1);
            sb.append("update T_TD_RentalEstate set FState = '1' where FID in (").append(idStr).append(")");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        int j = logPkList.size();
        for (i = 0; i < j; ++i) {
            LogUtils.afterLog(ctx, (IObjectPK)logPkList.get(i));
        }
        return errors;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        RentalEstateInfo info = RentalEstateFactory.getLocalInstance(ctx).getRentalEstateInfo(pk);
        try {
            IObjectPK logPk = LogUtils.beginLog(ctx, "delete", BOSObjectType.create((String)"AD4C3F13"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "estateData_rentalEstate_delete", info.getCompany().getId().toString());
            this.checkBeforeDelete(ctx, info);
            super._delete(ctx, pk);
            LogUtils.afterLog(ctx, logPk);
        }
        catch (Exception e) {
            throw new TDException(TDException.ERROR_MSG, new Object[]{e.getMessage()});
        }
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        RentalEstateInfo info = RentalEstateFactory.getLocalInstance(ctx).getRentalEstateInfo(pk);
        this.checkBeforeCancel(ctx, info);
        info.setState(EstStateEnum.FORBIDDEN);
        super._update(ctx, pk, (IObjectValue)info);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        RentalEstateInfo info = RentalEstateFactory.getLocalInstance(ctx).getRentalEstateInfo(pk);
        this.checkBeforeCancelCancel(ctx, info);
        info.setState(EstStateEnum.USING);
        super._update(ctx, pk, (IObjectValue)info);
    }

    private void checkBeforeDelete(Context ctx, RentalEstateInfo info) throws BOSException, EASBizException {
        if (EstStateEnum.USING.equals((Object)info.getState())) {
            throw new TDException(TDException.ERROR_MSG, new Object[]{TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Error_USINGDelete", ctx.getLocale())});
        }
        Boolean isReference = RefCheckerFactory.getLocalInstance((Context)ctx).isReferenced(BOSUuid.read((String)info.getId().toString()));
        if (isReference.booleanValue()) {
            throw new TDException(TDException.ERROR_MSG, new Object[]{TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Error_RefDelete", ctx.getLocale())});
        }
    }

    private void checkBeforeCancel(Context ctx, RentalEstateInfo info) throws BOSException, EASBizException {
        if (!EstStateEnum.USING.equals((Object)info.getState())) {
            throw new TDCloudException(TDCloudException.CANCEL_STATUS_ERROR);
        }
    }

    private void checkBeforeCancelCancel(Context ctx, RentalEstateInfo info) throws BOSException, EASBizException {
        if (EstStateEnum.USING.equals((Object)info.getState())) {
            throw new TDCloudException(TDCloudException.CANCELCANCEL_STATUS_ERROR);
        }
    }
}

