/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.est.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.message.BMCMessageFactory;
import com.kingdee.eas.base.message.BMCMessageInfo;
import com.kingdee.eas.base.message.MsgBizType;
import com.kingdee.eas.base.message.MsgPriority;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.common.perf.JobParam;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.est.ESTFacadeFactory;
import com.kingdee.eas.tm.td.est.EstStateEnum;
import com.kingdee.eas.tm.td.est.LandDataCollection;
import com.kingdee.eas.tm.td.est.LandDataFactory;
import com.kingdee.eas.tm.td.est.RealEstateCollection;
import com.kingdee.eas.tm.td.est.RealEstateFactory;
import com.kingdee.eas.tm.td.est.util.EstCalcStrategy;
import com.kingdee.eas.tm.td.est.util.EstConstant;
import com.kingdee.eas.tm.td.est.util.LandDataStrategy;
import com.kingdee.eas.tm.td.utils.LogUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EstCalculaterHandler
implements IJobHandler {
    public Object execute(Job job) throws Exception {
        HashMap calcResult = new HashMap();
        JobParam jobParam = (JobParam)job.getParameters();
        Map params = (Map)jobParam.getBizParam();
        Context ctx = (Context)params.get("context");
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.get("company");
        Set groupIds = (Set)params.get("groupIds");
        Boolean isCalculate = (Boolean)params.get("isCalculate");
        Boolean isCreateReport = (Boolean)params.get("isCreateReport");
        int periodFrom = (Integer)params.get("periodFrom");
        int periodTo = (Integer)params.get("periodTo");
        PeriodInfo period = (PeriodInfo)params.get("period");
        ArrayList errorList = new ArrayList();
        StringBuffer msgBody = new StringBuffer();
        if (isCalculate.booleanValue()) {
            int i;
            PeriodCollection periodRange;
            if (period != null) {
                periodRange = new PeriodCollection();
                periodRange.add(period);
            } else {
                periodRange = this.getPeriodCollection(ctx, periodFrom, periodTo, company);
            }
            RealEstateCollection realEstateRange = this.getRealEstateCollection(ctx, company, groupIds);
            LandDataCollection landDataRange = this.getLandDataCollection(ctx, company, groupIds);
            if (periodRange.isEmpty() || realEstateRange.isEmpty() && landDataRange.isEmpty()) {
                throw new TDException(TDException.ERROR_MSG, new Object[]{TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Error_NullToCalc", ctx.getLocale())});
            }
            ArrayList<String> periodList = new ArrayList<String>();
            ArrayList<String> realEstateList = new ArrayList<String>();
            ArrayList<String> landDataList = new ArrayList<String>();
            for (i = 0; i < periodRange.size(); ++i) {
                periodList.add(periodRange.get(i).getId().toString());
            }
            for (i = 0; i < realEstateRange.size(); ++i) {
                realEstateList.add(realEstateRange.get(i).getId().toString());
            }
            for (i = 0; i < landDataRange.size(); ++i) {
                landDataList.add(landDataRange.get(i).getId().toString());
            }
            this.deleteBeforeCalc(ctx, periodList, realEstateList, landDataList);
            IObjectPK logPk = null;
            for (int i2 = 0; i2 < periodRange.size(); ++i2) {
                Map result;
                Object strategy;
                int j;
                for (j = 0; j < realEstateRange.size(); ++j) {
                    logPk = LogUtils.beginLog(ctx, "edit", BOSObjectType.create((String)"2192DCCD"), (IObjectPK)new ObjectUuidPK(realEstateRange.get(j).getId().toString()), realEstateRange.get(j).getNumber(), "estateData_estCalculateRecord_calculate", realEstateRange.get(j).getCompany().getId().toString());
                    strategy = new EstCalcStrategy(ctx, realEstateRange.get(j), periodRange.get(i2));
                    result = ((EstCalcStrategy)strategy).doCalc();
                    if (result.get("errorMsg") != null) {
                        errorList.add(result.get("errorMsg"));
                        continue;
                    }
                    LogUtils.afterLog(ctx, logPk);
                }
                for (j = 0; j < landDataRange.size(); ++j) {
                    logPk = LogUtils.beginLog(ctx, "edit", BOSObjectType.create((String)"A4484738"), (IObjectPK)new ObjectUuidPK(landDataRange.get(j).getId().toString()), landDataRange.get(j).getNumber(), "estateData_estCalculateRecord_calculate", landDataRange.get(j).getCompany().getId().toString());
                    strategy = new LandDataStrategy(ctx, landDataRange.get(j), periodRange.get(i2));
                    result = ((LandDataStrategy)strategy).doCalc();
                    if (result.get("errorMsg") != null) {
                        errorList.add(result.get("errorMsg"));
                        continue;
                    }
                    LogUtils.afterLog(ctx, logPk);
                }
            }
            msgBody.append(TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Msg_CalculateComplete", ctx.getLocale(), new Object[]{company.getName(), periodFrom, periodTo}));
            msgBody.append(EstConstant.NEWLINE);
            msgBody.append(TDUtils.buildErrorMsg(errorList));
        }
        if (isCreateReport.booleanValue()) {
            HashMap<String, Object> reportParams = new HashMap<String, Object>();
            HashSet<String> companyIds = new HashSet<String>();
            companyIds.add(company.getId().toString());
            reportParams.put("groupIds", groupIds);
            reportParams.put("companyIds", companyIds);
            reportParams.put("periodFrom", periodFrom);
            reportParams.put("periodTo", periodTo);
            Map reportResult = ESTFacadeFactory.getLocalInstance(ctx).autoCreateReport(reportParams);
            int accountCount = (Integer)reportResult.get("accountCount");
            int taxDeclareCount = (Integer)reportResult.get("taxDeclareCount");
            msgBody.append(TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Msg_CreateReportComplete", ctx.getLocale(), new Object[]{company.getName(), periodFrom, periodTo, accountCount, taxDeclareCount}));
            msgBody.append(EstConstant.NEWLINE);
            msgBody.append(TDUtils.buildErrorMsg((ArrayList)reportResult.get("errorMsg")));
        }
        this.sendMsg(ctx, (String)params.get("title"), msgBody.toString());
        return calcResult;
    }

    private void deleteBeforeCalc(Context ctx, List periodList, List realEstateList, ArrayList landDataList) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" Delete From T_TD_EstCalculateRecord ");
        sql.append(" where FTaxPeriodID in ").append(TDUtils.getInStringFromList(periodList)).append(" ");
        StringBuffer andSql = new StringBuffer();
        if (realEstateList.size() > 0) {
            andSql.append(" and ( FRealEstateID in ").append(TDUtils.getInStringFromList(realEstateList)).append(" ");
        }
        if (landDataList.size() > 0) {
            if (andSql.length() > 0) {
                andSql.append(" or FLandDataID in ").append(TDUtils.getInStringFromList(landDataList)).append(" ");
            } else {
                andSql.append(" and ( FLandDataID in ").append(TDUtils.getInStringFromList(landDataList)).append(" ");
            }
        }
        andSql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.append(andSql).toString());
    }

    private RealEstateCollection getRealEstateCollection(Context ctx, CompanyOrgUnitInfo company, Set groupIds) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"1"));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isReference", (Object)true, CompareType.EQUALS));
        if (groupIds != null && !groupIds.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("realEstateGroup.id", (Object)groupIds, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        view.setSelector(this.getRealEstateSelector());
        ctx.put((Object)"disablePermissionForKScript", (Object)true);
        RealEstateCollection collection = RealEstateFactory.getLocalInstance(ctx).getRealEstateCollection(view);
        ctx.remove((Object)"disablePermissionForKScript");
        return collection;
    }

    private LandDataCollection getLandDataCollection(Context ctx, CompanyOrgUnitInfo company, Set groupIds) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)EstStateEnum.USING));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
        if (groupIds != null && !groupIds.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("realEstateGroup.id", (Object)groupIds, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        view.setSelector(this.getLandDataSelector());
        ctx.put((Object)"disablePermissionForKScript", (Object)true);
        LandDataCollection collection = LandDataFactory.getLocalInstance(ctx).getLandDataCollection(view);
        ctx.remove((Object)"disablePermissionForKScript");
        return collection;
    }

    private PeriodCollection getPeriodCollection(Context ctx, int periodFrom, int periodTo, CompanyOrgUnitInfo company) throws BOSException {
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo periodFilter = new FilterInfo();
            StringBuffer sql = new StringBuffer();
            sql.append(" Select Period.FID from T_BD_PERIOD Period ");
            sql.append(" left join T_ORG_COMPANY Company on Period.FTypeID = Company.FAccountPeriodID ");
            sql.append(" where FIsAdjustPeriod = 0  ");
            sql.append(" and (FPeriodYear * 100 + FPeriodNumber) Between " + periodFrom + " and " + periodTo);
            sql.append(" and Company.FID = '").append(company.getId().toString()).append("' ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            HashSet<String> idSet = new HashSet<String>();
            while (rs.next()) {
                idSet.add(rs.getString("FID"));
            }
            if (idSet.size() > 0) {
                periodFilter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                view.setFilter(periodFilter);
                PeriodCollection collection = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(view);
                return collection;
            }
            return new PeriodCollection();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void sendMsg(Context ctx, String title, String msgBody) throws EASBizException, BOSException {
        BMCMessageInfo msgInfo = new BMCMessageInfo();
        msgInfo.setType(MsgType.NOTICE);
        msgInfo.setBizType(MsgBizType.ONLINE);
        msgInfo.setStatus(MsgStatus.UNREADED);
        msgInfo.setPriority(MsgPriority.MIDDLE);
        msgInfo.setTitle(title);
        msgInfo.setBody(msgBody);
        msgInfo.setReceiver(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        BMCMessageFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)msgInfo);
    }

    private SelectorItemCollection getRealEstateSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("realEstateGroup.*"));
        sic.add(new SelectorItemInfo("calcFormula.id"));
        sic.add(new SelectorItemInfo("calcFormula.name"));
        sic.add(new SelectorItemInfo("calcFormula.number"));
        sic.add(new SelectorItemInfo("calcFormula.displayBasisExpr"));
        sic.add(new SelectorItemInfo("calcFormula.basisExpr"));
        sic.add(new SelectorItemInfo("calcFormula.displayExpr"));
        sic.add(new SelectorItemInfo("calcFormula.expr"));
        sic.add(new SelectorItemInfo("calcFormula.taxMethod"));
        sic.add(new SelectorItemInfo("calcFormula.dataSource.id"));
        sic.add(new SelectorItemInfo("calcFormula.dataSource.entry.id"));
        sic.add(new SelectorItemInfo("calcFormula.dataSource.entry.isMainTable"));
        sic.add(new SelectorItemInfo("calcFormula.dataSource.entry.tableName"));
        sic.add(new SelectorItemInfo("calcFormula.dataSource.entry.tableName"));
        sic.add(new SelectorItemInfo("calcFormula.dataSource.entry.tableAlias"));
        sic.add(new SelectorItemInfo("calcFormula.dataSource.entry.joinType"));
        sic.add(new SelectorItemInfo("calcFormula.dataSource.entry.joinCondition"));
        sic.add(new SelectorItemInfo("calcFormula.dataSource.entry.parentTable.id"));
        return sic;
    }

    private SelectorItemCollection getLandDataSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("realEstateGroup.*"));
        sic.add(new SelectorItemInfo("calcFormula.id"));
        sic.add(new SelectorItemInfo("calcFormula.name"));
        sic.add(new SelectorItemInfo("calcFormula.number"));
        sic.add(new SelectorItemInfo("calcFormula.displayBasisExpr"));
        sic.add(new SelectorItemInfo("calcFormula.basisExpr"));
        sic.add(new SelectorItemInfo("calcFormula.displayExpr"));
        sic.add(new SelectorItemInfo("calcFormula.expr"));
        sic.add(new SelectorItemInfo("calcFormula.taxMethod"));
        sic.add(new SelectorItemInfo("calcFormula.dataSource.id"));
        sic.add(new SelectorItemInfo("calcFormula.dataSource.entry.id"));
        sic.add(new SelectorItemInfo("calcFormula.dataSource.entry.isMainTable"));
        sic.add(new SelectorItemInfo("calcFormula.dataSource.entry.tableName"));
        sic.add(new SelectorItemInfo("calcFormula.dataSource.entry.tableName"));
        sic.add(new SelectorItemInfo("calcFormula.dataSource.entry.tableAlias"));
        sic.add(new SelectorItemInfo("calcFormula.dataSource.entry.joinType"));
        sic.add(new SelectorItemInfo("calcFormula.dataSource.entry.joinCondition"));
        sic.add(new SelectorItemInfo("calcFormula.dataSource.entry.parentTable.id"));
        return sic;
    }
}

