/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftRecordFactory;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.account.formula.FormulaHelper;
import com.kingdee.eas.tm.td.basedata.AccountConfigFactory;
import com.kingdee.eas.tm.td.basedata.AccountConfigInfo;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.est.RealEstateGroupInfo;
import com.kingdee.eas.tm.td.formula.AbstractBatchCalculater;
import com.kingdee.eas.tm.td.formula.ParamsInfo;
import com.kingdee.eas.tm.td.utils.TDSelectorFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class AccountSummaryCalculater
extends AbstractBatchCalculater {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.formula.ReportDataRefByRuleBatchCalculaterNew");

    public AccountSummaryCalculater(ICalculateContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    @Override
    public void execute(SortedParameterArray paramArray) {
        super.execute(paramArray);
        IReportPropertyAdapter reportAdapter = this.contextProvider.getReportAdapter();
        int querySize = paramArray.size();
        ReportBaseInfo info = (ReportBaseInfo)reportAdapter.getReportProperty("editData");
        for (int i = 0; i < querySize; ++i) {
            Parameter params = paramArray.getParameter(i);
            ParamsInfo formulaParam = new ParamsInfo();
            formulaParam.buildAccountSummaryParam(params);
            formulaParam.setInfo(info);
            try {
                this.innerExecute(formulaParam);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
                formulaParam.getBackFiller().setException((Throwable)e);
            }
        }
    }

    protected void innerExecute(ParamsInfo param) throws EASBizException, BOSException {
        ReportBaseInfo seftInfo = param.getInfo();
        String company = param.getCompany();
        String taxType = param.getTaxItemType();
        String periodValue = param.getPeriodValue();
        String accountConfig = param.getAccountConfig();
        String buildingTaxesGroup = param.getBuildingTaxesGroup();
        String sheetName = param.getSheetName();
        String filterCondition = param.getFilterCondition();
        String filterConfitionMask = param.getFilterConditionMask();
        String calType = param.getCalType();
        String selectField = param.getSelectField();
        String uniqueField = param.getUniqueField();
        if (!this.checkParams(param)) {
            param.getBackFiller().setValue((Object)"");
            return;
        }
        if (this.isEmpty(periodValue)) {
            periodValue = "0";
        }
        int value = Integer.parseInt(periodValue);
        String periodID = ((PeriodInfo)seftInfo.get("rptPeriod")).getId().toString();
        PeriodInfo prePeriod = (PeriodInfo)seftInfo.get("rptPeriod");
        for (int i = 0; i < value; ++i) {
            prePeriod = PeriodUtils.getPrePeriodInfo((Context)this.ctx, (IObjectPK)new ObjectUuidPK(periodID));
            if (prePeriod == null) {
                String destPeriodIsNotExists = TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "destPeriodIsNotExists", this.ctx.getLocale());
                String badFuntion = TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "BADFUNCTION", this.ctx.getLocale(), new Object[]{destPeriodIsNotExists});
                param.getBackFiller().setValue((Object)badFuntion);
                return;
            }
            if (prePeriod.isIsAdjustPeriod() && (prePeriod = PeriodUtils.getPrePeriodInfo((Context)this.ctx, (IObjectPK)new ObjectUuidPK(prePeriod.getId().toString()))) == null) {
                String destPeriodIsNotExists = TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "destPeriodIsNotExists", this.ctx.getLocale());
                String badFuntion = TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "BADFUNCTION", this.ctx.getLocale(), new Object[]{destPeriodIsNotExists});
                param.getBackFiller().setValue((Object)badFuntion);
                return;
            }
            periodID = prePeriod.getId().toString();
        }
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> paramList = new ArrayList<Object>();
        sql.append(" select t.fid as FRptID from T_TD_TaxDraftRecord t");
        sql.append(" left join T_BD_Period rptPeriod on rptPeriod.fid = t.FRptPeriod");
        sql.append(" left join T_ORG_Company company on company.fid = t.FCompanyOrgUnitID");
        sql.append(" left join T_TM_TaxItemType taxItemType on taxItemType.fid = t.FTaxTypeID");
        sql.append(" left join T_TM_AccountConfig account on account.fid = t.FRelateAccountID");
        sql.append(" left join T_TD_RealEstateGroup estGroup on estGroup.fid = t.FBuildingTaxesGroupID");
        sql.append(" where rptPeriod.fid = ?");
        paramList.add(periodID);
        sql.append(" and t.FRecordType = ?");
        paramList.add(0);
        if (!this.isEmpty(company)) {
            sql.append(" and company.fnumber = ?");
            paramList.add(company);
        } else {
            sql.append(" and company.fid = ?");
            String companyID = ((CompanyOrgUnitInfo)seftInfo.get("companyOrgUnit")).getId().toString();
            paramList.add(companyID);
        }
        if (!this.isEmpty(taxType)) {
            sql.append(" and taxItemType.fnumber = ?");
            paramList.add(taxType);
        } else if (seftInfo.containsKey("taxType") && seftInfo.get("taxType") != null) {
            sql.append(" and taxItemType.fid = ?");
            String taxTypeID = ((TaxItemTypeInfo)seftInfo.get("taxType")).getId().toString();
            paramList.add(taxTypeID);
        }
        if (!this.isEmpty(accountConfig)) {
            sql.append(" and account.fnumber = ?");
            paramList.add(accountConfig);
        }
        if (!this.isEmpty(buildingTaxesGroup)) {
            sql.append(" and estGroup.fnumber = ?");
            paramList.add(buildingTaxesGroup);
        } else if (seftInfo.containsKey("buildingTaxesGroup") && seftInfo.get("buildingTaxesGroup") != null) {
            String buildingTaxesGroupID = ((RealEstateGroupInfo)seftInfo.get("buildingTaxesGroup")).getId().toString();
            sql.append(" and estGroup.fid = ?");
            paramList.add(buildingTaxesGroupID);
        }
        sql.append(" order by t.FDraftRecordType desc");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])paramList.toArray());
        String rptID = null;
        try {
            if (rs.next()) {
                rptID = rs.getString("FRptID");
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        if (rptID == null) {
            param.getBackFiller().setValue((Object)"");
            return;
        }
        TaxDraftRecordInfo reportInfo = TaxDraftRecordFactory.getLocalInstance(this.ctx).getTaxDraftRecordInfo((IObjectPK)new ObjectUuidPK(rptID), TDSelectorFactory.getAllReportSelectors());
        if (reportInfo.getId().toString().equals(seftInfo.getId().toString())) {
            reportInfo = (TaxDraftRecordInfo)seftInfo;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("entry.*");
        AccountConfigInfo configInfo = AccountConfigFactory.getLocalInstance(this.ctx).getAccountConfigInfo((IObjectPK)new ObjectUuidPK(reportInfo.getRelateAccount().getId().toString()), sic);
        configInfo.getEntry().sort("seq");
        if (!this.checkFieldsVolid(configInfo, param)) {
            param.getBackFiller().setValue((Object)"");
            return;
        }
        Book book = FormulaHelper.initBook(this.ctx, reportInfo);
        Sheet sheet = book.getSheet(sheetName);
        if (sheet == null) {
            param.getBackFiller().setValue((Object)"");
            return;
        }
        Object[][] sheetData = FormulaHelper.getSheetData(sheet, configInfo);
        List<Object[]> volidData = FormulaHelper.getVolidData(this.ctx, configInfo, sheetData, filterCondition, filterConfitionMask);
        List<Object[]> uniqueData = null;
        uniqueData = !this.isEmpty(uniqueField) ? FormulaHelper.getUniqueData(this.ctx, configInfo, volidData, uniqueField) : volidData;
        if ("0".equals(calType)) {
            int index = FormulaHelper.getAccountConfigEntryIndex(configInfo, selectField);
            if (index >= 0) {
                BigDecimal sumTotal = BigDecimal.ZERO;
                Object[] rowData = null;
                int size = uniqueData.size();
                for (int i = 0; i < size; ++i) {
                    rowData = uniqueData.get(i);
                    try {
                        sumTotal = sumTotal.add(FormulaHelper.getBigDecimalValue(rowData[index]));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        logger.error((Object)e);
                    }
                }
                param.getBackFiller().setValue((Object)sumTotal);
            } else {
                param.getBackFiller().setValue((Object)"");
            }
        } else if ("1".equals(calType)) {
            param.getBackFiller().setValue((Object)uniqueData.size());
        }
    }

    public boolean checkParams(ParamsInfo param) {
        ReportBaseInfo seftInfo = param.getInfo();
        String calType = param.getCalType();
        String taxType = param.getTaxItemType();
        String selectField = param.getSelectField();
        if ("0".equals(calType) && this.isEmpty(selectField)) {
            return false;
        }
        return !this.isEmpty(taxType) || seftInfo.get("taxType") != null;
    }

    public boolean checkFieldsVolid(AccountConfigInfo configInfo, ParamsInfo param) {
        String selectField = param.getSelectField();
        String uniqueField = param.getUniqueField();
        if (!this.isEmpty(selectField) && FormulaHelper.getAccountConfigEntryIndex(configInfo, selectField) == -1) {
            return false;
        }
        if (!this.isEmpty(uniqueField)) {
            List fields = Arrays.asList((Object[])uniqueField.split(","));
            int index = -1;
            Iterator it = fields.iterator();
            while (it.hasNext()) {
                index = FormulaHelper.getAccountConfigEntryIndex(configInfo, (String)it.next());
                if (index != -1) continue;
                return false;
            }
        }
        return true;
    }
}

