/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.rpt.taxqing;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.qing.preparedata.handler.controller.model.EntryEntity;
import com.kingdee.bos.qing.preparedata.handler.controller.model.Field;
import com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.QingData;
import com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.QingMeta;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.DBUtils;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchEntryCollection;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchEntryInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchInfo;
import com.kingdee.eas.tm.td.rpt.TaxAnalysisThemeFactory;
import com.kingdee.eas.tm.td.rpt.TaxAnalysisThemeInfo;
import com.kingdee.eas.tm.td.rpt.taxqing.AbstractTaxQingService;
import com.kingdee.eas.tm.td.rpt.taxqing.processor.TaxQingDataFetchProcessor;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class DefaultTaxQingService
extends AbstractTaxQingService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.rpt.app.taxqing.DefaultTaxQingDataFetchService");
    private String themeID = null;
    private TaxAnalysisThemeInfo themeInfo;

    public DefaultTaxQingService(Context ctx) {
        super(ctx);
    }

    @Override
    protected void initParams(String tag) {
        super.initParams(tag);
        this.themeID = this.tagItems[1];
        this.themeInfo = this.loadThemeInfo(this.themeID);
    }

    @Override
    public QingMeta getQingMeta(String tag) {
        super.getQingMeta(tag);
        QingMeta qingMeta = new QingMeta();
        try {
            DataFetchInfo info = this.themeInfo.getScheme();
            DataFetchEntryCollection entryColl = info.getEntry();
            DataFetchEntryInfo entryInfo = null;
            int size = entryColl.size();
            for (int i = 0; i < size; ++i) {
                entryInfo = entryColl.get(i);
                com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field field = new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field();
                field.setAlias(entryInfo.getAlias());
                field.setName(entryInfo.getName());
                field.setFieldType(this.dataTypeToFieldType(entryInfo.getDataType()).toNumber());
                field.setEntity("");
                field.setRefEntity("");
                field.setHide(!entryInfo.isIsVisible());
                qingMeta.addColumn((Field)field);
                this.fields.add(field);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.EntryEntity entityInfo = new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.EntryEntity();
        entityInfo.setAlias("");
        entityInfo.setName("");
        entityInfo.setParentName("");
        entityInfo.setPkFieldName("");
        qingMeta.addEntryEntity((EntryEntity)entityInfo);
        return qingMeta;
    }

    protected TaxAnalysisThemeInfo loadThemeInfo(String themeID) {
        TaxAnalysisThemeInfo themeInfo = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("dimSettings.*");
        sic.add("dimSettings.members.*");
        sic.add("scheme.*");
        sic.add("scheme.entry.*");
        ObjectUuidPK pk = new ObjectUuidPK(themeID);
        try {
            themeInfo = TaxAnalysisThemeFactory.getLocalInstance(this.ctx).getTaxAnalysisThemeInfo((IObjectPK)pk, sic);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return themeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QingData getQingData(String tag, int startRow, int limit) {
        QingData qingData = new QingData();
        HashMap<String, Integer> dataIndex = new HashMap<String, Integer>();
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        int fieldSize = this.fields.size();
        Connection con = null;
        try {
            if (startRow == 1) {
                TaxQingDataFetchProcessor processor = new TaxQingDataFetchProcessor(this.ctx, this.themeInfo);
                this.tempTableName = processor.execute();
            }
            String sql = "select * from " + this.tempTableName;
            con = EJBFactory.getQueryConnection((Context)this.ctx);
            RptRowSet rs = DBUtils.executeQuery((String)sql, null, (int)startRow, (int)limit, (Connection)con);
            Object[] rowData = null;
            while (rs.next()) {
                rowData = new Object[this.fields.size()];
                for (int i = 0; i < fieldSize; ++i) {
                    String field = ((com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field)this.fields.get(i)).getName();
                    Object value = rs.getObject(field);
                    if (value instanceof Date) {
                        value = ((Date)value).getTime();
                    } else if (value instanceof Timestamp) {
                        value = ((Timestamp)value).getTime();
                    }
                    rowData[i] = value;
                    dataIndex.put(field, i);
                }
                dataList.add(rowData);
            }
            qingData.setDataindex(dataIndex);
            qingData.setRows(dataList);
            SQLUtils.cleanup((Connection)con);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        finally {
            SQLUtils.cleanup(con);
        }
        return qingData;
    }

    @Override
    public void disposeProvider(String tag) {
    }

    @Override
    public String setQingFilter(String tag, String filter) {
        return null;
    }

    @Override
    public String getQingFilter(String tag) throws EASBizException, BOSException {
        return null;
    }
}

