/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.rpt.taxqing.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.account.engine.interfaces.ISQLBuilder;
import com.kingdee.eas.tm.td.account.engine.thread.QueryDataSyncLock;
import com.kingdee.eas.tm.td.account.engine.thread.QueryDataTask;
import com.kingdee.eas.tm.td.account.engine.thread.ThreadPool;
import com.kingdee.eas.tm.td.basedata.TakeDataContditionCollection;
import com.kingdee.eas.tm.td.basedata.TakeDataContditionInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.utils.DataModelUtil;
import com.kingdee.eas.tm.td.rpt.TaxAnalysisThemeInfo;
import com.kingdee.eas.tm.td.rpt.taxqing.processor.TaxQingDataFetchSQLBuilder;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class TaxQingDataFetchProcessor {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.rpt.utils.TaxQingDataFetchService");
    private Context ctx;
    private TaxAnalysisThemeInfo themeInfo;
    private String tempTableName;
    private DataFetchInfo info;

    public String getTempTableName() {
        return this.tempTableName;
    }

    public TaxQingDataFetchProcessor(Context ctx, TaxAnalysisThemeInfo themeInfo) {
        this.ctx = ctx;
        this.themeInfo = themeInfo;
        this.info = this.themeInfo.getScheme();
    }

    public String execute() {
        try {
            String createSQL = DataModelUtil.getCreateSQLByDataFetch(this.ctx, this.info);
            this.tempTableName = TempTablePool.getInstance((Context)this.ctx).createTempTable(createSQL);
            this.insertBillData();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return this.tempTableName;
    }

    protected void insertBillData() throws BOSException, EASBizException {
        ISQLBuilder sqlBuilder = null;
        List<ISQLBuilder> sqlBuilderList = this.getSQLBuilder();
        Connection conn = null;
        QueryDataSyncLock lock = new QueryDataSyncLock();
        ThreadPool threadPool = ThreadPool.getInstance();
        int size = sqlBuilderList.size();
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            String insertSQL = DataModelUtil.getInsertSQL(this.tempTableName, this.info);
            StringBuffer sSQL = new StringBuffer();
            for (int i = 0; i < size; ++i) {
                sqlBuilder = sqlBuilderList.get(i);
                String selectSQL = sqlBuilder.getSQL();
                if (StringUtils.isEmpty((String)selectSQL)) continue;
                sSQL.setLength(0);
                sSQL.append(insertSQL).append("\r\n").append(selectSQL);
                QueryDataTask thread = new QueryDataTask(lock, sqlBuilder.getExecuteLockName(), conn, sSQL.toString());
                lock.addLock(sqlBuilder.getExecuteLockName());
                threadPool.addTask(thread);
            }
            lock.waitFinish();
        }
        catch (BOSException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    protected List<ISQLBuilder> getSQLBuilder() throws EASBizException, BOSException {
        TakeDataContditionCollection conditionList = DataModelUtil.getCondition(this.ctx, this.info);
        ISQLBuilder sqlBuilder = null;
        ArrayList<ISQLBuilder> sqlBuilderList = new ArrayList<ISQLBuilder>();
        if (conditionList == null || conditionList.size() == 0) {
            return sqlBuilderList;
        }
        int size = conditionList.size();
        TakeDataContditionInfo conditionInfo = null;
        for (int i = 0; i < size; ++i) {
            conditionInfo = conditionList.get(i);
            sqlBuilder = this.getSQLBuilder(conditionInfo);
            sqlBuilderList.add(sqlBuilder);
        }
        return sqlBuilderList;
    }

    protected ISQLBuilder getSQLBuilder(TakeDataContditionInfo conditionInfo) {
        TaxQingDataFetchSQLBuilder sqlBuilder = new TaxQingDataFetchSQLBuilder(this.ctx, this.info, conditionInfo, null, this.themeInfo);
        return sqlBuilder;
    }
}

