/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.rpt.taxqing.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.tm.td.basedata.DataFilterTypeEnum;
import com.kingdee.eas.tm.td.basedata.TakeDataContditionInfo;
import com.kingdee.eas.tm.td.cloud.GroupCollection;
import com.kingdee.eas.tm.td.cloud.GroupFactory;
import com.kingdee.eas.tm.td.cloud.GroupInfo;
import com.kingdee.eas.tm.td.cloud.OrgGroupCollection;
import com.kingdee.eas.tm.td.cloud.OrgGroupFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.rpt.app.DataFetchSQLBuilder;
import com.kingdee.eas.tm.td.cloud.utils.TDCloudUtil;
import com.kingdee.eas.tm.td.rpt.TaxAnalysisThemeInfo;
import com.kingdee.eas.tm.td.rpt.TaxDimSettingsCollection;
import com.kingdee.eas.tm.td.rpt.TaxDimSettingsInfo;
import com.kingdee.eas.tm.td.rpt.TaxDimSettingsMemberCollection;
import com.kingdee.eas.tm.td.rpt.TaxDimSettingsMemberInfo;
import com.kingdee.eas.tm.td.utils.CollectionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class TaxQingDataFetchSQLBuilder
extends DataFetchSQLBuilder {
    private TaxAnalysisThemeInfo themeInfo = null;

    public TaxQingDataFetchSQLBuilder(Context ctx, DataFetchInfo dataFetchInfo, TakeDataContditionInfo conditionInfo, RptParams params, TaxAnalysisThemeInfo themeInfo) {
        super(ctx, dataFetchInfo, conditionInfo, params);
        this.themeInfo = themeInfo;
    }

    @Override
    protected FilterInfo getOrgFilter() throws EASBizException, BOSException {
        if (this.conditionInfo.getOrgField() == null) {
            return null;
        }
        HashSet<String> companyIds = new HashSet<String>();
        TaxDimSettingsCollection dimSettingColl = this.themeInfo.getDimSettings();
        TaxDimSettingsInfo dimSettingInfo = null;
        TaxDimSettingsMemberCollection memberColl = null;
        TaxDimSettingsMemberInfo memberInfo = null;
        int size = dimSettingColl.size();
        for (int i = 0; i < size; ++i) {
            dimSettingInfo = dimSettingColl.get(i);
            memberColl = dimSettingInfo.getMembers();
            for (int j = 0; j < memberColl.size(); ++j) {
                memberInfo = memberColl.get(j);
                if ("GroupDim".equals(dimSettingInfo.getDimNumber())) {
                    companyIds.addAll(this.getCompanyByGroup(memberInfo.getMemberId()));
                    continue;
                }
                if (!"CompanyDim".equals(dimSettingInfo.getDimNumber())) continue;
                companyIds.add(memberInfo.getMemberId());
            }
        }
        FilterInfo orgFilter = new FilterInfo();
        if (companyIds.size() > 0) {
            StringBuffer orgFilterStr = new StringBuffer();
            orgFilterStr.append(this.conditionInfo.getOrgField()).append(" IN ");
            orgFilterStr.append("(").append(CollectionUtil.convertSet2String(companyIds, ",", true)).append(")");
            try {
                orgFilter = new FilterInfo(orgFilterStr.toString());
            }
            catch (ParserException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return orgFilter;
    }

    protected Set<String> getCompanyByGroup(String groupId) throws EASBizException, BOSException {
        HashSet<String> companyIds = new HashSet<String>();
        GroupInfo groupInfo = GroupFactory.getLocalInstance(this.ctx).getGroupInfo((IObjectPK)new ObjectUuidPK(groupId));
        GroupCollection groupColl = GroupFactory.getLocalInstance(this.ctx).getGroupCollection(" where longNumber like '" + groupInfo.getLongNumber() + "%'");
        HashSet<String> groupIncludeChildrenIds = new HashSet<String>();
        GroupInfo info = null;
        int size = groupColl.size();
        for (int i = 0; i < size; ++i) {
            info = groupColl.get(i);
            groupIncludeChildrenIds.add(info.getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("group.id", groupIncludeChildrenIds, CompareType.INCLUDE));
        view.setFilter(filter);
        OrgGroupCollection orgGroupColl = OrgGroupFactory.getLocalInstance(this.ctx).getOrgGroupCollection(view);
        int size2 = orgGroupColl.size();
        for (int i = 0; i < size2; ++i) {
            companyIds.add(orgGroupColl.get(i).getCompany().getId().toString());
        }
        return companyIds;
    }

    @Override
    protected FilterInfo getDateFilter() throws EASBizException, BOSException {
        int yearFrom = this.themeInfo.getStartYear();
        int monthFrom = this.themeInfo.getStartPeriod();
        int yearTo = this.themeInfo.getEndYear();
        int monthTo = this.themeInfo.getEndPeriod();
        FilterInfo filter = null;
        StringBuffer dateFilter = new StringBuffer();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        if (this.conditionInfo.getDateFilterType().equals((Object)DataFilterTypeEnum.BizDate)) {
            Date startDate = TDCloudUtil.getMonthFirstDay(yearFrom, monthFrom);
            Date endDate = TDCloudUtil.getMonthLastDay(yearTo, monthTo);
            dateFilter.append(" (").append(this.conditionInfo.getBizDateField()).append(" >= {ts'").append(sf.format(startDate)).append(" 00:00:00'}");
            dateFilter.append(" and ").append(this.conditionInfo.getBizDateField()).append(" <= {ts'").append(sf.format(endDate)).append(" 23:59:59'})");
        } else if (this.conditionInfo.getDateFilterType().equals((Object)DataFilterTypeEnum.PeriodID)) {
            String monthFromStr = monthFrom < 10 ? "0" + monthFrom : "" + monthFrom;
            String monthToStr = monthTo < 10 ? "0" + monthTo : "" + monthTo;
            String periodFromNumber = yearFrom + monthFromStr;
            String periodToNumber = yearTo + monthToStr;
            StringBuffer periodSql = new StringBuffer();
            periodSql.append(" select fid  FROM T_BD_Period WHERE fnumber>=").append(periodFromNumber).append(" and fnumber<=").append(periodToNumber);
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)periodSql.toString(), null);
            HashSet<String> periodIds = new HashSet<String>();
            try {
                while (rs.next()) {
                    periodIds.add(rs.getString("fid"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            String periodIdstr = CollectionUtil.convertSet2String(periodIds, ",", true);
            dateFilter.append(" ").append(this.conditionInfo.getPeriodIdField()).append(" in (").append(periodIdstr).append(")");
        } else if (this.conditionInfo.getDateFilterType().equals((Object)DataFilterTypeEnum.YearAndMonth)) {
            dateFilter.append(" (");
            dateFilter.append(this.conditionInfo.getPeriodYear()).append("*100+").append(this.conditionInfo.getPeriodMonth()).append(" >= ");
            dateFilter.append(yearFrom * 100 + monthFrom);
            dateFilter.append(" and ");
            dateFilter.append(this.conditionInfo.getPeriodYear()).append("*100+").append(this.conditionInfo.getPeriodMonth()).append(" <= ");
            dateFilter.append(yearTo * 100 + monthTo);
            dateFilter.append(") ");
        }
        try {
            filter = new FilterInfo(dateFilter.toString());
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        return filter;
    }
}

