/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.solutionmgr.impexp;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.solutionmgr.ExportSolutionMgrCollection;
import com.kingdee.eas.tm.td.solutionmgr.ExportSolutionMgrInfo;
import com.kingdee.eas.tm.td.solutionmgr.impexp.processor.ExpProcessor;
import com.kingdee.eas.tm.td.solutionmgr.impexp.processor.ImpProcessor;
import com.kingdee.eas.tm.td.solutionmgr.impexp.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ImpExpService {
    public void importData(int importType, Map params) throws BOSException, EASBizException {
        String filePath = (String)params.get("filePath");
        List childFolderList = FileUtil.getChildFolderList(filePath);
        String basePath = null;
        String solutionMgrNumber = null;
        for (int i = 0; i < childFolderList.size(); ++i) {
            basePath = filePath + File.separator + (String)childFolderList.get(i);
            solutionMgrNumber = ((String)childFolderList.get(i)).split("#")[1];
            Map ret = this.buildImportParams(basePath);
            Map tableFileMap = (Map)ret.get("tableFileMap");
            Map tableIdFileMap = (Map)ret.get("tableIdFileMap");
            Map blobFileMap = (Map)ret.get("blobFileMap");
            if (tableFileMap == null) continue;
            String tablePage2 = null;
            ImpProcessor impProcessor = null;
            List tableFileList = null;
            List tableIdFileList = null;
            List blobFileList = null;
            HashMap<String, Object> impParams = null;
            for (String tablePage2 : tableFileMap.keySet()) {
                tableFileList = (List)tableFileMap.get(tablePage2);
                tableIdFileList = (List)tableIdFileMap.get(tablePage2);
                blobFileList = (List)blobFileMap.get(tablePage2);
                impParams = new HashMap<String, Object>();
                impParams.put("tableFileName", tableFileList.get(0));
                if (tableIdFileList != null && tableIdFileList.size() > 0) {
                    impParams.put("tableIdFileName", tableIdFileList.get(0));
                }
                impParams.put("blobFileList", blobFileList);
                impParams.put("solutionMgrNumber", solutionMgrNumber);
                impParams.put("basePath", basePath);
                impProcessor = new ImpProcessor(importType, impParams);
                impProcessor.execute();
            }
        }
    }

    private Map buildImportParams(String filePath) {
        HashMap tableFileMap = new HashMap();
        HashMap tableIdFileMap = new HashMap();
        HashMap blobFileMap = new HashMap();
        String[] fileList = FileUtil.getFileList(filePath);
        String fileName2 = null;
        String tablePage = null;
        String[] keys = null;
        HashMap fileMap = null;
        for (String fileName2 : fileList) {
            if (fileName2 == null || !FileUtil.getFileSuffix(fileName2).equals(".dat")) continue;
            keys = FileUtil.getFileNoSuffix(fileName2).split("-");
            tablePage = keys[0] + "-" + keys[1];
            if (FileUtil.isTableFile(fileName2)) {
                fileMap = tableFileMap;
            } else if (FileUtil.isTableIdFile(fileName2)) {
                fileMap = tableIdFileMap;
            } else {
                if (!FileUtil.isBlobFile(fileName2)) continue;
                fileMap = blobFileMap;
            }
            if (!fileMap.containsKey(tablePage)) {
                fileMap.put(tablePage, new ArrayList());
            }
            ((List)fileMap.get(tablePage)).add(fileName2);
        }
        HashMap ret = new HashMap();
        ret.put("tableFileMap", tableFileMap);
        ret.put("tableIdFileMap", tableIdFileMap);
        ret.put("blobFileMap", blobFileMap);
        return ret;
    }

    public void exportData(ExportSolutionMgrCollection expColl, Map<String, String> conditionMap, Map params) throws BOSException {
        ExportSolutionMgrInfo mgrInfo = null;
        String filter = null;
        ExpProcessor processor = null;
        Iterator it = expColl.iterator();
        while (it.hasNext()) {
            mgrInfo = (ExportSolutionMgrInfo)it.next();
            filter = conditionMap.get(mgrInfo.getNumber());
            processor = new ExpProcessor(mgrInfo, filter, params);
            processor.execute();
        }
    }
}

