/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.solutionmgr.impexp.model;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.solutionmgr.ExportSolutionMgrInfo;
import com.kingdee.eas.tm.td.solutionmgr.ExportSolutionSubTabInfo;
import com.kingdee.eas.tm.td.solutionmgr.SolutionMgrFacadeFactory;
import com.kingdee.eas.tm.td.solutionmgr.impexp.model.TablePageModel;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TableModel
implements Serializable {
    private static final long serialVersionUID = 5768693276236150395L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.solutionmgr.impexp.model.TableModel");
    private ExportSolutionMgrInfo mgrInfo = null;
    private ExportSolutionSubTabInfo subTabInfo = null;
    private boolean isMainTable = false;
    private String sql = null;
    private String totalSql = null;
    private String filter = null;
    private int pageSize = 50000;
    private int tableSize = 0;
    private int totalPage = 1;
    private String basePath = null;
    private String resultFile = null;
    private String errorFile = null;
    private transient List<TablePageModel> pageModelList = new ArrayList<TablePageModel>();

    public TableModel(ExportSolutionMgrInfo mgrInfo, ExportSolutionSubTabInfo subTabInfo, boolean isMainTable) {
        this.mgrInfo = mgrInfo;
        this.subTabInfo = subTabInfo;
        this.isMainTable = isMainTable;
    }

    private List<TablePageModel> initPageModelList() {
        try {
            this.tableSize = this.initTableSize();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        this.totalPage = this.tableSize / this.pageSize + 1;
        ArrayList<TablePageModel> pageModelList = new ArrayList<TablePageModel>();
        TablePageModel pageModel = null;
        for (int i = 0; i < this.totalPage; ++i) {
            pageModel = new TablePageModel(this, i);
            pageModelList.add(pageModel);
        }
        return pageModelList;
    }

    public int initTableSize() throws EASBizException, BOSException {
        String sql = this.totalSql;
        if (!StringUtils.isEmpty((String)this.filter)) {
            sql = sql + this.filter;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sql", sql);
        Map ret = SolutionMgrFacadeFactory.getRemoteInstance().getRecordCount(params);
        int tableSize = (Integer)ret.get("count");
        return tableSize;
    }

    public boolean hasMutiPage() {
        return this.totalPage != 1;
    }

    public String getTblName() {
        return this.isMainTable ? this.mgrInfo.getMainTable() : this.subTabInfo.getSubTable();
    }

    public void out() throws EASBizException, BOSException {
        this.pageModelList = this.initPageModelList();
        TablePageModel pageModel = null;
        int size = this.pageModelList.size();
        for (int i = 0; i < size; ++i) {
            pageModel = this.pageModelList.get(i);
            pageModel.out();
        }
    }

    public ExportSolutionMgrInfo getMgrInfo() {
        return this.mgrInfo;
    }

    public void setMgrInfo(ExportSolutionMgrInfo mgrInfo) {
        this.mgrInfo = mgrInfo;
    }

    public ExportSolutionSubTabInfo getSubTabInfo() {
        return this.subTabInfo;
    }

    public void setSubTabInfo(ExportSolutionSubTabInfo subTabInfo) {
        this.subTabInfo = subTabInfo;
    }

    public boolean isMainTable() {
        return this.isMainTable;
    }

    public void setMainTable(boolean isMainTable) {
        this.isMainTable = isMainTable;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    public void setTableSize(int tableSize) {
        this.tableSize = tableSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getTotalSql() {
        return this.totalSql;
    }

    public void setTotalSql(String totalSql) {
        this.totalSql = totalSql;
    }

    public String getResultFile() {
        return this.resultFile;
    }

    public void setResultFile(String resultFile) {
        this.resultFile = resultFile;
    }

    public String getErrorFile() {
        return this.errorFile;
    }

    public void setErrorFile(String errorFile) {
        this.errorFile = errorFile;
    }
}

