/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.structure.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftRecordFactory;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.structure.DetailItemDataFactory;
import com.kingdee.eas.tm.td.structure.TaxReportItemInfo;
import com.kingdee.eas.tm.td.structure.TaxReportSheetInfo;
import com.kingdee.eas.tm.td.structure.TaxStructureExeception;
import com.kingdee.eas.tm.td.structure.TaxValueTypeEnum;
import com.kingdee.eas.tm.td.structure.app.AbstractTaxItemFormulaFacadeControllerBean;
import com.kingdee.eas.tm.td.structure.utils.StructureDbUtil;
import com.kingdee.eas.tm.td.structure.utils.StructureDynamicTableManager;
import com.kingdee.eas.tm.td.structure.utils.StructureUtils;
import com.kingdee.eas.tm.td.structure.utils.TaxItemFormula;
import com.kingdee.eas.tm.td.utils.TDSelectorFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

public class TaxItemFormulaFacadeControllerBean
extends AbstractTaxItemFormulaFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.structure.app.TaxItemFormulaFacadeControllerBean");

    @Override
    protected List _loadItemParamaters(Context ctx, String[] params) throws BOSException, EASBizException {
        if (params.length < 4) {
            throw new TaxStructureExeception(TaxStructureExeception.ITEMFORMULAPARAMATERERROR);
        }
        String sheetNumber = params[0];
        String rowItemNumber = params[1];
        String columnItemNumber = params[2];
        String valueTypeNumber = params[3];
        TaxReportSheetInfo sheetInfo = StructureUtils.getTaxReportSheetByNumber(ctx, sheetNumber);
        TaxReportItemInfo rowItemInfo = StructureUtils.getTaxReportItemByNumber(ctx, rowItemNumber);
        TaxReportItemInfo columnItemInfo = StructureUtils.getTaxReportItemByNumber(ctx, columnItemNumber);
        TaxValueTypeEnum valueType = TaxValueTypeEnum.getEnum(valueTypeNumber);
        ArrayList<Object> ret = new ArrayList<Object>();
        ret.add(sheetInfo);
        ret.add(rowItemInfo);
        ret.add(columnItemInfo);
        ret.add((Object)valueType);
        return ret;
    }

    @Override
    protected void _saveItemData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TaxDraftRecordInfo reportInfo = (TaxDraftRecordInfo)model;
        Book book = null;
        try {
            book = StructureUtils.prepareBook(ctx, reportInfo);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        ArrayList<Sheet> sheetList = new ArrayList<Sheet>();
        for (int i = 0; i < book.getSheetCount(); ++i) {
            sheetList.add(book.getSheet(i));
        }
        Sheet sheet = null;
        HashMap mapI = new HashMap();
        CoreBaseCollection dItems = new CoreBaseCollection();
        for (int i = 0; i < sheetList.size(); ++i) {
            sheet = (Sheet)sheetList.get(i);
            StructureUtils.scanItemFormulaDataBySheet(ctx, reportInfo, sheet, mapI, dItems);
        }
        String sheetNumber2 = null;
        Map detailMap = null;
        ArrayList itemTable = new ArrayList();
        for (String sheetNumber2 : mapI.keySet()) {
            detailMap = (Map)mapI.get(sheetNumber2);
            this.save_ItemData(ctx, reportInfo, sheetNumber2, detailMap, itemTable);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM T_TD_DetailItemDataEntry where FParentID in (SELECT FID from T_TD_DetailItemData where FReportID='").append(reportInfo.getId().toString()).append("');");
        sql.append("DELETE FROM T_TD_DetailItemData where FReportID='").append(reportInfo.getId().toString()).append("';");
        StructureDbUtil.batchSqlExecute(ctx, sql.toString(), ";");
        if (dItems.size() > 0) {
            DetailItemDataFactory.getLocalInstance(ctx).addnewBatchData(dItems);
        }
    }

    private void save_ItemData(Context ctx, TaxDraftRecordInfo info, String sheetNumber, Map data, List itemTable) throws EASBizException, BOSException {
        TaxReportSheetInfo sheetInfo = StructureUtils.getTaxReportSheetByNumber(ctx, sheetNumber);
        if (sheetInfo == null) {
            return;
        }
        String tblName = StructureDynamicTableManager.getPhysicalTblNameWithCreate(ctx, sheetInfo.getId().toString());
        itemTable.add(tblName);
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM ").append(tblName).append(" WHERE FReportID='").append(info.getId().toString()).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(this.getTaxItemDataInsertSQL(tblName));
            String key2 = null;
            TaxItemFormula itemFormula = null;
            for (String key2 : data.keySet()) {
                itemFormula = (TaxItemFormula)data.get(key2);
                TaxReportItemInfo rowItemInfo = StructureUtils.getTaxReportItemByNumber(ctx, itemFormula.getRowItem());
                TaxReportItemInfo columnItemInfo = StructureUtils.getTaxReportItemByNumber(ctx, itemFormula.getColumnItem());
                if (rowItemInfo == null || columnItemInfo == null) continue;
                pstmt.setString(1, Uuid.create().toString());
                pstmt.setString(2, info.getCompanyOrgUnit().getId().toString());
                pstmt.setString(3, info.getRptPeriod().getId().toString());
                pstmt.setString(4, info.getTaxType().getId().toString());
                pstmt.setInt(5, info.getRecordType().getValue());
                pstmt.setString(6, info.getRelateAccount() != null ? info.getRelateAccount().getId().toString() : null);
                pstmt.setString(7, info.getBuildingTaxesGroup() != null ? info.getBuildingTaxesGroup().getId().toString() : null);
                pstmt.setString(8, info.getId().toString());
                pstmt.setString(9, sheetInfo.getId().toString());
                pstmt.setString(10, rowItemInfo.getId().toString());
                pstmt.setString(11, columnItemInfo.getId().toString());
                pstmt.setString(12, itemFormula.getValueType());
                if ("TXT".equals(itemFormula.getValueType())) {
                    pstmt.setObject(13, null);
                    pstmt.setObject(14, itemFormula.getValue());
                } else {
                    pstmt.setObject(13, itemFormula.getValue());
                    pstmt.setObject(14, null);
                }
                pstmt.setInt(15, Integer.parseInt(info.getDraftRecordType().getValue()));
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                String message = e.getMessage();
                if ("Data truncation".equals(message)) {
                    message = TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "FValue1_length", ctx.getLocale());
                }
                throw new TDException(TDException.ERROR_MSG, new Object[]{message});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private String getTaxItemDataInsertSQL(String tblName) {
        StringBuffer sql = new StringBuffer();
        sql.append("  INSERT INTO ").append(tblName);
        sql.append(" (FID,FCompanyID,FPeriodID,FTaxTypeID,FRecordType,FAccountConfigID,FBuildingTaxesGroupID,");
        sql.append("  FReportID,FSheetID,FRowItemID,FColumnItemID,FValueType,FValue1,FValue2,FDraftRecordType)");
        sql.append("  values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        return sql.toString();
    }

    @Override
    protected void _clearItemData(Context ctx, String reportID) throws BOSException, EASBizException {
        StringBuffer sqlS = new StringBuffer();
        sqlS.append("SELECT FOWNERMENU FROM T_TD_TaxDraftRecord ").append(" WHERE FID = '").append(reportID).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlS.toString());
        try {
            if (!rs.next()) {
                return;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        TaxDraftRecordInfo reportInfo = TaxDraftRecordFactory.getLocalInstance(ctx).getTaxDraftRecordInfo((IObjectPK)new ObjectUuidPK(reportID), TDSelectorFactory.getAllReportSelectors());
        Book book = null;
        try {
            book = StructureUtils.prepareBook(ctx, reportInfo);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        ArrayList<Sheet> sheetList = new ArrayList<Sheet>();
        for (int i = 0; i < book.getSheetCount(); ++i) {
            sheetList.add(book.getSheet(i));
        }
        Sheet sheet = null;
        HashMap data = new HashMap();
        for (int i = 0; i < sheetList.size(); ++i) {
            sheet = (Sheet)sheetList.get(i);
            StructureUtils.scanItemFormulaDataBySheet(ctx, reportInfo, sheet, data, null);
        }
        String sheetNumber2 = null;
        String tblName = null;
        StringBuffer sql = new StringBuffer();
        for (String sheetNumber2 : data.keySet()) {
            TaxReportSheetInfo sheetInfo = StructureUtils.getTaxReportSheetByNumber(ctx, sheetNumber2);
            tblName = StructureDynamicTableManager.getPhysicalTblName(ctx, sheetInfo.getId().toString());
            if (StringUtils.isEmpty((Object)tblName)) continue;
            sql.append("DELETE FROM ").append(tblName).append(" WHERE FReportID='").append(reportID).append("';");
        }
        sql.append("DELETE FROM T_TD_DetailItemDataEntry where FParentID in (SELECT FID from T_TD_DetailItemData where FReportID='").append(reportID).append("');");
        sql.append("DELETE FROM T_TD_DetailItemData where FReportID='").append(reportID).append("';");
        StructureDbUtil.batchSqlExecute(ctx, sql.toString(), ";");
    }
}

