/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.structure.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.tm.td.StatusEnum;
import com.kingdee.eas.tm.td.cloud.TDCloudException;
import com.kingdee.eas.tm.td.structure.TaxReportItemFactory;
import com.kingdee.eas.tm.td.structure.TaxReportSheetFactory;
import com.kingdee.eas.tm.td.structure.TaxReportSheetInfo;
import com.kingdee.eas.tm.td.structure.TaxStructureExeception;
import com.kingdee.eas.tm.td.structure.app.AbstractTaxReportSheetControllerBean;
import com.kingdee.eas.tm.td.structure.utils.StructureDynamicTableManager;
import org.apache.log4j.Logger;

public class TaxReportSheetControllerBean
extends AbstractTaxReportSheetControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.structure.app.TaxReportSheetControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, (IObjectValue)((DataBaseInfo)model));
        this._checkNameDup(ctx, model);
        return super._submit(ctx, model);
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TaxReportSheetInfo info = (TaxReportSheetInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)info.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filter.getFilterItems().add(new FilterItemInfo("taxType.id", (Object)info.getTaxType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("recordType", (Object)info.getRecordType().getValue(), CompareType.EQUALS));
        if (info.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String name = this._getPropertyAlias(ctx, info, "name") + " : " + info.getName();
            throw new TaxStructureExeception(TaxStructureExeception.CHECKNAMEDUP0, new Object[]{name});
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TaxReportSheetInfo info = TaxReportSheetFactory.getLocalInstance(ctx).getTaxReportSheetInfo(pk);
        this.checkBeforeDelete(ctx, (IObjectValue)info);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("reportSheet.id", (Object)info.getId(), CompareType.EQUALS));
        if (TaxReportItemFactory.getLocalInstance(ctx).exists(filter)) {
            throw new TaxStructureExeception(TaxStructureExeception.REPORTSHEETDELETEERORR);
        }
        super._delete(ctx, pk);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        TaxReportSheetInfo info = TaxReportSheetFactory.getLocalInstance(ctx).getTaxReportSheetInfo(pk);
        this.checkBeforeCancel(ctx, (IObjectValue)info);
        info.setState(StatusEnum.DisEnable);
        super._update(ctx, pk, (IObjectValue)info);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        TaxReportSheetInfo info = TaxReportSheetFactory.getLocalInstance(ctx).getTaxReportSheetInfo(pk);
        this.checkBeforeCancelCancel(ctx, (IObjectValue)info);
        info.setState(StatusEnum.Enable);
        String tblName = StructureDynamicTableManager.getPhysicalTblNameWithCreate(ctx, info.getId().toString());
        super._update(ctx, pk, (IObjectValue)info);
    }

    private void checkBeforeDelete(Context ctx, IObjectValue value) throws BOSException, EASBizException {
        TaxReportSheetInfo info = (TaxReportSheetInfo)value;
        if (!"1".equals(info.getState().getValue())) {
            throw new TaxStructureExeception(TaxStructureExeception.BASEDATA_DELETE_STATUSERROR);
        }
        if (info.isIsScheduled()) {
            throw new TaxStructureExeception(TaxStructureExeception.BASEDATA_DELETE_SCHEDULEDERROR);
        }
    }

    private void checkBeforeCancel(Context ctx, IObjectValue value) throws BOSException, EASBizException {
        if (!"2".equals(value.get("state"))) {
            throw new TDCloudException(TDCloudException.CANCEL_STATUS_ERROR);
        }
    }

    private void checkBeforeCancelCancel(Context ctx, IObjectValue value) throws BOSException, EASBizException {
        if ("2".equals(value.get("state"))) {
            throw new TDCloudException(TDCloudException.CANCELCANCEL_STATUS_ERROR);
        }
    }
}

