/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.structure.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.common.olap.EASEjbFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.tm.td.DraftRecordTypeEnum;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.account.engine.thread.QueryDataSyncLock;
import com.kingdee.eas.tm.td.account.engine.thread.QueryDataTask;
import com.kingdee.eas.tm.td.account.engine.thread.ThreadPool;
import com.kingdee.eas.tm.td.basedata.AccountConfigInfo;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.est.RealEstateGroupInfo;
import com.kingdee.eas.tm.td.structure.TaxReportSheetCollection;
import com.kingdee.eas.tm.td.structure.TaxReportSheetFactory;
import com.kingdee.eas.tm.td.structure.TaxReportSheetInfo;
import com.kingdee.eas.tm.td.structure.rpt.app.AbstractTaxItemDataAnalysisFacadeControllerBean;
import com.kingdee.eas.tm.td.structure.utils.StructureDynamicTableManager;
import com.kingdee.eas.tm.td.structure.utils.StructureUtils;
import com.kingdee.eas.tm.td.utils.CollectionUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class TaxItemDataAnalysisFacadeControllerBean
extends AbstractTaxItemDataAnalysisFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.structure.rpt.app.TaxItemDataAnalysisFacadeControllerBean");
    private static final String RES = "com.kingdee.eas.tm.td.structure.rpt.TaxItemDataAnalysisRptResource";

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        ctx = EASEjbFactory.getCtx((String)this.getClass().getName(), (Context)ctx);
        this.dropTempTable(params.getString("tempTable"), ctx);
        this.initParams(ctx, params);
        String tempTable = this.createTempTable(ctx, this.getCreateTempTable(ctx, params));
        params.setString("tempTable", tempTable);
        this.insertBillData(ctx, params);
        RptTableHeader header = this.buildHead(ctx, params);
        RptParams result = new RptParams();
        result.setString("tempTable", tempTable);
        result.setObject("header", (Object)header);
        return result;
    }

    protected void initParams(Context ctx, RptParams params) throws BOSException, EASBizException {
        TaxReportSheetCollection coll = new TaxReportSheetCollection();
        TaxReportSheetInfo reportSheet = (TaxReportSheetInfo)params.getObject("reportSheet");
        if (reportSheet != null) {
            coll.add(reportSheet);
        } else {
            RecordTypeEnum recordType;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            TaxItemTypeInfo taxType = (TaxItemTypeInfo)params.getObject("taxType");
            if (taxType != null) {
                filter.getFilterItems().add(new FilterItemInfo("taxType.id", (Object)taxType.getId().toString(), CompareType.EQUALS));
            }
            if ((recordType = (RecordTypeEnum)((Object)params.getObject("recordType"))) != null) {
                filter.getFilterItems().add(new FilterItemInfo("recordType", (Object)recordType.getValue(), CompareType.EQUALS));
            }
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)"2", CompareType.EQUALS));
            view.setFilter(filter);
            coll = TaxReportSheetFactory.getLocalInstance(ctx).getTaxReportSheetCollection(view);
        }
        ArrayList<String> tableNameList = new ArrayList<String>();
        TaxReportSheetInfo sheetInfo = null;
        String tblName = null;
        for (int i = 0; i < coll.size(); ++i) {
            sheetInfo = coll.get(i);
            tblName = StructureDynamicTableManager.getPhysicalTblName(ctx, sheetInfo.getId().toString());
            if (StringUtils.isEmpty((String)tblName)) continue;
            tableNameList.add(tblName);
        }
        params.setObject("tableNameList", tableNameList);
    }

    protected RptTableHeader buildHead(Context ctx, RptParams params) throws BOSException {
        String[] keys = new String[]{"ID", "companyNumber", "companyName", "periodNumber", "taxTypeName", "recordType", "reportNumber", "reportName", "accountNumber", "accountName", "taxesGroupNumber", "taxesGroupName", "subRecordType", "reportSheetNumber", "reportSheetName", "rowItemNumber", "rowItemName", "columnItemNumber", "columnItemName", "valueType", "itemValue"};
        int[] keysWidth = new int[]{-1, 150, 200, 100, 100, 100, 150, 200, 150, 100, 150, 100, 100, 150, 200, 150, 200, 150, 200, 100, 150};
        String[] hidekeys = new String[]{"ID", "companyNumber", "reportNumber", "accountNumber", "taxesGroupNumber", "reportSheetNumber", "rowItemNumber", "columnItemNumber", "valueType"};
        List<String> hideKeysList = Arrays.asList(hidekeys);
        RptTableHeader header = new RptTableHeader();
        RptTableColumn col = null;
        int size = keys.length;
        Object[][] labels = new Object[1][size];
        String key = null;
        for (int i = 0; i < size; ++i) {
            key = keys[i];
            col = new RptTableColumn(keys[i]);
            col.setWidth(keysWidth[i]);
            if (hideKeysList.contains(key)) {
                col.setHided(true);
            }
            header.addColumn(col);
            labels[0][i] = TDUtils.getString(RES, key, ctx.getLocale());
        }
        header.setLabels(labels);
        return header;
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        ctx = EASEjbFactory.getCtx((String)this.getClass().getName(), (Context)ctx);
        RptRowSet rs = null;
        String tempTable = params.getString("tempTable");
        rs = this.executeQuery(this.getQuerySelectSQL(ctx, params), null, from, len, ctx);
        RptParams result = new RptParams();
        result.setObject("rowset", (Object)rs);
        RptRowSet countRs = null;
        int totalCount = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select count(*) as totalCount from ").append(tempTable);
        countRs = this.executeQuery(sql.toString(), null, ctx);
        if (countRs.next()) {
            totalCount = countRs.getInt("totalCount");
        }
        result.setInt("totalCount", totalCount);
        return result;
    }

    protected String getQuerySelectSQL(Context ctx, RptParams params) throws EASBizException, BOSException {
        String tempTable = params.getString("tempTable");
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT tbl.fid as ID,company.FNumber as companyNumber,company.FName_").append(ctx.getLocale().toString()).append(" as companyName,");
        sql.append(" period.fnumber as periodNumber,taxType.FName_").append(ctx.getLocale().toString()).append(" as taxTypeName,tbl.FRecordType as recordType,");
        sql.append(" report.fnumber as reportNumber,report.FName as reportName,");
        sql.append(" account.fnumber as accountNumber,account.FName_").append(ctx.getLocale().toString()).append(" as accountName,");
        sql.append(" taxesGroup.fnumber as taxesGroupNumber,taxesGroup.FName_").append(ctx.getLocale().toString()).append(" as taxesGroupName,tbl.FDraftRecordType as subRecordType,");
        sql.append(" reportSheet.fnumber as reportSheetNumber,reportSheet.FName_").append(ctx.getLocale().toString()).append(" as reportSheetName,");
        sql.append(" rowItem.fnumber as rowItemNumber,rowItem.FName_").append(ctx.getLocale().toString()).append(" as rowItemName,");
        sql.append(" columnItem.fnumber as columnItemNumber,columnItem.FName_").append(ctx.getLocale().toString()).append(" as columnItemName,");
        sql.append(" tbl.FValueType as valueType,ISNULL(tbl.FValue2,TOCHAR(tbl.FValue1)) as itemValue");
        sql.append(" FROM ").append(tempTable).append(" as tbl ");
        sql.append(" LEFT JOIN T_ORG_Company company on company.fid = tbl.FCompanyID ").append("\n");
        sql.append(" LEFT JOIN T_BD_Period  period on period.fid = tbl.FPeriodID ").append("\n");
        sql.append(" LEFT JOIN T_TM_TaxItemType taxType on taxType.fid = tbl.FTaxTypeID ").append("\n");
        sql.append(" left join T_TD_TaxDraftRecord report on report.fid = tbl.FReportID").append("\n");
        sql.append(" LEFT JOIN T_TM_AccountConfig account on account.fid = tbl.FAccountConfigID ").append("\n");
        sql.append(" LEFT JOIN T_TD_RealEstateGroup taxesGroup on taxesGroup.fid = tbl.FBuildingTaxesGroupID ").append("\n");
        sql.append(" LEFT JOIN T_TD_TaxReportSheet reportSheet on reportSheet.fid = tbl.FSheetID ").append("\n");
        sql.append(" LEFT JOIN T_TD_TaxReportItem rowItem on rowItem.fid = tbl.FRowItemID ").append("\n");
        sql.append(" LEFT JOIN T_TD_TaxReportItem columnItem on columnItem.fid = tbl.FColumnItemID ").append("\n");
        return sql.toString();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void insertBillData(Context ctx, RptParams params) throws BOSException, EASBizException {
        List tableNameList = (List)params.getObject("tableNameList");
        if (tableNameList == null) return;
        if (tableNameList.size() == 0) {
            return;
        }
        Connection conn = null;
        QueryDataSyncLock lock = new QueryDataSyncLock();
        ThreadPool threadPool = ThreadPool.getInstance();
        try {
            int size = tableNameList.size();
            conn = EJBFactory.getConnection((Context)ctx);
            String sql = null;
            String tblName = null;
            for (int i = 0; i < size; ++i) {
                tblName = (String)tableNameList.get(i);
                sql = this.getInsertSQL(params, tblName);
                QueryDataTask thread = new QueryDataTask(lock, tblName, conn, sql);
                lock.addLock(tblName);
                threadPool.addTask(thread);
            }
            lock.waitFinish();
        }
        catch (BOSException e) {
            try {
                throw e;
                catch (SQLException e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
    }

    protected String getInsertSQL(RptParams params, String tblName) {
        Object columnItem;
        Object rowItem;
        TaxReportSheetInfo reportSheet;
        RealEstateGroupInfo buildingTaxesGroup;
        AccountConfigInfo account;
        DraftRecordTypeEnum subRecordType;
        String tableName = params.getString("tempTable");
        StringBuffer sql = new StringBuffer();
        sql.append(" INSERT INTO ").append(tableName).append(" ( ");
        sql.append("FID,FCompanyID,FPeriodID,FTaxTypeID,FRecordType,FAccountConfigID,FBuildingTaxesGroupID,FReportID,FSheetID,FRowItemID,FColumnItemID,FValueType,FValue1,FValue2,FDraftRecordType ");
        sql.append(" ) ").append("\r\n");
        sql.append(" SELECT ").append(this.getSelectField());
        sql.append(" FROM ").append(tblName).append(" as tbl ");
        sql.append(" LEFT JOIN T_BD_Period  period on period.fid = tbl.FPeriodID ").append("\n");
        Object company = params.getObject("company");
        List ids = StructureUtils.getF7Value(company);
        sql.append(" WHERE tbl.FCompanyID in (").append(CollectionUtil.convertList2String(ids)).append(")");
        int yearFrom = (Integer)params.getObject("yearFrom");
        int monthFrom = (Integer)params.getObject("monthFrom");
        int yearTo = (Integer)params.getObject("yearTo");
        int monthTo = (Integer)params.getObject("monthTo");
        sql.append(" and period.FPERIODYEAR*100+period.FPERIODNUMBER >= ").append(yearFrom * 100 + monthFrom);
        sql.append(" and ").append(" period.FPERIODYEAR*100+period.FPERIODNUMBER <= ").append(yearTo * 100 + monthTo);
        TaxItemTypeInfo taxType = (TaxItemTypeInfo)params.getObject("taxType");
        sql.append(" and tbl.FTaxTypeID = '").append(taxType.getId().toString()).append("'");
        RecordTypeEnum recordType = (RecordTypeEnum)((Object)params.getObject("recordType"));
        sql.append(" and tbl.FRecordType=").append(recordType.getValue());
        Object report = params.getObject("report");
        if (report != null) {
            ids = StructureUtils.getF7Value(report);
            sql.append(" and FReportID in (").append(CollectionUtil.convertList2String(ids)).append(")");
        }
        if ((subRecordType = (DraftRecordTypeEnum)((Object)params.getObject("subRecordType"))) != null) {
            sql.append(" and FDraftRecordType = ").append(subRecordType.getValue());
        }
        if ((account = (AccountConfigInfo)params.getObject("account")) != null) {
            sql.append(" and FAccountConfigID = '").append(account.getId().toString()).append("'");
        }
        if ((buildingTaxesGroup = (RealEstateGroupInfo)params.getObject("buildingTaxesGroup")) != null) {
            sql.append(" and FBuildingTaxesGroupID = '").append(buildingTaxesGroup.getId().toString()).append("'");
        }
        if ((reportSheet = (TaxReportSheetInfo)params.getObject("reportSheet")) != null) {
            sql.append(" and FSheetID = '").append(reportSheet.getId().toString()).append("'");
        }
        if ((rowItem = params.getObject("rowItem")) != null) {
            ids = StructureUtils.getF7Value(rowItem);
            sql.append(" and FRowItemID in (").append(CollectionUtil.convertList2String(ids)).append(")");
        }
        if ((columnItem = params.getObject("columnItem")) != null) {
            ids = StructureUtils.getF7Value(columnItem);
            sql.append(" and FColumnItemID in (").append(CollectionUtil.convertList2String(ids)).append(")");
        }
        return sql.toString();
    }

    private String getSelectField() {
        String selectField = "tbl.FID,tbl.FCompanyID,tbl.FPeriodID,tbl.FTaxTypeID,tbl.FRecordType,tbl.FAccountConfigID,tbl.FBuildingTaxesGroupID,tbl.FReportID,tbl.FSheetID,tbl.FRowItemID,tbl.FColumnItemID,tbl.FValueType,tbl.FValue1,tbl.FValue2,tbl.FDraftRecordType ";
        return selectField;
    }

    private String getCreateTempTable(Context ctx, RptParams params) throws EASBizException, BOSException {
        return "Create Table TempReportTable ( FID VARCHAR(44) NOT NULL,FCompanyID VARCHAR(44),FPeriodID VARCHAR(44),FTaxTypeID VARCHAR(44),FRecordType int,FAccountConfigID VARCHAR(44),FBuildingTaxesGroupID VARCHAR(44),FReportID VARCHAR(44),FSheetID VARCHAR(44),FRowItemID VARCHAR(44),FColumnItemID VARCHAR(44),FValueType VARCHAR(20),FValue1 NUMERIC(28,16),FValue2 NVARCHAR(255),FDraftRecordType int)";
    }
}

