/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.structure.utils;

import com.kingdee.bos.ctrl.excel.io.BookIOController;
import com.kingdee.bos.ctrl.excel.io.BookIOUtil;
import com.kingdee.bos.ctrl.excel.io.table.BookKdfIOController;
import com.kingdee.bos.ctrl.excel.io.table.IBookKdfUOTrans;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.eas.fi.rpt.util.BookKdfUOTransDelegate;
import com.kingdee.eas.tm.td.structure.utils.TaxUserObjectTrans;
import com.kingdee.eas.tm.td.utils.IOUtils;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class TaxIOHelper {
    private static Logger logger = Logger.getLogger(TaxIOHelper.class);
    private static Map transMapping = new HashMap(2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadKDFUpGrader() {
        InputStream in = null;
        try {
            in = TaxUserObjectTrans.class.getResourceAsStream("KDFUserObject2BookUserObject.properties");
            Properties p = new Properties();
            p.load(in);
            for (Map.Entry<Object, Object> e : p.entrySet()) {
                Class<?> c = Class.forName((String)e.getValue());
                transMapping.put(e.getKey(), (IBookKdfUOTrans)c.newInstance());
            }
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
        }
        finally {
            IOUtils.close(in);
        }
    }

    public static byte[] packBook(Book book) throws IOException {
        BookIOController ctrl = TaxIOHelper.getCtrl();
        return BookIOUtil.pack((Book)book, (BookIOController)ctrl);
    }

    public static BookIOController getCtrl() {
        BookIOController ctrl = new BookIOController();
        ctrl.setKmlUOTrans((Book.IUserObjectProvider)new TaxUserObjectTrans());
        ctrl.setIOMode(TaxIOHelper.getNoCommentMode());
        return ctrl;
    }

    public static int getNoCommentMode() {
        int mod = BookIOController.FLAG_ALL;
        if ((mod & BookIOController.FLAG_BOOK_COMMENT) == BookIOController.FLAG_BOOK_COMMENT) {
            mod ^= BookIOController.FLAG_BOOK_COMMENT;
        }
        if ((mod & BookIOController.FLAG_CELL_COMMENT) == BookIOController.FLAG_CELL_COMMENT) {
            mod ^= BookIOController.FLAG_CELL_COMMENT;
        }
        if ((mod & BookIOController.FLAG_SHEET_COMMENT) == BookIOController.FLAG_SHEET_COMMENT) {
            mod ^= BookIOController.FLAG_SHEET_COMMENT;
        }
        return mod;
    }

    public static Book unpackBook(byte[] data, String kdf_trans_type) throws Exception {
        return TaxIOHelper.unpackBook(data, BookIOController.FLAG_ALL, kdf_trans_type);
    }

    public static Book unpackBook(byte[] data, int mode, String kdf_trans_type) throws Exception {
        BookIOController ctrl = TaxIOHelper.getCtrl();
        ctrl.setIOMode(mode);
        Book book = BookIOUtil.unpack((byte[])data, (BookIOController)ctrl, (BookKdfIOController)TaxIOHelper.getCtrl2(kdf_trans_type));
        book.getUndoManager().enable(false);
        return book;
    }

    private static BookKdfIOController getCtrl2(String trans_type) {
        BookKdfIOController ctrl = new BookKdfIOController();
        BookKdfUOTransDelegate transDelegate = new BookKdfUOTransDelegate();
        if (trans_type == null) {
            Iterator it = transMapping.values().iterator();
            while (it.hasNext()) {
                transDelegate.add((IBookKdfUOTrans)it.next());
            }
        } else {
            String[] split = StringUtils.split((String)trans_type, (int)124);
            for (int i = 0; i < split.length; ++i) {
                IBookKdfUOTrans bookKdfUOTrans = (IBookKdfUOTrans)transMapping.get(split[i]);
                if (bookKdfUOTrans == null) continue;
                transDelegate.add(bookKdfUOTrans);
            }
        }
        ctrl.setTableUOTrans((IBookKdfUOTrans)transDelegate);
        return ctrl;
    }

    static {
        TaxIOHelper.loadKDFUpGrader();
    }
}

