/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.newrpt.client.rptnewui.rptprop.OrgNodeUserDefineInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class OrgTreeBuilder {
    private final KDTree _orgTree;
    private final KDTreeNode _root;
    private Map<String, OrgNodeUserDefineInfo> _OrgNodeMap;
    private Set<String> _orgIDSets = null;

    public OrgTreeBuilder(KDTree orgTree, KDTreeNode root, Map<String, OrgNodeUserDefineInfo> OrgNodeMap) throws BOSException {
        this._orgTree = orgTree;
        this._root = root;
        this._OrgNodeMap = OrgNodeMap;
    }

    public void initOrgTree() {
        DefaultTreeModel model = (DefaultTreeModel)this._orgTree.getModel();
        model.setRoot((TreeNode)this._root);
        this._root.removeAllChildren();
    }

    public void buildOrgTree() throws EASBizException, BOSException, SQLException {
        this.addNode(this._OrgNodeMap);
        this._orgTree.expandAllNodes(true, (TreeNode)this._root);
    }

    public void expandAllNodes(KDTreeNode node) {
        this._orgTree.expandAllNodes(true, (TreeNode)node);
    }

    private void addNode(Map<String, OrgNodeUserDefineInfo> OrgnodeMap) {
        ArrayList<OrgNodeUserDefineInfo> valus = new ArrayList<OrgNodeUserDefineInfo>(OrgnodeMap.values());
        Collections.sort(valus, (Comparator)new Comparator<OrgNodeUserDefineInfo>(){

            @Override
            public int compare(OrgNodeUserDefineInfo arg0, OrgNodeUserDefineInfo arg1) {
                return arg0.getLongNum().compareTo(arg1.getLongNum());
            }
        });
        for (OrgNodeUserDefineInfo orgNode : valus) {
            KDTreeNode node = new KDTreeNode((Object)orgNode);
            if (orgNode.getLongNum().lastIndexOf("!") == -1) {
                this._root.add((MutableTreeNode)node);
                continue;
            }
            String parentLogNum = orgNode.getLongNum().substring(0, orgNode.getLongNum().lastIndexOf("!"));
            KDTreeNode root = this.findOrgNode(this._root, parentLogNum);
            if (root == null) {
                root = this._root;
            }
            root.add((MutableTreeNode)node);
        }
    }

    public void selectedCurrentLoginOrgnode() {
        this.selectedOrgNodeByGivenCompany(null);
    }

    public void selectedOrgNodeByGivenCompany(Object company) {
        String orgPK = company instanceof String ? (String)company : (company instanceof OrgUnitInfo ? ((OrgUnitInfo)company).getId().toString() : SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
        this._orgTree.setSelectionNode((DefaultKingdeeTreeNode)this.findCurOrgNode(orgPK, this._root));
    }

    public void sortOrgNodeMap(Map<String, OrgNodeUserDefineInfo> OrgnodeMap) {
        ArrayList<OrgNodeUserDefineInfo> valus = new ArrayList<OrgNodeUserDefineInfo>(OrgnodeMap.values());
        Collections.sort(valus, (Comparator)new Comparator<OrgNodeUserDefineInfo>(){

            @Override
            public int compare(OrgNodeUserDefineInfo arg0, OrgNodeUserDefineInfo arg1) {
                return arg0.getLongNum().compareTo(arg1.getLongNum());
            }
        });
    }

    public KDTreeNode findOrgNode(KDTreeNode nextNode, String longNum) {
        OrgNodeUserDefineInfo defineInfo;
        if (nextNode.getUserObject() instanceof OrgNodeUserDefineInfo && longNum.equals((defineInfo = (OrgNodeUserDefineInfo)nextNode.getUserObject()).getLongNum())) {
            return nextNode;
        }
        Enumeration enumt = nextNode.children();
        while (enumt.hasMoreElements()) {
            KDTreeNode targetNode = this.findOrgNode((KDTreeNode)enumt.nextElement(), longNum);
            if (targetNode == null) continue;
            return targetNode;
        }
        return null;
    }

    public KDTreeNode findCurOrgNode(String orgPK, KDTreeNode nextNode) {
        OrgNodeUserDefineInfo defineInfo;
        if (nextNode.getUserObject() instanceof OrgNodeUserDefineInfo && orgPK.equals((defineInfo = (OrgNodeUserDefineInfo)nextNode.getUserObject()).getOrgPK())) {
            return nextNode;
        }
        Enumeration enumt = nextNode.children();
        while (enumt.hasMoreElements()) {
            KDTreeNode targetNode = this.findCurOrgNode(orgPK, (KDTreeNode)enumt.nextElement());
            if (targetNode == null) continue;
            return targetNode;
        }
        return null;
    }

    private KDTreeNode findOrgNode(String orgPK) {
        Enumeration enumt = this._root.children();
        KDTreeNode childrenNode = null;
        boolean isFound = false;
        while (enumt.hasMoreElements()) {
            childrenNode = (KDTreeNode)enumt.nextElement();
            OrgNodeUserDefineInfo defineInfo = (OrgNodeUserDefineInfo)childrenNode.getUserObject();
            if (!orgPK.equals(defineInfo.getOrgPK())) continue;
            isFound = true;
            break;
        }
        return childrenNode;
    }

    public KDTreeNode getSelectedTreeNode() {
        if (this._orgTree.getSelectionPath() != null) {
            return (KDTreeNode)this._orgTree.getSelectionPath().getLastPathComponent();
        }
        return null;
    }

    public void selectTreeNode(KDTreeNode treeNode) {
        this._orgTree.setSelectionNode((DefaultKingdeeTreeNode)treeNode);
    }

    public Set<String> getOrgIDSets() {
        if (this._orgIDSets == null) {
            this._orgIDSets = new HashSet<String>();
            if (this._OrgNodeMap != null) {
                Iterator<String> it = this._OrgNodeMap.keySet().iterator();
                while (it.hasNext()) {
                    this._orgIDSets.add(it.next());
                }
            }
        }
        return this._orgIDSets;
    }
}

