/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class TDParamUtil {
    private static Logger logger = Logger.getLogger(TDParamUtil.class);
    public static final String PARAM_FILE_PATH = "tmParam.properties";
    public static final String SOLUTIONMGR_SECRET = "td.solutionmgr.secret";
    private static Properties properties = new Properties();

    public static String getValue(String key) {
        return properties.getProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() {
        String propertiesPath = System.getProperty("eas.properties.dir");
        propertiesPath = FilenameUtils.normalize((String)propertiesPath);
        String fileName = propertiesPath + File.separator + "tm" + File.separator + PARAM_FILE_PATH;
        FileInputStream in = null;
        try {
            in = new FileInputStream(fileName);
            properties.load(in);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void clearCache() {
        properties.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refresh(String fileName) {
        Properties prop = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(fileName);
            prop.load(in);
            TDParamUtil.setProperties(prop);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setProperties(Properties prop) {
        if (prop == null || prop.isEmpty()) {
            return;
        }
        Set<Object> keys = prop.keySet();
        if (keys != null) {
            for (String string : keys) {
                properties.setProperty(string, prop.getProperty(string));
            }
        }
    }

    static {
        TDParamUtil.load();
    }
}

