/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.utils;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.TaxDraftRecordFactory;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;

public class TaxDraftProvider
extends IBookProvider {
    public Book loadBook() throws Exception {
        Book book = null;
        if (this.getTaxDraftRecordInfo() == null) {
            this.setEditValue(this.createNewReport());
        }
        if (this.getTaxDraftRecordInfo().getData() != null) {
            book = this.getTaxDraftRecordInfo().getBook();
        }
        if (book != null) {
            // empty if block
        }
        if (this.getTaxDraftRecordInfo() != null && RecordTypeEnum.Account.equals((Object)this.getTaxDraftRecordInfo().getRecordType()) && book == null) {
            book = Book.Manager.getNewBook(null, (int)0);
        }
        return book;
    }

    public TaxDraftRecordInfo getTaxDraftRecordInfo() {
        return (TaxDraftRecordInfo)this.getEditValue();
    }

    public void restoreBook(Book book) throws Exception {
        if (ReportVariables.loadFromBook((Book)book) == null) {
            book.setUserObject("VARIABLES", (Object)new ReportVariables());
        }
        this.getTaxDraftRecordInfo().setBook(book);
    }

    public IObjectValue createNewReport() throws Exception {
        return new TaxDraftRecordInfo();
    }

    public ICoreBase getBizInterface() throws Exception {
        return TaxDraftRecordFactory.getRemoteInstance();
    }

    public String getBizFactoryName() {
        return TaxDraftRecordFactory.class.getName();
    }

    protected SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("companyOrgUnit.*"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.number"));
        sic.add(new SelectorItemInfo("rptPeriod.*"));
        sic.add(new SelectorItemInfo("rptPeriodFrom.*"));
        sic.add(new SelectorItemInfo("rptPeriodTo.*"));
        sic.add(new SelectorItemInfo("relateRecordAccount.*"));
        sic.add(new SelectorItemInfo("orgTree.*"));
        sic.add(new SelectorItemInfo("taxType.*"));
        sic.add(new SelectorItemInfo("relateAccount.*"));
        sic.add(new SelectorItemInfo("relateAccount.entry.*"));
        sic.add(new SelectorItemInfo("taxType.*"));
        sic.add(new SelectorItemInfo("billRange.id"));
        sic.add(new SelectorItemInfo("billRange.number"));
        sic.add(new SelectorItemInfo("billRange.entrys.*"));
        sic.add(new SelectorItemInfo("buildingTaxesGroup.*"));
        return sic;
    }
}

