/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.common.util;

import java.util.ArrayList;
import java.util.Collection;

public class PageList
extends ArrayList {
    protected int pageCount = 0;
    protected int currentPage = 0;
    protected int totalRowCount = 0;
    protected int pageSize;

    public PageList() {
    }

    public PageList(Collection c) {
        super(c);
    }

    public PageList(int initialCapacity) {
        super(initialCapacity);
    }

    public void setPageCount(int pageCount) {
        if (pageCount < 0) {
            pageCount = 0;
        }
        this.pageCount = pageCount;
    }

    public void setCurrentPage(int currentPage) {
        if (currentPage < 0) {
            currentPage = 0;
        }
        this.currentPage = currentPage;
    }

    public void setTotalRowCount(int totalRowCount) {
        this.totalRowCount = totalRowCount;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getTotalRowCount() {
        return this.totalRowCount;
    }

    public void calcPageCount(int pageSize) {
        int n;
        if (pageSize < 1) {
            pageSize = 1;
        }
        if ((n = this.totalRowCount % pageSize) == 0) {
            this.setPageCount(this.totalRowCount / pageSize);
        } else {
            this.setPageCount((this.totalRowCount - n) / pageSize + 1);
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
        this.calcPageCount(pageSize);
    }
}

