/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.module.cm.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.freechart.util.Log;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.cp.eip.cm.CMColorInfo;
import com.kingdee.eas.cp.eip.cm.CMColumnFactory;
import com.kingdee.eas.cp.eip.cm.CMColumnInfo;
import com.kingdee.eas.cp.eip.cm.CMReaderCollection;
import com.kingdee.eas.cp.eip.cm.CMReaderFactory;
import com.kingdee.eas.cp.eip.cm.CMReaderInfo;
import com.kingdee.eas.cp.eip.cm.ContentManageFactory;
import com.kingdee.eas.cp.eip.cm.ICMColumn;
import com.kingdee.eas.cp.eip.cm.ICMReader;
import com.kingdee.eas.cp.eip.cm.IContentManage;
import com.kingdee.eas.cp.eip.cm.LinkPicShowTypeEnum;
import com.kingdee.eas.cp.eip.cm.web.ContentResourceHandle;
import com.kingdee.eas.cp.eip.cm.web.util.CmUtil;
import com.kingdee.eas.cp.eip.de.web.DocumentOperater;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.biz.common.util.PortalContextUtil;
import com.kingdee.portal.common.util.StringUtil;
import com.kingdee.portal.plt.cp.common.exception.CpBizException;
import com.kingdee.portal.plt.cp.common.exception.conf.CpErrConfig;
import com.kingdee.portal.plt.cp.common.util.OldPortalSkinUtil;
import com.kingdee.portal.plt.cp.module.cm.dto.AttachmentDTO;
import com.kingdee.portal.plt.cp.module.cm.dto.CmDocDTO;
import com.kingdee.portal.plt.cp.module.cm.dto.CmPortletDTO;
import com.kingdee.portal.plt.cp.module.cm.service.ContentService;
import com.kingdee.portal.plt.cp.module.cm.service.impl.ContentServiceImpl;
import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class CMPortletNewAction
extends BaseAction {
    private static final String REECNTCOLUMNID = "tSFimQEREADgAAD5wKgSr7n/tuc=";
    private ContentService contentService = ContentServiceImpl.getInstance();

    public void doContent() {
        HttpServletRequest request = this.getRequest();
        try {
            String id = request.getParameter("id");
            String skin = request.getParameter("skin");
            if (id != null && id.trim().length() > 0) {
                CmPortletDTO cmDto = new CmPortletDTO();
                id = id.replaceAll(" ", "+");
                PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)request);
                Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
                if (ctx == null) {
                    this.logger.error("CMPortletNewAction getContext Error");
                    this.writeAjaxData(false, new LocalErr(), null);
                    return;
                }
                ICMColumn iCMColumn = CMColumnFactory.getLocalInstance((Context)ctx);
                if (!iCMColumn.exists((IObjectPK)new ObjectUuidPK(id))) {
                    this.logger.error("CMPortletNewAction \u5f53\u524dPortlet\u7684\u680f\u76eeID:" + id);
                    this.writeAjaxData(false, this.handleErr((Exception)((Object)new CpBizException(CpErrConfig.CM_PORTLET_NOT_EXIT))), null);
                    return;
                }
                CMColumnInfo info = iCMColumn.getCMColumnInfo((IObjectPK)new ObjectUuidPK(id));
                cmDto.setLinkPicShowType(info.getLinkPicShowType());
                cmDto.setContentHight(info.getContentHight());
                cmDto.setContentWidth(info.getContentWidth());
                cmDto.setColumnID(id);
                cmDto.setDisplayAuthor(info.isDisplayAuthor());
                cmDto.setDisplayDate(info.isDisplayDate());
                cmDto.setIsDisplayClass(info.isDisplayClass());
                cmDto.setColumnPicture(ContentResourceHandle.getContentResourceFile((String)info.getId().toString(), (Context)ctx, (ServletContext)this.getServletContext()));
                if (info.isCuFilter()) {
                    cmDto.setCanContribute(info.isCanContribute());
                } else {
                    CtrlUnitInfo tempCU = info.getCU();
                    if (tempCU != null && tempCU.getId() != null) {
                        if (ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString().equals(tempCU.getId().toString())) {
                            cmDto.setCanContribute(info.isCanContribute());
                        } else {
                            cmDto.setCanContribute(false);
                        }
                    }
                }
                cmDto.setScrollType(info.getScrollType());
                cmDto.setDisplayRows(info.getDisplayCount() <= 0 ? 5 : info.getDisplayCount());
                cmDto.setDisplayCols(info.getColCount() <= 0 ? 1 : info.getColCount());
                CMColorInfo colorInfo = OldPortalSkinUtil.getUserColor(skin);
                cmDto.setReadedStyle(colorInfo.getReadColor());
                cmDto.setUnReadedStyle(colorInfo.getUnReadColor());
                cmDto.setViewCount(info.getViewCount() <= 0 ? 5 : info.getViewCount());
                IRowSet rowSet = null;
                boolean isRecent = false;
                if (REECNTCOLUMNID.equals(info.getId().toString())) {
                    rowSet = this.getRecentContent(ctx);
                    isRecent = true;
                } else {
                    rowSet = this.getAuthorizedContent(ctx, id, info);
                }
                HashMap idMap = CmUtil.getReadRecord((HttpServletRequest)request, (IRowSet)rowSet);
                List<CmDocDTO> docList = null;
                if (rowSet != null && rowSet.size() > 0) {
                    HashMap attachmentDtoMap = this.getAttachmentDetail(request, rowSet);
                    docList = this.builtDocList(isRecent, info.getColumnType().getValue(), rowSet, idMap, cmDto, info.getLinkPicShowType(), ctx, attachmentDtoMap);
                    rowSet.beforeFirst();
                }
                cmDto.setDocList(docList);
                this.writeAjaxData(true, null, cmDto);
            } else {
                this.writeAjaxData(false, this.handleErr((Exception)((Object)new CpBizException(CpErrConfig.CM_PORTLET_NO_ID))), null);
            }
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    private HashMap getAttachmentDetail(HttpServletRequest request, IRowSet rowSet) {
        HashMap<String, AttachmentDTO> attachmentDetailMap = new HashMap<String, AttachmentDTO>();
        ArrayList<String> ids = new ArrayList<String>();
        try {
            PortalContext ctx;
            List<AttachmentDTO> attachmentList;
            while (rowSet.next()) {
                String fileId = rowSet.getString("FILE");
                if (fileId == null || fileId == "") continue;
                ids.add(fileId);
            }
            while (rowSet.previous()) {
            }
            if (ids.size() > 0 && (attachmentList = this.contentService.getAttachmentListByFile(ctx = this.getPortalContext(), ids)).size() > 0) {
                for (int i = 0; i < attachmentList.size(); ++i) {
                    AttachmentDTO attachmentDTO = attachmentList.get(i);
                    attachmentDetailMap.put(attachmentDTO.getDocId(), attachmentDTO);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attachmentDetailMap;
    }

    private List<CmDocDTO> builtDocList(boolean isRecent, int columnType, IRowSet rowSet, HashMap idMap, CmPortletDTO cmDto, LinkPicShowTypeEnum linkEnum, Context ctx, HashMap<String, AttachmentDTO> attachmentDtoMap) throws UnsupportedEncodingException, SQLException {
        DocumentOperater docOp = new DocumentOperater();
        docOp.setContext(ctx);
        ArrayList<CmDocDTO> docList = new ArrayList<CmDocDTO>();
        while (rowSet.next()) {
            AttachmentDTO attachmentDto = attachmentDtoMap.get(rowSet.getString("FILE"));
            CmDocDTO docInfo = this.createCmDocDTO(isRecent, columnType, rowSet, idMap, cmDto, docOp, linkEnum, ctx, attachmentDto);
            docList.add(docInfo);
        }
        return docList;
    }

    private CmDocDTO createCmDocDTO(boolean isRecent, int columnType, IRowSet rowSet, HashMap idMap, CmPortletDTO cmDto, DocumentOperater docOp, LinkPicShowTypeEnum linkEnum, Context ctx, AttachmentDTO attachmentDto) throws SQLException, UnsupportedEncodingException {
        CmDocDTO docInfo = new CmDocDTO();
        docInfo.setDocId(rowSet.getString("ID"));
        String summary = rowSet.getString("summary");
        docInfo.setCloumnType(columnType);
        HttpServletRequest request = this.getRequest();
        String isNewTmpl = request.getParameter("isNewTmpl");
        if (columnType == 30 && StringUtils.isEmpty((String)summary)) {
            byte[] docBodyContent = docOp.getDocBodyContent(rowSet.getString("ID"));
            if (docBodyContent != null) {
                summary = new String(docBodyContent, "UTF-8");
                if (summary.length() > 200) {
                    summary = summary.substring(0, 197) + "...";
                }
            } else {
                summary = "";
            }
        } else if (isRecent) {
            docInfo.setCloumnType(rowSet.getInt("CMColumn.columnType"));
        }
        docInfo.setColumnName(rowSet.getString("CMCOLUMN.NAME"));
        docInfo.setSummary(summary);
        boolean isDisplayNew = false;
        if (rowSet.getBoolean("displayNew")) {
            Date beginDate = rowSet.getDate("beginDate");
            Date endDate = rowSet.getDate("endDate");
            if (beginDate != null && endDate != null) {
                Calendar cal = Calendar.getInstance();
                long curDay = cal.getTimeInMillis();
                cal.setTime(beginDate);
                long startDay = cal.getTimeInMillis();
                cal.setTime(endDate);
                long endDay = cal.getTimeInMillis();
                if (curDay >= startDay && curDay < endDay) {
                    isDisplayNew = true;
                }
            }
        }
        docInfo.setDisplayNew(isDisplayNew);
        String tips = rowSet.getString("TITLE");
        String title = "";
        String className = "";
        if (tips != null) {
            title = tips;
        }
        if (cmDto.getIsDisplayClass().booleanValue()) {
            docInfo.setClassName(rowSet.getString("CMClass.name"));
            className = "&nbsp;&nbsp;[" + rowSet.getString("CMClass.name") + "]";
        }
        if ("false".equals(isNewTmpl) && attachmentDto != null) {
            if (isRecent) {
                if (cmDto.isDisplayDate() && cmDto.isDisplayAuthor()) {
                    title = "<span style='_portletWidth'>" + title + "</span><span style='float: right;margin-right: 15px;'>" + rowSet.getString("User.name") + "&nbsp;&nbsp;&nbsp;&nbsp;" + rowSet.getString("lastUpdateTime").substring(0, 10) + className + "</span>";
                } else if (cmDto.isDisplayDate() && !cmDto.isDisplayAuthor()) {
                    title = "<span style='_portletWidth'>" + title + "</span><span style='float: right;margin-right: 15px;'>" + rowSet.getString("lastUpdateTime").substring(0, 10) + className + "</span>";
                } else if (!cmDto.isDisplayDate() && cmDto.isDisplayAuthor()) {
                    title = "<span style='_portletWidth'>" + title + "</span><span style='float: right;margin-right: 15px;'>" + rowSet.getString("User.name") + className + "</span>";
                }
            } else if (columnType == 20) {
                if (cmDto.isDisplayDate() && cmDto.isDisplayAuthor()) {
                    title = "<span style='float: left;'>" + title + "</span><span style='float: right;margin-right: 15px;' >" + rowSet.getString("User.name") + "&nbsp;&nbsp;&nbsp;&nbsp;" + rowSet.getString("lastUpdateTime").substring(0, 10) + className + "</span>";
                } else if (cmDto.isDisplayDate() && !cmDto.isDisplayAuthor()) {
                    title = "<span style='float: left;' >" + title + "</span><span style='float: right;margin-right: 15px;' >" + rowSet.getString("lastUpdateTime").substring(0, 10) + className + "</span>";
                } else if (!cmDto.isDisplayDate() && cmDto.isDisplayAuthor()) {
                    title = "<span style='float: left;' >" + title + "</span><span style='float: right;margin-right: 15px;'>" + rowSet.getString("User.name") + className + "</span>";
                }
            } else if (columnType != 70) {
                if (cmDto.isDisplayDate() && cmDto.isDisplayAuthor()) {
                    title = "<span class='title_old'>" + title + "." + attachmentDto.getSimplename() + "</span>&nbsp;&nbsp;<span class='file-size_old'>(" + attachmentDto.getFileSize() + ")</span>&nbsp;&nbsp;&nbsp;<span class='author-date_old'>" + rowSet.getString("User.name") + "&nbsp;(" + rowSet.getString("lastUpdateTime").substring(0, 10) + ")</span>";
                } else if (cmDto.isDisplayDate() && !cmDto.isDisplayAuthor()) {
                    title = "<span class='title_old'>" + title + "." + attachmentDto.getSimplename() + "</span>&nbsp;&nbsp;<span class='file-size_old'>(" + attachmentDto.getFileSize() + ")</span>&nbsp;&nbsp;&nbsp;<span class='author-date_old'>(" + rowSet.getString("lastUpdateTime").substring(0, 10) + ")</span>";
                } else if (!cmDto.isDisplayDate() && cmDto.isDisplayAuthor()) {
                    title = "<span class='title_old'>" + title + "." + attachmentDto.getSimplename() + "</span>&nbsp;&nbsp;<span class='file-size_old'>(" + attachmentDto.getFileSize() + ")</span>&nbsp;&nbsp;&nbsp;<span class='author-date_old'>(" + rowSet.getString("User.name") + ")</span>";
                }
            }
        } else if (isRecent) {
            if (cmDto.isDisplayDate() && cmDto.isDisplayAuthor()) {
                title = "<span style='_portletWidth'>" + title + "</span><span style='float: right;margin-right: 15px;'>" + rowSet.getString("User.name") + "&nbsp;&nbsp;&nbsp;&nbsp;" + rowSet.getString("lastUpdateTime").substring(0, 10) + className + "</span>";
            } else if (cmDto.isDisplayDate() && !cmDto.isDisplayAuthor()) {
                title = "<span style='_portletWidth'>" + title + "</span><span style='float: right;margin-right: 15px;'>" + rowSet.getString("lastUpdateTime").substring(0, 10) + className + "</span>";
            } else if (!cmDto.isDisplayDate() && cmDto.isDisplayAuthor()) {
                title = "<span style='_portletWidth'>" + title + "</span><span style='float: right;margin-right: 15px;'>" + rowSet.getString("User.name") + className + "</span>";
            }
        } else if (columnType == 20) {
            if (cmDto.isDisplayDate() && cmDto.isDisplayAuthor()) {
                title = "<span style='float: left;'>" + title + "</span><span style='float: right;margin-right: 15px;' >" + rowSet.getString("User.name") + "&nbsp;&nbsp;&nbsp;&nbsp;" + rowSet.getString("lastUpdateTime").substring(0, 10) + className + "</span>";
            } else if (cmDto.isDisplayDate() && !cmDto.isDisplayAuthor()) {
                title = "<span style='float: left;' >" + title + "</span><span style='float: right;margin-right: 15px;' >" + rowSet.getString("lastUpdateTime").substring(0, 10) + className + "</span>";
            } else if (!cmDto.isDisplayDate() && cmDto.isDisplayAuthor()) {
                title = "<span style='float: left;' >" + title + "</span><span style='float: right;margin-right: 15px;'>" + rowSet.getString("User.name") + className + "</span>";
            }
        } else if (columnType != 70) {
            if (cmDto.isDisplayDate() && cmDto.isDisplayAuthor()) {
                title = "<span class='title title-ellipsis' style='_portletWidth'>" + title + "</span><span class='author-date title-ellipsis'>" + rowSet.getString("User.name") + "&nbsp;&nbsp;&nbsp;&nbsp;" + rowSet.getString("lastUpdateTime").substring(0, 10) + className + "</span>";
            } else if (cmDto.isDisplayDate() && !cmDto.isDisplayAuthor()) {
                title = "<span class='title title-ellipsis' style='_portletWidth'>" + title + "</span><span class='author-date title-ellipsis'>" + rowSet.getString("lastUpdateTime").substring(0, 10) + className + "</span>";
            } else if (!cmDto.isDisplayDate() && cmDto.isDisplayAuthor()) {
                title = "<span class='title title-ellipsis' style='_portletWidth'>" + title + "</span><span class='author-date title-ellipsis'>" + rowSet.getString("User.name") + className + "</span>";
            }
        }
        docInfo.setTips(tips);
        docInfo.setTitle(title);
        docInfo.setFileType(attachmentDto == null ? "" : attachmentDto.getSimplename());
        String file = rowSet.getString("file");
        String pictureSrc = StringUtils.isEmpty((String)file) ? "tt" : ContentResourceHandle.getContentResourceFile((String)file, (Context)ctx, (ServletContext)this.getServletContext());
        docInfo.setPictureSrc(pictureSrc);
        if ("true".equals(idMap.get(docInfo.getDocId()))) {
            docInfo.setReaded(true);
        } else {
            docInfo.setReaded(false);
        }
        return docInfo;
    }

    private IRowSet getAuthorizedContent(Context ctx, String id, CMColumnInfo info) throws Exception {
        if (id == null || info == null) {
            return null;
        }
        IRowSet rowSet = null;
        HashSet hashSet = this.getReadColumnIDStr(ctx);
        if (hashSet.contains(id)) {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo filterItemInfo = null;
            filterItemInfo = new FilterItemInfo("columnID", (Object)id, CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            filterItemInfo = new FilterItemInfo("status", (Object)new Integer(2), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            boolean isNotice = false;
            int columnType = 0;
            columnType = info.getColumnType() != null ? info.getColumnType().getValue() : 10;
            Calendar cal = Calendar.getInstance();
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            filterItemInfo = new FilterItemInfo("isRoleControl", (Object)new Integer(0), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            FilterInfo rangFilterInfo = CmUtil.getContributeRangFilter((Context)ctx, (String)id, null, (String)new Integer(2).toString(), null, null, null);
            if (rangFilterInfo.getFilterItems().size() > 0) {
                filterInfo.mergeFilter(rangFilterInfo, "or");
            }
            entityViewInfo.setFilter(filterInfo);
            SorterItemInfo sorterItemInfo = new SorterItemInfo("lastUpdateTime");
            sorterItemInfo.setSortType(SortType.DESCEND);
            entityViewInfo.getSorter().add(sorterItemInfo);
            MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.cp.eip.cm.app", "ContentQuery");
            IQueryExecutor exec = this.getQueryExecutor((IMetaDataPK)queryPK, entityViewInfo, ctx);
            int tempSize = 0;
            int tempRows = info.getDisplayCount();
            int tempCols = info.getColCount();
            if (tempRows <= 0) {
                tempRows = 5;
            }
            if (tempCols <= 0) {
                tempCols = 1;
            }
            tempSize = tempRows * tempCols;
            java.util.Date date1 = new java.util.Date();
            if (tempSize > 0) {
                rowSet = exec.executeQuery(0, tempSize);
            }
            java.util.Date date = new java.util.Date();
        } else {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            int columnType = 0;
            columnType = info.getColumnType() != null ? info.getColumnType().getValue() : 10;
            FilterInfo rangFilterInfo = CmUtil.getContributeRangFilter((Context)ctx, (String)id, null, (String)new Integer(2).toString(), null, null, null);
            entityViewInfo.setFilter(rangFilterInfo);
            SorterItemInfo sorterItemInfo = new SorterItemInfo("lastUpdateTime");
            sorterItemInfo.setSortType(SortType.DESCEND);
            entityViewInfo.getSorter().add(sorterItemInfo);
            MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.cp.eip.cm.app", "ContentQuery");
            IQueryExecutor exec = this.getQueryExecutor((IMetaDataPK)queryPK, entityViewInfo, ctx);
            int tempSize = 0;
            int tempRows = info.getDisplayCount();
            int tempCols = info.getColCount();
            if (tempRows <= 0) {
                tempRows = 5;
            }
            if (tempCols <= 0) {
                tempCols = 1;
            }
            if ((tempSize = tempRows * tempCols) > 0) {
                rowSet = exec.executeQuery(0, tempSize);
            }
        }
        return rowSet;
    }

    private IRowSet getRecentContent(Context ctx) {
        try {
            HashSet hashSet = this.getReadColumnIDStr(ctx);
            if (hashSet != null && hashSet.size() > 0) {
                ICMColumn iCMColumn = CMColumnFactory.getLocalInstance((Context)ctx);
                CMColumnInfo info = iCMColumn.getCMColumnInfo((IObjectPK)new ObjectUuidPK(REECNTCOLUMNID));
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                FilterItemInfo filterItemInfo = null;
                filterItemInfo = new FilterItemInfo("columnID", (Object)hashSet, CompareType.INNER);
                filterInfo.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("status", (Object)new Integer(2), CompareType.EQUALS);
                filterInfo.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("CMCOLUMN.INNEWPORTLET", (Object)true, CompareType.EQUALS);
                filterInfo.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("isRoleControl", (Object)new Integer(0), CompareType.EQUALS);
                filterInfo.getFilterItems().add(filterItemInfo);
                FilterInfo rangFilterInfo = CmUtil.getContributeRangFilter((Context)ctx, null, null, (String)new Integer(2).toString(), null, null, (Boolean)true);
                filterInfo.mergeFilter(rangFilterInfo, "or");
                entityViewInfo.setFilter(filterInfo);
                SorterItemInfo sorterItemInfo = new SorterItemInfo("lastUpdateTime");
                sorterItemInfo.setSortType(SortType.DESCEND);
                entityViewInfo.getSorter().add(sorterItemInfo);
                MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.cp.eip.cm.app", "ContentQuery");
                IQueryExecutor exec = this.getQueryExecutor((IMetaDataPK)queryPK, entityViewInfo, ctx);
                exec.option().isAutoTranslateEnum = false;
                IRowSet rowSet = null;
                int tempSize = 0;
                int tempRows = info.getDisplayCount();
                int tempCols = info.getColCount();
                if (tempRows <= 0) {
                    tempRows = 5;
                }
                if (tempCols <= 0) {
                    tempCols = 1;
                }
                tempSize = tempRows * tempCols;
                rowSet = exec.executeQuery(0, tempSize);
                return rowSet;
            }
            ICMColumn iCMColumn = CMColumnFactory.getLocalInstance((Context)ctx);
            CMColumnInfo info = iCMColumn.getCMColumnInfo((IObjectPK)new ObjectUuidPK(REECNTCOLUMNID));
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo rangFilterInfo = CmUtil.getContributeRangFilter((Context)ctx, null, null, (String)new Integer(2).toString(), null, null, (Boolean)true);
            entityViewInfo.setFilter(rangFilterInfo);
            SorterItemInfo sorterItemInfo = new SorterItemInfo("lastUpdateTime");
            sorterItemInfo.setSortType(SortType.DESCEND);
            entityViewInfo.getSorter().add(sorterItemInfo);
            MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.cp.eip.cm.app", "ContentQuery");
            IQueryExecutor exec = this.getQueryExecutor((IMetaDataPK)queryPK, entityViewInfo, ctx);
            exec.option().isAutoTranslateEnum = false;
            IRowSet rowSet = null;
            int tempSize = 0;
            int tempRows = info.getDisplayCount();
            int tempCols = info.getColCount();
            if (tempRows <= 0) {
                tempRows = 5;
            }
            if (tempCols <= 0) {
                tempCols = 1;
            }
            tempSize = tempRows * tempCols;
            rowSet = exec.executeQuery(0, tempSize);
            return rowSet;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private HashSet getReadColumnIDStr(Context ctx) throws Exception {
        IContentManage iManage = ContentManageFactory.getLocalInstance((Context)ctx);
        IRowSet rowset = iManage.getReadColumn();
        HashSet<String> set = new HashSet<String>();
        if (rowset != null && rowset.size() > 0) {
            while (rowset.next()) {
                set.add(rowset.getString("FID"));
            }
        }
        return set;
    }

    public void setCMUserRead() {
        try {
            PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)this.getRequest());
            Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
            String type = this.getRequest().getParameter("type");
            if (!StringUtil.isEmpty((String)type) && type.equals("add")) {
                String contentId = this.getRequest().getParameter("contentId");
                String username = ContextUtil.getCurrentUserInfo((Context)ctx).getName();
                String Dep = ContextUtil.getCurrentAdminUnit((Context)ctx).getName();
                if (contentId != null && !contentId.trim().equals("") && username != null && Dep != null) {
                    EntityViewInfo tempEVI = new EntityViewInfo();
                    FilterInfo filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("contentID", (Object)contentId, CompareType.EQUALS));
                    filterInfo.getFilterItems().add(new FilterItemInfo("reader", (Object)username, CompareType.EQUALS));
                    tempEVI.setFilter(filterInfo);
                    CMReaderCollection con = CMReaderFactory.getLocalInstance((Context)ctx).getCollection(tempEVI);
                    if (con == null || con.size() == 0) {
                        ICMReader iCMReader = CMReaderFactory.getLocalInstance((Context)ctx);
                        CMReaderInfo info = new CMReaderInfo();
                        info.setContentID(BOSUuid.read((String)contentId));
                        info.setReader(username);
                        info.setReaderDep(Dep);
                        java.util.Date date = new java.util.Date();
                        info.setReadTime(new Timestamp(System.currentTimeMillis()));
                        iCMReader.addnew(info);
                    }
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = true;
        String sql = exec.getSQL();
        Log.error((Object)("  sql  =   " + sql));
        return exec;
    }
}

