/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.module.cm.action;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.cp.base.common.fme.ConvertUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.plt.cm.common.util.CMLicenseName;
import com.kingdee.portal.plt.cm.common.util.LicenseTool;
import com.kingdee.portal.plt.cp.common.util.FilterSpecialCharactersTool;
import com.kingdee.portal.plt.cp.common.util.PageList;
import com.kingdee.portal.plt.cp.module.cm.dto.ColumnDTO;
import com.kingdee.portal.plt.cp.module.cm.dto.ContentDTO;
import com.kingdee.portal.plt.cp.module.cm.service.ClassService;
import com.kingdee.portal.plt.cp.module.cm.service.ColumnsService;
import com.kingdee.portal.plt.cp.module.cm.service.CommentService;
import com.kingdee.portal.plt.cp.module.cm.service.ContentService;
import com.kingdee.portal.plt.cp.module.cm.service.impl.ClassServiceImpl;
import com.kingdee.portal.plt.cp.module.cm.service.impl.ColumnsServiceImpl;
import com.kingdee.portal.plt.cp.module.cm.service.impl.CommentServiceImpl;
import com.kingdee.portal.plt.cp.module.cm.service.impl.ContentServiceImpl;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class PictureAction
extends BaseAction {
    private ColumnsService columnsService = ColumnsServiceImpl.getInstance();
    private ClassService classService = ClassServiceImpl.getInstance();
    private ContentService contentService = ContentServiceImpl.getInstance();
    private CommentService commentService = CommentServiceImpl.getInstance();

    public String list() throws Exception {
        PortalContext ctx = this.getPortalContext();
        if (null == this.getUserInfo(ctx)) {
            return "session_out";
        }
        HttpServletRequest request = this.getRequest();
        String columnId = FilterSpecialCharactersTool.cleanXSS(request.getParameter("columnId"));
        String classId = request.getParameter("classId");
        String keyWords = request.getParameter("keyWords");
        String page = request.getParameter("page");
        String pageSize = request.getParameter("pageSize");
        if (null != columnId) {
            columnId = columnId.replaceAll(" ", "+");
        }
        if (null != classId) {
            classId = classId.replaceAll(" ", "+");
        }
        if (null == columnId) {
            columnId = "";
        }
        if (null == classId) {
            classId = "";
        }
        if (null == keyWords) {
            keyWords = "";
        }
        if (null == page) {
            page = "";
        }
        if (null == pageSize) {
            pageSize = "";
        }
        keyWords = new String(keyWords.getBytes("iso-8859-1"), "utf-8");
        HttpSession session = request.getSession();
        ColumnDTO columnDTO = (ColumnDTO)session.getAttribute("Picture_ColumnDTO_" + columnId);
        if (null == columnDTO) {
            columnDTO = this.columnsService.findBean(ctx, columnId);
            List classList = this.classService.findClassList(ctx, columnId);
            columnDTO.setClassList(classList);
            session.setAttribute("Picture_ColumnDTO_" + columnId, (Object)columnDTO);
        }
        columnDTO = this.classService.addCurrClassList(columnDTO, classId);
        request.setAttribute("columnDTO", (Object)columnDTO);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("columnId", columnId);
        params.put("classId", classId);
        params.put("page", page);
        params.put("pageSize", pageSize);
        params.put("keyWords", keyWords);
        params.put("sortFieldName", "SUMBITTIME");
        params.put("sortType", SortType.DESCEND.getName());
        PageList contentList = this.contentService.pageList(ctx, params);
        request.setAttribute("contentList", (Object)contentList);
        request.setAttribute("columnId", (Object)columnId);
        request.setAttribute("classId", (Object)classId);
        request.setAttribute("keyWords", (Object)keyWords);
        request.setAttribute("page", (Object)contentList.getCurrentPage());
        request.setAttribute("pageSize", (Object)contentList.getPageSize());
        return "success";
    }

    public String view() throws Exception {
        boolean hasPermission;
        PortalContext ctx = this.getPortalContext();
        if (null == this.getUserInfo(ctx)) {
            return "session_out";
        }
        HttpServletRequest request = this.getRequest();
        String docId = request.getParameter("docId");
        if (null == docId || "".equals(docId)) {
            docId = request.getParameter("contentId");
        }
        if (null != docId) {
            docId = docId.replaceAll(" ", "+");
        }
        if (!(hasPermission = this.contentService.hasPermissionToRead(ctx, docId))) {
            return "noPermission";
        }
        boolean hasLicense = LicenseTool.checkLicense((HttpServletRequest)request, (String)CMLicenseName.licenseClassName);
        if (!hasLicense) {
            return "noLicense";
        }
        request.setAttribute("actionName", (Object)"viewPicture");
        String columnId = request.getParameter("columnId");
        String classId = request.getParameter("classId");
        if (null != columnId) {
            columnId = columnId.replaceAll(" ", "+");
        }
        if (null != classId) {
            classId = classId.replaceAll(" ", "+");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("columnId", columnId);
        params.put("classId", classId);
        params.put("page", "1");
        params.put("pageSize", "20");
        params.put("sortFieldName", "SUMBITTIME");
        params.put("sortType", SortType.DESCEND.getName());
        PageList contentList = this.contentService.pageList(ctx, params, true);
        request.setAttribute("contentList", (Object)contentList);
        String loadIndex = FilterSpecialCharactersTool.cleanXSS(request.getParameter("loadIndex"));
        if (null == loadIndex || "".equals(loadIndex)) {
            loadIndex = "1";
        }
        for (int i = 0; i < contentList.size(); ++i) {
            ContentDTO content = (ContentDTO)contentList.get(i);
            int clicks = this.contentService.updateClicks(content, ctx);
            content.setClicks(clicks);
            String conId = content.getId();
            if (!conId.equals(docId)) continue;
            loadIndex = String.valueOf(i);
        }
        request.setAttribute("loadIndex", (Object)loadIndex);
        return "success";
    }

    public String viewSinglePic() throws Exception {
        PortalContext ctx = this.getPortalContext();
        if (null == this.getUserInfo(ctx)) {
            return "session_out";
        }
        HttpServletRequest request = this.getRequest();
        String docId = request.getParameter("docId");
        if (null == docId || "".equals(docId)) {
            docId = request.getParameter("contentId");
        }
        if (null != docId) {
            docId = docId.replaceAll(" ", "+");
        }
        request.setAttribute("actionName", (Object)"viewPicNews");
        String callBackUrl = ConvertUtil.getBaseUrl((HttpServletRequest)request) + "/common/fileToSwfPublic.action";
        ContentDTO content = this.contentService.getViewContent(ctx, docId, callBackUrl);
        int clicks = this.contentService.updateClicks(content, ctx);
        content.setClicks(clicks);
        request.setAttribute("docId", (Object)docId);
        request.setAttribute("content", (Object)content);
        return "success";
    }

    public UserInfo getUserInfo(PortalContext ctx) {
        if (null == ctx) {
            return null;
        }
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        if (null == context) {
            return null;
        }
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)context);
        return user;
    }
}

