/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.module.cm.action;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.cp.base.common.fme.ConvertUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.plt.cm.common.util.CMLicenseName;
import com.kingdee.portal.plt.cm.common.util.LicenseTool;
import com.kingdee.portal.plt.cp.common.util.FilterSpecialCharactersTool;
import com.kingdee.portal.plt.cp.common.util.PageList;
import com.kingdee.portal.plt.cp.module.cm.dto.AttachmentDTO;
import com.kingdee.portal.plt.cp.module.cm.dto.ColumnDTO;
import com.kingdee.portal.plt.cp.module.cm.dto.ContentDTO;
import com.kingdee.portal.plt.cp.module.cm.service.ClassService;
import com.kingdee.portal.plt.cp.module.cm.service.ColumnsService;
import com.kingdee.portal.plt.cp.module.cm.service.CommentService;
import com.kingdee.portal.plt.cp.module.cm.service.ContentService;
import com.kingdee.portal.plt.cp.module.cm.service.impl.ClassServiceImpl;
import com.kingdee.portal.plt.cp.module.cm.service.impl.ColumnsServiceImpl;
import com.kingdee.portal.plt.cp.module.cm.service.impl.CommentServiceImpl;
import com.kingdee.portal.plt.cp.module.cm.service.impl.ContentServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class RecentAction
extends BaseAction {
    private ColumnsService columnsService = ColumnsServiceImpl.getInstance();
    private ClassService classService = ClassServiceImpl.getInstance();
    private ContentService contentService = ContentServiceImpl.getInstance();
    private CommentService commentService = CommentServiceImpl.getInstance();

    public String list() throws Exception {
        PortalContext ctx = this.getPortalContext();
        if (null == this.getUserInfo(ctx)) {
            return "session_out";
        }
        HttpServletRequest request = this.getRequest();
        String columnId = FilterSpecialCharactersTool.cleanXSS(request.getParameter("columnId"));
        String classId = request.getParameter("classId");
        String keyWords = request.getParameter("keyWords");
        String page = request.getParameter("page");
        String pageSize = request.getParameter("pageSize");
        if (null != columnId) {
            columnId = columnId.replaceAll(" ", "+");
        }
        if (null != classId) {
            classId = classId.replaceAll(" ", "+");
        }
        if (null == columnId) {
            columnId = "";
        }
        if (null == classId) {
            classId = "";
        }
        if (null == keyWords) {
            keyWords = "";
        }
        if (null == page) {
            page = "";
        }
        if (null == pageSize) {
            pageSize = "";
        }
        keyWords = new String(keyWords.getBytes("iso-8859-1"), "utf-8");
        HttpSession session = request.getSession();
        ColumnDTO columnDTO = (ColumnDTO)session.getAttribute("Recent_ColumnDTO_" + columnId);
        if (null == columnDTO) {
            columnDTO = this.columnsService.findBean(ctx, columnId);
            List classList = this.classService.findClassList(ctx, columnId);
            columnDTO.setClassList(classList);
            session.setAttribute("Recent_ColumnDTO_" + columnId, (Object)columnDTO);
        }
        columnDTO = this.classService.addCurrClassList(columnDTO, classId);
        request.setAttribute("columnDTO", (Object)columnDTO);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("columnId", columnId);
        params.put("page", "1");
        params.put("pageSize", "10");
        params.put("sortFieldName", "CLICKS");
        params.put("sortType", SortType.DESCEND.getName());
        PageList pointList = this.contentService.pageRecentList(ctx, params);
        int len = pointList.size();
        for (int i = 0; i < len; ++i) {
            ContentDTO dto = (ContentDTO)pointList.get(i);
            String docId = dto.getId();
            String fileId = dto.getFileId();
            String cloumnType = dto.getColumnType();
            if (null == cloumnType || !"50".equals(cloumnType)) continue;
            AttachmentDTO attachmentDTO = this.contentService.getAttachment(ctx, fileId, docId, false);
            dto.setAttachmentDTO(attachmentDTO);
        }
        request.setAttribute("pointList", (Object)pointList);
        params.put("page", page);
        params.put("classId", classId);
        params.put("pageSize", pageSize);
        params.put("keyWords", keyWords);
        params.put("sortFieldName", "SUMBITTIME");
        params.put("sortType", SortType.DESCEND.getName());
        PageList contentList = this.contentService.pageRecentList(ctx, params);
        int len2 = contentList.size();
        for (int i = 0; i < len2; ++i) {
            ContentDTO dto = (ContentDTO)contentList.get(i);
            String docId = dto.getId();
            String fileId = dto.getFileId();
            String cloumnType = dto.getColumnType();
            if (null == cloumnType || !"50".equals(cloumnType)) continue;
            AttachmentDTO attachmentDTO = this.contentService.getAttachment(ctx, fileId, docId, false);
            dto.setAttachmentDTO(attachmentDTO);
        }
        request.setAttribute("contentList", (Object)contentList);
        request.setAttribute("columnId", (Object)columnId);
        request.setAttribute("classId", (Object)classId);
        request.setAttribute("keyWords", (Object)keyWords);
        request.setAttribute("page", (Object)contentList.getCurrentPage());
        request.setAttribute("pageSize", (Object)contentList.getPageSize());
        return "success";
    }

    public String view() throws Exception {
        boolean hasPermission;
        PortalContext ctx = this.getPortalContext();
        if (null == this.getUserInfo(ctx)) {
            return "session_out";
        }
        HttpServletRequest request = this.getRequest();
        String docId = request.getParameter("docId");
        if (null == docId || "".equals(docId)) {
            docId = request.getParameter("contentId");
        }
        if (null != docId) {
            docId = docId.replaceAll(" ", "+");
        }
        if (!(hasPermission = this.contentService.hasPermissionToRead(ctx, docId))) {
            return "noPermission";
        }
        boolean hasLicense = LicenseTool.checkLicense((HttpServletRequest)request, (String)CMLicenseName.licenseClassName);
        if (!hasLicense) {
            return "noLicense";
        }
        String loadIndex = FilterSpecialCharactersTool.cleanXSS(request.getParameter("loadIndex"));
        if (null == loadIndex || "".equals(loadIndex)) {
            loadIndex = "1";
        }
        request.setAttribute("loadIndex", (Object)loadIndex);
        request.setAttribute("actionName", (Object)"viewRecent");
        String callBackUrl = ConvertUtil.getBaseUrl((HttpServletRequest)request) + "/common/fileToSwfPublic.action";
        ContentDTO content = this.contentService.getViewContent(ctx, docId, callBackUrl);
        int clicks = this.contentService.updateClicks(content, ctx);
        content.setClicks(clicks);
        request.setAttribute("content", (Object)content);
        ArrayList attachmentList = this.contentService.getAttachmentList(ctx, docId);
        if (null == attachmentList) {
            attachmentList = new ArrayList();
        }
        request.setAttribute("attachmentList", attachmentList);
        request.setAttribute("attachmentListSize", (Object)attachmentList.size());
        ArrayList cmRelateList = this.contentService.getRelateList(ctx, docId);
        if (null == cmRelateList) {
            cmRelateList = new ArrayList();
        }
        request.setAttribute("cmRelateList", cmRelateList);
        request.setAttribute("cmRelateListSize", (Object)cmRelateList.size());
        ArrayList commentList = this.commentService.queryCommentList(ctx, docId);
        if (null == commentList) {
            commentList = new ArrayList();
        }
        request.setAttribute("commentList", commentList);
        request.setAttribute("commentListSize", (Object)commentList.size());
        return "success";
    }

    public UserInfo getUserInfo(PortalContext ctx) {
        if (null == ctx) {
            return null;
        }
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        if (null == context) {
            return null;
        }
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)context);
        return user;
    }
}

