/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.module.cm.service.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.plt.cp.module.cm.dto.ClassDTO;
import com.kingdee.portal.plt.cp.module.cm.dto.ColumnDTO;
import com.kingdee.portal.plt.cp.module.cm.service.ClassService;
import com.kingdee.portal.plt.cp.module.cm.service.ColumnsService;
import com.kingdee.portal.plt.cp.module.cm.service.impl.ClassServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnsServiceImpl
implements ColumnsService {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private static ColumnsService instance = null;

    private ColumnsServiceImpl() {
    }

    public static synchronized ColumnsService getInstance() {
        if (instance == null) {
            instance = new ColumnsServiceImpl();
        }
        return instance;
    }

    @Override
    public ColumnDTO findBean(PortalContext ctx, String id) throws DataAccessException {
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        String ksql = "select * from T_CM_Column where fid='" + id + "'";
        try {
            IRowSet dataSet = DbUtil.executeQuery((Context)context, (String)ksql);
            if (dataSet.next()) {
                ColumnDTO se = new ColumnDTO();
                se.setId(dataSet.getString("FID"));
                se.setName(dataSet.getString("FNAME_L2"));
                se.setContentWidth(dataSet.getInt("FContentWidth"));
                se.setContentHight(dataSet.getInt("FContentHight"));
                se.setDisplayCount(dataSet.getInt("FDisplayCount"));
                se.setColcount(dataSet.getInt("fcolcount"));
                se.setColumnType(dataSet.getString("fcolumnType"));
                se.setDisplayauthor(String.valueOf(dataSet.getInt("FDisplayAuthor")));
                se.setDisplaydate(String.valueOf(dataSet.getInt("FDisplaydate")));
                se.setDisplayClass(String.valueOf(dataSet.getInt("FDisplayClass")));
                se.setPicShowType(String.valueOf(dataSet.getInt("FPicShowType")));
                se.setScrollType(String.valueOf(dataSet.getInt("FScrollType")));
                se.setFileId(dataSet.getString("FColumnPicture"));
                se.setIsDisplayMore(dataSet.getString("FDisplaymore"));
                return se;
            }
        }
        catch (Exception e) {
            this.log.error(" ColumnsServiceImpl findBean sql=" + ksql.toString(), (Throwable)e);
            throw new DataAccessException(e.getCause());
        }
        return new ColumnDTO();
    }

    @Override
    public List queryReadColumnList(PortalContext ctx) throws Exception {
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        String userId = ContextUtil.getCurrentUserInfo((Context)context).getId().toString();
        ClassService classService = ClassServiceImpl.getInstance();
        ArrayList<ColumnDTO> list = new ArrayList<ColumnDTO>();
        StringBuffer sql = new StringBuffer();
        Object[] params = null;
        if (this._ifCMAdmin(context)) {
            params = new Object[]{ContextUtil.getCurrentCtrlUnit((Context)context).getId().toString()};
            sql.append("select FID");
            sql.append(",FNAME_L2");
            sql.append(",fcolumnType");
            sql.append(",FSubEditOrWorkFlow");
            sql.append(" from T_CM_Column ");
            sql.append(" where FEffect=1 and (FControlUnitID = ? or FCuFilter = 1 or fid='tSFimQEREADgAAD5wKgSr7n/tuc=')");
        } else {
            params = new Object[]{ContextUtil.getCurrentCtrlUnit((Context)context).getId().toString(), context.getCaller().toString(), ContextUtil.getCurrentCtrlUnit((Context)context).getId().toString()};
            sql.append(" select distinct(FID)");
            sql.append(",FNAME_L2");
            sql.append(",fcolumnType");
            sql.append(",FSubEditOrWorkFlow");
            sql.append(" from (");
            sql.append(" select a.FID");
            sql.append(",a.FNAME_L2");
            sql.append(",a.fcolumnType");
            sql.append(",a.FSubEditOrWorkFlow");
            sql.append(" from T_CM_Column a, T_CM_ColumnReadRight b, T_PM_UserRoleOrg c");
            sql.append(" where a.FEffect=1 and (a.FControlUnitID = ? or FCuFilter = 1  or a.fid='tSFimQEREADgAAD5wKgSr7n/tuc=')");
            sql.append(" and a.FID = b.FColumnID and b.FRoleID = c.FRoleID");
            sql.append(" and c.FUserID = ?");
            sql.append(" union select FID ");
            sql.append(",FNAME_L2");
            sql.append(",fcolumnType");
            sql.append(",FSubEditOrWorkFlow ");
            sql.append(" from T_CM_Column where FEffect=1 and (FControlUnitID = ? or FCuFilter = 1) and FID not in ( select FColumnID from T_CM_ColumnReadRight)");
            sql.append(") a");
        }
        try {
            IRowSet dataSet = DbUtil.executeQuery((Context)context, (String)sql.toString(), (Object[])params);
            while (dataSet.next()) {
                ColumnDTO se = new ColumnDTO();
                String id = dataSet.getString("FID");
                se.setId(id);
                String name = dataSet.getString("FNAME_L2");
                se.setName(name);
                se.setColumnType(dataSet.getString("fcolumnType"));
                List classList = classService.findClassList(ctx, id);
                se.setClassList(classList);
                list.add(se);
            }
        }
        catch (Exception e) {
            this.log.error(" ColumnsServiceImpl queryReadColumnList sql=" + sql.toString(), (Throwable)e);
            throw new DataAccessException(e.getCause());
        }
        return list;
    }

    @Override
    public List queryReadShowNoticColumnList(Context context, String isShowInNotice) throws Exception {
        String userId = ContextUtil.getCurrentUserInfo((Context)context).getId().toString();
        ArrayList<ColumnDTO> list = new ArrayList<ColumnDTO>();
        StringBuffer sql = new StringBuffer();
        Object[] params = null;
        if (this._ifCMAdmin(context)) {
            params = new Object[]{ContextUtil.getCurrentCtrlUnit((Context)context).getId().toString()};
            sql.append("select FID");
            sql.append(",FNAME_L2");
            sql.append(",fcolumnType");
            sql.append(",FSubEditOrWorkFlow");
            sql.append(" from T_CM_Column ");
            sql.append(" where FEffect=1  ");
            sql.append(" and fcolumnType='40' ");
            if (null != isShowInNotice && "1".equals(isShowInNotice)) {
                sql.append("  and FShowInNotice='1' ");
            }
            sql.append("    and  (FControlUnitID = ? or FCuFilter = 1 or fid='tSFimQEREADgAAD5wKgSr7n/tuc=')");
        } else {
            params = new Object[]{ContextUtil.getCurrentCtrlUnit((Context)context).getId().toString(), context.getCaller().toString(), ContextUtil.getCurrentCtrlUnit((Context)context).getId().toString()};
            sql.append(" select distinct(FID)");
            sql.append(",FNAME_L2");
            sql.append(",fcolumnType");
            sql.append(",FSubEditOrWorkFlow");
            sql.append(" from (");
            sql.append(" select a.FID");
            sql.append(",a.FNAME_L2");
            sql.append(",a.fcolumnType");
            sql.append(",a.FSubEditOrWorkFlow");
            sql.append(" from T_CM_Column a, T_CM_ColumnReadRight b, T_PM_UserRoleOrg c");
            sql.append(" where a.FEffect=1 and (a.FControlUnitID = ? or FCuFilter = 1  or a.fid='tSFimQEREADgAAD5wKgSr7n/tuc=')");
            sql.append(" and a.FID = b.FColumnID and b.FRoleID = c.FRoleID");
            sql.append(" and c.FUserID = ?");
            sql.append(" and a.fcolumnType='40' ");
            if (null != isShowInNotice && "1".equals(isShowInNotice)) {
                sql.append("  and a.FShowInNotice='1' ");
            }
            sql.append(" union select FID ");
            sql.append(",FNAME_L2");
            sql.append(",fcolumnType");
            sql.append(",FSubEditOrWorkFlow ");
            sql.append(" from T_CM_Column where FEffect=1 ");
            sql.append(" and fcolumnType='40' ");
            if (null != isShowInNotice && "1".equals(isShowInNotice)) {
                sql.append("  and FShowInNotice='1' ");
            }
            sql.append(" and (FControlUnitID = ? or FCuFilter = 1) and FID not in ( select FColumnID from T_CM_ColumnReadRight)");
            sql.append(") a");
        }
        try {
            IRowSet dataSet = DbUtil.executeQuery((Context)context, (String)sql.toString(), (Object[])params);
            while (dataSet.next()) {
                ColumnDTO se = new ColumnDTO();
                String id = dataSet.getString("FID");
                se.setId(id);
                String name = dataSet.getString("FNAME_L2");
                se.setName(name);
                se.setColumnType(dataSet.getString("fcolumnType"));
                list.add(se);
            }
        }
        catch (Exception e) {
            this.log.error(" ColumnsServiceImpl queryReadColumnList sql=" + sql.toString(), (Throwable)e);
            throw new DataAccessException(e.getCause());
        }
        return list;
    }

    @Override
    public List addCurrColumnList(List list, String columnId, String classId) throws BOSException {
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            ColumnDTO se = (ColumnDTO)list.get(i);
            String id = se.getId();
            String isCuur = se.getIsCuur();
            if (null != id && id.equals(columnId)) {
                if (null == classId || "".equals(classId)) {
                    if ("1".equals(isCuur)) {
                        se.setIsCuur("0");
                    } else {
                        se.setIsCuur("1");
                    }
                } else {
                    se.setIsCuur("1");
                }
            } else {
                se.setIsCuur("0");
            }
            List classList = se.getClassList();
            int lens = classList.size();
            for (int j = 0; j < lens; ++j) {
                ClassDTO cdto = (ClassDTO)classList.get(j);
                String cid = cdto.getId();
                if (null != classId && classId.equals(cid)) {
                    cdto.setIsCuur("1");
                    continue;
                }
                cdto.setIsCuur("0");
            }
        }
        return list;
    }

    protected boolean _ifCMAdmin(Context ctx) throws BOSException {
        boolean isCMAdmin = false;
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        try {
            iPermission.checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId()), "cm_manager");
            isCMAdmin = true;
        }
        catch (Exception e) {
            this.log.info(ctx.getUserName() + "\u6ca1\u6709\u5185\u5bb9\u7ba1\u7406\u6743\u9650");
        }
        return isCMAdmin;
    }
}

