/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.module.cm.service.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.cp.eip.cm.CMCommentFactory;
import com.kingdee.eas.cp.eip.cm.CMCommentInfo;
import com.kingdee.eas.cp.eip.cm.ICMComment;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.plt.cp.common.util.DateTool;
import com.kingdee.portal.plt.cp.module.cm.dto.CommentDTO;
import com.kingdee.portal.plt.cp.module.cm.service.CommentService;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommentServiceImpl
implements CommentService {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private static CommentService instance = null;

    private CommentServiceImpl() {
    }

    public static synchronized CommentService getInstance() {
        if (instance == null) {
            instance = new CommentServiceImpl();
        }
        return instance;
    }

    @Override
    public CMCommentInfo saveBean(PortalContext ctx, CMCommentInfo info) throws Exception {
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        ICMComment iCMComment = CMCommentFactory.getLocalInstance((Context)context);
        info.setId(BOSUuid.read((String)BOSUuid.create((BOSObjectType)info.getBOSType()).toString()));
        info.setCommentTime(this.getTime());
        info.setCreateTime(this.getTime());
        info.setLastUpdateTime(this.getTime());
        info.setState(1);
        iCMComment.submit((CoreBaseInfo)info);
        return info;
    }

    private Timestamp getTime() {
        java.util.Date date = new java.util.Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    @Override
    public List queryCommentList(PortalContext ctx, String docId) throws Exception {
        ArrayList<CommentDTO> resultList = new ArrayList<CommentDTO>();
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        StringBuffer sql = new StringBuffer();
        sql.append(" select A.*,B.FNAME_L2 as FcreatorName   ");
        sql.append("   from t_cm_Comment  A ");
        sql.append("   left join T_PM_User B on B.fid=A.Fcreatorid ");
        sql.append(" where 1=1  ");
        sql.append(" and A.fcontentID='" + docId + "' ");
        sql.append(" and ( A.fstate ='1' or A.fstate is null )");
        sql.append("  order by A.fcreateTime asc ");
        try {
            IRowSet dataSet = DbUtil.executeQuery((Context)context, (String)sql.toString());
            while (dataSet.next()) {
                CommentDTO se = new CommentDTO();
                String id = dataSet.getString("FID");
                se.setId(id);
                se.setCommenttitle(dataSet.getString("FCommenttitle"));
                se.setCommentcontent(dataSet.getString("Fcommentcontent"));
                se.setContentid(dataSet.getString("Fcontentid"));
                se.setCreatorName(dataSet.getString("FcreatorName"));
                se.setCreatorid(dataSet.getString("Fcreatorid"));
                Date Commenttime = dataSet.getDate("FCommenttime");
                se.setCommenttime(DateTool.dateToString(Commenttime, "yyyy-MM-dd HH:mm"));
                se.setScore(dataSet.getInt("Fscore"));
                resultList.add(se);
            }
        }
        catch (Exception e) {
            this.log.error(" CommentServiceImpl queryCommentList sql=" + sql.toString(), (Throwable)e);
            throw new DataAccessException(e.getCause());
        }
        return resultList;
    }
}

