/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.module.cm.service.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.base.common.fme.ConvertUtil;
import com.kingdee.eas.cp.eip.cm.CMClassCollection;
import com.kingdee.eas.cp.eip.cm.CMClassFactory;
import com.kingdee.eas.cp.eip.cm.CMClassInfo;
import com.kingdee.eas.cp.eip.cm.CMContentFactory;
import com.kingdee.eas.cp.eip.cm.CMContentInfo;
import com.kingdee.eas.cp.eip.cm.CMReaderCollection;
import com.kingdee.eas.cp.eip.cm.CMReaderFactory;
import com.kingdee.eas.cp.eip.cm.CMReaderInfo;
import com.kingdee.eas.cp.eip.cm.CMRelateDocCollection;
import com.kingdee.eas.cp.eip.cm.CMRelateDocFactory;
import com.kingdee.eas.cp.eip.cm.ContentManageFactory;
import com.kingdee.eas.cp.eip.cm.ICMClass;
import com.kingdee.eas.cp.eip.cm.ICMContent;
import com.kingdee.eas.cp.eip.cm.ICMReader;
import com.kingdee.eas.cp.eip.cm.ICMRelateDoc;
import com.kingdee.eas.cp.eip.cm.IContentManage;
import com.kingdee.eas.cp.eip.cm.web.ContentResourceHandle;
import com.kingdee.eas.cp.eip.cm.web.util.CmUtil;
import com.kingdee.eas.cp.eip.de.web.DocumentOperater;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.plt.cp.common.util.CMContentImgHandle;
import com.kingdee.portal.plt.cp.common.util.DateTool;
import com.kingdee.portal.plt.cp.common.util.PageList;
import com.kingdee.portal.plt.cp.module.cm.dto.AttachmentDTO;
import com.kingdee.portal.plt.cp.module.cm.dto.ColumnDTO;
import com.kingdee.portal.plt.cp.module.cm.dto.ContentDTO;
import com.kingdee.portal.plt.cp.module.cm.dto.RelateDocDTO;
import com.kingdee.portal.plt.cp.module.cm.service.ColumnsService;
import com.kingdee.portal.plt.cp.module.cm.service.ContentService;
import com.kingdee.portal.plt.cp.module.cm.service.impl.ColumnsServiceImpl;
import java.io.File;
import java.net.URLEncoder;
import java.sql.Blob;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentServiceImpl
implements ContentService {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private static ContentService instance = null;

    private ContentServiceImpl() {
    }

    public static synchronized ContentService getInstance() {
        if (instance == null) {
            instance = new ContentServiceImpl();
        }
        return instance;
    }

    @Override
    public int updateClicks(ContentDTO content, PortalContext ctx) throws Exception {
        if (!"2".equals(content.getStatus())) {
            return content.getClicks();
        }
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        String username = ContextUtil.getCurrentUserInfo((Context)context).getName();
        String Dep = ContextUtil.getCurrentAdminUnit((Context)context).getName();
        int result = 0;
        if (content == null || username == null || Dep == null) {
            return -1;
        }
        String fid = content.getId();
        EntityViewInfo tempEVI = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("contentID", (Object)fid, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("reader", (Object)username, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("readerDep", (Object)Dep, CompareType.EQUALS));
        tempEVI.setFilter(filterInfo);
        CMReaderCollection con = CMReaderFactory.getLocalInstance((Context)context).getCollection(tempEVI);
        int click = content.getClicks();
        if (con == null || con.size() == 0) {
            ICMReader iCMReader = CMReaderFactory.getLocalInstance((Context)context);
            CMReaderInfo info = new CMReaderInfo();
            info.setContentID(BOSUuid.read((String)fid));
            info.setReader(username);
            info.setReaderDep(Dep);
            java.util.Date date = new java.util.Date();
            info.setReadTime(new Timestamp(System.currentTimeMillis()));
            iCMReader.addnew(info);
            result = click != 0 ? ++click : (click = 1);
            String updateSql = "update T_CM_Content set FClicks= " + click + " where FID='" + fid + "'";
            DbUtil.execute((Context)context, (String)updateSql);
        } else {
            result = click;
        }
        return result;
    }

    @Override
    public ContentDTO getViewContent(PortalContext ctx, String docId, String callBackUrl) throws Exception {
        return this.getViewContent(ctx, docId, callBackUrl, true);
    }

    @Override
    public ContentDTO getViewContent(PortalContext ctx, String docId, String callBackUrl, boolean isConvert) throws Exception {
        block19: {
            Context context = (Context)ctx.getMetaInfo().get("eas_context");
            StringBuffer sql = new StringBuffer();
            sql.append(" select A.* ,B.FNAME_L2 as columnName, C.Fname_L2 as className  ");
            sql.append(" ,D.FNAME_L2 as userName,B.fcolumnType  ");
            sql.append("   from T_CM_Content  A    ");
            sql.append("  left join T_CM_Column  B on B.fid=A.FCOLUMNID ");
            sql.append("  left join T_CM_Class   C on C.fid=A.FCLASSID  ");
            sql.append("   left join T_PM_User   D on D.Fid=A.Fcreatorid ");
            sql.append("  where A.fid='" + docId + "'");
            try {
                IRowSet dataSet = DbUtil.executeQuery((Context)context, (String)sql.toString());
                if (!dataSet.next()) break block19;
                ContentDTO se = new ContentDTO();
                se.setId(dataSet.getString("FID"));
                se.setTitle(dataSet.getString("FTITLE"));
                se.setSummary(dataSet.getString("fsummary"));
                se.setKeyWord(dataSet.getString("FKEYWORD"));
                se.setCreateName(dataSet.getString("userName"));
                Date createTime = dataSet.getDate("FCREATETIME");
                se.setCreateTime(DateTool.dateToString(createTime, "yyyy-MM-dd HH:mm:ss"));
                se.setCreateTime2(DateTool.dateToString(createTime, "yyyy\u5e74MM\u6708dd\u65e5 HH:mm"));
                se.setCreateTime3(DateTool.dateToString(createTime, "yyyy-MM-dd"));
                se.setCanCopy(String.valueOf(dataSet.getInt("FCANCOPY")));
                String fileId = dataSet.getString("ffile");
                se.setFileId(fileId);
                String imgPath = "/plt_cp/res/img/defalt.png";
                if (fileId != null) {
                    AttachmentInfo info = this.getShowImg(ctx, fileId);
                    System.out.println("AttachmentInfo info: " + (info != null));
                    if (info != null) {
                        imgPath = CMContentImgHandle.getImgFilePath(info.getId().toString(), context);
                        System.out.println("imgPath: " + imgPath);
                        if (imgPath == "") {
                            imgPath = "/plt_cp/res/img/defalt.png";
                        }
                    }
                }
                se.setFilePath(imgPath);
                se.setColumnName(dataSet.getString("columnName"));
                se.setClassName(dataSet.getString("className"));
                se.setDisplayNew(dataSet.getString("fpicdisplay"));
                se.setColumnType(dataSet.getString("fcolumnType"));
                String contType = dataSet.getString("fcontenttype");
                EntityViewInfo tempEVI = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("contentID", (Object)dataSet.getString("FID"), CompareType.EQUALS));
                tempEVI.setFilter(filterInfo);
                CMReaderCollection con = CMReaderFactory.getLocalInstance((Context)context).getCollection(tempEVI);
                if (con != null) {
                    se.setClicks(con.size());
                } else {
                    se.setClicks(0);
                }
                se.setContenttype(contType);
                if ("1".equals(contType)) {
                    String docContent = this.getDocInfo(ctx, docId);
                    se.setDocContent(docContent);
                } else if (isConvert) {
                    String id = se.getId();
                    String nameId = id.replace("\\", "");
                    nameId = nameId.replace("/", "");
                    nameId = nameId.replaceAll(" ", "+");
                    String toFileName = nameId + ".swf";
                    String easHome = System.getProperty("EAS_HOME");
                    String datePath = ConvertUtil.createPath((java.util.Date)createTime);
                    try {
                        toFileName = URLEncoder.encode(toFileName, "UTF-8");
                        toFileName = toFileName.replaceAll("%", "");
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        toFileName = toFileName.replaceAll("\\+", "2B");
                        toFileName = toFileName.replaceAll("=", "3D");
                    }
                    String filePath = easHome + "/server/deploy/portal.ear/plt_cp.war/resource/" + datePath;
                    String toFile = filePath + toFileName;
                    String requestID = toFileName;
                    File file = new File(toFile);
                    if (!file.exists()) {
                        if (null != callBackUrl && !"".equals(callBackUrl)) {
                            File fileDir = new File(filePath);
                            if (!fileDir.exists()) {
                                fileDir.mkdirs();
                            }
                            String fileName = nameId + ".doc";
                            byte[] data = this.getDocInfoData(ctx, id);
                            if (null != data) {
                                try {
                                    ConvertUtil.convert((String)fileName, (byte[])data, (String)toFile, (String)requestID, (String)callBackUrl);
                                }
                                catch (Exception e) {
                                    this.log.error("\u8c03\u7528SWF\u6587\u6863\u8f6c\u6362\u670d\u52a1\u5931\u8d25!", (Throwable)e);
                                }
                            }
                        }
                    } else {
                        se.setContentSwfUrl("/plt_cp/resource/" + datePath + toFileName);
                    }
                }
                se.setIscomment(dataSet.getString("fiscomment"));
                se.setClassId(dataSet.getString("FCLASSID"));
                se.setColumnId(dataSet.getString("FCOLUMNID"));
                se.setStatus(dataSet.getString("fstatus"));
                return se;
            }
            catch (Exception e) {
                this.log.error(" ContentServiceImpl getViewContent sql=" + sql.toString(), (Throwable)e);
                throw new DataAccessException(e.getCause());
            }
        }
        return new ContentDTO();
    }

    @Override
    public ContentDTO getViewContent(PortalContext ctx, String docId) throws Exception {
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        StringBuffer sql = new StringBuffer();
        sql.append(" select A.* ,B.FNAME_L2 as columnName, C.Fname_L2 as className  ");
        sql.append(" ,D.FNAME_L2 as userName,B.fcolumnType  ");
        sql.append("   from T_CM_Content  A    ");
        sql.append("  left join T_CM_Column  B on B.fid=A.FCOLUMNID ");
        sql.append("  left join T_CM_Class   C on C.fid=A.FCLASSID  ");
        sql.append("   left join T_PM_User   D on D.Fid=A.Fcreatorid ");
        sql.append("  where A.fid='" + docId + "'");
        try {
            IRowSet dataSet = DbUtil.executeQuery((Context)context, (String)sql.toString());
            if (dataSet.next()) {
                ContentDTO se = new ContentDTO();
                se.setId(dataSet.getString("FID"));
                se.setTitle(dataSet.getString("FTITLE"));
                se.setSummary(dataSet.getString("fsummary"));
                se.setKeyWord(dataSet.getString("FKEYWORD"));
                se.setCreateName(dataSet.getString("userName"));
                Date createTime = dataSet.getDate("FCREATETIME");
                se.setCreateTime(DateTool.dateToString(createTime, "yyyy-MM-dd HH:mm:ss"));
                se.setCreateTime2(DateTool.dateToString(createTime, "yyyy\u5e74MM\u6708dd\u65e5 HH:mm"));
                se.setCreateTime3(DateTool.dateToString(createTime, "yyyy-MM-dd"));
                se.setCanCopy(String.valueOf(dataSet.getInt("FCANCOPY")));
                se.setColumnName(dataSet.getString("columnName"));
                se.setClassName(dataSet.getString("className"));
                se.setColumnType(dataSet.getString("fcolumnType"));
                se.setIscomment(dataSet.getString("fiscomment"));
                se.setClassId(dataSet.getString("FCLASSID"));
                se.setColumnId(dataSet.getString("FCOLUMNID"));
                se.setStatus(dataSet.getString("fstatus"));
                EntityViewInfo tempEVI = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("contentID", (Object)dataSet.getString("FID"), CompareType.EQUALS));
                tempEVI.setFilter(filterInfo);
                CMReaderCollection con = CMReaderFactory.getLocalInstance((Context)context).getCollection(tempEVI);
                if (con != null) {
                    se.setClicks(con.size());
                } else {
                    se.setClicks(0);
                }
                return se;
            }
        }
        catch (Exception e) {
            this.log.error(" ContentServiceImpl getViewContent sql=" + sql.toString(), (Throwable)e);
            throw new DataAccessException(e.getCause());
        }
        return new ContentDTO();
    }

    @Override
    public String getDocInfo(PortalContext ctx, String docId) throws Exception {
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        String docContent = "";
        DocumentOperater docOp = new DocumentOperater();
        docOp.setContext(context);
        byte[] docBodyContent = docOp.getDocBodyContent(docId);
        if (docBodyContent != null) {
            docContent = new String(docBodyContent, "UTF-8");
            this.log.debug("\u4ece\u6587\u6863\u5f15\u64ce\u4e2d\u83b7\u5f97\u6587\u6863\u7684\u5185\u5bb9\u5df2\u7ecf\u6210\u529f\uff01");
        } else {
            docContent = "";
            this.log.debug("\u4ece\u6587\u6863\u5f15\u64ce\u4e2d\u83b7\u5f97\u6587\u6863\u7684\u5185\u5bb9\u5931\u8d25\uff01");
        }
        return docContent;
    }

    @Override
    public byte[] getDocInfoData(PortalContext ctx, String docId) throws Exception {
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        String sql = "select FContent from T_CM_DocumentContent WHERE FID = '" + docId + "'";
        IRowSet rows = DbUtil.executeQuery((Context)context, (String)sql);
        Blob blob = null;
        byte[] b = null;
        if (rows.next()) {
            blob = rows.getBlob(1);
            b = blob.getBytes(1L, Integer.valueOf(String.valueOf(blob.length())));
        }
        return b;
    }

    @Override
    public List getAttachmentList(PortalContext ctx, String docId) throws Exception {
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        ArrayList<AttachmentDTO> list = new ArrayList<AttachmentDTO>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select B.fboid as fid, A.fid as fattachmentid  ");
        sql.append("   ,A.fsize  ,A.fname_l2 as fattachmentName,A.fsimplename,A.ftype  ");
        sql.append(" from t_bas_Attachment A  ");
        sql.append(" left join T_BAS_BoAttchAsso B on A.Fid=B.fattachmentid   ");
        sql.append(" where 1=1  ");
        sql.append(" and fsimplename !='b'");
        sql.append("    and B.fboid='" + docId + "'");
        try {
            IRowSet dataSet = DbUtil.executeQuery((Context)context, (String)sql.toString());
            while (dataSet.next()) {
                AttachmentDTO se = new AttachmentDTO();
                se.setDocId(docId);
                se.setId(dataSet.getString("fattachmentid"));
                se.setSimplename(dataSet.getString("fsimplename"));
                se.setAttachmentName(dataSet.getString("fattachmentName"));
                se.setType(dataSet.getString("ftype"));
                se.setFileSize(dataSet.getString("fsize"));
                list.add(se);
            }
        }
        catch (Exception e) {
            this.log.error(" ContentServiceImpl getAttachmentList sql=" + sql.toString(), (Throwable)e);
            throw new DataAccessException((Throwable)e);
        }
        return list;
    }

    @Override
    public List<AttachmentDTO> getAttachmentListByFile(PortalContext ctx, List<String> docIds) throws Exception {
        ArrayList<AttachmentDTO> list = new ArrayList<AttachmentDTO>();
        if (docIds.size() <= 0) {
            return list;
        }
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        String[] ids = docIds.toArray(new String[docIds.size()]);
        StringBuilder sb = new StringBuilder();
        for (String id : ids) {
            sb.append("'").append(id).append("'").append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        StringBuffer sql = new StringBuffer();
        sql.append(" select B.fboid as fid, A.fid as fattachmentid  ");
        sql.append("   ,A.fsize  ,A.fname_l2 as fattachmentName,A.fsimplename,A.ftype  ");
        sql.append(" from t_bas_Attachment A  ");
        sql.append(" left join T_BAS_BoAttchAsso B on A.Fid=B.fattachmentid   ");
        sql.append(" where 1=1  ");
        sql.append(" and fsimplename !='b'");
        sql.append(" and B.fboid in (" + sb.toString() + ")");
        try {
            IRowSet dataSet = DbUtil.executeQuery((Context)context, (String)sql.toString());
            while (dataSet.next()) {
                AttachmentDTO se = new AttachmentDTO();
                se.setDocId(dataSet.getString("fid"));
                se.setId(dataSet.getString("fattachmentid"));
                se.setSimplename(dataSet.getString("fsimplename"));
                se.setAttachmentName(dataSet.getString("fattachmentName"));
                se.setType(dataSet.getString("ftype"));
                se.setFileSize(dataSet.getString("fsize"));
                list.add(se);
            }
        }
        catch (Exception e) {
            this.log.error(" ContentServiceImpl getAttachmentList sql=" + sql.toString(), (Throwable)e);
            throw new DataAccessException((Throwable)e);
        }
        return list;
    }

    @Override
    public AttachmentDTO getAttachment(PortalContext ctx, String ffileId, String docId, boolean file) throws Exception {
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        StringBuffer sql = new StringBuffer();
        sql.append(" select B.fboid as fid, A.fid as fattachmentid  ");
        sql.append("   ,A.fsize  ,A.fname_l2 as fattachmentName,A.fsimplename,A.ftype  ");
        sql.append(" from t_bas_Attachment A  ");
        sql.append(" left join T_BAS_BoAttchAsso B on A.Fid=B.fattachmentid   ");
        sql.append(" where 1=1  ");
        sql.append(" and fsimplename !='b'");
        sql.append(" and B.fboid='" + ffileId + "' ");
        try {
            IRowSet dataSet = DbUtil.executeQuery((Context)context, (String)sql.toString());
            if (dataSet.next()) {
                AttachmentDTO se = new AttachmentDTO();
                se.setDocId(docId);
                String attachmentId = dataSet.getString("fattachmentid");
                se.setId(attachmentId);
                se.setSimplename(dataSet.getString("fsimplename"));
                se.setAttachmentName(dataSet.getString("fattachmentName"));
                se.setType(dataSet.getString("ftype"));
                se.setFileSize(dataSet.getString("fsize"));
                if (file) {
                    AttachmentServerManager acm = AttachmentManagerFactory.getServerManager((Context)context);
                    byte[] bytes = acm.download(attachmentId);
                    se.setFile(bytes);
                }
                return se;
            }
        }
        catch (Exception e) {
            this.log.error(" ContentServiceImpl getAttachmentList sql=" + sql.toString(), (Throwable)e);
            throw new DataAccessException((Throwable)e);
        }
        return null;
    }

    @Override
    public AttachmentDTO queryAttachment(PortalContext ctx, String attachmentId) throws Exception {
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        StringBuffer sql = new StringBuffer();
        sql.append(" select  A.fid  ,A.fsize  ");
        sql.append("    ,A.fname_l2 as fattachmentName,A.fsimplename,A.ftype  ");
        sql.append(" from t_bas_Attachment A  ");
        sql.append(" where 1=1  ");
        sql.append(" and A.fsimplename !='b'");
        sql.append("    and A.fid='" + attachmentId + "'");
        AttachmentServerManager acm = AttachmentManagerFactory.getServerManager((Context)context);
        byte[] bytes = acm.download(attachmentId);
        try {
            IRowSet dataSet = DbUtil.executeQuery((Context)context, (String)sql.toString());
            if (dataSet.next()) {
                AttachmentDTO se = new AttachmentDTO();
                se.setId(dataSet.getString("FID"));
                se.setSimplename(dataSet.getString("fsimplename"));
                se.setAttachmentName(dataSet.getString("fattachmentName"));
                se.setType(dataSet.getString("ftype"));
                se.setFileSize(dataSet.getString("fsize"));
                se.setFile(bytes);
                return se;
            }
        }
        catch (Exception e) {
            this.log.error(" ContentServiceImpl getAttachmentList sql=" + sql.toString(), (Throwable)e);
            throw new DataAccessException((Throwable)e);
        }
        return null;
    }

    @Override
    public CMRelateDocCollection getCMRelateDoc(PortalContext ctx, String docId) throws Exception {
        Object relateDocInfo = null;
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        ICMRelateDoc iCMRelateDoc = CMRelateDocFactory.getLocalInstance((Context)context);
        String oql = " where contentID = '" + docId + "'";
        CMRelateDocCollection relateDocCollection = new CMRelateDocCollection();
        relateDocCollection = iCMRelateDoc.getCMRelateDocCollection(oql);
        return relateDocCollection;
    }

    @Override
    public List getRelateList(PortalContext ctx, String docId) throws Exception {
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        ArrayList<RelateDocDTO> list = new ArrayList<RelateDocDTO>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select * From t_cm_relatedoc ");
        sql.append(" where 1=1  ");
        sql.append(" and fcontentid='" + docId + "'");
        try {
            IRowSet dataSet = DbUtil.executeQuery((Context)context, (String)sql.toString());
            String newUrl = "";
            while (dataSet.next()) {
                RelateDocDTO se = new RelateDocDTO();
                se.setId(dataSet.getString("FID"));
                se.setTitle(dataSet.getString("FTITLE"));
                String url = dataSet.getString("FURL");
                if (null != url && url.indexOf("/easportal/cm/ContentView.do?contentId") >= 0) {
                    String contentId = url.substring(url.indexOf("contentId=") + "contentId=".length());
                    ContentDTO contDTO = this.getViewContent(ctx, contentId, "");
                    String columnType = contDTO.getColumnType();
                    if ("10".equals(columnType)) {
                        newUrl = "/plt_cp/cm/viewCommon.action?docId";
                        url = url.replace("/easportal/cm/ContentView.do?contentId", newUrl);
                    } else if ("20".equals(columnType)) {
                        String summary = contDTO.getSummary();
                        if (null != summary) {
                            url = summary;
                        }
                    } else if ("30".equals(columnType)) {
                        newUrl = "/plt_cp/cm/viewNews.action?docId";
                        url = url.replace("/easportal/cm/ContentView.do?contentId", newUrl);
                    } else if ("40".equals(columnType)) {
                        newUrl = "/plt_cp/cm/viewNotic.action?docId";
                        url = url.replace("/easportal/cm/ContentView.do?contentId", newUrl);
                    } else if ("50".equals(columnType)) {
                        String fileId = contDTO.getFileId();
                        newUrl = "/plt_cp/cm/downAttachment.action?attachmentId=" + fileId + "&docId";
                        url = url.replace("/easportal/cm/ContentView.do?contentId", newUrl);
                    } else if ("60".equals(columnType)) {
                        String columnId = contDTO.getColumnId();
                        newUrl = "/plt_cp/cm/viewPicture.action?columnId=" + columnId + "&docId";
                        url = url.replace("/easportal/cm/ContentView.do?contentId", newUrl);
                    } else if ("70".equals(columnType)) {
                        newUrl = "/plt_cp/cm/viewPicNews.action?docId";
                        url = url.replace("/easportal/cm/ContentView.do?contentId", newUrl);
                    }
                }
                se.setUrl(url);
                se.setDocId(dataSet.getString("fcontentid"));
                list.add(se);
            }
        }
        catch (Exception e) {
            this.log.error(" ContentServiceImpl getRelateList sql=" + sql.toString(), (Throwable)e);
            throw new DataAccessException((Throwable)e);
        }
        return list;
    }

    @Override
    public AttachmentInfo getShowImg(PortalContext context, String ffile) throws Exception {
        Context ctx = (Context)context.getMetaInfo().get("eas_context");
        AttachmentInfo attachment = ContentResourceHandle.getAttacheByBizID((Context)ctx, (String)ffile);
        return attachment;
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    private String getSubClassId(Context ctx, String id) throws Exception {
        ICMClass iCMClass = CMClassFactory.getLocalInstance((Context)ctx);
        CMClassInfo info = (CMClassInfo)iCMClass.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        CMClassCollection infos = iCMClass.getCMClassCollection(" select id where longNumber like '" + info.getLongNumber() + "%'");
        StringBuffer idBf = new StringBuffer();
        idBf.append("0");
        for (int i = 0; i < infos.size(); ++i) {
            info = infos.get(i);
            idBf.append(",");
            idBf.append(info.getId().toString());
        }
        return idBf.toString();
    }

    private String getReadColumnIDStr(Context ctx) throws Exception {
        IContentManage iManage = ContentManageFactory.getLocalInstance((Context)ctx);
        IRowSet rowset = iManage.getReadColumn();
        StringBuffer columnIdBf = new StringBuffer();
        columnIdBf.append("0");
        if (rowset != null && rowset.size() > 0) {
            while (rowset.next()) {
                columnIdBf.append(",");
                columnIdBf.append(rowset.getString("FID"));
            }
        }
        return columnIdBf.toString();
    }

    private String getReadShowNoticColumnIDStr(Context ctx, String isShowInNotice) throws Exception {
        ColumnsService columnsService = ColumnsServiceImpl.getInstance();
        List columnList = columnsService.queryReadShowNoticColumnList(ctx, isShowInNotice);
        StringBuffer ids = new StringBuffer();
        int len = columnList.size();
        for (int i = 0; i < len; ++i) {
            ColumnDTO se = (ColumnDTO)columnList.get(i);
            String id = se.getId();
            if (i == 0) {
                ids.append("'" + id + "'");
                continue;
            }
            ids.append(",'" + id + "'");
        }
        return ids.toString();
    }

    @Override
    public PageList pageList(PortalContext context, Map params) throws Exception {
        return this.pageList(context, params, false);
    }

    @Override
    public PageList pageList(PortalContext context, Map params, Boolean isLoadImg) throws Exception {
        Context ctx = (Context)context.getMetaInfo().get("eas_context");
        int total = 0;
        int pageNo = 0;
        int totalPage = 0;
        int pageSize = 0;
        int currentPage = 0;
        String page = (String)params.get("page");
        String pageSizeStr = (String)params.get("pageSize");
        String columnID = (String)params.get("columnId");
        String classID = (String)params.get("classId");
        String keyWords = (String)params.get("keyWords");
        String displaynew = (String)params.get("displaynew");
        String orderByField = (String)params.get("sortFieldName");
        String orderType = (String)params.get("sortType");
        if (StringUtil.isEmpty((String)orderByField)) {
            orderByField = "lastUpdateTime";
        }
        if (StringUtil.isEmpty((String)orderType)) {
            orderType = SortType.DESCEND.getName().toUpperCase();
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = null;
        if (StringUtil.isEmpty((String)page)) {
            page = "1";
        }
        if (StringUtil.isEmpty((String)pageSizeStr)) {
            pageSizeStr = "20";
        }
        pageNo = Integer.parseInt(page);
        pageSize = Integer.parseInt(pageSizeStr);
        if (!StringUtil.isEmpty((String)displaynew)) {
            FilterInfo filterkey = new FilterInfo();
            filterItemInfo = new FilterItemInfo("DISPLAYNEW", (Object)displaynew, CompareType.EQUALS);
            filterkey.getFilterItems().add(filterItemInfo);
            filterInfo.mergeFilter(filterkey, "and");
        }
        String columnIds = this.getReadColumnIDStr(ctx);
        if (null != classID && !"".equals(classID)) {
            classID = classID.replaceAll(" ", "+");
            ICMClass iCMClass = CMClassFactory.getLocalInstance((Context)ctx);
            CMClassInfo info = (CMClassInfo)iCMClass.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)classID)));
            if (columnIds.indexOf(info.getColumnID().toString()) >= 0) {
                String classIds = this.getSubClassId(ctx, classID);
                filterItemInfo = new FilterItemInfo("classID", (Object)classIds, CompareType.INCLUDE);
                filterInfo.getFilterItems().add(filterItemInfo);
            }
        }
        if (!StringUtil.isEmpty((String)columnID)) {
            filterItemInfo = columnIds.indexOf(columnID = columnID.replaceAll(" ", "+")) >= 0 ? new FilterItemInfo("columnID", (Object)columnID) : new FilterItemInfo("columnID", (Object)"##");
            filterInfo.getFilterItems().add(filterItemInfo);
        } else if (columnIds.length() > 0) {
            filterItemInfo = new FilterItemInfo("columnID", (Object)columnIds, CompareType.INCLUDE);
            filterInfo.getFilterItems().add(filterItemInfo);
        }
        filterItemInfo = new FilterItemInfo("status", (Object)new Integer(2), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        if (!StringUtil.isEmpty((String)keyWords)) {
            FilterInfo filterkeyw = new FilterInfo();
            filterItemInfo = new FilterItemInfo("title", (Object)("%" + keyWords + "%"), CompareType.LIKE);
            filterkeyw.getFilterItems().add(filterItemInfo);
            filterItemInfo = new FilterItemInfo("keyWord", (Object)("%" + keyWords + "%"), CompareType.LIKE);
            filterkeyw.getFilterItems().add(filterItemInfo);
            filterkeyw.setMaskString("(#0 or #1)");
            filterInfo.mergeFilter(filterkeyw, "and");
        }
        filterItemInfo = new FilterItemInfo("isRoleControl", (Object)new Integer(0), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        FilterInfo filterInfoRole = !StringUtil.isEmpty((String)classID) ? this.getContributeRangFilter(ctx, columnID, this.getSubClassId(ctx, classID), new Integer(2).toString(), null, null, null, keyWords) : this.getContributeRangFilter(ctx, columnID, null, new Integer(2).toString(), null, null, null, keyWords);
        filterInfo.mergeFilter(filterInfoRole, "or");
        entityViewInfo.setFilter(filterInfo);
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.eip.cm.app", "ContentQuery");
        IQueryExecutor exec = null;
        IRowSet rowSet = null;
        IRowSet countRowSet = null;
        PageList resultList = new PageList();
        try {
            SorterItemInfo sorterItemInfo = new SorterItemInfo(orderByField);
            sorterItemInfo.setSortType(SortType.getEnum((String)orderType));
            entityViewInfo.getSorter().add(sorterItemInfo);
            exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
            exec.setObjectView(entityViewInfo);
            String sql = exec.getSQL();
            this.log.debug("executor search content  sql is:" + sql);
            String countSql = sql.substring(0, sql.indexOf("ORDER BY"));
            countSql = " select count(1) from ( " + countSql + " )  AAA ";
            countRowSet = DbUtil.executeQuery((Context)ctx, (String)countSql);
            if (countRowSet.next()) {
                total = countRowSet.getInt(1);
                this.log.debug("record total is\uff1a" + total);
            }
            totalPage = (total - 1) / pageSize + 1;
            this.log.debug("total page is:" + totalPage);
            if (pageNo > totalPage) {
                pageNo = totalPage;
            }
            if (pageNo <= 0) {
                pageNo = 1;
            }
            currentPage = pageNo;
            resultList.setTotalRowCount(total);
            resultList.setCurrentPage(currentPage);
            resultList.setPageSize(pageSize);
            rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
            resultList = this.rowSetToPageList(resultList, rowSet, context, isLoadImg);
            resultList = this.setDocReadCount(ctx, resultList);
        }
        catch (Exception e) {
            this.log.error("\u5206\u9875\u67e5\u627e\u5185\u5bb9\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage());
        }
        return resultList;
    }

    @Override
    public PageList pageContentList(PortalContext context, Map params) throws Exception {
        String myReadColumnIds;
        Context ctx = (Context)context.getMetaInfo().get("eas_context");
        PageList resultList = new PageList();
        PersonInfo person = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        if (person == null) {
            return resultList;
        }
        int total = 0;
        int pageNo = 0;
        int totalPage = 0;
        int pageSize = 0;
        int currentPage = 0;
        String page = (String)params.get("page");
        String pageSizeStr = (String)params.get("pageSize");
        String columnID = (String)params.get("columnId");
        String classID = (String)params.get("classId");
        String keyWords = (String)params.get("keyWords");
        String displaynew = (String)params.get("displaynew");
        String columnType = (String)params.get("columnType");
        String showinnotice = (String)params.get("showinnotice");
        String isRead = (String)params.get("isRead");
        String orderByField = (String)params.get("sortFieldName");
        String orderType = (String)params.get("sortType");
        String state = (String)params.get("state");
        if (orderByField == null || orderByField.trim().length() == 0) {
            orderByField = "A.FLASTUPDATETIME";
        }
        if (orderType == null || orderType.trim().length() == 0) {
            orderType = SortType.DESCEND.getName();
        }
        if (null != classID && !"".equals(classID)) {
            classID = classID.replaceAll(" ", "+");
        }
        if (null != columnID && !"".equals(columnID)) {
            columnID = columnID.replaceAll(" ", "+");
        }
        orderType = orderType.toUpperCase();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        Object filterItemInfo = null;
        if (page == null || page.equals("")) {
            page = "1";
        }
        if (pageSizeStr == null || pageSizeStr.equals("")) {
            pageSizeStr = "20";
        }
        pageNo = Integer.parseInt(page);
        pageSize = Integer.parseInt(pageSizeStr);
        String personId = person.getId().toString();
        String personName = person.getName();
        String now = DateTool.dateToString(new java.util.Date(), "yyyy-MM-dd HH:mm:ss");
        AdminOrgUnitInfo currentAdmin = PersonFactory.getLocalInstance((Context)ctx).getPrimaryAdminOrgUnit(person.getId());
        if (currentAdmin == null || currentAdmin.isIsSealUp()) {
            AdminOrgUnitCollection orgUnitCol = PersonFactory.getLocalInstance((Context)ctx).getAllAdminOrgUnit(person.getId());
            currentAdmin = null;
            for (int i = orgUnitCol.size() - 1; i >= 0 && (currentAdmin = orgUnitCol.get(i)).isIsSealUp(); --i) {
                currentAdmin = null;
            }
        }
        if (currentAdmin == null) {
            currentAdmin = ContextUtil.getCurrentAdminUnit((Context)ctx);
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT");
        sql.append(" DISTINCT A.FID ");
        sql.append("  ,A.FTitle  ");
        sql.append("  ,A.fcolumnid  ");
        sql.append("  ,A.fclassid  ");
        sql.append("  ,A.FKeyword  ");
        sql.append("  ,A.FSummary  ");
        sql.append("  ,A.FClicks ");
        sql.append("  ,A.FCreateTime");
        sql.append("  ,A.FSource ");
        sql.append("  ,A.FLastUpdateTime ");
        sql.append("  ,A.FBeginDate  ");
        sql.append("  ,A.FEndDate ");
        sql.append("  ,A.FStatus ");
        sql.append("  ,A.FFile  ");
        sql.append("  ,A.FDisplayNew ");
        sql.append("  ,A.FPicDisplay  ");
        sql.append("  ,A.FIsRoleControl  ");
        sql.append("  ,B.FColumnType as COLUMN_TYPE ");
        sql.append("  ,B.FName_l2 AS COLUMN_NAME ");
        sql.append("  ,C.FName_l2 AS CLASS_NAME");
        sql.append("  ,D.FName_l2 AS USER_NAME ");
        sql.append("  ,M.FID as READ_ID ");
        sql.append("   FROM T_CM_Content  A");
        sql.append("  left JOIN T_CM_Column  B ON A.FColumnID = B.FID");
        sql.append("  left JOIN T_CM_Class  C ON A.FClassID = C.FID");
        sql.append("  left JOIN T_PM_User D ON A.FCreatorID = D.FID");
        sql.append("  left JOIN T_PM_User E ON A.FLastUpdateUserID =E.FID");
        sql.append("  left JOIN T_CM_CMRolePerson F ON A.FID =F.FContentID ");
        sql.append("  left JOIN T_CM_CMRoleAdmin G ON A.FID =G.FContentID");
        sql.append("  left JOIN T_CM_CMRoleRole H  ON A.FID =H.FContentID");
        sql.append("  LEFT JOIN T_ORG_Admin L ON G.FAdminOrgId =L.FID");
        sql.append("   LEFT JOIN t_cm_reader M ON M.fcontentID = A.FID and M.freader='" + personName + "' ");
        sql.append("   WHERE  1=1");
        if (null != keyWords && !"".equals(keyWords)) {
            sql.append("   AND ( A.fkeyword like '%" + keyWords + "%' ");
            sql.append("   or  A.ftitle like '%" + keyWords + "%' ) ");
        }
        if (null != displaynew && "1".equals(displaynew)) {
            sql.append("   AND A.fdisplaynew = '1' ");
        }
        if (!StringUtil.isEmpty((String)(myReadColumnIds = this.getMyReadColumnID(ctx)))) {
            sql.append("   and  A.FColumnID IN (" + myReadColumnIds + ") ");
        }
        if (null != columnType && !"".equals(columnType)) {
            sql.append("   AND B.FColumnType = '" + columnType + "' ");
        }
        if (null != columnID && !"".equals(columnID)) {
            sql.append("   AND A.FColumnID = '" + columnID + "' ");
        }
        if (null != classID && !"".equals(classID)) {
            sql.append("   AND A.fclassid = '" + classID + "' ");
        }
        if (null != state && "2".equals(state)) {
            sql.append("   AND A.FStatus = '2' ");
        }
        if (null != showinnotice && "1".equals(showinnotice)) {
            sql.append("   and B.fshowinnotice='1'");
        }
        sql.append("   AND B.FEffect = '1'");
        String dbType = (String)ctx.get((Object)"dbType");
        if ("Oracle".equals(dbType)) {
            sql.append("   AND To_char(A.FBeginDate,'YYYY-MM-DD HH24:MI:SS') <='" + now + "' ");
            sql.append("   AND To_char(A.FEndDate,'YYYY-MM-DD HH24:MI:SS') >= '" + now + "'");
        } else if ("MS SQL Server".equals(dbType)) {
            sql.append("   AND A.FBeginDate <='" + now + "' ");
            sql.append("   AND A.FEndDate >= '" + now + "'");
        } else if ("DB2 UDB".equals(dbType)) {
            sql.append("   AND to_char(A.FBeginDate,'yyyy-mm-dd hh.mm.ss') <='" + now + "' ");
            sql.append("   AND to_char(A.FEndDate,'yyyy-mm-dd hh.mm.ss') >= '" + now + "'");
        }
        sql.append("   AND");
        sql.append("    ( A.FIsRoleControl = '0'");
        sql.append("    OR");
        sql.append("     (  A.FIsRoleControl = '1' AND");
        sql.append("        ( ");
        sql.append("           F.FPersonId = '" + personId + "' ");
        String dminOrgId = currentAdmin.getId().toString();
        sql.append("           OR ( ( G.FIsLeaf = '0' AND G.FAdminOrgId = '" + dminOrgId + "')");
        sql.append("           OR  ( G.FIsLeaf = '1' AND");
        StringBuffer longNumStr = new StringBuffer();
        String[] currentNumber = currentAdmin.getLongNumber().split("!");
        String longNumber = "";
        if (currentNumber != null && currentNumber.length > 0) {
            int size = currentNumber.length;
            for (int i = 0; i < size; ++i) {
                longNumber = longNumber + currentNumber[i];
                if (i == 0) {
                    longNumStr.append("'" + longNumber + "'");
                } else {
                    longNumStr.append(",'" + longNumber + "'");
                }
                if (i == size - 1) continue;
                longNumber = longNumber + "!";
            }
        }
        sql.append("  L.FLongNumber IN(" + longNumStr + ") ))");
        Set roleSet = CmUtil.getUserRolePerm((Context)ctx, (String)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        if (roleSet.size() == 0) {
            roleSet.add("0");
        }
        Iterator iter = roleSet.iterator();
        StringBuffer roleStr = new StringBuffer();
        boolean index = false;
        while (iter.hasNext()) {
            String roleId = (String)iter.next();
            if (!index) {
                roleStr.append("'" + roleId + "'");
                continue;
            }
            roleStr.append(",'" + roleId + "'");
        }
        sql.append("   OR  H.FRoleId IN (" + roleStr.toString() + ")");
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        sql.append(" OR  D.FID = '" + userId + "' ");
        sql.append(" )");
        sql.append(" ) ");
        sql.append("    ) ");
        if (null != isRead && "1".equals(isRead)) {
            sql.append("   and");
            sql.append("     (select count(1) from  t_cm_reader X ");
            sql.append("      where X.fcontentID=A.FID and X.freader='" + personName + "')=0");
        }
        sql.append("   ORDER BY " + orderByField + " " + orderType + " ");
        this.log.debug("sql==" + sql.toString());
        IRowSet rowSet = null;
        IRowSet countRowSet = null;
        try {
            String countSql = sql.substring(0, sql.indexOf("ORDER BY"));
            countSql = "/*dialect*/  select count(1) from ( " + countSql + " )  AAA ";
            countRowSet = DbUtil.executeQuery((Context)ctx, (String)countSql);
            if (countRowSet.next()) {
                total = countRowSet.getInt(1);
                this.log.debug("record total is\uff1a" + total);
            }
            totalPage = (total - 1) / pageSize + 1;
            this.log.debug("total page is:" + totalPage);
            if (pageNo > totalPage) {
                pageNo = totalPage;
            }
            if (pageNo <= 0) {
                pageNo = 1;
            }
            currentPage = pageNo;
            resultList.setTotalRowCount(total);
            resultList.setCurrentPage(currentPage);
            resultList.setPageSize(pageSize);
            rowSet = DbUtil.executeQuery((Context)ctx, (String)("/*dialect*/ " + sql.toString()), (int)((pageNo - 1) * pageSize), (int)pageSize);
        }
        catch (Exception e) {
            this.log.error("\u5206\u9875\u67e5\u627e\u5185\u5bb9\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage());
        }
        int orders = 1;
        while (rowSet.next()) {
            ContentDTO dto = new ContentDTO();
            dto.setId(rowSet.getString("FID"));
            dto.setTitle(rowSet.getString("FTITLE"));
            dto.setIsDisplayNew(rowSet.getString("FDisplayNew"));
            dto.setCreateName(rowSet.getString("USER_NAME"));
            Date createTime = rowSet.getDate("FCreateTime");
            dto.setCreateTime(DateTool.dateToString(createTime, "yyyy-MM-dd HH:mm:ss"));
            dto.setCreateTime2(DateTool.dateToString(createTime, "yyyy\u5e74MM\u6708dd\u65e5 HH:mm"));
            dto.setCreateTime3(DateTool.dateToString(createTime, "yyyy-MM-dd"));
            dto.setCreateTime4(DateTool.dateToString(createTime, "yyyy-MM-dd HH:mm"));
            dto.setSummary(rowSet.getString("FSummary"));
            dto.setClicks(rowSet.getInt("FClicks"));
            dto.setFileId(rowSet.getString("FFile"));
            String columnName = rowSet.getString("COLUMN_TYPE");
            dto.setColumnType(this.getColumnType(columnName));
            String readId = rowSet.getString("READ_ID");
            dto.setReadId(readId);
            if (null != readId && readId.length() > 0) {
                dto.setReaded("1");
            }
            dto.setOrders(orders + "");
            ++orders;
            resultList.add(dto);
        }
        return resultList;
    }

    private String getMyReadColumnID(Context ctx) throws Exception {
        IContentManage iManage = ContentManageFactory.getLocalInstance((Context)ctx);
        IRowSet rowset = iManage.getReadColumn();
        StringBuffer columnIdBf = new StringBuffer();
        if (rowset != null && rowset.size() > 0) {
            int i = 0;
            while (rowset.next()) {
                if (i != 0) {
                    columnIdBf.append(",");
                }
                columnIdBf.append("'" + rowset.getString("FID") + "'");
                ++i;
            }
        }
        return columnIdBf.toString();
    }

    public PageList rowSetReadShowToPageList(PageList list, IRowSet rowSet, Map readMap, int rows) throws Exception {
        int orders = 1;
        String columnName = "";
        while (rowSet.next() && orders <= rows) {
            ContentDTO dto = new ContentDTO();
            String id = rowSet.getString("ID");
            String isRead = (String)readMap.get(id);
            if (null != isRead) continue;
            dto.setId(id);
            dto.setReaded("0");
            dto.setColumnId(rowSet.getString("COLUMNID"));
            dto.setTitle(rowSet.getString("TITLE"));
            dto.setCreateName(rowSet.getString("USER.NAME"));
            Date createTime = rowSet.getDate("CREATETIME");
            dto.setCreateTime(DateTool.dateToString(createTime, "yyyy-MM-dd HH:mm:ss"));
            dto.setCreateTime2(DateTool.dateToString(createTime, "yyyy\u5e74MM\u6708dd\u65e5 HH:mm"));
            dto.setCreateTime3(DateTool.dateToString(createTime, "yyyy-MM-dd"));
            dto.setCreateTime4(DateTool.dateToString(createTime, "yyyy-MM-dd HH:mm"));
            dto.setSummary(rowSet.getString("SUMMARY"));
            dto.setClicks(rowSet.getInt("CLICKS"));
            dto.setFileId(rowSet.getString("FILE"));
            columnName = rowSet.getString("CMCOLUMN.COLUMNTYPE");
            dto.setColumnType(this.getColumnType(columnName));
            dto.setOrders(orders + "");
            ++orders;
            list.add(dto);
        }
        return list;
    }

    @Override
    public PageList pageNoticAllList(PortalContext context, Map params) throws Exception {
        Context ctx = (Context)context.getMetaInfo().get("eas_context");
        boolean total = false;
        int pageNo = 0;
        boolean totalPage = false;
        int pageSize = 0;
        boolean currentPage = false;
        String page = (String)params.get("page");
        String pageSizeStr = (String)params.get("pageSize");
        String keyWords = (String)params.get("keyWords");
        String orderByField = (String)params.get("sortFieldName");
        String orderType = (String)params.get("sortType");
        if (orderByField == null || orderByField.trim().length() == 0) {
            orderByField = "lastUpdateTime";
        }
        if (orderType == null || orderType.trim().length() == 0) {
            orderType = SortType.DESCEND.getName();
        }
        orderType = orderType.toUpperCase();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = null;
        if (page == null || page.equals("")) {
            page = "1";
        }
        if (pageSizeStr == null || pageSizeStr.equals("")) {
            pageSizeStr = "20";
        }
        pageNo = Integer.parseInt(page);
        pageSize = Integer.parseInt(pageSizeStr);
        String columnIds = this.getReadShowNoticColumnIDStr(ctx, "0");
        if (columnIds.length() > 0) {
            filterItemInfo = new FilterItemInfo("columnID", (Object)columnIds, CompareType.INCLUDE);
            filterInfo.getFilterItems().add(filterItemInfo);
        }
        filterItemInfo = new FilterItemInfo("status", (Object)new Integer(2), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        if (null != keyWords && !"".equals(keyWords)) {
            filterItemInfo = new FilterItemInfo("KEYWORD", (Object)("%" + keyWords + "%"), CompareType.LIKE);
            filterInfo.getFilterItems().add(filterItemInfo);
        }
        filterItemInfo = new FilterItemInfo("CMCOLUMN.columnType", (Object)"40", CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("CMCOLUMN.effect", (Object)"1", CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("isRoleControl", (Object)new Integer(0), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("beginDate", (Object)new java.util.Date(), CompareType.LESS_EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("endDate", (Object)new java.util.Date(), CompareType.GREATER_EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        FilterInfo filterInfoRole = this.getContributeRangFilter(ctx, "");
        filterInfo.mergeFilter(filterInfoRole, "or");
        entityViewInfo.setFilter(filterInfo);
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.eip.cm.app", "ContentQuery");
        IQueryExecutor exec = null;
        IRowSet rowSet = null;
        Object countRowSet = null;
        PageList resultList = new PageList();
        try {
            SorterItemInfo sorterItemInfo = new SorterItemInfo(orderByField);
            sorterItemInfo.setSortType(SortType.getEnum((String)orderType));
            entityViewInfo.getSorter().add(sorterItemInfo);
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            String sql = exec.getSQL();
            rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
            resultList = this.rowSetToPageList(resultList, rowSet);
        }
        catch (Exception e) {
            this.log.error("\u5206\u9875\u67e5\u627e\u5185\u5bb9\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage());
        }
        return resultList;
    }

    public PageList rowSetToPageList(PageList list, IRowSet rowSet, PortalContext context, Boolean isLoadImg) throws Exception {
        Context ctx = (Context)context.getMetaInfo().get("eas_context");
        int orders = 1;
        while (rowSet.next()) {
            AttachmentInfo info;
            ContentDTO dto = new ContentDTO();
            dto.setId(rowSet.getString("ID"));
            dto.setColumnId(rowSet.getString("COLUMNID"));
            dto.setTitle(rowSet.getString("TITLE"));
            dto.setCreateName(rowSet.getString("USER.NAME"));
            Date createTime = rowSet.getDate("CREATETIME");
            dto.setCreateTime(DateTool.dateToString(createTime, "yyyy-MM-dd HH:mm:ss"));
            dto.setCreateTime2(DateTool.dateToString(createTime, "yyyy\u5e74MM\u6708dd\u65e5 HH:mm"));
            dto.setCreateTime3(DateTool.dateToString(createTime, "yyyy-MM-dd"));
            dto.setCreateTime4(DateTool.dateToString(createTime, "yyyy-MM-dd HH:mm"));
            dto.setSummary(rowSet.getString("SUMMARY"));
            dto.setClicks(rowSet.getInt("CLICKS"));
            dto.setFileId(rowSet.getString("FILE"));
            String fileId = rowSet.getString("FILE");
            String columnType = rowSet.getString("CMCOLUMN.COLUMNTYPE");
            String imgPath = "/plt_cp/res/img/defalt.png";
            if ("80".equals(columnType)) {
                String sql = "select FImgId from T_CM_PicGroupImg where fcontentid=? order by Forder";
                IRowSet imgRowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{dto.getId()});
                if (imgRowSet.next()) {
                    String imgId = imgRowSet.getString("FImgId");
                    imgPath = CMContentImgHandle.getImgFilePath(imgId, ctx);
                }
            } else if (isLoadImg.booleanValue() && !StringUtil.isEmpty((String)fileId) && (info = this.getShowImg(context, fileId)) != null && (imgPath = "60".equals(columnType) ? CMContentImgHandle.getImgFilePath(info, ctx) : CMContentImgHandle.getMin_ImgFilePath(info, ctx)) == "") {
                imgPath = "/plt_cp/res/img/defalt.png";
            }
            String status = "";
            if ("\u53d1\u5e03".equals(rowSet.getString("STATUS")) || "\u767c\u4f48".equals(rowSet.getString("STATUS"))) {
                status = "2";
            }
            dto.setStatus(status);
            dto.setFilePath(imgPath);
            dto.setDisplayNew(String.valueOf(rowSet.getInt("DISPLAYNEW")));
            dto.setClassId(rowSet.getString("classID"));
            dto.setClassName(rowSet.getString("CMClass.name"));
            dto.setColumnType(columnType);
            dto.setOrders(orders + "");
            dto.setKeyWord(rowSet.getString("KEYWORD"));
            ++orders;
            list.add(dto);
        }
        return list;
    }

    public PageList rowSetToPageList(PageList list, IRowSet rowSet) throws Exception {
        int orders = 1;
        String columnName = "";
        String columnType = "";
        while (rowSet.next()) {
            ContentDTO dto = new ContentDTO();
            dto.setId(rowSet.getString("ID"));
            dto.setColumnId(rowSet.getString("COLUMNID"));
            dto.setTitle(rowSet.getString("TITLE"));
            dto.setCreateName(rowSet.getString("USER.NAME"));
            Date createTime = rowSet.getDate("CREATETIME");
            dto.setCreateTime(DateTool.dateToString(createTime, "yyyy-MM-dd HH:mm:ss"));
            dto.setCreateTime2(DateTool.dateToString(createTime, "yyyy\u5e74MM\u6708dd\u65e5 HH:mm"));
            dto.setCreateTime3(DateTool.dateToString(createTime, "yyyy-MM-dd"));
            dto.setCreateTime4(DateTool.dateToString(createTime, "yyyy-MM-dd HH:mm"));
            dto.setSummary(rowSet.getString("SUMMARY"));
            dto.setClicks(rowSet.getInt("CLICKS"));
            dto.setFileId(rowSet.getString("FILE"));
            dto.setDisplayNew(String.valueOf(rowSet.getInt("DISPLAYNEW")));
            dto.setClassId(rowSet.getString("classID"));
            dto.setClassName(rowSet.getString("CMClass.name"));
            columnName = rowSet.getString("CMCOLUMN.COLUMNTYPE");
            dto.setColumnType(this.getColumnType(columnName));
            dto.setOrders(orders + "");
            dto.setKeyWord(rowSet.getString("KEYWORD"));
            ++orders;
            list.add(dto);
        }
        return list;
    }

    public PageList setDocReadCount(Context ctx, PageList list) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            ContentDTO dto = (ContentDTO)list.get(i);
            EntityViewInfo tempEVI = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("contentID", (Object)dto.getId(), CompareType.EQUALS));
            tempEVI.setFilter(filterInfo);
            CMReaderCollection con = CMReaderFactory.getLocalInstance((Context)ctx).getCollection(tempEVI);
            if (con == null) continue;
            dto.setClicks(con.size());
        }
        return list;
    }

    private String getColumnType(String columnName) {
        if (null == columnName) {
            return "";
        }
        if ("\u666e\u901a".equals(columnName)) {
            return "10";
        }
        if ("\u94fe\u63a5".equals(columnName)) {
            return "20";
        }
        if ("\u7126\u70b9\u65b0\u95fb".equals(columnName)) {
            return "30";
        }
        if ("\u901a\u77e5".equals(columnName)) {
            return "40";
        }
        if ("\u9644\u4ef6".equals(columnName)) {
            return "50";
        }
        if ("\u56fe\u7247".equals(columnName)) {
            return "60";
        }
        if ("\u56fe\u7247\u65b0\u95fb".equals(columnName)) {
            return "70";
        }
        if ("\u56fe\u7247\u7ec4".equals(columnName)) {
            return "80";
        }
        return columnName;
    }

    private FilterInfo getContributeRangFilter(Context ctx, String columnID) throws EASBizException, BOSException {
        FilterItemInfo filterItemInfo = null;
        FilterInfo filterInfoRole = new FilterInfo();
        if (ContextUtil.getCurrentUserInfo((Context)ctx) != null && ContextUtil.getCurrentAdminUnit((Context)ctx) != null) {
            String maskStr;
            Set rolePermSet;
            int cloumAndClassFilterNum = 0;
            filterItemInfo = new FilterItemInfo("isRoleControl", (Object)new Integer(1), CompareType.EQUALS);
            filterInfoRole.getFilterItems().add(filterItemInfo);
            if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null) {
                PersonInfo currentPerson = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
                filterItemInfo = new FilterItemInfo("CMRolePerson.personId", (Object)currentPerson.getId().toString(), CompareType.EQUALS);
                filterInfoRole.getFilterItems().add(filterItemInfo);
                AdminOrgUnitInfo currentAdmin = PersonFactory.getLocalInstance((Context)ctx).getPrimaryAdminOrgUnit(currentPerson.getId());
                if (currentAdmin == null || currentAdmin.isIsSealUp()) {
                    AdminOrgUnitCollection orgUnitCol = PersonFactory.getLocalInstance((Context)ctx).getAllAdminOrgUnit(currentPerson.getId());
                    currentAdmin = null;
                    for (int i = orgUnitCol.size() - 1; i >= 0 && (currentAdmin = orgUnitCol.get(i)).isIsSealUp(); --i) {
                        currentAdmin = null;
                    }
                }
                if (currentAdmin == null) {
                    currentAdmin = ContextUtil.getCurrentAdminUnit((Context)ctx);
                }
                filterItemInfo = new FilterItemInfo("CMRoleAdmin.isLeaf", (Object)new Boolean(false), CompareType.EQUALS);
                filterInfoRole.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("CMRoleAdmin.adminOrgId", (Object)currentAdmin.getId().toString(), CompareType.EQUALS);
                filterInfoRole.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("CMRoleAdmin.isLeaf", (Object)new Boolean(true), CompareType.EQUALS);
                filterInfoRole.getFilterItems().add(filterItemInfo);
                HashSet<String> adminNumber = new HashSet<String>();
                String[] currentNumber = currentAdmin.getLongNumber().split("!");
                String longNumber = "";
                if (currentNumber != null && currentNumber.length > 0) {
                    int size = currentNumber.length;
                    for (int i = 0; i < size; ++i) {
                        longNumber = longNumber + currentNumber[i];
                        adminNumber.add(longNumber);
                        if (i == size - 1) continue;
                        longNumber = longNumber + "!";
                    }
                }
                filterItemInfo = new FilterItemInfo("AdminOrgUnit.longNumber", adminNumber, CompareType.INCLUDE);
                filterInfoRole.getFilterItems().add(filterItemInfo);
            }
            if ((rolePermSet = CmUtil.getUserRolePerm((Context)ctx, (String)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString())).size() == 0) {
                rolePermSet.add(new Integer(0));
            }
            filterItemInfo = new FilterItemInfo("CMRoleRole.roleId", (Object)rolePermSet, CompareType.INCLUDE);
            filterInfoRole.getFilterItems().add(filterItemInfo);
            filterItemInfo = new FilterItemInfo("User.id", (Object)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), CompareType.EQUALS);
            filterInfoRole.getFilterItems().add(filterItemInfo);
            if (null != columnID && !"".equals(columnID)) {
                columnID = columnID.replaceAll(" ", "+");
                filterItemInfo = new FilterItemInfo("columnID", (Object)columnID);
                filterInfoRole.getFilterItems().add(filterItemInfo);
                ++cloumAndClassFilterNum;
            }
            filterItemInfo = new FilterItemInfo("CMCOLUMN.columnType", (Object)"40", CompareType.EQUALS);
            filterInfoRole.getFilterItems().add(filterItemInfo);
            ++cloumAndClassFilterNum;
            filterItemInfo = new FilterItemInfo("CMCOLUMN.effect", (Object)"1", CompareType.EQUALS);
            filterInfoRole.getFilterItems().add(filterItemInfo);
            ++cloumAndClassFilterNum;
            filterItemInfo = new FilterItemInfo("beginDate", (Object)new java.util.Date(), CompareType.LESS_EQUALS);
            filterInfoRole.getFilterItems().add(filterItemInfo);
            ++cloumAndClassFilterNum;
            filterItemInfo = new FilterItemInfo("endDate", (Object)new java.util.Date(), CompareType.GREATER_EQUALS);
            filterInfoRole.getFilterItems().add(filterItemInfo);
            ++cloumAndClassFilterNum;
            filterItemInfo = new FilterItemInfo("status", (Object)"2", CompareType.EQUALS);
            filterInfoRole.getFilterItems().add(filterItemInfo);
            ++cloumAndClassFilterNum;
            if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null) {
                maskStr = "( #0 and (#1 or ((#2 and #3) or(#4 and #5)) or #6 or #7)";
                for (int i = 0; i < cloumAndClassFilterNum; ++i) {
                    maskStr = maskStr + " and #" + (i + 8);
                }
                maskStr = maskStr + ")";
                filterInfoRole.setMaskString(maskStr);
            } else {
                maskStr = "(#0 and (#1 or #2)";
                for (int i = 0; i < cloumAndClassFilterNum; ++i) {
                    maskStr = maskStr + " and #" + (i + 3);
                }
                maskStr = maskStr + ")";
                filterInfoRole.setMaskString(maskStr);
            }
        }
        return filterInfoRole;
    }

    @Override
    public PageList pageRecentList(PortalContext context, Map params) throws Exception {
        Context ctx = (Context)context.getMetaInfo().get("eas_context");
        int total = 0;
        int pageNo = 0;
        int totalPage = 0;
        int pageSize = 0;
        int currentPage = 0;
        String page = (String)params.get("page");
        String pageSizeStr = (String)params.get("pageSize");
        String columnID = (String)params.get("columnId");
        String classID = (String)params.get("classId");
        String keyWords = (String)params.get("keyWords");
        String displaynew = (String)params.get("displaynew");
        String orderByField = (String)params.get("sortFieldName");
        String orderType = (String)params.get("sortType");
        if (orderByField == null || orderByField.trim().length() == 0) {
            orderByField = "lastUpdateTime";
        }
        if (orderType == null || orderType.trim().length() == 0) {
            orderType = SortType.DESCEND.getName();
        }
        if (page == null || page.equals("")) {
            page = "1";
        }
        if (pageSizeStr == null || pageSizeStr.equals("")) {
            pageSizeStr = "20";
        }
        pageNo = Integer.parseInt(page);
        pageSize = Integer.parseInt(pageSizeStr);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        HashSet hashSet = this.getReadColumnIDRecentStr(ctx);
        if (hashSet != null && hashSet.size() > 0) {
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo filterItemInfo = null;
            filterItemInfo = new FilterItemInfo("columnID", (Object)hashSet, CompareType.INNER);
            filterInfo.getFilterItems().add(filterItemInfo);
            filterItemInfo = new FilterItemInfo("status", (Object)new Integer(2), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            filterItemInfo = new FilterItemInfo("CMCOLUMN.INNEWPORTLET", (Object)true, CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            filterItemInfo = new FilterItemInfo("isRoleControl", (Object)new Integer(0), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            if (null != keyWords && !"".equals(keyWords)) {
                filterItemInfo = new FilterItemInfo("KEYWORD", (Object)("%" + keyWords + "%"), CompareType.LIKE);
                filterInfo.getFilterItems().add(filterItemInfo);
            }
            FilterInfo rangFilterInfo = this.getContributeRangFilter(ctx, null, null, new Integer(2).toString(), null, null, true, keyWords);
            filterInfo.mergeFilter(rangFilterInfo, "or");
            entityViewInfo.setFilter(filterInfo);
        } else {
            FilterInfo rangFilterInfo = this.getContributeRangFilter(ctx, null, null, new Integer(2).toString(), null, null, true, keyWords);
            entityViewInfo.setFilter(rangFilterInfo);
        }
        SorterItemInfo sorterItemInfo = new SorterItemInfo("lastUpdateTime");
        sorterItemInfo.setSortType(SortType.DESCEND);
        entityViewInfo.getSorter().add(sorterItemInfo);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.cp.eip.cm.app", "ContentQuery");
        IQueryExecutor exec = this.getQueryExecutor((IMetaDataPK)queryPK, entityViewInfo, ctx);
        exec.option().isAutoTranslateEnum = false;
        IRowSet rowSet = null;
        IRowSet countRowSet = null;
        PageList resultList = new PageList();
        String sql = exec.getSQL();
        this.log.debug("executor search content  sql is:" + sql);
        String countSql = sql.substring(0, sql.indexOf("ORDER BY"));
        countSql = " select count(1) from ( " + countSql + " )  AAA ";
        countRowSet = DbUtil.executeQuery((Context)ctx, (String)countSql);
        if (countRowSet.next()) {
            total = countRowSet.getInt(1);
            this.log.debug("record total is\uff1a" + total);
        }
        totalPage = (total - 1) / pageSize + 1;
        this.log.debug("total page is:" + totalPage);
        if (pageNo > totalPage) {
            pageNo = totalPage;
        }
        if (pageNo <= 0) {
            pageNo = 1;
        }
        currentPage = pageNo;
        resultList.setTotalRowCount(total);
        resultList.setCurrentPage(currentPage);
        resultList.setPageSize(pageSize);
        rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
        resultList = this.rowSetToPageList(resultList, rowSet);
        return resultList;
    }

    private HashSet getReadColumnIDRecentStr(Context ctx) throws Exception {
        IContentManage iManage = ContentManageFactory.getLocalInstance((Context)ctx);
        IRowSet rowset = iManage.getReadColumn();
        HashSet<String> set = new HashSet<String>();
        if (rowset != null && rowset.size() > 0) {
            while (rowset.next()) {
                set.add(rowset.getString("FID"));
            }
        }
        return set;
    }

    public HashMap getReadRecord(PortalContext context, IRowSet rowSet) {
        Context ctx = (Context)context.getMetaInfo().get("eas_context");
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String sqltv = "";
        IRowSet rstv = null;
        HashMap<String, String> idMap = new HashMap<String, String>();
        if (rowSet != null && rowSet.size() > 0) {
            StringBuffer columnIdStr = new StringBuffer();
            try {
                while (rowSet.next()) {
                    columnIdStr.append("'").append(rowSet.getString("id")).append("',");
                }
                if (columnIdStr.length() > 0 && (rstv = DbUtil.executeQuery((Context)ctx, (String)(sqltv = "select fcontentid from t_cm_reader where  freader='" + userInfo.getPerson().getName() + "' and fcontentid in(" + columnIdStr.substring(0, columnIdStr.length() - 1) + ")"))) != null && rstv.size() > 0) {
                    while (rstv.next()) {
                        idMap.put(rstv.getString("fcontentid"), "true");
                    }
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return idMap;
    }

    @Override
    public HashMap getReadRecord(PortalContext context, String ids, String personName) throws Exception {
        IRowSet rstv = null;
        Context ctx = (Context)context.getMetaInfo().get("eas_context");
        String sqltv = "";
        HashMap<String, String> idMap = new HashMap<String, String>();
        try {
            if (ids.length() > 0 && (rstv = DbUtil.executeQuery((Context)ctx, (String)(sqltv = "select fcontentid from t_cm_reader where  freader='" + personName + "' and fcontentid in(" + ids + ")"))) != null && rstv.size() > 0) {
                while (rstv.next()) {
                    idMap.put(rstv.getString("fcontentid"), "true");
                }
            }
        }
        catch (Exception e) {
            String error = "\u83b7\u53d6\u5185\u5bb9\u7ba1\u7406\u7684\u5df2\u9605\u8bfb\u8bb0\u5f55ID\u96c6\u5931\u8d25,sql=" + sqltv;
            this.log.error(error, (Throwable)e);
            throw new Exception(error, e);
        }
        return idMap;
    }

    @Override
    public String getcontentIds(PageList list) {
        StringBuffer ids = new StringBuffer();
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            ContentDTO dto = (ContentDTO)list.get(i);
            String id = dto.getId();
            if (i == 0) {
                ids.append("'" + id + "'");
                continue;
            }
            ids.append(",'" + id + "'");
        }
        return ids.toString();
    }

    private FilterInfo getContributeRangFilter(Context ctx, String columnID, String classID, String status, java.util.Date beginDate, java.util.Date endDate, Boolean inNewPortlet, String keyWords) throws EASBizException, BOSException {
        FilterItemInfo filterItemInfo = null;
        FilterInfo filterInfoRole = new FilterInfo();
        if (ContextUtil.getCurrentUserInfo((Context)ctx) != null && ContextUtil.getCurrentAdminUnit((Context)ctx) != null) {
            String maskStr;
            Set rolePermSet;
            int cloumAndClassFilterNum = 0;
            filterItemInfo = new FilterItemInfo("isRoleControl", (Object)new Integer(1), CompareType.EQUALS);
            filterInfoRole.getFilterItems().add(filterItemInfo);
            if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null) {
                PersonInfo currentPerson = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
                filterItemInfo = new FilterItemInfo("CMRolePerson.personId", (Object)currentPerson.getId().toString(), CompareType.EQUALS);
                filterInfoRole.getFilterItems().add(filterItemInfo);
                AdminOrgUnitInfo currentAdmin = PersonFactory.getLocalInstance((Context)ctx).getPrimaryAdminOrgUnit(currentPerson.getId());
                if (currentAdmin == null || currentAdmin.isIsSealUp()) {
                    AdminOrgUnitCollection orgUnitCol = PersonFactory.getLocalInstance((Context)ctx).getAllAdminOrgUnit(currentPerson.getId());
                    currentAdmin = null;
                    for (int i = orgUnitCol.size() - 1; i >= 0 && (currentAdmin = orgUnitCol.get(i)).isIsSealUp(); --i) {
                        currentAdmin = null;
                    }
                }
                if (currentAdmin == null) {
                    currentAdmin = ContextUtil.getCurrentAdminUnit((Context)ctx);
                }
                filterItemInfo = new FilterItemInfo("CMRoleAdmin.isLeaf", (Object)new Boolean(false), CompareType.EQUALS);
                filterInfoRole.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("CMRoleAdmin.adminOrgId", (Object)currentAdmin.getId().toString(), CompareType.EQUALS);
                filterInfoRole.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("CMRoleAdmin.isLeaf", (Object)new Boolean(true), CompareType.EQUALS);
                filterInfoRole.getFilterItems().add(filterItemInfo);
                HashSet<String> adminNumber = new HashSet<String>();
                String[] currentNumber = currentAdmin.getLongNumber().split("!");
                String longNumber = "";
                if (currentNumber != null && currentNumber.length > 0) {
                    int size = currentNumber.length;
                    for (int i = 0; i < size; ++i) {
                        longNumber = longNumber + currentNumber[i];
                        adminNumber.add(longNumber);
                        if (i == size - 1) continue;
                        longNumber = longNumber + "!";
                    }
                }
                filterItemInfo = new FilterItemInfo("AdminOrgUnit.longNumber", adminNumber, CompareType.INCLUDE);
                filterInfoRole.getFilterItems().add(filterItemInfo);
            }
            if ((rolePermSet = CmUtil.getUserRolePerm((Context)ctx, (String)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString())).size() == 0) {
                rolePermSet.add(new Integer(0));
            }
            filterItemInfo = new FilterItemInfo("CMRoleRole.roleId", (Object)rolePermSet, CompareType.INCLUDE);
            filterInfoRole.getFilterItems().add(filterItemInfo);
            filterItemInfo = new FilterItemInfo("User.id", (Object)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), CompareType.EQUALS);
            filterInfoRole.getFilterItems().add(filterItemInfo);
            if (null != columnID && !"".equals(columnID)) {
                columnID = columnID.replaceAll(" ", "+");
                filterItemInfo = new FilterItemInfo("columnID", (Object)columnID);
                filterInfoRole.getFilterItems().add(filterItemInfo);
                ++cloumAndClassFilterNum;
            }
            if (null != classID && !"".equals(classID)) {
                filterItemInfo = new FilterItemInfo("classID", (Object)classID, CompareType.INCLUDE);
                filterInfoRole.getFilterItems().add(filterItemInfo);
                ++cloumAndClassFilterNum;
            }
            if (null != status && !"".equals(status)) {
                filterItemInfo = new FilterItemInfo("status", (Object)status);
                filterInfoRole.getFilterItems().add(filterItemInfo);
                ++cloumAndClassFilterNum;
            }
            if (null != beginDate) {
                filterItemInfo = new FilterItemInfo("beginDate", (Object)beginDate, CompareType.LESS_EQUALS);
                filterInfoRole.getFilterItems().add(filterItemInfo);
                ++cloumAndClassFilterNum;
            }
            if (null != endDate) {
                filterItemInfo = new FilterItemInfo("endDate", (Object)endDate, CompareType.GREATER_EQUALS);
                filterInfoRole.getFilterItems().add(filterItemInfo);
                ++cloumAndClassFilterNum;
            }
            if (null != inNewPortlet) {
                filterItemInfo = new FilterItemInfo("CMCOLUMN.INNEWPORTLET", (Object)inNewPortlet, CompareType.EQUALS);
                filterInfoRole.getFilterItems().add(filterItemInfo);
                ++cloumAndClassFilterNum;
            }
            if (null != keyWords && !"".equals(keyWords)) {
                filterItemInfo = new FilterItemInfo("KEYWORD", (Object)("%" + keyWords + "%"), CompareType.LIKE);
                filterInfoRole.getFilterItems().add(filterItemInfo);
                ++cloumAndClassFilterNum;
            }
            if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null) {
                maskStr = "#0 and (#1 or ((#2 and #3) or(#4 and #5)) or #6 or #7)";
                for (int i = 0; i < cloumAndClassFilterNum; ++i) {
                    maskStr = maskStr + " and #" + (i + 8);
                }
                filterInfoRole.setMaskString(maskStr);
            } else {
                maskStr = "#0 and (#1 or #2)";
                for (int i = 0; i < cloumAndClassFilterNum; ++i) {
                    maskStr = maskStr + " and #" + (i + 3);
                }
                filterInfoRole.setMaskString(maskStr);
            }
        }
        return filterInfoRole;
    }

    @Override
    public boolean hasPermissionToRead(PortalContext context, String docId) throws Exception {
        Context ctx = (Context)context.getMetaInfo().get("eas_context");
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (user == null) {
            return false;
        }
        ICMContent iCMC = CMContentFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK tempPk = new ObjectUuidPK(BOSUuid.read((String)docId));
        CMContentInfo tempInfo = (CMContentInfo)iCMC.getValue((IObjectPK)tempPk);
        String CurColumnId = tempInfo.getColumnID().toString();
        IContentManage iManage = ContentManageFactory.getLocalInstance((Context)ctx);
        IRowSet rowset = iManage.getReadColumn();
        if (rowset != null && rowset.size() > 0) {
            while (rowset.next()) {
                String columnId = rowset.getString("FID");
                if (!CurColumnId.equals(columnId)) continue;
                return true;
            }
        }
        return false;
    }
}

