/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.module.document.service.impl;

import com.kingdee.bos.Context;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.plt.cp.module.document.dao.DocumentDAO;
import com.kingdee.portal.plt.cp.module.document.entity.Category;
import com.kingdee.portal.plt.cp.module.document.entity.DmCategoryTreeDTO;
import com.kingdee.portal.plt.cp.module.document.entity.Document;
import com.kingdee.portal.plt.cp.module.document.entity.DocumentBorrow;
import com.kingdee.portal.plt.cp.module.document.service.DocumentService;
import com.kingdee.portal.plt.cp.module.document.service.PermissionUtil;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class DocumentServiceImpl
implements DocumentService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private DocumentDAO documentDAO;

    public void setDocumentDAO(DocumentDAO documentDAO) {
        this.documentDAO = documentDAO;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PagingResult<Document> findMyReadList(Context ctx, String readerId, String searchText, PagingParam pagingParam) throws PortalBizException {
        try {
            PagingResult<Document> pr = this.documentDAO.findMyReadList(readerId, searchText, pagingParam);
            return pr;
        }
        catch (DataAccessException e) {
            throw new PortalBizException("findMyReadList error", (Throwable)e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PagingResult<Document> findMyBookMarkList(Context ctx, String personId, String searchText, PagingParam pagingParam) throws PortalBizException {
        try {
            PagingResult<Document> pr = this.documentDAO.findMyBookMarkList(personId, searchText, pagingParam);
            return pr;
        }
        catch (DataAccessException e) {
            throw new PortalBizException("findMyBookMarkList error", (Throwable)e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PagingResult<Document> findMyBorrowedList(Context ctx, String personId, String searchText, PagingParam pagingParam) throws PortalBizException {
        try {
            PagingResult<Document> pr = this.documentDAO.findMyBorrowedList(ctx, personId, searchText, pagingParam);
            return pr;
        }
        catch (Exception e) {
            throw new PortalBizException("findMyBorrowedList error", (Throwable)e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PagingResult<Document> findMySendList(Context ctx, String personId, String searchText, PagingParam pagingParam) throws PortalBizException {
        try {
            PagingResult<Document> pr = this.documentDAO.findMySendList(personId, searchText, pagingParam);
            List docs = pr.getRecords();
            for (int i = 0; docs != null && i < docs.size(); ++i) {
                Document doc = (Document)((Object)docs.get(i));
                String personNames = this.documentDAO.getRecommend2Persons(ctx, doc.getDocumentRecommendId());
                doc.setSendTo(personNames);
            }
            return pr;
        }
        catch (Exception e) {
            throw new PortalBizException("findMySendList error", (Throwable)e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PagingResult<Document> findMyReceiveList(Context ctx, String personId, String searchText, PagingParam pagingParam) throws PortalBizException {
        try {
            PagingResult<Document> pr = this.documentDAO.findMyReceiveList(personId, searchText, pagingParam);
            List docs = pr.getRecords();
            for (int i = 0; docs != null && i < docs.size(); ++i) {
                Document doc = (Document)((Object)docs.get(i));
                String personName = this.documentDAO.getRecommendSenderName(ctx, doc.getDocumentRecommendId());
                doc.setSender(personName);
            }
            return pr;
        }
        catch (Exception e) {
            throw new PortalBizException("findMyReceiveList error", (Throwable)e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public Document getDocumentById(Context ctx, String docId) throws PortalBizException {
        try {
            return this.documentDAO.getDocumentById(ctx, docId);
        }
        catch (Exception e) {
            throw new PortalBizException("getDocumentById error", (Throwable)e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public String getEnterpriseDocName(Context ctx) throws PortalBizException {
        try {
            return this.documentDAO.getEnterpriseDocName(ctx);
        }
        catch (Exception e) {
            throw new PortalBizException("getEnterpriseDocName error", (Throwable)e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List getAuthorDocs(Context ctx, String docId) throws PortalBizException {
        try {
            Document document = this.documentDAO.getDocumentById(ctx, docId);
            return this.documentDAO.getAuthorDocs(ctx, document.getAuthorId(), docId);
        }
        catch (Exception e) {
            throw new PortalBizException("getDocumentById error", (Throwable)e);
        }
    }

    @Override
    public List<DmCategoryTreeDTO> findDmCategoryListByParentId(Context ctx, String parentId, String type) throws PortalBizException {
        List list;
        List<DmCategoryTreeDTO> dmTreeList = null;
        if (null == parentId || "".equals(parentId)) {
            PermissionUtil.initPermListCache();
        }
        if (null == (list = PermissionUtil.getDmPermListCache()) || list.size() == 0) {
            return dmTreeList;
        }
        dmTreeList = null == parentId || "".equals(parentId) ? this.documentDAO.findDmDocAreaListByPersonId(ctx, list) : this.documentDAO.findDmCategoryListByDocAreaId(ctx, parentId, list);
        PermissionUtil.clearDmPermListCache();
        return dmTreeList;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PagingResult<Document> findMySpecialList(Context ctx, String personId, String searchText, PagingParam pagingParam) throws PortalBizException {
        try {
            PagingResult<Document> pr = this.documentDAO.findMySpecialList(personId, searchText, pagingParam);
            return pr;
        }
        catch (DataAccessException e) {
            throw new PortalBizException("findMyReadList error", (Throwable)e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PagingResult<Document> findDocsList(Context ctx, String searchText, PagingParam pagingParam, String type, String docareaIdOrCategoryId) throws PortalBizException {
        try {
            PagingResult<Document> pr = this.documentDAO.findDocsList(ctx, searchText, pagingParam, type, docareaIdOrCategoryId);
            return pr;
        }
        catch (DataAccessException e) {
            throw new PortalBizException("findMyReadList error", (Throwable)e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PagingResult<DocumentBorrow> findBorrowedListByDocId(String docId, PagingParam pagingParam) throws PortalBizException {
        try {
            PagingResult<DocumentBorrow> pr = this.documentDAO.findBorrowedListByDocId(docId, pagingParam);
            return pr;
        }
        catch (DataAccessException e) {
            throw new PortalBizException("findBorrowedListByDocId error", (Throwable)e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PagingResult<DocumentBorrow> findMyBorrowedListByDocId(Context ctx, String docId, PagingParam pagingParam) throws PortalBizException {
        try {
            PagingResult<DocumentBorrow> pr = this.documentDAO.findMyBorrowedListByDocId(ctx, docId, pagingParam);
            return pr;
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            throw new PortalBizException("findMyBorrowedListByDocId error", (Throwable)e);
        }
    }

    @Override
    public void addDocumentBorrow(Context ctx, DocumentBorrow documentBorrow) {
        try {
            this.documentDAO.addDocumentBorrow(ctx, documentBorrow);
        }
        catch (Exception e) {
            this.logger.error("addDocumentBorrow error!", (Throwable)e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public Category getCategoryById(Context ctx, String categoryId) throws Exception {
        try {
            return this.documentDAO.getCategoryById(ctx, categoryId);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("getCategoryById error", (Throwable)e);
        }
    }

    @Override
    public void addDocumentCommend(Context ctx, String docId) {
        try {
            this.documentDAO.addDocumentCommend(ctx, docId);
        }
        catch (Exception e) {
            this.logger.error("addDocumentCommend error!", (Throwable)e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public boolean isDocumentCommended(Context ctx, String docId) {
        try {
            return this.documentDAO.isDocumentCommended(ctx, docId);
        }
        catch (Exception e) {
            this.logger.error("isDocumentCommended error!", (Throwable)e);
            return false;
        }
    }

    @Override
    public void addDocumentBookMark(Context ctx, String docId) {
        try {
            this.documentDAO.addDocumentBookMark(ctx, docId);
        }
        catch (Exception e) {
            this.logger.error("addDocumentBookMark error!", (Throwable)e);
        }
    }

    @Override
    public void cancelDocumentBookMark(Context ctx, String docId) {
        try {
            this.documentDAO.cancelDocumentBookMark(ctx, docId);
        }
        catch (Exception e) {
            this.logger.error("cancelDocumentBookMark error!", (Throwable)e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public boolean isDocumentBookMarked(Context ctx, String docId) {
        try {
            return this.documentDAO.isDocumentBookMarked(ctx, docId);
        }
        catch (Exception e) {
            this.logger.error("isDocumentBookMarked error!", (Throwable)e);
            return false;
        }
    }

    @Override
    public void addDocumentReadCount(Context ctx, String docId) {
        try {
            this.documentDAO.addDocumentReadCount(ctx, docId);
        }
        catch (Exception e) {
            this.logger.error("addDocumentReadCount error!", (Throwable)e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PagingResult<Document> findPortletDocsList(Context ctx, String searchText, PagingParam pagingParam, Set categoryIds) throws PortalBizException {
        try {
            PagingResult<Document> pr = this.documentDAO.findPortletDocsList(ctx, searchText, pagingParam, categoryIds);
            return pr;
        }
        catch (DataAccessException e) {
            throw new PortalBizException("findPortletDocsList error", (Throwable)e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public Set getEnableCates(Context ctx, Set categoryIds) throws PortalBizException {
        try {
            Set set = this.documentDAO.getEnableCates(ctx, categoryIds);
            return set;
        }
        catch (Exception e) {
            throw new PortalBizException("getEnableCates error", (Throwable)e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public String getFWfBorrowProcess(Context ctx, String documentId) {
        try {
            return this.documentDAO.getFWfBorrowProcess(ctx, documentId);
        }
        catch (Exception e) {
            this.logger.error("getFWfBorrowProcess error!", (Throwable)e);
            return null;
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public String getLatestBorrowId(Context ctx, String documentId) {
        try {
            return this.documentDAO.getLatestBorrowId(ctx, documentId);
        }
        catch (Exception e) {
            this.logger.error("getLatestBorrowId error!", (Throwable)e);
            return null;
        }
    }

    @Override
    public void addDocumentBorrowWf(Context ctx, DocumentBorrow documentBorrow) {
        try {
            this.documentDAO.addDocumentBorrowWf(ctx, documentBorrow);
        }
        catch (Exception e) {
            this.logger.error("addDocumentBorrowWf error!", (Throwable)e);
        }
    }

    @Override
    public void addDocumentRecommend(Context ctx, String docId, String personIds) {
        try {
            String parentId = this.documentDAO.addDocumentRecommend(ctx, docId);
            String[] persons = personIds.split(",");
            for (int i = 0; i < persons.length; ++i) {
                this.documentDAO.addDocumentRecommendEntry(ctx, persons[i], parentId);
            }
        }
        catch (Exception e) {
            this.logger.error("addDocumentRecommend error!", (Throwable)e);
        }
    }

    @Override
    public int addDocumentReadNote(Context ctx, String docId) {
        int readCount = 0;
        try {
            readCount = this.documentDAO.addDocumentReadNote(ctx, docId);
        }
        catch (Exception e) {
            this.logger.error("addDocumentReadNote error!", (Throwable)e);
        }
        return readCount;
    }

    @Override
    public int commendCount(Context ctx, String docId) throws Exception {
        int commendCount = 0;
        try {
            commendCount = this.documentDAO.commendCount(ctx, docId);
        }
        catch (Exception e) {
            this.logger.error("commendCount error!", (Throwable)e);
        }
        return commendCount;
    }

    @Override
    public void delDocumentCommend(Context ctx, String docId) throws Exception {
        try {
            this.documentDAO.delDocumentCommend(ctx, docId);
        }
        catch (Exception e) {
            this.logger.error("delDocumentCommend error!", (Throwable)e);
        }
    }
}

